/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.common.persistence;

import java.io.InputStream;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.io.IOUtils;
import org.apache.kylin.common.persistence.JDBCSqlQueryFormat;

public class JDBCSqlQueryFormatProvider {
    static Map<String, Properties> cache = new HashMap<String, Properties>();

    public static JDBCSqlQueryFormat createJDBCSqlQueriesFormat(String dialect) {
        JDBCSqlQueryFormat jDBCSqlQueryFormat;
        String key = String.format(Locale.ROOT, "/metadata-jdbc-%s.properties", dialect.toLowerCase(Locale.ROOT));
        if (cache.containsKey(key)) {
            return new JDBCSqlQueryFormat(cache.get(key));
        }
        Properties props = new Properties();
        InputStream input = null;
        try {
            input = props.getClass().getResourceAsStream(key);
            props.load(input);
            if (!props.isEmpty()) {
                cache.put(key, props);
            }
            jDBCSqlQueryFormat = new JDBCSqlQueryFormat(props);
        }
        catch (Exception e) {
            try {
                throw new RuntimeException(String.format(Locale.ROOT, "Can't find properties named %s for metastore", key), e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(input);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)input);
        return jDBCSqlQueryFormat;
    }
}

