/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.cache.cachemanager;

import java.util.Collection;
import org.apache.kylin.cache.cachemanager.MemcachedCacheManager;
import org.apache.kylin.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.kylin.shaded.com.google.common.base.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.Cache;
import org.springframework.cache.CacheManager;
import org.springframework.cache.support.AbstractCacheManager;

public class RemoteLocalFailOverCacheManager
extends AbstractCacheManager {
    private static final Logger logger = LoggerFactory.getLogger(RemoteLocalFailOverCacheManager.class);
    @Autowired
    private MemcachedCacheManager remoteCacheManager;
    @Autowired
    private CacheManager localCacheManager;

    @Override
    public void afterPropertiesSet() {
        Preconditions.checkNotNull(this.localCacheManager, "localCacheManager is not injected yet");
    }

    @Override
    protected Collection<? extends Cache> loadCaches() {
        return null;
    }

    @Override
    public Cache getCache(String name) {
        if (this.remoteCacheManager == null || this.remoteCacheManager.isClusterDown()) {
            logger.info("use local cache, because remote cache is not configured or down");
            return this.localCacheManager.getCache(name);
        }
        return this.remoteCacheManager.getCache(name);
    }

    @VisibleForTesting
    void disableRemoteCacheManager() {
        this.remoteCacheManager.setClusterHealth(false);
    }

    @VisibleForTesting
    void enableRemoteCacheManager() {
        this.remoteCacheManager.setClusterHealth(true);
    }

    @VisibleForTesting
    MemcachedCacheManager getRemoteCacheManager() {
        return this.remoteCacheManager;
    }
}

