/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.materialize;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.UncheckedExecutionException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import javax.annotation.Nonnull;
import org.apache.calcite.materialize.Lattice;
import org.apache.calcite.materialize.LatticeStatisticProvider;
import org.apache.calcite.util.Util;

class CachingLatticeStatisticProvider
implements LatticeStatisticProvider {
    private final Lattice lattice;
    private final LoadingCache<Lattice.Column, Double> cache;

    CachingLatticeStatisticProvider(Lattice lattice, final LatticeStatisticProvider provider) {
        this.lattice = lattice;
        this.cache = CacheBuilder.newBuilder().build(new CacheLoader<Lattice.Column, Double>(){

            @Override
            public Double load(@Nonnull Lattice.Column key) throws Exception {
                return provider.cardinality(ImmutableList.of(key));
            }
        });
    }

    @Override
    public double cardinality(List<Lattice.Column> columns) {
        ArrayList<Double> counts = new ArrayList<Double>();
        for (Lattice.Column column : columns) {
            try {
                counts.add(this.cache.get(column));
            }
            catch (UncheckedExecutionException | ExecutionException e) {
                Util.throwIfUnchecked(e.getCause());
                throw new RuntimeException(e.getCause());
            }
        }
        return (int)Lattice.getRowCount(this.lattice.getFactRowCount(), counts);
    }
}

