/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.core.userdetails.cache;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cache.Cache;
import org.springframework.security.core.userdetails.UserCache;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.util.Assert;

public class SpringCacheBasedUserCache
implements UserCache {
    private static final Log logger = LogFactory.getLog(SpringCacheBasedUserCache.class);
    private final Cache cache;

    public SpringCacheBasedUserCache(Cache cache) throws Exception {
        Assert.notNull(cache, "cache mandatory");
        this.cache = cache;
    }

    @Override
    public UserDetails getUserFromCache(String username) {
        Cache.ValueWrapper element;
        Cache.ValueWrapper valueWrapper = element = username != null ? this.cache.get((Object)username) : null;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Cache hit: " + (element != null) + "; username: " + username));
        }
        if (element == null) {
            return null;
        }
        return (UserDetails)element.get();
    }

    @Override
    public void putUserInCache(UserDetails user) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Cache put: " + user.getUsername()));
        }
        this.cache.put((Object)user.getUsername(), (Object)user);
    }

    public void removeUserFromCache(UserDetails user) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Cache remove: " + user.getUsername()));
        }
        this.removeUserFromCache(user.getUsername());
    }

    @Override
    public void removeUserFromCache(String username) {
        this.cache.evict((Object)username);
    }
}

