/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.tool.migration;

import com.google.common.base.Strings;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.net.URI;
import java.util.HashSet;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.persistence.RawResource;
import org.apache.kylin.common.persistence.ResourceStore;
import org.apache.kylin.common.restclient.RestClient;
import org.apache.kylin.dict.DictionaryInfo;
import org.apache.kylin.dict.lookup.SnapshotTable;
import org.apache.kylin.engine.mr.JobBuilderSupport;
import org.apache.kylin.metadata.project.ProjectInstance;
import org.apache.kylin.rest.security.ManagedUser;
import org.apache.kylin.rest.service.KylinUserService;
import org.apache.kylin.storage.hbase.HBaseResourceStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ClusterUtil {
    private static final Logger logger = LoggerFactory.getLogger(ClusterUtil.class);
    protected final KylinConfig kylinConfig;
    protected final RestClient restClient;
    protected final String hdfsWorkingDirectory;
    protected final Configuration hbaseConf;
    protected final Connection hbaseConn;
    protected final ResourceStore resourceStore;
    protected final Admin hbaseAdmin;
    final Configuration jobConf;
    final FileSystem jobFS;
    final String jobHdfsWorkingDirectoryQualified;
    final FileSystem hbaseFS;
    final String hbaseHdfsWorkingDirectoryQualified;

    public ClusterUtil(String configURI, boolean ifJobFSHAEnabled, boolean ifHBaseFSHAEnabled) throws IOException {
        this.kylinConfig = KylinConfig.createInstanceFromUri(configURI);
        this.restClient = new RestClient(configURI);
        Path hdfsWorkingPath = Path.getPathWithoutSchemeAndAuthority((Path)new Path(this.kylinConfig.getHdfsWorkingDirectory()));
        String tmpHdfsWorkingDirectory = hdfsWorkingPath.toString();
        this.hdfsWorkingDirectory = tmpHdfsWorkingDirectory.endsWith("/") ? tmpHdfsWorkingDirectory : tmpHdfsWorkingDirectory + "/";
        this.jobConf = KylinConfig.getConfigFromString(this.restClient.getHDFSConfiguration());
        this.jobFS = FileSystem.get((Configuration)this.jobConf);
        this.jobHdfsWorkingDirectoryQualified = ClusterUtil.getQualifiedPath(this.jobConf, this.hdfsWorkingDirectory, ifJobFSHAEnabled);
        this.hbaseConf = KylinConfig.getConfigFromString(this.restClient.getHBaseConfiguration());
        this.hbaseFS = FileSystem.get((Configuration)this.hbaseConf);
        this.hbaseHdfsWorkingDirectoryQualified = ClusterUtil.getQualifiedPath(this.hbaseConf, this.hdfsWorkingDirectory, ifHBaseFSHAEnabled);
        this.hbaseConn = ConnectionFactory.createConnection((Configuration)this.hbaseConf);
        this.resourceStore = new HBaseResourceStore(this.kylinConfig){

            @Override
            protected Connection getConnection() {
                return ClusterUtil.this.hbaseConn;
            }

            @Override
            protected Configuration getCurrentHBaseConfiguration() {
                return ClusterUtil.this.hbaseConf;
            }
        };
        this.hbaseAdmin = this.hbaseConn.getAdmin();
    }

    public abstract ProjectInstance getProject(String var1) throws IOException;

    public abstract DictionaryInfo getDictionaryInfo(String var1) throws IOException;

    public abstract SnapshotTable getSnapshotTable(String var1) throws IOException;

    public abstract String getRootDirQualifiedOfHTable(String var1);

    public ManagedUser getUserDetails(String userKey) throws IOException {
        return this.resourceStore.getResource(userKey, KylinUserService.SERIALIZER);
    }

    public final RawResource getResource(String resPath) throws IOException {
        return this.resourceStore.getResource(resPath);
    }

    public String getJobWorkingDirQualified(String jobId) {
        return JobBuilderSupport.getJobWorkingDir(this.jobHdfsWorkingDirectoryQualified, jobId);
    }

    private static String getQualifiedPath(Configuration conf, String path, boolean ifHAEnabled) throws IOException {
        String hdfsSchema = ClusterUtil.getReplacedDefaultFS(conf, !ifHAEnabled);
        return hdfsSchema + path;
    }

    private static String getReplacedDefaultFS(Configuration conf, boolean ifNeedReplace) throws IOException {
        String defaultNameService;
        String defaultFS = conf.get("fs.defaultFS");
        if (!ifNeedReplace) {
            return defaultFS;
        }
        String nameServices = conf.get("dfs.nameservices");
        if (Strings.isNullOrEmpty((String)nameServices)) {
            return defaultFS;
        }
        HashSet nameServiceSet = Sets.newHashSet((Object[])nameServices.split(","));
        if (!nameServiceSet.contains(defaultNameService = URI.create(defaultFS).getHost())) {
            logger.info("name service {} is not defined among {}", (Object)defaultNameService, (Object)nameServices);
            return defaultFS;
        }
        String haHostNames = conf.get("dfs.ha.namenodes." + defaultNameService);
        if (!Strings.isNullOrEmpty((String)haHostNames)) {
            conf = new Configuration(conf);
            for (String oneNodeAlias : haHostNames.split(",")) {
                String rpcNode = conf.get("dfs.namenode.rpc-address." + defaultNameService + "." + oneNodeAlias);
                String replaced = "hdfs://" + rpcNode;
                conf.set("fs.defaultFS", replaced);
                Path rootPath = new Path(replaced + "/");
                FileSystem fs = FileSystem.get((Configuration)conf);
                try {
                    fs.getStatus(rootPath);
                }
                catch (Exception e) {
                    logger.warn("cannot use {} as default fs due to ", (Object)replaced, (Object)e);
                    continue;
                }
                logger.info("replaced the default fs {} by {}", (Object)defaultFS, (Object)replaced);
                return replaced;
            }
            throw new IllegalArgumentException("fail to replace the default fs " + defaultFS);
        }
        throw new IllegalArgumentException("dfs.ha.namenodes." + defaultNameService + " is not set");
    }
}

