/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.stream.core.util;

import java.util.Collection;
import org.apache.kylin.common.util.Pair;
import org.apache.kylin.dimension.TimeDerivedColumnType;
import org.apache.kylin.metadata.filter.CompareTupleFilter;

public class CompareFilterTimeRangeChecker {
    protected long timeStart;
    protected long timeEnd;
    private boolean endClose;

    public CompareFilterTimeRangeChecker(long timeStart, long timeEnd) {
        this(timeStart, timeEnd, false);
    }

    public CompareFilterTimeRangeChecker(long timeStart, long timeEnd, boolean endClose) {
        this.timeStart = timeStart;
        this.timeEnd = timeEnd;
        this.endClose = endClose;
    }

    public CheckResult check(CompareTupleFilter compFilter, TimeDerivedColumnType timeDerivedColumnType, long timezoneOffset) {
        Object timestampValue = compFilter.getFirstValue();
        Collection conditionValues = compFilter.getValues();
        Pair<Long, Long> timeUnitRange = timeDerivedColumnType != TimeDerivedColumnType.MINUTE_START && timeDerivedColumnType != TimeDerivedColumnType.HOUR_START ? (timezoneOffset == 0L ? timeDerivedColumnType.getTimeUnitRange(timestampValue) : timeDerivedColumnType.getTimeUnitRangeTimezoneAware(timestampValue, timezoneOffset)) : timeDerivedColumnType.getTimeUnitRange(timestampValue);
        switch (compFilter.getOperator()) {
            case EQ: {
                return this.checkForEqValue(timeUnitRange);
            }
            case NEQ: {
                if (timeUnitRange.getFirst() <= this.timeStart && timeUnitRange.getSecond() >= this.timeEnd) {
                    return CheckResult.EXCLUDED;
                }
                if (timeUnitRange.getSecond() <= this.timeStart || timeUnitRange.getFirst() >= this.timeEnd) {
                    return CheckResult.INCLUDED;
                }
                return CheckResult.OVERLAP;
            }
            case LT: {
                if (!this.endClose && timeUnitRange.getFirst() >= this.timeEnd || this.endClose && timeUnitRange.getFirst() > this.timeEnd) {
                    return CheckResult.INCLUDED;
                }
                if (timeUnitRange.getFirst() <= this.timeStart) {
                    return CheckResult.EXCLUDED;
                }
                return CheckResult.OVERLAP;
            }
            case LTE: {
                if (timeUnitRange.getFirst() >= this.timeEnd) {
                    return CheckResult.INCLUDED;
                }
                if (timeUnitRange.getSecond() < this.timeStart) {
                    return CheckResult.EXCLUDED;
                }
                return CheckResult.OVERLAP;
            }
            case GT: {
                if (timeUnitRange.getSecond() < this.timeStart) {
                    return CheckResult.INCLUDED;
                }
                if (timeUnitRange.getFirst() >= this.timeEnd) {
                    return CheckResult.EXCLUDED;
                }
                return CheckResult.OVERLAP;
            }
            case GTE: {
                if (timeUnitRange.getFirst() <= this.timeStart) {
                    return CheckResult.INCLUDED;
                }
                if (!this.endClose && timeUnitRange.getFirst() >= this.timeEnd || this.endClose && timeUnitRange.getFirst() > this.timeEnd) {
                    return CheckResult.EXCLUDED;
                }
                return CheckResult.OVERLAP;
            }
            case IN: {
                return this.checkForInValues(timeDerivedColumnType, conditionValues, timezoneOffset);
            }
        }
        return CheckResult.OVERLAP;
    }

    private CheckResult checkForEqValue(Pair<Long, Long> timeUnitRange) {
        if (timeUnitRange.getFirst() <= this.timeStart && timeUnitRange.getSecond() >= this.timeEnd) {
            return CheckResult.INCLUDED;
        }
        if (timeUnitRange.getSecond() <= this.timeStart || timeUnitRange.getFirst() >= this.timeEnd) {
            return CheckResult.EXCLUDED;
        }
        return CheckResult.OVERLAP;
    }

    private CheckResult checkForInValues(TimeDerivedColumnType timeDerivedColumnType, Collection<Object> values, long timezoneOffset) {
        CheckResult result = null;
        for (Object timestampValue : values) {
            Pair<Long, Long> timeUnitRange = timeDerivedColumnType.getTimeUnitRangeTimezoneAware(timestampValue, timezoneOffset);
            CheckResult checkResult = this.checkForEqValue(timeUnitRange);
            if (result == null) {
                result = checkResult;
                continue;
            }
            result = result.or(checkResult);
        }
        return result;
    }

    public static enum CheckResult {
        INCLUDED,
        EXCLUDED,
        OVERLAP;


        public CheckResult or(CheckResult other) {
            if (this == INCLUDED || other == INCLUDED) {
                return INCLUDED;
            }
            if (this == EXCLUDED && other == EXCLUDED) {
                return EXCLUDED;
            }
            return OVERLAP;
        }
    }
}

