/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.stream.core.storage.columnar.compress;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.kylin.stream.core.storage.columnar.ColumnDataReader;
import org.apache.kylin.stream.core.storage.columnar.GeneralColumnDataReader;

public class RunLengthCompressedColumnReader
implements ColumnDataReader {
    private int valLen;
    private int numValInBlock;
    private ByteBuffer currBlockBuffer;
    private int currBlockNum;
    private int rowCount;
    private GeneralColumnDataReader blockDataReader;

    public RunLengthCompressedColumnReader(ByteBuffer dataBuffer, int columnDataStartOffset, int columnDataLength, int rowCount) {
        this.rowCount = rowCount;
        int footStartOffset = columnDataStartOffset + columnDataLength - 8;
        dataBuffer.position(footStartOffset);
        this.numValInBlock = dataBuffer.getInt();
        this.valLen = dataBuffer.getInt();
        this.blockDataReader = new GeneralColumnDataReader(dataBuffer, columnDataStartOffset, columnDataLength - 8);
        this.currBlockNum = -1;
    }

    private void loadBuffer(int targetBlockNum) {
        this.currBlockBuffer = this.blockDataReader.get(targetBlockNum);
        this.currBlockNum = targetBlockNum;
    }

    public void reset() {
        this.currBlockNum = -1;
    }

    @Override
    public Iterator<byte[]> iterator() {
        return new RunLengthCompressedColumnDataItr();
    }

    @Override
    public byte[] read(int rowNum) {
        byte[] readBuffer = new byte[this.valLen];
        int targetBlockNum = rowNum / this.numValInBlock;
        if (targetBlockNum != this.currBlockNum) {
            this.loadBuffer(targetBlockNum);
        }
        int blockStartOffset = this.currBlockBuffer.position();
        int limit = this.currBlockBuffer.limit();
        int entryNum = this.currBlockBuffer.getInt(limit - 4);
        int entryIndexStartOffset = limit - 4 - (entryNum << 2);
        int blockRowNum = rowNum % this.numValInBlock;
        int targetEntry = this.binarySearchIndex(this.currBlockBuffer, entryIndexStartOffset, entryNum, blockRowNum);
        this.currBlockBuffer.position(blockStartOffset + (this.valLen + 4) * targetEntry + 4);
        this.currBlockBuffer.get(readBuffer);
        this.currBlockBuffer.position(blockStartOffset);
        return readBuffer;
    }

    private int binarySearchIndex(ByteBuffer currBlockBuffer, int entryIndexStartOffset, int entryNum, int rowNum) {
        int low = 0;
        int high = entryNum - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            int idxVal = currBlockBuffer.getInt(entryIndexStartOffset + (mid << 2));
            if (idxVal >= rowNum) {
                high = mid - 1;
                continue;
            }
            low = mid + 1;
        }
        return low;
    }

    @Override
    public void close() throws IOException {
    }

    private class RunLengthCompressedColumnDataItr
    implements Iterator<byte[]> {
        private int currRLEntryValCnt;
        private byte[] currRLEntryVal;
        private int readRLEntryValCnt;
        private int readRowCount = 0;
        private int blockReadRowCount = 0;

        public RunLengthCompressedColumnDataItr() {
            this.currRLEntryVal = new byte[RunLengthCompressedColumnReader.this.valLen];
        }

        @Override
        public boolean hasNext() {
            return this.readRowCount < RunLengthCompressedColumnReader.this.rowCount;
        }

        @Override
        public byte[] next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            if (this.readRLEntryValCnt >= this.currRLEntryValCnt) {
                this.loadNextEntry();
            }
            ++this.readRLEntryValCnt;
            ++this.readRowCount;
            ++this.blockReadRowCount;
            return this.currRLEntryVal;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("not supported");
        }

        private void loadNextEntry() {
            if (RunLengthCompressedColumnReader.this.currBlockNum == -1 || this.blockReadRowCount >= RunLengthCompressedColumnReader.this.numValInBlock) {
                this.loadNextBuffer();
                this.blockReadRowCount = 0;
            }
            this.currRLEntryVal = new byte[RunLengthCompressedColumnReader.this.valLen];
            this.currRLEntryValCnt = RunLengthCompressedColumnReader.this.currBlockBuffer.getInt();
            RunLengthCompressedColumnReader.this.currBlockBuffer.get(this.currRLEntryVal);
            this.readRLEntryValCnt = 0;
        }

        private void loadNextBuffer() {
            RunLengthCompressedColumnReader.this.loadBuffer(RunLengthCompressedColumnReader.this.currBlockNum + 1);
        }
    }
}

