/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.stream.core.storage.columnar;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org.apache.kylin.cube.model.CubeDesc;
import org.apache.kylin.dimension.DimensionEncoding;
import org.apache.kylin.metadata.datatype.DataType;
import org.apache.kylin.metadata.model.MeasureDesc;
import org.apache.kylin.metadata.model.TblColRef;
import org.apache.kylin.shaded.com.google.common.collect.Maps;
import org.apache.kylin.stream.core.storage.columnar.ColumnDataReader;
import org.apache.kylin.stream.core.storage.columnar.ColumnarMetricsEncoding;
import org.apache.kylin.stream.core.storage.columnar.ColumnarMetricsEncodingFactory;
import org.apache.kylin.stream.core.storage.columnar.ColumnarStoreDimDesc;
import org.apache.kylin.stream.core.storage.columnar.ColumnarStoreMetricsDesc;
import org.apache.kylin.stream.core.storage.columnar.FragmentData;
import org.apache.kylin.stream.core.storage.columnar.RawRecord;
import org.apache.kylin.stream.core.storage.columnar.protocol.CuboidMetaInfo;
import org.apache.kylin.stream.core.storage.columnar.protocol.DimensionMetaInfo;
import org.apache.kylin.stream.core.storage.columnar.protocol.MetricMetaInfo;

public class FragmentCuboidReader
implements Iterable<RawRecord> {
    private long rowCount;
    private long readRowCount = 0L;
    private int dimCnt;
    private int metricCnt;
    private ColumnDataReader[] dimensionDataReaders;
    private ColumnDataReader[] metricDataReaders;

    public FragmentCuboidReader(CubeDesc cubeDesc, FragmentData fragmentData, CuboidMetaInfo cuboidMetaInfo, TblColRef[] dimensions, MeasureDesc[] measures, DimensionEncoding[] dimEncodings) {
        this.dimCnt = dimensions.length;
        this.metricCnt = measures.length;
        this.dimensionDataReaders = new ColumnDataReader[this.dimCnt];
        this.metricDataReaders = new ColumnDataReader[this.metricCnt];
        this.rowCount = cuboidMetaInfo.getNumberOfRows();
        Map<String, DimensionMetaInfo> dimensionMetaInfoMap = this.getDimensionMetaMap(cuboidMetaInfo);
        Map<String, MetricMetaInfo> metricMetaInfoMap = this.getMetricMetaMap(cuboidMetaInfo);
        int i = 0;
        for (TblColRef tblColRef : dimensions) {
            ColumnDataReader dimensionDataReader;
            DimensionMetaInfo dimensionMetaInfo = dimensionMetaInfoMap.get(tblColRef.getName());
            this.dimensionDataReaders[i] = dimensionDataReader = this.getDimensionDataReader(dimensionMetaInfo, (int)cuboidMetaInfo.getNumberOfRows(), tblColRef, dimEncodings[i], fragmentData.getDataReadBuffer());
            ++i;
        }
        i = 0;
        for (Serializable serializable : measures) {
            ColumnDataReader metricDataReader;
            MetricMetaInfo metricMetaInfo = metricMetaInfoMap.get(((MeasureDesc)serializable).getName());
            this.metricDataReaders[i] = metricDataReader = this.getMetricsDataReader((MeasureDesc)serializable, metricMetaInfo, (int)cuboidMetaInfo.getNumberOfRows(), fragmentData.getDataReadBuffer());
            ++i;
        }
    }

    public RawRecord read(int rowNum) {
        int i;
        if ((long)rowNum > this.rowCount - 1L) {
            throw new IllegalStateException("cannot read row:" + rowNum + ", total row cnt is:" + this.rowCount);
        }
        RawRecord rawRecord = new RawRecord(this.dimCnt, this.metricCnt);
        for (i = 0; i < this.dimCnt; ++i) {
            rawRecord.setDimension(i, this.dimensionDataReaders[i].read(rowNum));
        }
        for (i = 0; i < this.metricCnt; ++i) {
            rawRecord.setMetric(i, this.metricDataReaders[i].read(rowNum));
        }
        ++this.readRowCount;
        return rawRecord;
    }

    private Map<String, DimensionMetaInfo> getDimensionMetaMap(CuboidMetaInfo cuboidMetaInfo) {
        HashMap<String, DimensionMetaInfo> result = Maps.newHashMap();
        List<DimensionMetaInfo> dimensionMetaInfoList = cuboidMetaInfo.getDimensionsInfo();
        for (DimensionMetaInfo dimensionMetaInfo : dimensionMetaInfoList) {
            result.put(dimensionMetaInfo.getName(), dimensionMetaInfo);
        }
        return result;
    }

    private Map<String, MetricMetaInfo> getMetricMetaMap(CuboidMetaInfo cuboidMetaInfo) {
        HashMap<String, MetricMetaInfo> result = Maps.newHashMap();
        List<MetricMetaInfo> metricMetaInfoList = cuboidMetaInfo.getMetricsInfo();
        for (MetricMetaInfo metricMetaInfo : metricMetaInfoList) {
            result.put(metricMetaInfo.getName(), metricMetaInfo);
        }
        return result;
    }

    @Override
    public Iterator<RawRecord> iterator() {
        final RawRecord oneRawRecord = new RawRecord(this.dimCnt, this.metricCnt);
        final Iterator[] dimValItr = new Iterator[this.dimensionDataReaders.length];
        for (int i = 0; i < this.dimensionDataReaders.length; ++i) {
            dimValItr[i] = this.dimensionDataReaders[i].iterator();
        }
        final Iterator[] metricsValItr = new Iterator[this.metricDataReaders.length];
        for (int i = 0; i < this.metricDataReaders.length; ++i) {
            metricsValItr[i] = this.metricDataReaders[i].iterator();
        }
        return new Iterator<RawRecord>(){

            @Override
            public boolean hasNext() {
                return FragmentCuboidReader.this.readRowCount < FragmentCuboidReader.this.rowCount;
            }

            @Override
            public RawRecord next() {
                int i;
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                for (i = 0; i < FragmentCuboidReader.this.dimensionDataReaders.length; ++i) {
                    oneRawRecord.setDimension(i, (byte[])dimValItr[i].next());
                }
                for (i = 0; i < FragmentCuboidReader.this.metricDataReaders.length; ++i) {
                    oneRawRecord.setMetric(i, (byte[])metricsValItr[i].next());
                }
                FragmentCuboidReader.this.readRowCount++;
                return oneRawRecord;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("unSupported");
            }
        };
    }

    public long getReadRowCount() {
        return this.readRowCount;
    }

    public ColumnDataReader getDimensionDataReader(DimensionMetaInfo dimensionMetaInfo, int numberOfRows, TblColRef dimension, DimensionEncoding dimensionEncoding, ByteBuffer dataReadBuffer) {
        ColumnarStoreDimDesc cStoreDimDesc = new ColumnarStoreDimDesc(dimensionEncoding.getLengthOfEncoding(), dimensionMetaInfo.getCompressionType());
        return cStoreDimDesc.getDimReader(dataReadBuffer, dimensionMetaInfo.getStartOffset(), dimensionMetaInfo.getDataLength(), numberOfRows);
    }

    public ColumnDataReader getMetricsDataReader(MeasureDesc measure, MetricMetaInfo metricMetaInfo, int numberOfRows, ByteBuffer dataReadBuffer) {
        DataType type = measure.getFunction().getReturnDataType();
        ColumnarMetricsEncoding metricsEncoding = ColumnarMetricsEncodingFactory.create(type);
        ColumnarStoreMetricsDesc cStoreMetricsDesc = new ColumnarStoreMetricsDesc(metricsEncoding, metricMetaInfo.getCompressionType());
        return cStoreMetricsDesc.getMetricsReader(dataReadBuffer, metricMetaInfo.getStartOffset(), metricMetaInfo.getMetricLength(), numberOfRows);
    }
}

