/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.stream.core.storage.columnar;

import java.io.IOException;
import java.util.List;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.kylin.shaded.com.google.common.cache.CacheBuilder;
import org.apache.kylin.shaded.com.google.common.cache.CacheLoader;
import org.apache.kylin.shaded.com.google.common.cache.CacheStats;
import org.apache.kylin.shaded.com.google.common.cache.LoadingCache;
import org.apache.kylin.shaded.com.google.common.cache.RemovalListener;
import org.apache.kylin.shaded.com.google.common.cache.RemovalNotification;
import org.apache.kylin.shaded.com.google.common.collect.Maps;
import org.apache.kylin.stream.core.storage.columnar.ColumnarStoreCacheStats;
import org.apache.kylin.stream.core.storage.columnar.DataSegmentFragment;
import org.apache.kylin.stream.core.storage.columnar.FragmentData;
import org.apache.kylin.stream.core.storage.columnar.protocol.FragmentMetaInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ColumnarStoreCache {
    private static Logger logger = LoggerFactory.getLogger(ColumnarStoreCache.class);
    private static ColumnarStoreCache instance = new ColumnarStoreCache();
    private static final int INIT_CACHE_SIZE = 100;
    private static final int CACHE_SIZE = 10000;
    private static final long MAX_BUFFERED_SIZE = Long.MAX_VALUE;
    private AtomicLong currentBufferedSize = new AtomicLong(0L);
    private ConcurrentMap<DataSegmentFragment, AtomicLong> refCounters = Maps.newConcurrentMap();
    public LoadingCache<DataSegmentFragment, FragmentData> fragmentDataCache = CacheBuilder.newBuilder().initialCapacity(100).concurrencyLevel(8).maximumSize(10000L).expireAfterAccess(6L, TimeUnit.HOURS).removalListener(new RemovalListener<DataSegmentFragment, FragmentData>(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onRemoval(RemovalNotification<DataSegmentFragment, FragmentData> notification) {
            DataSegmentFragment fragment = (DataSegmentFragment)notification.getKey();
            logger.debug("Data fragment " + fragment + " is unloaded from Cache due to " + (Object)((Object)notification.getCause()));
            FragmentData fragmentData = (FragmentData)notification.getValue();
            AtomicLong refCounter = (AtomicLong)ColumnarStoreCache.this.refCounters.get(fragment);
            if (refCounter != null) {
                AtomicLong atomicLong = refCounter;
                synchronized (atomicLong) {
                    if (refCounter.get() <= 0L) {
                        int bufferSize = fragmentData.getBufferCapacity();
                        ColumnarStoreCache.this.currentBufferedSize.addAndGet(-bufferSize);
                        fragmentData.tryForceUnMapBuffer();
                        ColumnarStoreCache.this.refCounters.remove(fragment);
                    } else {
                        logger.debug("Fragment mapped buffer " + fragment + " cannot be cleaned, because it has reference " + refCounter.get());
                    }
                }
            } else {
                logger.debug("no ref counter found for fragment: " + fragment);
            }
        }
    }).build(new CacheLoader<DataSegmentFragment, FragmentData>(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public FragmentData load(DataSegmentFragment fragment) throws Exception {
            FragmentMetaInfo fragmentMetaInfo;
            if (ColumnarStoreCache.this.currentBufferedSize.get() >= Long.MAX_VALUE) {
                LoadingCache<DataSegmentFragment, FragmentData> loadingCache = ColumnarStoreCache.this.fragmentDataCache;
                synchronized (loadingCache) {
                    if (ColumnarStoreCache.this.currentBufferedSize.get() >= Long.MAX_VALUE) {
                        long entrySize = ColumnarStoreCache.this.fragmentDataCache.size();
                        logger.debug("Max buffer size exceeds {}, invalidate half of the cache, cacheSize {}", (Object)ColumnarStoreCache.this.currentBufferedSize, (Object)entrySize);
                        long removed = 0L;
                        for (DataSegmentFragment frag : ColumnarStoreCache.this.fragmentDataCache.asMap().keySet()) {
                            if (removed >= entrySize / 2L) break;
                            ColumnarStoreCache.this.fragmentDataCache.invalidate(frag);
                            ++removed;
                        }
                    }
                }
            }
            if ((fragmentMetaInfo = fragment.getMetaInfo()) == null) {
                throw new IllegalStateException("no metadata file exists for fragment:" + fragment);
            }
            FragmentData fragmentData = new FragmentData(fragmentMetaInfo, fragment.getDataFile());
            int bufferSize = fragmentData.getBufferCapacity();
            ColumnarStoreCache.this.currentBufferedSize.addAndGet(bufferSize);
            logger.debug("Data fragment {} cached, bufferSize {}, totalBufferSize {}", fragment, bufferSize, ColumnarStoreCache.this.currentBufferedSize.get());
            return fragmentData;
        }
    });

    public static ColumnarStoreCache getInstance() {
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FragmentData startReadFragmentData(DataSegmentFragment fragment) throws IOException {
        try {
            AtomicLong refCounter = this.refCounters.putIfAbsent(fragment, new AtomicLong(1L));
            if (refCounter != null) {
                AtomicLong atomicLong = refCounter;
                synchronized (atomicLong) {
                    refCounter.incrementAndGet();
                }
            }
            return this.fragmentDataCache.get(fragment);
        }
        catch (ExecutionException e) {
            throw new IOException(e);
        }
    }

    public void finishReadFragmentData(DataSegmentFragment fragment) {
        AtomicLong refCounter = (AtomicLong)this.refCounters.get(fragment);
        if (refCounter != null) {
            refCounter.decrementAndGet();
        } else {
            logger.warn("Ref counter not exist for fragment:{}", (Object)fragment);
        }
    }

    public ColumnarStoreCacheStats getCacheStats() {
        ColumnarStoreCacheStats stats = new ColumnarStoreCacheStats();
        CacheStats cacheStats = this.fragmentDataCache.stats();
        stats.setHitCount(cacheStats.hitCount());
        stats.setMissCount(cacheStats.missCount());
        stats.setEvictionCount(cacheStats.evictionCount());
        stats.setLoadSuccessCount(cacheStats.loadSuccessCount());
        stats.setLoadExceptionCount(cacheStats.loadExceptionCount());
        stats.setTotalLoadTime(cacheStats.totalLoadTime());
        stats.setCacheEntriesNum(this.fragmentDataCache.size());
        stats.setCachedDataBufferSize(this.currentBufferedSize.get());
        return stats;
    }

    public void removeFragmentsCache(List<DataSegmentFragment> fragmentList) {
        if (fragmentList == null) {
            return;
        }
        for (DataSegmentFragment fragment : fragmentList) {
            this.fragmentDataCache.invalidate(fragment);
        }
    }

    public void removeFragmentCache(DataSegmentFragment fragment) {
        if (fragment == null) {
            return;
        }
        this.fragmentDataCache.invalidate(fragment);
    }
}

