/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.stream.core.query;

import java.util.TimeZone;
import org.apache.kylin.cube.model.CubeDesc;
import org.apache.kylin.dimension.TimeDerivedColumnType;
import org.apache.kylin.metadata.filter.CompareTupleFilter;
import org.apache.kylin.metadata.filter.ConstantTupleFilter;
import org.apache.kylin.metadata.filter.LogicalTupleFilter;
import org.apache.kylin.metadata.filter.TupleFilter;
import org.apache.kylin.metadata.model.TblColRef;
import org.apache.kylin.stream.core.util.CompareFilterTimeRangeChecker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamingDataQueryPlanner {
    private static Logger logger = LoggerFactory.getLogger(StreamingDataQueryPlanner.class);
    protected CubeDesc cubeDesc;
    protected TupleFilter filter;
    protected TupleFilter flatFilter;
    private final long timezoneOffset;

    public StreamingDataQueryPlanner(CubeDesc cubeDesc, TupleFilter filter) {
        this.cubeDesc = cubeDesc;
        this.filter = filter;
        this.flatFilter = this.flattenToOrAndFilter(filter);
        String timezoneName = cubeDesc.getConfig().getStreamingDerivedTimeTimezone();
        this.timezoneOffset = timezoneName == null || timezoneName.length() == 0 ? 0L : (long)TimeZone.getTimeZone(timezoneName).getRawOffset();
    }

    public boolean canSkip(long timeStart, long timeEnd) {
        return this.canSkip(timeStart, timeEnd, false);
    }

    public boolean canSkip(long timeStart, long timeEnd, boolean endInclude) {
        if (this.flatFilter == null) {
            return false;
        }
        CompareFilterTimeRangeChecker timeRangeChecker = new CompareFilterTimeRangeChecker(timeStart, timeEnd, endInclude);
        for (TupleFilter tupleFilter : this.flatFilter.getChildren()) {
            if (tupleFilter.getOperator() != TupleFilter.FilterOperatorEnum.AND) {
                throw new IllegalStateException("Filter should be AND instead of " + tupleFilter);
            }
            if (this.canSkipForAndFilter(tupleFilter, timeRangeChecker)) continue;
            return false;
        }
        return true;
    }

    private boolean canSkipForAndFilter(TupleFilter andFilter, CompareFilterTimeRangeChecker timeRangeChecker) {
        for (TupleFilter tupleFilter : andFilter.getChildren()) {
            TimeDerivedColumnType timeDerivedColumnType;
            CompareFilterTimeRangeChecker.CheckResult checkResult;
            CompareTupleFilter comp;
            TblColRef column;
            if (!(!(tupleFilter instanceof CompareTupleFilter) ? tupleFilter instanceof ConstantTupleFilter && !tupleFilter.evaluate(null, null) : (column = (comp = (CompareTupleFilter)tupleFilter).getColumn()) != null && TimeDerivedColumnType.isTimeDerivedColumn(column.getName()) && (checkResult = timeRangeChecker.check(comp, timeDerivedColumnType = TimeDerivedColumnType.getTimeDerivedColumnType(column.getName()), this.timezoneOffset)) == CompareFilterTimeRangeChecker.CheckResult.EXCLUDED)) continue;
            return true;
        }
        return false;
    }

    protected TupleFilter flattenToOrAndFilter(TupleFilter filter) {
        if (filter == null) {
            return null;
        }
        TupleFilter flatFilter = filter.flatFilter();
        if (flatFilter.getOperator() == TupleFilter.FilterOperatorEnum.AND) {
            LogicalTupleFilter f = new LogicalTupleFilter(TupleFilter.FilterOperatorEnum.OR);
            f.addChild(flatFilter);
            flatFilter = f;
        }
        if (flatFilter.getOperator() != TupleFilter.FilterOperatorEnum.OR) {
            throw new IllegalStateException();
        }
        return flatFilter;
    }
}

