/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.stream.core.model;

import java.util.HashSet;
import java.util.Set;

public class SegmentBuildState
implements Comparable<SegmentBuildState> {
    private String segmentName;
    private Set<Integer> completeReplicaSets = new HashSet<Integer>();
    private BuildState state;

    public SegmentBuildState(String segmentName) {
        this.segmentName = segmentName;
    }

    public Set<Integer> getCompleteReplicaSets() {
        return this.completeReplicaSets;
    }

    public void setCompleteReplicaSets(Set<Integer> completeReplicaSets) {
        this.completeReplicaSets = completeReplicaSets;
    }

    public void addCompleteReplicaSet(int replicaSetID) {
        this.completeReplicaSets.add(replicaSetID);
    }

    public BuildState getState() {
        return this.state;
    }

    public void setState(BuildState state) {
        this.state = state;
    }

    public boolean isInBuilding() {
        if (this.state == null) {
            return false;
        }
        return BuildState.State.BUILDING.equals((Object)this.state.getState());
    }

    public boolean isInWaiting() {
        return this.state == null || BuildState.State.WAIT.equals((Object)this.state.getState());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SegmentBuildState that = (SegmentBuildState)o;
        if (this.segmentName != null ? !this.segmentName.equals(that.segmentName) : that.segmentName != null) {
            return false;
        }
        if (this.completeReplicaSets != null ? !this.completeReplicaSets.equals(that.completeReplicaSets) : that.completeReplicaSets != null) {
            return false;
        }
        return this.state != null ? this.state.equals(that.state) : that.state == null;
    }

    public int hashCode() {
        int result = this.segmentName != null ? this.segmentName.hashCode() : 0;
        result = 31 * result + (this.completeReplicaSets != null ? this.completeReplicaSets.hashCode() : 0);
        result = 31 * result + (this.state != null ? this.state.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "SegmentBuildState{segmentName='" + this.segmentName + '\'' + ", completeReplicaSets=" + this.completeReplicaSets + ", state=" + this.state + '}';
    }

    @Override
    public int compareTo(SegmentBuildState o) {
        return this.segmentName.compareTo(o.segmentName);
    }

    public String getSegmentName() {
        return this.segmentName;
    }

    public void setSegmentName(String segmentName) {
        this.segmentName = segmentName;
    }

    public static class BuildState {
        private State state = State.WAIT;
        private long buildStartTime;
        private String jobId;

        public State getState() {
            return this.state;
        }

        public void setState(State state) {
            this.state = state;
        }

        public long getBuildStartTime() {
            return this.buildStartTime;
        }

        public void setBuildStartTime(long buildStartTime) {
            this.buildStartTime = buildStartTime;
        }

        public String getJobId() {
            return this.jobId;
        }

        public void setJobId(String jobId) {
            this.jobId = jobId;
        }

        public static enum State {
            WAIT,
            BUILDING;

        }
    }
}

