/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.stream.core.consumer;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.kylin.shaded.com.google.common.collect.Lists;
import org.apache.kylin.shaded.com.google.common.collect.Sets;
import org.apache.kylin.stream.core.consumer.IStopConsumptionCondition;
import org.apache.kylin.stream.core.model.StreamingMessage;
import org.apache.kylin.stream.core.source.ISourcePosition;
import org.apache.kylin.stream.core.source.Partition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EndPositionStopCondition
implements IStopConsumptionCondition {
    private static final Logger logger = LoggerFactory.getLogger(EndPositionStopCondition.class);
    private ISourcePosition endPosition;
    private Set<Integer> finishPartitions = Sets.newHashSet();
    private int expectedEndPartitionNum;

    public EndPositionStopCondition(ISourcePosition endPosition) {
        this.endPosition = endPosition;
    }

    @Override
    public void init(List<Partition> consumingPartitions) {
        HashSet<Integer> partitionIDSets = Sets.newHashSet();
        for (Partition partition : consumingPartitions) {
            partitionIDSets.add(partition.getPartitionId());
        }
        ArrayList<Integer> endPartitionIdList = Lists.newArrayList(this.endPosition.getPartitionPositions().keySet());
        for (Integer endPartitionId : endPartitionIdList) {
            if (!partitionIDSets.contains(endPartitionId)) continue;
            ++this.expectedEndPartitionNum;
        }
    }

    @Override
    public boolean isSatisfied(StreamingMessage event) {
        boolean exceed;
        if (this.endPosition == null) {
            return false;
        }
        ISourcePosition.IPartitionPosition partitionPosition = event.getSourcePosition();
        int partition = partitionPosition.getPartition();
        ISourcePosition.IPartitionPosition endPartPos = this.endPosition.getPartitionPositions().get(partition);
        if (endPartPos == null) {
            return false;
        }
        boolean bl = exceed = partitionPosition.compareTo(endPartPos) > 0;
        if (exceed) {
            event.setFiltered(true);
            if (!this.finishPartitions.contains(partition)) {
                this.finishPartitions.add(partition);
                logger.info("finished partitions: " + this.finishPartitions);
            }
        }
        return this.finishPartitions.size() == this.expectedEndPartitionNum;
    }

    public String toString() {
        return "EndPositionStopCondition{partitionEndOffsets=" + this.endPosition + '}';
    }
}

