/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.stream.coordinator.assign;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.kylin.shaded.com.google.common.collect.Lists;
import org.apache.kylin.shaded.com.google.common.collect.Maps;
import org.apache.kylin.stream.core.model.CubeAssignment;
import org.apache.kylin.stream.core.source.Partition;

public class AssignmentUtil {
    public static Map<Integer, Map<String, List<Partition>>> convertCubeAssign2ReplicaSetAssign(List<CubeAssignment> cubeAssignmentList) {
        HashMap<Integer, Map<String, List<Partition>>> nodeAssignmentsMap = Maps.newHashMap();
        for (CubeAssignment cubeAssignment : cubeAssignmentList) {
            String cubeName = cubeAssignment.getCubeName();
            for (Integer replicaSetID : cubeAssignment.getReplicaSetIDs()) {
                List<Partition> partitions = cubeAssignment.getPartitionsByReplicaSetID(replicaSetID);
                LinkedHashMap<String, List<Partition>> nodeAssignment = (LinkedHashMap<String, List<Partition>>)nodeAssignmentsMap.get(replicaSetID);
                if (nodeAssignment == null) {
                    nodeAssignment = Maps.newLinkedHashMap();
                    nodeAssignmentsMap.put(replicaSetID, nodeAssignment);
                }
                nodeAssignment.put(cubeName, partitions);
            }
        }
        return nodeAssignmentsMap;
    }

    public static List<CubeAssignment> convertReplicaSetAssign2CubeAssign(Map<Integer, Map<String, List<Partition>>> replicaSetAssignmentsMap) {
        HashMap cubeAssignmentsMap = Maps.newHashMap();
        for (Map.Entry<Integer, Map<String, List<Partition>>> entry : replicaSetAssignmentsMap.entrySet()) {
            Integer replicaSetID = entry.getKey();
            Map<String, List<Partition>> nodeAssignmentsInfo = entry.getValue();
            for (Map.Entry<String, List<Partition>> assignment : nodeAssignmentsInfo.entrySet()) {
                String cubeName = assignment.getKey();
                List<Partition> partitions = assignment.getValue();
                HashMap<Integer, List<Partition>> cubeAssignment = (HashMap<Integer, List<Partition>>)cubeAssignmentsMap.get(cubeName);
                if (cubeAssignment == null) {
                    cubeAssignment = Maps.newHashMap();
                    cubeAssignmentsMap.put(cubeName, cubeAssignment);
                }
                cubeAssignment.put(replicaSetID, partitions);
            }
        }
        ArrayList<CubeAssignment> result = Lists.newArrayList();
        for (Map.Entry cubeAssignmentsEntry : cubeAssignmentsMap.entrySet()) {
            CubeAssignment cubeAssignment = new CubeAssignment((String)cubeAssignmentsEntry.getKey(), (Map)cubeAssignmentsEntry.getValue());
            result.add(cubeAssignment);
        }
        return result;
    }
}

