/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.stream.coordinator;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.recipes.leader.LeaderSelector;
import org.apache.curator.framework.recipes.leader.LeaderSelectorListener;
import org.apache.curator.framework.recipes.leader.LeaderSelectorListenerAdapter;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.HadoopUtil;
import org.apache.kylin.common.util.JsonUtil;
import org.apache.kylin.common.util.Pair;
import org.apache.kylin.common.util.ServerMode;
import org.apache.kylin.cube.CubeInstance;
import org.apache.kylin.cube.CubeManager;
import org.apache.kylin.cube.CubeSegment;
import org.apache.kylin.engine.mr.CubingJob;
import org.apache.kylin.engine.mr.StreamingCubingEngine;
import org.apache.kylin.job.execution.AbstractExecutable;
import org.apache.kylin.job.execution.DefaultChainedExecutable;
import org.apache.kylin.job.execution.ExecutableManager;
import org.apache.kylin.job.execution.ExecutableState;
import org.apache.kylin.metadata.model.SegmentRange;
import org.apache.kylin.metadata.model.SegmentStatusEnum;
import org.apache.kylin.metadata.model.Segments;
import org.apache.kylin.metadata.realization.RealizationStatusEnum;
import org.apache.kylin.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.kylin.shaded.com.google.common.base.Function;
import org.apache.kylin.shaded.com.google.common.collect.Collections2;
import org.apache.kylin.shaded.com.google.common.collect.Lists;
import org.apache.kylin.shaded.com.google.common.collect.MapDifference;
import org.apache.kylin.shaded.com.google.common.collect.Maps;
import org.apache.kylin.shaded.com.google.common.collect.Sets;
import org.apache.kylin.stream.coordinator.StreamMetadataStore;
import org.apache.kylin.stream.coordinator.StreamMetadataStoreFactory;
import org.apache.kylin.stream.coordinator.StreamingCubeInfo;
import org.apache.kylin.stream.coordinator.StreamingUtils;
import org.apache.kylin.stream.coordinator.assign.Assigner;
import org.apache.kylin.stream.coordinator.assign.AssignmentUtil;
import org.apache.kylin.stream.coordinator.assign.AssignmentsCache;
import org.apache.kylin.stream.coordinator.assign.CubePartitionRoundRobinAssigner;
import org.apache.kylin.stream.coordinator.assign.DefaultAssigner;
import org.apache.kylin.stream.coordinator.client.CoordinatorClient;
import org.apache.kylin.stream.coordinator.exception.ClusterStateException;
import org.apache.kylin.stream.coordinator.exception.CoordinateException;
import org.apache.kylin.stream.coordinator.exception.NotLeadCoordinatorException;
import org.apache.kylin.stream.coordinator.exception.StoreException;
import org.apache.kylin.stream.core.client.HttpReceiverAdminClient;
import org.apache.kylin.stream.core.client.ReceiverAdminClient;
import org.apache.kylin.stream.core.consumer.ConsumerStartProtocol;
import org.apache.kylin.stream.core.model.AssignRequest;
import org.apache.kylin.stream.core.model.ConsumerStatsResponse;
import org.apache.kylin.stream.core.model.CubeAssignment;
import org.apache.kylin.stream.core.model.Node;
import org.apache.kylin.stream.core.model.PauseConsumersRequest;
import org.apache.kylin.stream.core.model.ReplicaSet;
import org.apache.kylin.stream.core.model.ResumeConsumerRequest;
import org.apache.kylin.stream.core.model.SegmentBuildState;
import org.apache.kylin.stream.core.model.StartConsumersRequest;
import org.apache.kylin.stream.core.model.StopConsumersRequest;
import org.apache.kylin.stream.core.model.StreamingCubeConsumeState;
import org.apache.kylin.stream.core.model.UnAssignRequest;
import org.apache.kylin.stream.core.model.stats.ReceiverCubeStats;
import org.apache.kylin.stream.core.source.ISourcePosition;
import org.apache.kylin.stream.core.source.ISourcePositionHandler;
import org.apache.kylin.stream.core.source.IStreamingSource;
import org.apache.kylin.stream.core.source.Partition;
import org.apache.kylin.stream.core.source.StreamingSourceFactory;
import org.apache.kylin.stream.core.source.StreamingTableSourceInfo;
import org.apache.kylin.stream.core.util.HDFSUtil;
import org.apache.kylin.stream.core.util.NamedThreadFactory;
import org.apache.kylin.stream.core.util.NodeUtil;
import org.apache.kylin.tool.shaded.com.fasterxml.jackson.core.JsonProcessingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class Coordinator
implements CoordinatorClient {
    private static final Logger logger = LoggerFactory.getLogger(Coordinator.class);
    private static final int DEFAULT_PORT = 7070;
    private static volatile Coordinator instance = null;
    private StreamMetadataStore streamMetadataStore;
    private Assigner assigner;
    private ReceiverAdminClient receiverAdminClient;
    private CuratorFramework zkClient;
    private CoordinatorLeaderSelector selector;
    private volatile boolean isLead = false;
    private ScheduledExecutorService streamingJobCheckExecutor;
    private StreamingBuildJobStatusChecker jobStatusChecker;

    private Coordinator() {
        this.streamMetadataStore = StreamMetadataStoreFactory.getStreamMetaDataStore();
        this.receiverAdminClient = new HttpReceiverAdminClient();
        this.assigner = this.getAssigner();
        this.zkClient = StreamingUtils.getZookeeperClient();
        this.selector = new CoordinatorLeaderSelector();
        this.jobStatusChecker = new StreamingBuildJobStatusChecker();
        this.streamingJobCheckExecutor = Executors.newScheduledThreadPool(1, new NamedThreadFactory("streaming_job_status_checker"));
        if (ServerMode.SERVER_MODE.canServeStreamingCoordinator()) {
            this.start();
        }
    }

    @VisibleForTesting
    public Coordinator(StreamMetadataStore metadataStore, ReceiverAdminClient receiverClient) {
        this.streamMetadataStore = metadataStore;
        this.receiverAdminClient = receiverClient;
        this.assigner = this.getAssigner();
        this.zkClient = StreamingUtils.getZookeeperClient();
        this.selector = new CoordinatorLeaderSelector();
        this.jobStatusChecker = new StreamingBuildJobStatusChecker();
        this.streamingJobCheckExecutor = Executors.newScheduledThreadPool(1, new NamedThreadFactory("streaming_job_status_checker"));
        if (ServerMode.SERVER_MODE.canServeStreamingCoordinator()) {
            this.start();
        }
        this.isLead = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Coordinator getInstance() {
        if (instance != null) return instance;
        Class<Coordinator> clazz = Coordinator.class;
        synchronized (Coordinator.class) {
            if (instance != null) return instance;
            instance = new Coordinator();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public void start() {
        this.selector.start();
        this.streamingJobCheckExecutor.scheduleAtFixedRate(this.jobStatusChecker, 0L, 2L, TimeUnit.MINUTES);
    }

    @VisibleForTesting
    public void setReceiverAdminClient(ReceiverAdminClient receiverAdminClient) {
        this.receiverAdminClient = receiverAdminClient;
    }

    @VisibleForTesting
    public void setToLeader() {
        this.streamMetadataStore.setCoordinatorNode(NodeUtil.getCurrentNode(7070));
        this.isLead = true;
    }

    private void restoreJobStatusChecker() {
        logger.info("restore job status checker");
        List<String> cubes = this.streamMetadataStore.getCubes();
        for (String cube : cubes) {
            List<SegmentBuildState> segmentBuildStates = this.streamMetadataStore.getSegmentBuildStates(cube);
            Collections.sort(segmentBuildStates);
            for (SegmentBuildState segmentBuildState : segmentBuildStates) {
                if (!segmentBuildState.isInBuilding()) continue;
                SegmentJobBuildInfo jobBuildInfo = new SegmentJobBuildInfo(cube, segmentBuildState.getSegmentName(), segmentBuildState.getState().getJobId());
                this.jobStatusChecker.addSegmentBuildJob(jobBuildInfo);
            }
        }
    }

    @Override
    public synchronized void assignCube(String cubeName) {
        this.checkLead();
        this.streamMetadataStore.addStreamingCube(cubeName);
        StreamingCubeInfo cube = this.getStreamCubeInfo(cubeName);
        CubeAssignment existAssignment = this.streamMetadataStore.getAssignmentsByCube(cube.getCubeName());
        if (existAssignment != null) {
            logger.warn("cube " + cube.getCubeName() + " is already assigned.");
            return;
        }
        List<ReplicaSet> replicaSets = this.streamMetadataStore.getReplicaSets();
        if (replicaSets == null || replicaSets.isEmpty()) {
            throw new IllegalStateException("no replicaSet is configured in system");
        }
        CubeAssignment assignment = this.assigner.assign(cube, replicaSets, this.streamMetadataStore.getAllCubeAssignments());
        this.doAssignCube(cubeName, assignment);
    }

    @Override
    public void unAssignCube(String cubeName) {
        this.checkLead();
        CubeAssignment assignment = this.streamMetadataStore.getAssignmentsByCube(cubeName);
        if (assignment == null) {
            return;
        }
        ArrayList unAssignedFailReceivers = Lists.newArrayList();
        try {
            logger.info("send unAssign cube:{} request to receivers", (Object)cubeName);
            for (Integer replicaSetID : assignment.getReplicaSetIDs()) {
                ReplicaSet rs = this.streamMetadataStore.getReplicaSet(replicaSetID);
                UnAssignRequest request = new UnAssignRequest();
                request.setCube(cubeName);
                for (Node receiver : rs.getNodes()) {
                    try {
                        this.unAssignToReceiver(receiver, request);
                    }
                    catch (Exception e) {
                        logger.error("exception throws when unAssign receiver", e);
                    }
                }
            }
            logger.info("remove temp hdfs files");
            this.removeCubeHDFSFiles(cubeName);
            logger.info("clear cube info from job check list");
            this.jobStatusChecker.clearCheckCube(cubeName);
            logger.info("remove cube info in metadata store");
            this.streamMetadataStore.removeStreamingCube(cubeName);
            AssignmentsCache.getInstance().clearCubeCache(cubeName);
        }
        catch (Exception e) {
            throw new CoordinateException(e);
        }
        if (unAssignedFailReceivers.size() > 0) {
            String msg = "unAssign fail for receivers:" + unAssignedFailReceivers;
            throw new CoordinateException(msg);
        }
    }

    @Override
    public synchronized void reAssignCube(String cubeName, CubeAssignment assignments) {
        this.checkLead();
        CubeAssignment preAssignments = this.streamMetadataStore.getAssignmentsByCube(cubeName);
        if (preAssignments == null) {
            logger.info("no previous cube assign exists, use the new assignment:{}", (Object)assignments);
            this.doAssignCube(cubeName, assignments);
        } else {
            this.reassignCubeImpl(cubeName, preAssignments, assignments);
        }
    }

    @Override
    public void segmentRemoteStoreComplete(Node receiver, String cubeName, Pair<Long, Long> segment) {
        this.checkLead();
        logger.info("segment remote store complete signal received for cube:{}, segment:{}, try to find proper segment to build", (Object)cubeName, (Object)segment);
        this.tryFindAndBuildSegment(cubeName);
    }

    @Override
    public Map<Integer, Map<String, List<Partition>>> reBalanceRecommend() {
        this.checkLead();
        return this.reBalancePlan(this.getEnableStreamingCubes(), this.streamMetadataStore.getReplicaSets());
    }

    @Override
    public synchronized void reBalance(Map<Integer, Map<String, List<Partition>>> newAssignmentsPlan) {
        this.checkLead();
        List<CubeAssignment> currCubeAssignments = this.streamMetadataStore.getAllCubeAssignments();
        List<CubeAssignment> newCubeAssignments = AssignmentUtil.convertReplicaSetAssign2CubeAssign(newAssignmentsPlan);
        this.doReBalance(currCubeAssignments, newCubeAssignments);
    }

    @Override
    public void pauseConsumers(String cubeName) {
        this.checkLead();
        CubeAssignment assignment = this.streamMetadataStore.getAssignmentsByCube(cubeName);
        PauseConsumersRequest request = new PauseConsumersRequest();
        request.setCube(cubeName);
        try {
            for (Integer rsID : assignment.getReplicaSetIDs()) {
                ReplicaSet rs = this.streamMetadataStore.getReplicaSet(rsID);
                this.pauseConsumersInReplicaSet(rs, request);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.streamMetadataStore.saveStreamingCubeConsumeState(cubeName, StreamingCubeConsumeState.PAUSED);
    }

    @Override
    public void resumeConsumers(String cubeName) {
        this.checkLead();
        CubeAssignment assignment = this.streamMetadataStore.getAssignmentsByCube(cubeName);
        ResumeConsumerRequest request = new ResumeConsumerRequest();
        request.setCube(cubeName);
        try {
            for (Integer rsID : assignment.getReplicaSetIDs()) {
                ReplicaSet rs = this.streamMetadataStore.getReplicaSet(rsID);
                this.resumeConsumersInReplicaSet(rs, request);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.streamMetadataStore.saveStreamingCubeConsumeState(cubeName, StreamingCubeConsumeState.RUNNING);
    }

    @Override
    public void replicaSetLeaderChange(int replicaSetID, Node newLeader) {
        this.checkLead();
        Map<String, List<Partition>> assignment = this.streamMetadataStore.getAssignmentsByReplicaSet(replicaSetID);
        if (assignment == null || assignment.isEmpty()) {
            return;
        }
        for (String cubeName : assignment.keySet()) {
            AssignmentsCache.getInstance().clearCubeCache(cubeName);
        }
    }

    private void checkLead() {
        if (!this.isLead) {
            Node coordinatorLeader;
            try {
                coordinatorLeader = this.streamMetadataStore.getCoordinatorNode();
            }
            catch (StoreException store) {
                throw new NotLeadCoordinatorException("Lead coordinator can not found.", store);
            }
            throw new NotLeadCoordinatorException("Current coordinator is not lead, please check host " + coordinatorLeader);
        }
    }

    public StreamingCubeInfo getStreamCubeInfo(String cubeName) {
        CubeInstance cube = CubeManager.getInstance(this.getConfig()).getCube(cubeName);
        if (cube == null) {
            return null;
        }
        int numOfConsumerTasks = cube.getConfig().getStreamingCubeConsumerTasksNum();
        IStreamingSource streamingSource = StreamingSourceFactory.getStreamingSource(cube);
        StreamingTableSourceInfo tableSourceInfo = streamingSource.load(cubeName);
        return new StreamingCubeInfo(cubeName, tableSourceInfo, numOfConsumerTasks);
    }

    private KylinConfig getConfig() {
        return KylinConfig.getInstanceFromEnv();
    }

    private void doAssignCube(String cubeName, CubeAssignment assignment) {
        HashSet<ReplicaSet> successRS = Sets.newHashSet();
        try {
            for (Integer rsID : assignment.getReplicaSetIDs()) {
                ReplicaSet rs = this.streamMetadataStore.getReplicaSet(rsID);
                this.assignCubeToReplicaSet(rs, cubeName, assignment.getPartitionsByReplicaSetID(rsID), true, false);
                successRS.add(rs);
            }
            this.streamMetadataStore.saveNewCubeAssignment(assignment);
        }
        catch (Exception e) {
            for (ReplicaSet rs : successRS) {
                try {
                    UnAssignRequest request = new UnAssignRequest();
                    request.setCube(cubeName);
                    this.unAssignFromReplicaSet(rs, request);
                }
                catch (IOException e1) {
                    logger.error("error when roll back assignment", e);
                }
            }
            throw new RuntimeException(e);
        }
    }

    private CubeAssignment reassignCubeImpl(String cubeName, CubeAssignment preAssignments, CubeAssignment newAssignments) {
        logger.info("start cube reBalance, cube:{}, previous assignments:{}, new assignments:{}", cubeName, preAssignments, newAssignments);
        if (newAssignments.equals(preAssignments)) {
            logger.info("the new assignment is the same as the previous assignment, do nothing for this reassignment");
            return newAssignments;
        }
        CubeInstance cubeInstance = CubeManager.getInstance(KylinConfig.getInstanceFromEnv()).getCube(cubeName);
        this.doReassign(cubeInstance, preAssignments, newAssignments);
        MapDifference<Integer, List<Partition>> assignDiff = Maps.difference(preAssignments.getAssignments(), newAssignments.getAssignments());
        Map<Integer, List<Partition>> removedAssign = assignDiff.entriesOnlyOnLeft();
        for (Integer removedReplicaSet : removedAssign.keySet()) {
            newAssignments.addAssignment(removedReplicaSet, Lists.newArrayList());
        }
        this.streamMetadataStore.saveNewCubeAssignment(newAssignments);
        AssignmentsCache.getInstance().clearCubeCache(cubeName);
        return newAssignments;
    }

    void doReassign(CubeInstance cubeInstance, CubeAssignment preAssignments, CubeAssignment newAssignments) {
        ISourcePosition consumePosition;
        String cubeName = preAssignments.getCubeName();
        IStreamingSource streamingSource = StreamingSourceFactory.getStreamingSource(cubeInstance);
        MapDifference<Integer, List<Partition>> assignDiff = Maps.difference(preAssignments.getAssignments(), newAssignments.getAssignments());
        Map<Integer, List<Partition>> sameAssign = assignDiff.entriesInCommon();
        Map<Integer, List<Partition>> newAssign = assignDiff.entriesOnlyOnRight();
        Map<Integer, List<Partition>> removedAssign = assignDiff.entriesOnlyOnLeft();
        ArrayList<ISourcePosition> allPositions = Lists.newArrayList();
        ArrayList<ReplicaSet> successSyncReplicaSet = Lists.newArrayList();
        try {
            for (Map.Entry<Integer, List<Partition>> assignmentEntry : preAssignments.getAssignments().entrySet()) {
                Integer replicaSetID = assignmentEntry.getKey();
                if (sameAssign.containsKey(replicaSetID)) {
                    logger.info("the assignment is not changed for cube:{}, replicaSet:{}", (Object)cubeName, (Object)replicaSetID);
                    continue;
                }
                ReplicaSet rs = this.getStreamMetadataStore().getReplicaSet(replicaSetID);
                ISourcePosition position = this.syncAndStopConsumersInRs(streamingSource, cubeName, rs);
                allPositions.add(position);
                successSyncReplicaSet.add(rs);
            }
            consumePosition = streamingSource.getSourcePositionHandler().mergePositions(allPositions, ISourcePositionHandler.MergeStrategy.KEEP_LARGE);
            logger.info("the consumer position for cube:{} is:{}", (Object)cubeName, (Object)consumePosition);
        }
        catch (Exception e) {
            logger.error("fail to sync assign replicaSet for cube:" + cubeName, e);
            Set needRollback = successSyncReplicaSet.stream().map(ReplicaSet::getReplicaSetID).collect(Collectors.toSet());
            for (ReplicaSet rs : successSyncReplicaSet) {
                StartConsumersRequest request = new StartConsumersRequest();
                request.setCube(cubeName);
                try {
                    this.startConsumersInReplicaSet(rs, request);
                    needRollback.remove(rs.getReplicaSetID());
                }
                catch (IOException e1) {
                    logger.error("fail to start consumers for cube:" + cubeName + " replicaSet:" + rs.getReplicaSetID(), e1);
                }
            }
            if (needRollback.isEmpty()) {
                throw new ClusterStateException(cubeName, ClusterStateException.ClusterState.ROLLBACK_SUCCESS, ClusterStateException.TransactionStep.STOP_AND_SNYC, "", e);
            }
            StringBuilder str = new StringBuilder();
            try {
                str.append("Fail restart:").append(JsonUtil.writeValueAsString(needRollback));
            }
            catch (JsonProcessingException jpe) {
                logger.error("", jpe);
            }
            throw new ClusterStateException(cubeName, ClusterStateException.ClusterState.ROLLBACK_FAILED, ClusterStateException.TransactionStep.STOP_AND_SNYC, str.toString(), e);
        }
        ArrayList<ReplicaSet> successAssigned = Lists.newArrayList();
        ArrayList<ReplicaSet> successStarted = Lists.newArrayList();
        HashSet<Node> failedConvertToImmutableNodes = new HashSet<Node>();
        try {
            Integer replicaSetID;
            for (Map.Entry<Integer, List<Partition>> cubeAssignmentEntry : newAssignments.getAssignments().entrySet()) {
                replicaSetID = cubeAssignmentEntry.getKey();
                if (sameAssign.containsKey(replicaSetID)) continue;
                ReplicaSet replicaSet = this.getStreamMetadataStore().getReplicaSet(replicaSetID);
                logger.info("assign cube:{} to replicaSet:{}", (Object)cubeName, (Object)replicaSetID);
                this.assignCubeToReplicaSet(replicaSet, cubeName, cubeAssignmentEntry.getValue(), false, true);
                successAssigned.add(replicaSet);
            }
            for (Map.Entry<Integer, List<Partition>> cubeAssignmentEntry : newAssignments.getAssignments().entrySet()) {
                replicaSetID = cubeAssignmentEntry.getKey();
                if (sameAssign.containsKey(replicaSetID)) continue;
                ConsumerStartProtocol consumerStartProtocol = new ConsumerStartProtocol(streamingSource.getSourcePositionHandler().serializePosition(consumePosition.advance()));
                ReplicaSet replicaSet = this.getStreamMetadataStore().getReplicaSet(replicaSetID);
                StartConsumersRequest startRequest = new StartConsumersRequest();
                startRequest.setCube(cubeName);
                startRequest.setStartProtocol(consumerStartProtocol);
                logger.info("start consumers for cube:{}, replicaSet:{}, startRequest:{}", cubeName, replicaSetID, startRequest);
                this.startConsumersInReplicaSet(replicaSet, startRequest);
                successStarted.add(replicaSet);
            }
            for (Map.Entry<Integer, List<Partition>> removeAssignmentEntry : removedAssign.entrySet()) {
                replicaSetID = removeAssignmentEntry.getKey();
                logger.info("make cube immutable for cube:{}, replicaSet{}", (Object)cubeName, (Object)replicaSetID);
                ReplicaSet replicaSet = this.getStreamMetadataStore().getReplicaSet(replicaSetID);
                List<Node> list = this.makeCubeImmutableInReplicaSet(replicaSet, cubeName);
                failedConvertToImmutableNodes.addAll(list);
            }
            if (!failedConvertToImmutableNodes.isEmpty()) {
                throw new IOException();
            }
            logger.info("finish cube reBalance, cube:{}", (Object)cubeName);
        }
        catch (IOException e) {
            logger.error("fail to start consumers for cube:" + cubeName, e);
            Set rollbackStarted = successStarted.stream().map(ReplicaSet::getReplicaSetID).collect(Collectors.toSet());
            for (ReplicaSet replicaSet : successStarted) {
                try {
                    StopConsumersRequest stopConsumersRequest = new StopConsumersRequest();
                    stopConsumersRequest.setCube(cubeName);
                    if (newAssign.containsKey(replicaSet.getReplicaSetID())) {
                        stopConsumersRequest.setRemoveData(true);
                    }
                    this.stopConsumersInReplicaSet(replicaSet, stopConsumersRequest);
                    rollbackStarted.remove(replicaSet.getReplicaSetID());
                }
                catch (IOException iOException) {
                    logger.error("fail to stop consumers for cube:" + cubeName + " replicaSet:" + replicaSet.getReplicaSetID(), iOException);
                }
            }
            Set rollbackAssigned = successAssigned.stream().map(ReplicaSet::getReplicaSetID).collect(Collectors.toSet());
            for (ReplicaSet replicaSet : successAssigned) {
                try {
                    List<Partition> partitions = preAssignments.getPartitionsByReplicaSetID(replicaSet.getReplicaSetID());
                    this.assignCubeToReplicaSet(replicaSet, cubeName, partitions, true, true);
                    rollbackAssigned.remove(replicaSet.getReplicaSetID());
                }
                catch (IOException e1) {
                    logger.error("fail to start consumers for cube:" + cubeName + " replicaSet:" + replicaSet.getReplicaSetID(), e1);
                }
            }
            HashSet hashSet = new HashSet(failedConvertToImmutableNodes);
            for (Node node : failedConvertToImmutableNodes) {
                try {
                    this.makeCubeImmutableForReceiver(node, cubeName);
                    hashSet.remove(node);
                }
                catch (IOException ioe) {
                    logger.error("fail to make cube immutable for cube:" + cubeName + " to " + node, ioe);
                }
            }
            StringBuilder stringBuilder = new StringBuilder();
            try {
                stringBuilder.append("FailStarted:").append(JsonUtil.writeValueAsString(rollbackStarted)).append(";");
                stringBuilder.append("FailAssigned:").append(JsonUtil.writeValueAsString(rollbackAssigned)).append(";");
                stringBuilder.append("FailRemotedPresisted:").append(JsonUtil.writeValueAsString(hashSet));
            }
            catch (JsonProcessingException jpe) {
                logger.error("", jpe);
            }
            String failedInfo = stringBuilder.toString();
            if (!rollbackStarted.isEmpty()) {
                throw new ClusterStateException(cubeName, ClusterStateException.ClusterState.ROLLBACK_FAILED, ClusterStateException.TransactionStep.START_NEW, failedInfo, e);
            }
            if (!rollbackAssigned.isEmpty()) {
                throw new ClusterStateException(cubeName, ClusterStateException.ClusterState.ROLLBACK_FAILED, ClusterStateException.TransactionStep.ASSIGN_NEW, failedInfo, e);
            }
            if (!hashSet.isEmpty()) {
                throw new ClusterStateException(cubeName, ClusterStateException.ClusterState.ROLLBACK_FAILED, ClusterStateException.TransactionStep.MAKE_IMMUTABLE, failedInfo, e);
            }
            throw new ClusterStateException(cubeName, ClusterStateException.ClusterState.ROLLBACK_SUCCESS, ClusterStateException.TransactionStep.ASSIGN_NEW, failedInfo, e);
        }
    }

    private ISourcePosition syncAndStopConsumersInRs(final IStreamingSource streamingSource, String cubeName, ReplicaSet replicaSet) throws IOException {
        if (replicaSet.getNodes().size() > 1) {
            logger.info("sync consume for cube:{}, replicaSet:{}", (Object)cubeName, (Object)replicaSet.getReplicaSetID());
            PauseConsumersRequest suspendRequest = new PauseConsumersRequest();
            suspendRequest.setCube(cubeName);
            List<ConsumerStatsResponse> allReceiverConsumeState = this.pauseConsumersInReplicaSet(replicaSet, suspendRequest);
            List<ISourcePosition> consumePositionList = Lists.transform(allReceiverConsumeState, new Function<ConsumerStatsResponse, ISourcePosition>(){

                @Override
                @Nullable
                public ISourcePosition apply(@Nullable ConsumerStatsResponse input) {
                    return streamingSource.getSourcePositionHandler().parsePosition(input.getConsumePosition());
                }
            });
            ISourcePosition consumePosition = streamingSource.getSourcePositionHandler().mergePositions(consumePositionList, ISourcePositionHandler.MergeStrategy.KEEP_LARGE);
            ResumeConsumerRequest resumeRequest = new ResumeConsumerRequest();
            resumeRequest.setCube(cubeName);
            resumeRequest.setResumeToPosition(streamingSource.getSourcePositionHandler().serializePosition(consumePosition));
            this.resumeConsumersInReplicaSet(replicaSet, resumeRequest);
            return consumePosition;
        }
        if (replicaSet.getNodes().size() == 1) {
            Node receiver = replicaSet.getNodes().iterator().next();
            StopConsumersRequest request = new StopConsumersRequest();
            request.setCube(cubeName);
            logger.info("stop consumers for cube:{}, receiver:{}", (Object)cubeName, (Object)receiver);
            List<ConsumerStatsResponse> stopResponse = this.stopConsumersInReplicaSet(replicaSet, request);
            return streamingSource.getSourcePositionHandler().parsePosition(stopResponse.get(0).getConsumePosition());
        }
        return null;
    }

    public Map<Integer, Map<String, List<Partition>>> reBalancePlan(List<StreamingCubeInfo> allCubes, List<ReplicaSet> allReplicaSets) {
        List<CubeAssignment> currCubeAssignments = this.streamMetadataStore.getAllCubeAssignments();
        return this.assigner.reBalancePlan(allReplicaSets, allCubes, currCubeAssignments);
    }

    private List<StreamingCubeInfo> getEnableStreamingCubes() {
        List<StreamingCubeInfo> allCubes = this.getStreamingCubes();
        ArrayList<StreamingCubeInfo> result = Lists.newArrayList();
        for (StreamingCubeInfo cube : allCubes) {
            CubeInstance cubeInstance = CubeManager.getInstance(KylinConfig.getInstanceFromEnv()).getCube(cube.getCubeName());
            if (cubeInstance.getStatus() != RealizationStatusEnum.READY) continue;
            result.add(cube);
        }
        return result;
    }

    private List<StreamingCubeInfo> getStreamingCubes() {
        List<String> cubes = this.streamMetadataStore.getCubes();
        ArrayList<StreamingCubeInfo> result = Lists.newArrayList();
        for (String cubeName : cubes) {
            StreamingCubeInfo cubeInfo = this.getStreamCubeInfo(cubeName);
            if (cubeInfo == null) continue;
            result.add(cubeInfo);
        }
        return result;
    }

    public void removeCubeHDFSFiles(String cubeName) {
        String segmentHDFSPath = HDFSUtil.getStreamingCubeFilePath(cubeName);
        try {
            FileSystem fs = HadoopUtil.getFileSystem(segmentHDFSPath);
            fs.delete(new Path(segmentHDFSPath), true);
        }
        catch (Exception e) {
            logger.error("error when remove hdfs file, hdfs path:{}", (Object)segmentHDFSPath);
        }
    }

    @Override
    public synchronized void createReplicaSet(ReplicaSet rs) {
        List<ReplicaSet> allReplicaset = this.streamMetadataStore.getReplicaSets();
        for (Node node : rs.getNodes()) {
            for (ReplicaSet set : allReplicaset) {
                if (!set.containPhysicalNode(node)) continue;
                throw new CoordinateException(String.format(Locale.ROOT, "The receiver node %s is already exists in the set %s", node, set));
            }
        }
        int replicaSetID = this.streamMetadataStore.createReplicaSet(rs);
        try {
            for (Node receiver : rs.getNodes()) {
                this.addReceiverToReplicaSet(receiver, replicaSetID);
            }
        }
        catch (IOException iOException) {
            logger.warn("create replica set fail", iOException);
        }
    }

    @Override
    public synchronized void removeReplicaSet(int rsID) {
        ReplicaSet rs = this.streamMetadataStore.getReplicaSet(rsID);
        if (rs == null) {
            return;
        }
        if (rs.getNodes() != null && rs.getNodes().size() > 0) {
            throw new CoordinateException("cannot remove rs, because there are nodes in it");
        }
        Map<String, List<Partition>> assignment = this.streamMetadataStore.getAssignmentsByReplicaSet(rsID);
        if (assignment != null && !assignment.isEmpty()) {
            throw new CoordinateException("cannot remove rs, because there are assignments");
        }
        this.streamMetadataStore.removeReplicaSet(rsID);
    }

    @Override
    public synchronized void addNodeToReplicaSet(Integer replicaSetID, String nodeID) {
        ReplicaSet rs = this.streamMetadataStore.getReplicaSet(replicaSetID);
        Node receiver = Node.fromNormalizeString(nodeID);
        List<ReplicaSet> allReplicaSet = this.streamMetadataStore.getReplicaSets();
        for (ReplicaSet other : allReplicaSet) {
            if (other.getReplicaSetID() == replicaSetID.intValue() || !other.containPhysicalNode(receiver)) continue;
            logger.error("error add Node {} to replicaSet {}, already exist in replicaSet {} ", nodeID, replicaSetID, other.getReplicaSetID());
            throw new IllegalStateException("Node exists in ReplicaSet!");
        }
        rs.addNode(receiver);
        this.streamMetadataStore.updateReplicaSet(rs);
        try {
            Map<String, List<Partition>> assignment = this.streamMetadataStore.getAssignmentsByReplicaSet(replicaSetID);
            if (assignment == null || assignment.isEmpty()) {
                return;
            }
            this.addReceiverToReplicaSet(receiver, replicaSetID);
            for (String cubeName : assignment.keySet()) {
                AssignmentsCache.getInstance().clearCubeCache(cubeName);
            }
        }
        catch (IOException e) {
            logger.warn("fail to add receiver to replicaSet ", e);
        }
    }

    @Override
    public synchronized void removeNodeFromReplicaSet(Integer replicaSetID, String nodeID) {
        ReplicaSet rs = this.streamMetadataStore.getReplicaSet(replicaSetID);
        Node receiver = Node.fromNormalizeString(nodeID);
        rs.removeNode(receiver);
        this.streamMetadataStore.updateReplicaSet(rs);
        try {
            Map<String, List<Partition>> assignment = this.streamMetadataStore.getAssignmentsByReplicaSet(replicaSetID);
            this.removeReceiverFromReplicaSet(receiver);
            if (assignment != null) {
                for (String cubeName : assignment.keySet()) {
                    AssignmentsCache.getInstance().clearCubeCache(cubeName);
                }
            }
        }
        catch (IOException e) {
            logger.warn("remove node from replicaSet fail", e);
        }
    }

    public void stopConsumers(String cubeName) {
        CubeAssignment assignment = this.streamMetadataStore.getAssignmentsByCube(cubeName);
        StopConsumersRequest request = new StopConsumersRequest();
        request.setCube(cubeName);
        try {
            for (Integer rsID : assignment.getReplicaSetIDs()) {
                ReplicaSet rs = this.streamMetadataStore.getReplicaSet(rsID);
                this.stopConsumersInReplicaSet(rs, request);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void doReBalance(List<CubeAssignment> previousAssignments, List<CubeAssignment> newAssignments) {
        HashMap<String, CubeAssignment> previousCubeAssignMap = Maps.newHashMap();
        HashMap<String, CubeAssignment> newCubeAssignMap = Maps.newHashMap();
        for (CubeAssignment cubeAssignment : previousAssignments) {
            previousCubeAssignMap.put(cubeAssignment.getCubeName(), cubeAssignment);
        }
        for (CubeAssignment cubeAssignment : newAssignments) {
            newCubeAssignMap.put(cubeAssignment.getCubeName(), cubeAssignment);
        }
        try {
            Set preCubes = previousCubeAssignMap.keySet();
            Set newCubes = newCubeAssignMap.keySet();
            if (!preCubes.equals(newCubes)) {
                logger.error("previous assignment cubes:" + preCubes + ", new assignment cubes:" + newCubes);
                throw new IllegalStateException("previous cube assignments");
            }
            MapDifference diff = Maps.difference(previousCubeAssignMap, newCubeAssignMap);
            Map changedAssignments = diff.entriesDiffering();
            for (Map.Entry changedAssignmentEntry : changedAssignments.entrySet()) {
                String cubeName = (String)changedAssignmentEntry.getKey();
                MapDifference.ValueDifference cubeAssignDiff = changedAssignmentEntry.getValue();
                this.reassignCubeImpl(cubeName, (CubeAssignment)cubeAssignDiff.leftValue(), (CubeAssignment)cubeAssignDiff.rightValue());
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void assignCubeToReplicaSet(ReplicaSet rs, String cubeName, List<Partition> partitions, boolean startConsumer, boolean mustAllSucceed) throws IOException {
        boolean hasNodeAssigned = false;
        IOException exception = null;
        AssignRequest assignRequest = new AssignRequest();
        assignRequest.setCubeName(cubeName);
        assignRequest.setPartitions(partitions);
        assignRequest.setStartConsumers(startConsumer);
        for (Node node : rs.getNodes()) {
            try {
                this.assignToReceiver(node, assignRequest);
                hasNodeAssigned = true;
            }
            catch (IOException e) {
                if (mustAllSucceed) {
                    throw e;
                }
                exception = e;
                logger.error("cube:" + cubeName + " consumers start fail for node:" + node.toString(), e);
            }
        }
        if (!hasNodeAssigned && exception != null) {
            throw exception;
        }
    }

    private void assignToReceiver(Node receiver, AssignRequest request) throws IOException {
        this.receiverAdminClient.assign(receiver, request);
    }

    private void unAssignFromReplicaSet(ReplicaSet rs, UnAssignRequest unAssignRequest) throws IOException {
        for (Node receiver : rs.getNodes()) {
            this.unAssignToReceiver(receiver, unAssignRequest);
        }
    }

    private void unAssignToReceiver(Node receiver, UnAssignRequest request) throws IOException {
        this.receiverAdminClient.unAssign(receiver, request);
    }

    private void addReceiverToReplicaSet(Node receiver, int replicaSetID) throws IOException {
        this.receiverAdminClient.addToReplicaSet(receiver, replicaSetID);
    }

    private void removeReceiverFromReplicaSet(Node receiver) throws IOException {
        this.receiverAdminClient.removeFromReplicaSet(receiver);
    }

    private void startConsumersForReceiver(Node receiver, StartConsumersRequest request) throws IOException {
        this.receiverAdminClient.startConsumers(receiver, request);
    }

    private ConsumerStatsResponse stopConsumersForReceiver(Node receiver, StopConsumersRequest request) throws IOException {
        return this.receiverAdminClient.stopConsumers(receiver, request);
    }

    private ConsumerStatsResponse pauseConsumersForReceiver(Node receiver, PauseConsumersRequest request) throws IOException {
        return this.receiverAdminClient.pauseConsumers(receiver, request);
    }

    public ConsumerStatsResponse resumeConsumersForReceiver(Node receiver, ResumeConsumerRequest request) throws IOException {
        return this.receiverAdminClient.resumeConsumers(receiver, request);
    }

    private void makeCubeImmutableForReceiver(Node receiver, String cubeName) throws IOException {
        this.receiverAdminClient.makeCubeImmutable(receiver, cubeName);
    }

    public void startConsumersInReplicaSet(ReplicaSet rs, StartConsumersRequest request) throws IOException {
        for (Node node : rs.getNodes()) {
            this.startConsumersForReceiver(node, request);
        }
    }

    public List<Node> makeCubeImmutableInReplicaSet(ReplicaSet rs, String cubeName) throws IOException {
        ArrayList<Node> failedNodes = new ArrayList<Node>();
        for (Node node : rs.getNodes()) {
            try {
                this.makeCubeImmutableForReceiver(node, cubeName);
            }
            catch (IOException ioe) {
                logger.error(String.format(Locale.ROOT, "Convert %s to immutable for node %s failed.", cubeName, node.toNormalizeString()), ioe);
                failedNodes.add(node);
            }
        }
        return failedNodes;
    }

    public List<ConsumerStatsResponse> stopConsumersInReplicaSet(ReplicaSet rs, StopConsumersRequest request) throws IOException {
        ArrayList<ConsumerStatsResponse> consumerStats = Lists.newArrayList();
        for (Node node : rs.getNodes()) {
            consumerStats.add(this.stopConsumersForReceiver(node, request));
        }
        return consumerStats;
    }

    public List<ConsumerStatsResponse> pauseConsumersInReplicaSet(ReplicaSet rs, PauseConsumersRequest request) throws IOException {
        ArrayList<ConsumerStatsResponse> consumerStats = Lists.newArrayList();
        ArrayList<Node> successReceivers = Lists.newArrayList();
        try {
            for (Node node : rs.getNodes()) {
                consumerStats.add(this.pauseConsumersForReceiver(node, request));
                successReceivers.add(node);
            }
        }
        catch (IOException ioe) {
            logger.info("roll back pause consumers for receivers:" + successReceivers);
            ResumeConsumerRequest resumeRequest = new ResumeConsumerRequest();
            resumeRequest.setCube(request.getCube());
            for (Node receiver : successReceivers) {
                this.resumeConsumersForReceiver(receiver, resumeRequest);
            }
            throw ioe;
        }
        return consumerStats;
    }

    public List<ConsumerStatsResponse> resumeConsumersInReplicaSet(ReplicaSet rs, ResumeConsumerRequest request) throws IOException {
        ArrayList<ConsumerStatsResponse> consumerStats = Lists.newArrayList();
        for (Node node : rs.getNodes()) {
            consumerStats.add(this.resumeConsumersForReceiver(node, request));
        }
        return consumerStats;
    }

    public StreamMetadataStore getStreamMetadataStore() {
        return this.streamMetadataStore;
    }

    public ExecutableManager getExecutableManager() {
        return ExecutableManager.getInstance(this.getConfig());
    }

    public CubeManager getCubeManager() {
        return CubeManager.getInstance(this.getConfig());
    }

    private synchronized boolean tryFindAndBuildSegment(String cubeName) {
        List<SegmentBuildState> segmentStates = this.streamMetadataStore.getSegmentBuildStates(cubeName);
        if (segmentStates.isEmpty()) {
            logger.info("no segment build states for cube:{} found in the metadata store", (Object)cubeName);
            return true;
        }
        boolean triggered = true;
        List<String> segmentsToBuild = this.findSegmentsCanBuild(cubeName);
        if (segmentsToBuild != null && !segmentsToBuild.isEmpty()) {
            logger.info("try to trigger cube building for cube:{}, segments:{}", (Object)cubeName, (Object)segmentsToBuild);
            for (String segmentName : segmentsToBuild) {
                triggered = triggered && this.triggerSegmentBuild(cubeName, segmentName);
            }
        }
        if (!triggered) {
            this.jobStatusChecker.addPendingCube(cubeName);
        }
        return triggered;
    }

    private void segmentBuildComplete(CubingJob cubingJob, CubeInstance cubeInstance, CubeSegment cubeSegment, SegmentJobBuildInfo segmentBuildInfo) throws IOException {
        if (!this.checkPreviousSegmentReady(cubeSegment)) {
            logger.warn("the segment:{}'s previous segment is not ready, will not set the segment to ready", (Object)cubeSegment);
            return;
        }
        if (!SegmentStatusEnum.READY.equals(cubeSegment.getStatus())) {
            this.promoteNewSegment(cubingJob, cubeInstance, cubeSegment);
        }
        String cubeName = segmentBuildInfo.cubeName;
        String segmentName = segmentBuildInfo.segmentName;
        CubeAssignment assignments = this.streamMetadataStore.getAssignmentsByCube(cubeName);
        for (int replicaSetID : assignments.getReplicaSetIDs()) {
            ReplicaSet rs = this.streamMetadataStore.getReplicaSet(replicaSetID);
            for (Node node : rs.getNodes()) {
                try {
                    this.receiverAdminClient.segmentBuildComplete(node, cubeName, segmentName);
                }
                catch (IOException e) {
                    logger.error("error when remove cube segment for receiver:" + node, e);
                }
            }
            if (!assignments.getPartitionsByReplicaSetID(replicaSetID).isEmpty()) continue;
            logger.info("no partition is assign to the replicaSet:{}, check whether there are local segments on the rs.", (Object)replicaSetID);
            Node leader = rs.getLeader();
            try {
                ReceiverCubeStats receiverCubeStats = this.receiverAdminClient.getReceiverCubeStats(leader, cubeName);
                Set<String> segments = receiverCubeStats.getSegmentStatsMap().keySet();
                if (!segments.isEmpty()) continue;
                logger.info("no local segments exist for replicaSet:{}, cube:{}, update assignments.", (Object)replicaSetID, (Object)cubeName);
                assignments.removeAssignment(replicaSetID);
                this.streamMetadataStore.saveNewCubeAssignment(assignments);
            }
            catch (IOException e) {
                logger.error("error when get receiver cube stats from:" + leader, e);
            }
        }
        this.streamMetadataStore.removeSegmentBuildState(cubeName, segmentName);
        logger.info("try to remove the hdfs files for cube:{} segment:{}", (Object)cubeName, (Object)segmentName);
        this.removeHDFSFiles(cubeName, segmentName);
        logger.info("try to find segments for cube:{} build", (Object)cubeName);
        this.tryFindAndBuildSegment(segmentBuildInfo.cubeName);
    }

    private void promoteNewSegment(CubingJob cubingJob, CubeInstance cubeInstance, CubeSegment cubeSegment) throws IOException {
        long sourceCount = cubingJob.findSourceRecordCount();
        long sourceSizeBytes = cubingJob.findSourceSizeBytes();
        long cubeSizeBytes = cubingJob.findCubeSizeBytes();
        Map<Integer, String> sourceCheckpoint = this.streamMetadataStore.getSourceCheckpoint(cubeInstance.getName(), cubeSegment.getName());
        final ISourcePositionHandler positionOperator = StreamingSourceFactory.getStreamingSource(cubeInstance).getSourcePositionHandler();
        Collection<ISourcePosition> sourcePositions = Collections2.transform(sourceCheckpoint.values(), new Function<String, ISourcePosition>(){

            @Override
            @Nullable
            public ISourcePosition apply(@Nullable String input) {
                return positionOperator.parsePosition(input);
            }
        });
        ISourcePosition sourcePosition = positionOperator.mergePositions(sourcePositions, ISourcePositionHandler.MergeStrategy.KEEP_SMALL);
        cubeSegment.setLastBuildJobID(cubingJob.getId());
        cubeSegment.setLastBuildTime(System.currentTimeMillis());
        cubeSegment.setSizeKB(cubeSizeBytes / 1024L);
        cubeSegment.setInputRecords(sourceCount);
        cubeSegment.setInputRecordsSize(sourceSizeBytes);
        cubeSegment.setStreamSourceCheckpoint(positionOperator.serializePosition(sourcePosition));
        this.getCubeManager().promoteNewlyBuiltSegments(cubeInstance, cubeSegment);
    }

    private boolean checkPreviousSegmentReady(CubeSegment currSegment) {
        long segmentEnd;
        long currSegmentStart = (Long)currSegment.getTSRange().start.v;
        CubeInstance cubeInstance = currSegment.getCubeInstance();
        Segments<CubeSegment> segments = cubeInstance.getSegments();
        long previousSegmentEnd = -1L;
        for (CubeSegment segment : segments) {
            segmentEnd = (Long)segment.getTSRange().end.v;
            if (segmentEnd > currSegmentStart || segmentEnd <= previousSegmentEnd) continue;
            previousSegmentEnd = segmentEnd;
        }
        if (previousSegmentEnd == -1L) {
            return true;
        }
        for (CubeSegment segment : segments) {
            segmentEnd = (Long)segment.getTSRange().end.v;
            if (segmentEnd != previousSegmentEnd || !SegmentStatusEnum.READY.equals(segment.getStatus())) continue;
            return true;
        }
        return false;
    }

    private void removeHDFSFiles(String cubeName, String segmentName) {
        String segmentHDFSPath = HDFSUtil.getStreamingSegmentFilePath(cubeName, segmentName);
        try {
            FileSystem fs = HadoopUtil.getFileSystem(segmentHDFSPath);
            fs.delete(new Path(segmentHDFSPath), true);
        }
        catch (Exception e) {
            logger.error("error when remove hdfs file, hdfs path:{}", (Object)segmentHDFSPath);
        }
    }

    private boolean triggerSegmentBuild(String cubeName, String segmentName) {
        CubeManager cubeManager = CubeManager.getInstance(KylinConfig.getInstanceFromEnv());
        CubeInstance cubeInstance = cubeManager.getCube(cubeName);
        try {
            Pair<Long, Long> segmentRange = CubeSegment.parseSegmentName(segmentName);
            logger.info("submit streaming segment build, cube:{} segment:{}", (Object)cubeName, (Object)segmentName);
            CubeSegment newSeg = this.getCubeManager().appendSegment(cubeInstance, new SegmentRange.TSRange(segmentRange.getFirst(), segmentRange.getSecond()));
            DefaultChainedExecutable executable = new StreamingCubingEngine().createStreamingCubingJob(newSeg, "SYSTEM");
            this.getExecutableManager().addJob(executable);
            CubingJob cubingJob = (CubingJob)executable;
            newSeg.setLastBuildJobID(cubingJob.getId());
            SegmentJobBuildInfo segmentJobBuildInfo = new SegmentJobBuildInfo(cubeName, segmentName, cubingJob.getId());
            this.jobStatusChecker.addSegmentBuildJob(segmentJobBuildInfo);
            SegmentBuildState.BuildState state = new SegmentBuildState.BuildState();
            state.setBuildStartTime(System.currentTimeMillis());
            state.setState(SegmentBuildState.BuildState.State.BUILDING);
            state.setJobId(cubingJob.getId());
            this.streamMetadataStore.updateSegmentBuildState(cubeName, segmentName, state);
            return true;
        }
        catch (Exception e) {
            logger.error("streaming job submit fail, cubeName:" + cubeName + " segment:" + segmentName, e);
            return false;
        }
    }

    private List<String> findSegmentsCanBuild(String cubeName) {
        ArrayList<String> result = Lists.newArrayList();
        CubeInstance cubeInstance = CubeManager.getInstance(KylinConfig.getInstanceFromEnv()).getCube(cubeName);
        if (this.isInOptimize(cubeInstance)) {
            return result;
        }
        int allowMaxBuildingSegments = cubeInstance.getConfig().getMaxBuildingSegments();
        CubeSegment latestHistoryReadySegment = cubeInstance.getLatestReadySegment();
        long minSegmentStart = -1L;
        if (latestHistoryReadySegment != null) {
            minSegmentStart = (Long)latestHistoryReadySegment.getTSRange().end.v;
        } else {
            logger.info("there is no ready segments for cube:{}, so only allow 1 segment build concurrently", (Object)cubeName);
            allowMaxBuildingSegments = 1;
        }
        CubeAssignment assignments = this.streamMetadataStore.getAssignmentsByCube(cubeName);
        Set<Integer> cubeAssignedReplicaSets = assignments.getReplicaSetIDs();
        List<SegmentBuildState> segmentStates = this.streamMetadataStore.getSegmentBuildStates(cubeName);
        Collections.sort(segmentStates);
        int inBuildingSegments = cubeInstance.getBuildingSegments().size();
        int leftQuota = allowMaxBuildingSegments - inBuildingSegments;
        for (int i = 0; i < segmentStates.size(); ++i) {
            SegmentBuildState segmentState = segmentStates.get(i);
            Pair<Long, Long> segmentRange = CubeSegment.parseSegmentName(segmentState.getSegmentName());
            if (segmentRange.getFirst() < minSegmentStart) {
                logger.warn("the cube segment state is not clear correctly, cube:{} segment:{}, clear it", (Object)cubeName, (Object)segmentState.getSegmentName());
                this.streamMetadataStore.removeSegmentBuildState(cubeName, segmentState.getSegmentName());
                continue;
            }
            if (segmentState.isInBuilding()) {
                ++inBuildingSegments;
                String jobId = segmentState.getState().getJobId();
                logger.info("there is segment in building, cube:{} segment:{} jobId:{}", cubeName, segmentState.getSegmentName(), jobId);
                long buildStartTime = segmentState.getState().getBuildStartTime();
                if (buildStartTime != 0L && jobId != null) {
                    long buildDuration = System.currentTimeMillis() - buildStartTime;
                    if (buildDuration < 2400000L) continue;
                    CubingJob cubingJob = (CubingJob)this.getExecutableManager().getJob(jobId);
                    ExecutableState jobState = cubingJob.getStatus();
                    if (ExecutableState.SUCCEED.equals((Object)jobState)) {
                        CubeSegment cubeSegment = cubeInstance.getSegment(segmentState.getSegmentName(), null);
                        if (cubeSegment == null || SegmentStatusEnum.READY != cubeSegment.getStatus()) continue;
                        logger.info("job:{} is already succeed, and segment:{} is ready, remove segment build state", (Object)jobId, (Object)segmentState.getSegmentName());
                        this.streamMetadataStore.removeSegmentBuildState(cubeName, segmentState.getSegmentName());
                        continue;
                    }
                    if (ExecutableState.ERROR.equals((Object)jobState)) {
                        logger.info("job:{} is error, resume the job", (Object)jobId);
                        this.getExecutableManager().resumeJob(jobId);
                        continue;
                    }
                    if (ExecutableState.DISCARDED.equals((Object)jobState)) {
                        logger.info("job:{} is discard, reset the job state in metaStore", (Object)jobId);
                        SegmentBuildState.BuildState state = new SegmentBuildState.BuildState();
                        state.setBuildStartTime(0L);
                        state.setState(SegmentBuildState.BuildState.State.WAIT);
                        state.setJobId(cubingJob.getId());
                        this.streamMetadataStore.updateSegmentBuildState(cubeName, segmentState.getSegmentName(), state);
                        segmentState.setState(state);
                        logger.info("segment:{} is discard", (Object)segmentState.getSegmentName());
                        continue;
                    }
                    logger.info("job:{} is in running, job state: {}", (Object)jobId, (Object)jobState);
                    continue;
                }
            }
            if (leftQuota <= 0) {
                logger.info("No left quota to build segments for cube:{}", (Object)cubeName);
                return result;
            }
            if (!this.checkSegmentIsReadyToBuild(segmentStates, i, cubeAssignedReplicaSets)) break;
            result.add(segmentState.getSegmentName());
            --leftQuota;
        }
        return result;
    }

    private boolean isInOptimize(CubeInstance cube) {
        Segments<CubeSegment> readyPendingSegments = cube.getSegments(SegmentStatusEnum.READY_PENDING);
        if (readyPendingSegments.size() > 0) {
            logger.info("The cube {} has READY_PENDING segments {}. It's not allowed for building", (Object)cube.getName(), (Object)readyPendingSegments);
            return true;
        }
        Segments<CubeSegment> newSegments = cube.getSegments(SegmentStatusEnum.NEW);
        for (CubeSegment newSegment : newSegments) {
            AbstractExecutable job;
            String jobId = newSegment.getLastBuildJobID();
            if (jobId == null || (job = this.getExecutableManager().getJob(jobId)) == null || !(job instanceof CubingJob)) continue;
            CubingJob cubingJob = (CubingJob)job;
            if (!CubingJob.CubingJobTypeEnum.OPTIMIZE.toString().equals(cubingJob.getJobType())) continue;
            logger.info("The cube {} is in optimization. It's not allowed to build new segments during optimization.", (Object)cube.getName());
            return true;
        }
        return false;
    }

    private boolean checkSegmentIsReadyToBuild(List<SegmentBuildState> allSegmentStates, int checkedSegmentIdx, Set<Integer> cubeAssignedReplicaSets) {
        SegmentBuildState checkedSegmentState = allSegmentStates.get(checkedSegmentIdx);
        HashSet<Integer> notCompleteReplicaSets = Sets.newHashSet(Sets.difference(cubeAssignedReplicaSets, checkedSegmentState.getCompleteReplicaSets()));
        if (notCompleteReplicaSets.isEmpty()) {
            return true;
        }
        for (int i = checkedSegmentIdx + 1; i < allSegmentStates.size(); ++i) {
            SegmentBuildState segmentBuildState = allSegmentStates.get(i);
            Set<Integer> completeReplicaSetsForNext = segmentBuildState.getCompleteReplicaSets();
            Iterator notCompleteRSItr = notCompleteReplicaSets.iterator();
            while (notCompleteRSItr.hasNext()) {
                Integer rsID = (Integer)notCompleteRSItr.next();
                if (!completeReplicaSetsForNext.contains(rsID)) continue;
                logger.info("the replica set:{} doesn't have data for segment:{}, but have data for later segment:{}", rsID, checkedSegmentState.getSegmentName(), segmentBuildState.getSegmentName());
                notCompleteRSItr.remove();
            }
        }
        return notCompleteReplicaSets.isEmpty();
    }

    private Assigner getAssigner() {
        Assigner oneAssigner;
        String assignerName = this.getConfig().getStreamingAssigner();
        logger.debug("Using assigner {}", (Object)assignerName);
        switch (assignerName) {
            case "DefaultAssigner": {
                oneAssigner = new DefaultAssigner();
                break;
            }
            case "CubePartitionRoundRobinAssigner": {
                oneAssigner = new CubePartitionRoundRobinAssigner();
                break;
            }
            default: {
                oneAssigner = new DefaultAssigner();
            }
        }
        return oneAssigner;
    }

    private class SegmentJobBuildInfo
    implements Comparable<SegmentJobBuildInfo> {
        public String cubeName;
        public String segmentName;
        public String jobID;
        public int retryCnt = 0;

        public SegmentJobBuildInfo(String cubeName, String segmentName, String jobID) {
            this.cubeName = cubeName;
            this.segmentName = segmentName;
            this.jobID = jobID;
        }

        public String toString() {
            return "SegmentJobBuildInfo{cubeName='" + this.cubeName + '\'' + ", segmentName='" + this.segmentName + '\'' + ", jobID='" + this.jobID + '\'' + ", retryCnt=" + this.retryCnt + '}';
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SegmentJobBuildInfo that = (SegmentJobBuildInfo)o;
            if (this.cubeName != null ? !this.cubeName.equals(that.cubeName) : that.cubeName != null) {
                return false;
            }
            if (this.segmentName != null ? !this.segmentName.equals(that.segmentName) : that.segmentName != null) {
                return false;
            }
            return this.jobID != null ? this.jobID.equals(that.jobID) : that.jobID == null;
        }

        public int hashCode() {
            int result = this.cubeName != null ? this.cubeName.hashCode() : 0;
            result = 31 * result + (this.segmentName != null ? this.segmentName.hashCode() : 0);
            result = 31 * result + (this.jobID != null ? this.jobID.hashCode() : 0);
            return result;
        }

        @Override
        public int compareTo(SegmentJobBuildInfo o) {
            if (!this.cubeName.equals(o.cubeName)) {
                return this.cubeName.compareTo(o.cubeName);
            }
            return this.segmentName.compareTo(o.segmentName);
        }
    }

    private class StreamingBuildJobStatusChecker
    implements Runnable {
        private int maxJobTryCnt = 5;
        private ConcurrentMap<String, ConcurrentSkipListSet<SegmentJobBuildInfo>> segmentBuildJobMap = Maps.newConcurrentMap();
        private CopyOnWriteArrayList<String> pendingCubeName = Lists.newCopyOnWriteArrayList();

        private StreamingBuildJobStatusChecker() {
        }

        public void addSegmentBuildJob(SegmentJobBuildInfo segmentBuildJob) {
            ConcurrentSkipListSet previousValue;
            ConcurrentSkipListSet<SegmentJobBuildInfo> buildInfos = (ConcurrentSkipListSet<SegmentJobBuildInfo>)this.segmentBuildJobMap.get(segmentBuildJob.cubeName);
            if (buildInfos == null && (previousValue = this.segmentBuildJobMap.putIfAbsent(segmentBuildJob.cubeName, buildInfos = new ConcurrentSkipListSet<SegmentJobBuildInfo>())) != null) {
                buildInfos = previousValue;
            }
            buildInfos.add(segmentBuildJob);
        }

        public void addPendingCube(String cubeName) {
            if (!this.pendingCubeName.contains(cubeName)) {
                this.pendingCubeName.add(cubeName);
            }
        }

        public void clearCheckCube(String cubeName) {
            if (this.pendingCubeName.contains(cubeName)) {
                this.pendingCubeName.remove(cubeName);
            }
            this.segmentBuildJobMap.remove(cubeName);
        }

        @Override
        public void run() {
            try {
                if (Coordinator.this.isLead) {
                    this.doRun();
                }
            }
            catch (Exception e) {
                logger.error("error", e);
            }
        }

        private void doRun() {
            ArrayList<SegmentJobBuildInfo> successJobs = Lists.newArrayList();
            for (ConcurrentSkipListSet buildInfos : this.segmentBuildJobMap.values()) {
                if (buildInfos.isEmpty()) continue;
                SegmentJobBuildInfo segmentBuildJob = (SegmentJobBuildInfo)buildInfos.first();
                logger.info("check the cube:{} segment:{} build status", (Object)segmentBuildJob.cubeName, (Object)segmentBuildJob.segmentName);
                try {
                    CubingJob cubingJob = (CubingJob)Coordinator.this.getExecutableManager().getJob(segmentBuildJob.jobID);
                    ExecutableState jobState = cubingJob.getStatus();
                    if (ExecutableState.SUCCEED.equals((Object)jobState)) {
                        logger.info("job:{} is complete", (Object)segmentBuildJob);
                        CubeManager cubeManager = CubeManager.getInstance(KylinConfig.getInstanceFromEnv());
                        CubeInstance cubeInstance = cubeManager.getCube(segmentBuildJob.cubeName).latestCopyForWrite();
                        CubeSegment cubeSegment = cubeInstance.getSegment(segmentBuildJob.segmentName, null);
                        logger.info("the cube:{} segment:{} is ready", (Object)segmentBuildJob.cubeName, (Object)segmentBuildJob.segmentName);
                        Coordinator.this.segmentBuildComplete(cubingJob, cubeInstance, cubeSegment, segmentBuildJob);
                        successJobs.add(segmentBuildJob);
                        continue;
                    }
                    if (!ExecutableState.ERROR.equals((Object)jobState) || segmentBuildJob.retryCnt >= this.maxJobTryCnt) continue;
                    logger.info("job:{} is error, resume the job", (Object)segmentBuildJob);
                    Coordinator.this.getExecutableManager().resumeJob(segmentBuildJob.jobID);
                    ++segmentBuildJob.retryCnt;
                }
                catch (Exception e) {
                    logger.error("error when check streaming segment job build state:" + segmentBuildJob, e);
                }
            }
            for (SegmentJobBuildInfo successJob : successJobs) {
                ConcurrentSkipListSet buildInfos = (ConcurrentSkipListSet)this.segmentBuildJobMap.get(successJob.cubeName);
                buildInfos.remove(successJob);
            }
            ArrayList<String> successCubes = Lists.newArrayList();
            for (String cubeName : this.pendingCubeName) {
                logger.info("check the pending cube:{} ", (Object)cubeName);
                try {
                    if (!Coordinator.this.tryFindAndBuildSegment(cubeName)) continue;
                    successCubes.add(cubeName);
                }
                catch (Exception e) {
                    logger.error("error when try to find and build cube segment:{}" + cubeName, e);
                }
            }
            for (String successCube : successCubes) {
                this.pendingCubeName.remove(successCube);
            }
        }
    }

    private class CoordinatorLeaderSelector
    extends LeaderSelectorListenerAdapter
    implements Closeable {
        private LeaderSelector leaderSelector;

        public CoordinatorLeaderSelector() {
            String path = "/stream/coordinator";
            this.leaderSelector = new LeaderSelector(Coordinator.this.zkClient, path, (LeaderSelectorListener)this);
            this.leaderSelector.autoRequeue();
        }

        @Override
        public void close() throws IOException {
            this.leaderSelector.close();
        }

        public void start() {
            this.leaderSelector.start();
        }

        public void takeLeadership(CuratorFramework client) throws Exception {
            logger.info("current node become the lead coordinator");
            Coordinator.this.streamMetadataStore.setCoordinatorNode(NodeUtil.getCurrentNode(7070));
            Coordinator.this.isLead = true;
            Coordinator.this.restoreJobStatusChecker();
            do {
                try {
                    Thread.sleep(300000L);
                }
                catch (InterruptedException exception) {
                    Thread.interrupted();
                    break;
                }
            } while (this.leaderSelector.hasLeadership());
            logger.info("become the follower coordinator");
            Coordinator.this.isLead = false;
        }
    }
}

