/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.storage.gtrecord;

import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.Array;
import org.apache.kylin.common.util.DateFormat;
import org.apache.kylin.common.util.Dictionary;
import org.apache.kylin.cube.CubeManager;
import org.apache.kylin.cube.CubeSegment;
import org.apache.kylin.cube.cuboid.Cuboid;
import org.apache.kylin.cube.model.CubeDesc;
import org.apache.kylin.cube.model.RowKeyColDesc;
import org.apache.kylin.cube.model.RowKeyDesc;
import org.apache.kylin.dict.lookup.ILookupTable;
import org.apache.kylin.dimension.TimeDerivedColumnType;
import org.apache.kylin.measure.MeasureType;
import org.apache.kylin.metadata.model.FunctionDesc;
import org.apache.kylin.metadata.model.JoinDesc;
import org.apache.kylin.metadata.model.TblColRef;
import org.apache.kylin.metadata.tuple.Tuple;
import org.apache.kylin.metadata.tuple.TupleInfo;
import org.apache.kylin.shaded.com.google.common.collect.Lists;
import org.apache.kylin.shaded.com.google.common.collect.Maps;
import org.apache.kylin.storage.gtrecord.ITupleConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CubeTupleConverter
implements ITupleConverter {
    private static final Logger logger = LoggerFactory.getLogger(CubeTupleConverter.class);
    final CubeSegment cubeSeg;
    final Cuboid cuboid;
    final TupleInfo tupleInfo;
    public final List<IDerivedColumnFiller> derivedColFillers;
    public final int[] gtColIdx;
    public final int[] tupleIdx;
    public final MeasureType<?>[] measureTypes;
    public final List<MeasureType.IAdvMeasureFiller> advMeasureFillers;
    public final List<Integer> advMeasureIndexInGTValues;
    private List<ILookupTable> usedLookupTables;
    final Set<Integer> needAdjustTimeColumns = new HashSet<Integer>();
    String eventTimezone;
    boolean autoJustByTimezone;
    private final long timeZoneOffset;
    public final int nSelectedDims;
    private final RowKeyDesc rowKeyDesc;

    public CubeTupleConverter(CubeSegment cubeSeg, Cuboid cuboid, Set<TblColRef> selectedDimensions, Set<FunctionDesc> selectedMetrics, int[] gtColIdx, TupleInfo returnTupleInfo) {
        this.cubeSeg = cubeSeg;
        this.cuboid = cuboid;
        this.gtColIdx = gtColIdx;
        this.tupleInfo = returnTupleInfo;
        this.derivedColFillers = Lists.newArrayList();
        this.nSelectedDims = selectedDimensions.size();
        this.tupleIdx = new int[selectedDimensions.size() + selectedMetrics.size()];
        this.measureTypes = new MeasureType[selectedDimensions.size() + selectedMetrics.size()];
        this.advMeasureFillers = Lists.newArrayListWithCapacity(1);
        this.advMeasureIndexInGTValues = Lists.newArrayListWithCapacity(1);
        this.usedLookupTables = Lists.newArrayList();
        this.eventTimezone = cubeSeg.getConfig().getStreamingDerivedTimeTimezone();
        boolean bl = this.autoJustByTimezone = this.eventTimezone.length() > 0 && cubeSeg.getCubeDesc().getModel().getRootFactTable().getTableDesc().isStreamingTable();
        if (this.autoJustByTimezone) {
            logger.debug("Will ajust dimsension for Time Derived Column.");
            this.timeZoneOffset = TimeZone.getTimeZone(this.eventTimezone).getRawOffset();
        } else {
            this.timeZoneOffset = 0L;
        }
        int i = 0;
        for (TblColRef dim : selectedDimensions) {
            int n = this.tupleIdx[i] = this.tupleInfo.hasColumn(dim) ? this.tupleInfo.getColumnIndex(dim) : -1;
            if (dim.getType().isDateTimeFamily() && !TimeDerivedColumnType.isTimeDerivedColumnAboveDayLevel(dim.getName())) {
                this.needAdjustTimeColumns.add(this.tupleIdx[i]);
            }
            ++i;
        }
        for (FunctionDesc metric : selectedMetrics) {
            TblColRef col;
            String rewriteFieldName;
            this.tupleIdx[i] = metric.needRewriteField() ? (this.tupleInfo.hasField(rewriteFieldName = metric.getRewriteFieldName()) ? this.tupleInfo.getFieldIndex(rewriteFieldName) : -1) : (this.tupleInfo.hasColumn(col = metric.getParameter().getColRefs().get(0)) ? this.tupleInfo.getColumnIndex(col) : -1);
            MeasureType<?> measureType = metric.getMeasureType();
            if (measureType.needAdvancedTupleFilling()) {
                Map<TblColRef, Dictionary<String>> dictionaryMap = this.buildDictionaryMap(measureType.getColumnsNeedDictionary(metric));
                this.advMeasureFillers.add(measureType.getAdvancedTupleFiller(metric, returnTupleInfo, dictionaryMap));
                this.advMeasureIndexInGTValues.add(i);
            } else {
                this.measureTypes[i] = measureType;
            }
            ++i;
        }
        Map<Array<TblColRef>, List<CubeDesc.DeriveInfo>> hostToDerivedInfo = cuboid.getCubeDesc().getHostToDerivedInfo(cuboid.getColumns(), null);
        for (Map.Entry<Array<TblColRef>, List<CubeDesc.DeriveInfo>> entry : hostToDerivedInfo.entrySet()) {
            TblColRef[] hostCols = entry.getKey().getData();
            for (CubeDesc.DeriveInfo deriveInfo : entry.getValue()) {
                IDerivedColumnFiller filler = this.newDerivedColumnFiller(hostCols, deriveInfo);
                if (filler == null) continue;
                this.derivedColFillers.add(filler);
            }
        }
        this.rowKeyDesc = cubeSeg.getCubeDesc().getRowkey();
    }

    private Map<TblColRef, Dictionary<String>> buildDictionaryMap(List<TblColRef> columnsNeedDictionary) {
        HashMap<TblColRef, Dictionary<String>> result = Maps.newHashMap();
        for (TblColRef col : columnsNeedDictionary) {
            result.put(col, this.cubeSeg.getDictionary(col));
        }
        return result;
    }

    @Override
    public List<MeasureType.IAdvMeasureFiller> translateResult(Object[] gtValues, Tuple tuple) {
        int ti;
        int i;
        assert (gtValues.length == this.gtColIdx.length);
        for (i = 0; i < this.nSelectedDims; ++i) {
            ti = this.tupleIdx[i];
            if (ti < 0) continue;
            if (this.autoJustByTimezone && this.needAdjustTimeColumns.contains(ti)) {
                try {
                    String v = CubeTupleConverter.toString(gtValues[i]);
                    if (v == null) continue;
                    tuple.setDimensionValue(ti, Long.toString(Long.parseLong(v) + this.timeZoneOffset));
                }
                catch (NumberFormatException nfe) {
                    logger.warn("{} is not a long value.", gtValues[i]);
                    tuple.setDimensionValue(ti, CubeTupleConverter.toString(gtValues[i]));
                }
                continue;
            }
            this.setDimensionValue(tuple, ti, CubeTupleConverter.toString(gtValues[i]));
        }
        for (i = this.nSelectedDims; i < this.gtColIdx.length; ++i) {
            ti = this.tupleIdx[i];
            if (ti < 0 || this.measureTypes[i] == null) continue;
            this.measureTypes[i].fillTupleSimply(tuple, ti, gtValues[i]);
        }
        for (IDerivedColumnFiller filler : this.derivedColFillers) {
            filler.fillDerivedColumns(gtValues, tuple);
        }
        if (this.advMeasureFillers.isEmpty()) {
            return null;
        }
        for (int i2 = 0; i2 < this.advMeasureFillers.size(); ++i2) {
            Object measureValue = gtValues[this.advMeasureIndexInGTValues.get(i2)];
            this.advMeasureFillers.get(i2).reload(measureValue);
        }
        return this.advMeasureFillers;
    }

    private void setDimensionValue(Tuple tuple, int idx, String valueStr) {
        if (valueStr == null) {
            tuple.setDimensionValueDirectly(idx, valueStr);
            return;
        }
        Number valueConvert = null;
        TblColRef col = this.tupleInfo.getColumn(idx);
        RowKeyColDesc rowKeyColDesc = this.rowKeyDesc.getColDescUncheck(col);
        if (rowKeyColDesc != null) {
            if (col.getType().isDate() && !RowKeyColDesc.isDateDimEnc(rowKeyColDesc)) {
                long tmpValue = (Long)Tuple.convertOptiqCellValue(valueStr, "timestamp");
                valueConvert = Tuple.millisToEpicDays(tmpValue);
            } else if (col.getType().isDatetime() && !RowKeyColDesc.isTimeDimEnc(rowKeyColDesc)) {
                int tmpValue = (Integer)Tuple.convertOptiqCellValue(valueStr, "date");
                valueConvert = Tuple.epicDaysToMillis(tmpValue);
            }
        }
        if (valueConvert != null) {
            tuple.setDimensionValueDirectly(idx, valueConvert);
        } else {
            tuple.setDimensionValue(idx, valueStr);
        }
    }

    @Override
    public void close() throws IOException {
        for (ILookupTable usedLookupTable : this.usedLookupTables) {
            try {
                usedLookupTable.close();
            }
            catch (Exception e) {
                logger.error("error when close lookup table:" + usedLookupTable);
            }
        }
    }

    protected IDerivedColumnFiller newDerivedColumnFiller(TblColRef[] hostCols, final CubeDesc.DeriveInfo deriveInfo) {
        boolean allHostsPresent = true;
        final int[] hostTmpIdx = new int[hostCols.length];
        for (int i = 0; i < hostCols.length; ++i) {
            hostTmpIdx[i] = this.indexOnTheGTValues(hostCols[i]);
            allHostsPresent = allHostsPresent && hostTmpIdx[i] >= 0;
        }
        boolean needCopyDerived = false;
        final int[] derivedTupleIdx = new int[deriveInfo.columns.length];
        for (int i = 0; i < deriveInfo.columns.length; ++i) {
            TblColRef col = deriveInfo.columns[i];
            derivedTupleIdx[i] = this.tupleInfo.hasColumn(col) ? this.tupleInfo.getColumnIndex(col) : -1;
            needCopyDerived = needCopyDerived || derivedTupleIdx[i] >= 0;
        }
        if (!(allHostsPresent && needCopyDerived)) {
            return null;
        }
        switch (deriveInfo.type) {
            case LOOKUP: {
                return new IDerivedColumnFiller(){
                    ILookupTable lookupTable;
                    int[] derivedColIdx;
                    Array<String> lookupKey;
                    {
                        this.lookupTable = CubeTupleConverter.this.getAndAddLookupTable(CubeTupleConverter.this.cubeSeg, deriveInfo.join);
                        this.derivedColIdx = this.initDerivedColIdx();
                        this.lookupKey = new Array<String>(new String[hostTmpIdx.length]);
                    }

                    private int[] initDerivedColIdx() {
                        int[] idx = new int[deriveInfo.columns.length];
                        for (int i = 0; i < idx.length; ++i) {
                            idx[i] = deriveInfo.columns[i].getColumnDesc().getZeroBasedIndex();
                        }
                        return idx;
                    }

                    @Override
                    public void fillDerivedColumns(Object[] gtValues, Tuple tuple) {
                        for (int i = 0; i < hostTmpIdx.length; ++i) {
                            this.lookupKey.getData()[i] = CubeTupleConverter.toString(gtValues[hostTmpIdx[i]]);
                            if (this.lookupKey.getData()[i] == null || !deriveInfo.join.getPrimaryKeyColumns()[i].getType().isDateTimeFamily()) continue;
                            this.lookupKey.getData()[i] = String.valueOf(DateFormat.stringToMillis(this.lookupKey.getData()[i]));
                        }
                        String[] lookupRow = this.lookupTable.getRow(this.lookupKey);
                        if (lookupRow != null) {
                            for (int i = 0; i < derivedTupleIdx.length; ++i) {
                                if (derivedTupleIdx[i] < 0) continue;
                                String value = lookupRow[this.derivedColIdx[i]];
                                tuple.setDimensionValue(derivedTupleIdx[i], value);
                            }
                        } else {
                            for (int i = 0; i < derivedTupleIdx.length; ++i) {
                                if (derivedTupleIdx[i] < 0) continue;
                                tuple.setDimensionValue(derivedTupleIdx[i], null);
                            }
                        }
                    }
                };
            }
            case PK_FK: {
                return new IDerivedColumnFiller(){

                    @Override
                    public void fillDerivedColumns(Object[] gtValues, Tuple tuple) {
                        tuple.setDimensionValue(derivedTupleIdx[0], CubeTupleConverter.toString(gtValues[hostTmpIdx[0]]));
                    }
                };
            }
        }
        throw new IllegalArgumentException();
    }

    public int indexOnTheGTValues(TblColRef col) {
        List<TblColRef> cuboidDims = this.cuboid.getColumns();
        int cuboidIdx = cuboidDims.indexOf(col);
        for (int i = 0; i < this.gtColIdx.length; ++i) {
            if (this.gtColIdx[i] != cuboidIdx) continue;
            return i;
        }
        return -1;
    }

    public ILookupTable getAndAddLookupTable(CubeSegment cubeSegment, JoinDesc join) {
        ILookupTable lookupTable = CubeManager.getInstance(KylinConfig.getInstanceFromEnv()).getLookupTable(cubeSegment, join);
        this.usedLookupTables.add(lookupTable);
        return lookupTable;
    }

    private static String toString(Object o) {
        return o == null ? null : o.toString();
    }

    protected static interface IDerivedColumnFiller {
        public void fillDerivedColumns(Object[] var1, Tuple var2);
    }
}

