/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.source.kafka.config;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.kafka.clients.consumer.ConsumerConfig;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.KylinConfigCannotInitException;
import org.apache.kylin.common.util.OptionsHelper;
import org.apache.kylin.tool.shaded.org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaConsumerProperties {
    public static final String KAFKA_CONSUMER_FILE = "kylin-kafka-consumer.xml";
    private static final Logger logger = LoggerFactory.getLogger(KafkaConsumerProperties.class);
    private static KafkaConsumerProperties ENV_INSTANCE = null;
    private volatile Properties properties = new Properties();

    private KafkaConsumerProperties() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static KafkaConsumerProperties getInstanceFromEnv() {
        Class<KafkaConsumerProperties> clazz = KafkaConsumerProperties.class;
        synchronized (KafkaConsumerProperties.class) {
            if (ENV_INSTANCE == null) {
                try {
                    KafkaConsumerProperties config = new KafkaConsumerProperties();
                    config.properties = config.loadKafkaConsumerProperties();
                    logger.info("Initialized a new KafkaConsumerProperties from getInstanceFromEnv : {}", (Object)System.identityHashCode(config));
                    ENV_INSTANCE = config;
                }
                catch (IllegalArgumentException e) {
                    throw new IllegalStateException("Failed to find KafkaConsumerProperties ", e);
                }
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return ENV_INSTANCE;
        }
    }

    private static File getKafkaConsumerFile(String path) {
        if (path == null) {
            return null;
        }
        return new File(path, KAFKA_CONSUMER_FILE);
    }

    public static Properties extractKafkaConfigToProperties(Configuration configuration) {
        Set<String> configNames = new HashSet();
        try {
            configNames = ConsumerConfig.configNames();
        }
        catch (Exception e) {
            String[] configNamesArray = "metric.reporters, metadata.max.age.ms, partition.assignment.strategy, reconnect.backoff.ms,sasl.kerberos.ticket.renew.window.factor, max.partition.fetch.bytes, bootstrap.servers, ssl.keystore.type, enable.auto.commit, sasl.mechanism, interceptor.classes, exclude.internal.topics, ssl.truststore.password, client.id, ssl.endpoint.identification.algorithm, max.poll.records, check.crcs, request.timeout.ms, heartbeat.interval.ms, auto.commit.interval.ms, receive.buffer.bytes, ssl.truststore.type, ssl.truststore.location, ssl.keystore.password, fetch.min.bytes, fetch.max.bytes, send.buffer.bytes, max.poll.interval.ms, value.deserializer, group.id, retry.backoff.ms, ssl.secure.random.implementation, sasl.kerberos.kinit.cmd, sasl.kerberos.service.name, sasl.kerberos.ticket.renew.jitter, ssl.trustmanager.algorithm, ssl.key.password, fetch.max.wait.ms, sasl.kerberos.min.time.before.relogin, connections.max.idle.ms, session.timeout.ms, metrics.num.samples, key.deserializer, ssl.protocol, ssl.provider, ssl.enabled.protocols, ssl.keystore.location, ssl.cipher.suites, security.protocol, ssl.keymanager.algorithm, metrics.sample.window.ms, auto.offset.reset".split(",");
            configNames.addAll(Arrays.asList(configNamesArray));
        }
        Properties result = new Properties();
        for (Map.Entry entry : configuration) {
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            if (!configNames.contains(key)) continue;
            result.put(key, value);
        }
        return result;
    }

    private Properties loadKafkaConsumerProperties() {
        Properties properties;
        block28: {
            File propFile = this.getKafkaConsumerFile();
            if (propFile == null || !propFile.exists()) {
                logger.warn("fail to locate {}, use empty kafka consumer properties", (Object)KAFKA_CONSUMER_FILE);
                return new Properties();
            }
            properties = new Properties();
            try (FileInputStream is = new FileInputStream(propFile);){
                Configuration conf = new Configuration();
                conf.addResource((InputStream)is);
                properties.putAll((Map<?, ?>)KafkaConsumerProperties.extractKafkaConfigToProperties(conf));
                File propOverrideFile = new File(propFile.getParentFile(), propFile.getName() + ".override");
                if (!propOverrideFile.exists()) break block28;
                try (FileInputStream ois = new FileInputStream(propOverrideFile);){
                    Configuration oconf = new Configuration();
                    oconf.addResource((InputStream)ois);
                    properties.putAll((Map<?, ?>)KafkaConsumerProperties.extractKafkaConfigToProperties(oconf));
                }
            }
            catch (FileNotFoundException fne) {
                throw new IllegalArgumentException(fne);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return properties;
    }

    public String getKafkaConsumerHadoopJobConf() {
        File kafkaConsumerFile = this.getKafkaConsumerFile();
        return OptionsHelper.convertToFileURL(kafkaConsumerFile.getAbsolutePath());
    }

    private File getKafkaConsumerFile() {
        String kylinConfHome = System.getProperty("KYLIN_CONF");
        if (!StringUtils.isEmpty(kylinConfHome)) {
            logger.info("Use KYLIN_CONF={}", (Object)kylinConfHome);
            return KafkaConsumerProperties.getKafkaConsumerFile(kylinConfHome);
        }
        logger.warn("KYLIN_CONF property was not set, will seek KYLIN_HOME env variable");
        String kylinHome = KylinConfig.getKylinHome();
        if (StringUtils.isEmpty(kylinHome)) {
            throw new KylinConfigCannotInitException("Didn't find KYLIN_CONF or KYLIN_HOME, please set one of them");
        }
        String path = kylinHome + File.separator + "conf";
        return KafkaConsumerProperties.getKafkaConsumerFile(path);
    }

    public Properties extractKafkaConfigToProperties() {
        Properties prop = new Properties();
        prop.putAll((Map<?, ?>)this.properties);
        return prop;
    }
}

