/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.source.jdbc.extensible;

import java.util.Locale;
import org.apache.calcite.sql.SqlDialect;
import org.apache.hadoop.util.StringUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.job.JoinedFlatTable;
import org.apache.kylin.job.execution.AbstractExecutable;
import org.apache.kylin.job.util.FlatTableSqlQuoteUtils;
import org.apache.kylin.metadata.model.IJoinedFlatTableDesc;
import org.apache.kylin.metadata.model.PartitionDesc;
import org.apache.kylin.metadata.model.SegmentRange;
import org.apache.kylin.metadata.model.TblColRef;
import org.apache.kylin.sdk.datasource.framework.JdbcConnector;
import org.apache.kylin.sdk.datasource.framework.conv.SqlConverter;
import org.apache.kylin.source.jdbc.JdbcHiveInputBase;
import org.apache.kylin.source.jdbc.sqoop.SqoopCmdStep;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdbcHiveInputBase
extends org.apache.kylin.source.jdbc.JdbcHiveInputBase {
    private static final Logger logger = LoggerFactory.getLogger(JdbcHiveInputBase.class);

    public static class JDBCBaseBatchCubingInputSide
    extends JdbcHiveInputBase.JdbcBaseBatchCubingInputSide {
        private final JdbcConnector dataSource;

        public JDBCBaseBatchCubingInputSide(IJoinedFlatTableDesc flatDesc, JdbcConnector dataSource) {
            super(flatDesc, true);
            this.dataSource = dataSource;
        }

        protected JdbcConnector getDataSource() {
            return this.dataSource;
        }

        @Override
        protected AbstractExecutable createSqoopToFlatHiveStep(String jobWorkingDir, String cubeName) {
            SegmentRange segRange;
            String splitColumn;
            KylinConfig config = this.flatDesc.getDataModel().getConfig();
            PartitionDesc partitionDesc = this.flatDesc.getDataModel().getPartitionDesc();
            String partCol = null;
            boolean enableQuote = this.dataSource.getSqlConverter().getConfigurer().enableQuote();
            enableQuote = enableQuote && config.enableHiveDdlQuote();
            logger.debug("Quote switch is set to {}", (Object)enableQuote);
            SqlDialect sqlDialect = enableQuote ? this.dataSource.getSqlConverter().getConfigurer().getSqlDialect() : FlatTableSqlQuoteUtils.NON_QUOTE_DIALECT;
            SqlConverter.IConfigurer iconfigurer = this.dataSource.getSqlConverter().getConfigurer();
            if (partitionDesc.isPartitioned()) {
                partCol = partitionDesc.getPartitionDateColumn();
            }
            TblColRef splitColRef = this.determineSplitColumn();
            String splitTable = splitColRef.getTableRef().getTableDesc().getName();
            String splitTableAlias = splitColRef.getTableAlias();
            String splitDatabase = splitColRef.getColumnDesc().getTable().getDatabase();
            if (enableQuote) {
                splitColumn = sqlDialect.quoteIdentifier(splitColRef.getTableAlias()) + "." + sqlDialect.quoteIdentifier(splitColRef.getName());
                splitDatabase = sqlDialect.quoteIdentifier(splitDatabase);
                splitTable = sqlDialect.quoteIdentifier(splitTable);
                splitTableAlias = sqlDialect.quoteIdentifier(splitTableAlias);
            } else {
                splitColumn = splitColRef.getTableAlias() + "." + splitColRef.getName();
            }
            String selectSql = JoinedFlatTable.generateSelectDataStatement(this.flatDesc, true, new String[]{partCol}, sqlDialect);
            selectSql = JdbcHiveInputBase.escapeQuotationInSql(this.dataSource.convertSql(selectSql));
            String hiveTable = this.flatDesc.getTableName();
            String filedDelimiter = config.getJdbcSourceFieldDelimiter();
            int mapperNum = config.getSqoopMapperNum();
            String bquery = String.format(Locale.ROOT, "SELECT min(%s), max(%s) FROM %s.%s as %s", splitColumn, splitColumn, splitDatabase, splitTable, splitTableAlias);
            bquery = this.dataSource.convertSql(bquery);
            if (partitionDesc.isPartitioned() && (segRange = this.flatDesc.getSegRange()) != null && !segRange.isInfinite() && partitionDesc.getPartitionDateColumnRef().getTableAlias().equals(splitTableAlias) && (partitionDesc.getPartitionTimeColumnRef() == null || partitionDesc.getPartitionTimeColumnRef().getTableAlias().equals(splitTableAlias))) {
                String quotedPartCond = FlatTableSqlQuoteUtils.quoteIdentifierInSqlExpr(this.flatDesc, partitionDesc.getPartitionConditionBuilder().buildDateRangeCondition(partitionDesc, this.flatDesc.getSegment(), segRange, null), sqlDialect);
                bquery = bquery + " WHERE " + quotedPartCond;
            }
            bquery = JdbcHiveInputBase.escapeQuotationInSql(bquery);
            splitColumn = JdbcHiveInputBase.escapeQuotationInSql(splitColumn);
            String cmd = StringUtils.format((String)"--connect \"%s\" --driver \"%s\" --username \"%s\" --password \"%s\" --query \"%s AND \\$CONDITIONS\" --target-dir \"%s/%s\" --split-by \"%s\" --boundary-query \"%s\" --null-string '' --fields-terminated-by '%s' --num-mappers %d", (Object[])new Object[]{this.dataSource.getJdbcUrl(), this.dataSource.getJdbcDriver(), this.dataSource.getJdbcUser(), this.dataSource.getJdbcPassword(), selectSql, jobWorkingDir, hiveTable, splitColumn, bquery, filedDelimiter, mapperNum});
            if (iconfigurer.getTransactionIsolationLevel() != null) {
                cmd = cmd + " --relaxed-isolation --metadata-transaction-isolation-level " + iconfigurer.getTransactionIsolationLevel();
            }
            logger.debug("sqoop cmd: {}", (Object)cmd);
            SqoopCmdStep step = new SqoopCmdStep();
            step.setCmd(cmd);
            step.setName("Sqoop To Flat Hive Table");
            return step;
        }
    }
}

