/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.mr.steps;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.persistence.ResourceStore;
import org.apache.kylin.common.util.HadoopUtil;
import org.apache.kylin.cube.CubeInstance;
import org.apache.kylin.cube.CubeManager;
import org.apache.kylin.cube.CubeSegment;
import org.apache.kylin.engine.mr.CubingJob;
import org.apache.kylin.engine.mr.common.CubeStatsReader;
import org.apache.kylin.engine.mr.common.CubeStatsWriter;
import org.apache.kylin.engine.mr.common.StatisticsDecisionUtil;
import org.apache.kylin.engine.mr.steps.CubingExecutableUtil;
import org.apache.kylin.job.exception.ExecuteException;
import org.apache.kylin.job.execution.AbstractExecutable;
import org.apache.kylin.job.execution.ExecutableContext;
import org.apache.kylin.job.execution.ExecuteResult;
import org.apache.kylin.job.impl.threadpool.IJobRunner;
import org.apache.kylin.measure.hllc.HLLCounter;
import org.apache.kylin.shaded.com.google.common.base.Preconditions;
import org.apache.kylin.shaded.com.google.common.collect.Maps;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MergeStatisticsWithOldStep
extends AbstractExecutable {
    private static final Logger logger = LoggerFactory.getLogger(MergeStatisticsWithOldStep.class);
    protected Map<Long, HLLCounter> cuboidHLLMap = Maps.newHashMap();

    @Override
    protected ExecuteResult doWork(ExecutableContext context, IJobRunner jobRunner) throws ExecuteException {
        CubeManager mgr = CubeManager.getInstance(context.getConfig());
        CubeInstance cube = mgr.getCube(CubingExecutableUtil.getCubeName(this.getParams()));
        CubeSegment optimizeSegment = cube.getSegmentById(CubingExecutableUtil.getSegmentId(this.getParams()));
        CubeSegment oldSegment = optimizeSegment.getCubeInstance().getOriginalSegmentToOptimize(optimizeSegment);
        Preconditions.checkNotNull(oldSegment, "cannot find the original segment to be optimized by " + optimizeSegment);
        KylinConfig kylinConf = cube.getConfig();
        Configuration conf = HadoopUtil.getCurrentConfiguration();
        ResourceStore rs = ResourceStore.getStore(kylinConf);
        int averageSamplingPercentage = 0;
        try {
            Path statisticsDirPath = new Path(CubingExecutableUtil.getStatisticsPath(this.getParams()));
            FileSystem hdfs = FileSystem.get((Configuration)conf);
            if (!hdfs.exists(statisticsDirPath)) {
                throw new IOException("StatisticsFilePath " + statisticsDirPath + " does not exists");
            }
            if (!hdfs.isDirectory(statisticsDirPath)) {
                throw new IOException("StatisticsFilePath " + statisticsDirPath + " is not a directory");
            }
            Path[] statisticsFiles = HadoopUtil.getFilteredPath(hdfs, statisticsDirPath, "statistics");
            if (statisticsFiles == null) {
                throw new IOException("fail to find the statistics file in base dir: " + statisticsDirPath);
            }
            for (Path item : statisticsFiles) {
                CubeStatsReader optimizeSegmentStatsReader = new CubeStatsReader(optimizeSegment, null, optimizeSegment.getConfig(), item);
                averageSamplingPercentage += optimizeSegmentStatsReader.getSamplingPercentage();
                this.addFromCubeStatsReader(optimizeSegmentStatsReader);
            }
            CubeStatsReader oldSegmentStatsReader = new CubeStatsReader(oldSegment, null, oldSegment.getConfig());
            averageSamplingPercentage += oldSegmentStatsReader.getSamplingPercentage();
            this.addFromCubeStatsReader(oldSegmentStatsReader);
            logger.info("Cuboid set with stats info: " + this.cuboidHLLMap.keySet().toString());
            averageSamplingPercentage /= 2;
            Set<Long> cuboidsRecommend = cube.getCuboidsRecommend();
            HashMap<Long, HLLCounter> resultCuboidHLLMap = Maps.newHashMapWithExpectedSize(cuboidsRecommend.size());
            for (Long cuboid : cuboidsRecommend) {
                HLLCounter hll = this.cuboidHLLMap.get(cuboid);
                if (hll == null) {
                    logger.warn("Cannot get the row count stats for cuboid " + cuboid);
                    continue;
                }
                resultCuboidHLLMap.put(cuboid, hll);
            }
            String resultDir = CubingExecutableUtil.getMergedStatisticsPath(this.getParams());
            CubeStatsWriter.writeCuboidStatistics(conf, new Path(resultDir), resultCuboidHLLMap, averageSamplingPercentage, oldSegmentStatsReader.getSourceRowCount());
            try (FSDataInputStream mergedStats = hdfs.open(new Path(resultDir, "cuboid_statistics.seq"));){
                String statisticsFileName = optimizeSegment.getStatisticsResourcePath();
                rs.putResource(statisticsFileName, (InputStream)mergedStats, System.currentTimeMillis());
            }
            CubingJob cubingJob = (CubingJob)this.getManager().getJob(CubingExecutableUtil.getCubingJobId(this.getParams()));
            StatisticsDecisionUtil.decideCubingAlgorithm(cubingJob, optimizeSegment);
            return new ExecuteResult();
        }
        catch (IOException e) {
            logger.error("fail to merge cuboid statistics", e);
            return ExecuteResult.createError(e);
        }
    }

    private void addFromCubeStatsReader(CubeStatsReader cubeStatsReader) {
        for (Map.Entry<Long, HLLCounter> entry : cubeStatsReader.getCuboidRowHLLCounters().entrySet()) {
            if (this.cuboidHLLMap.get(entry.getKey()) != null) {
                this.cuboidHLLMap.get(entry.getKey()).merge(entry.getValue());
                continue;
            }
            this.cuboidHLLMap.put(entry.getKey(), entry.getValue());
        }
    }
}

