/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.mr;

import org.apache.kylin.cube.CubeSegment;
import org.apache.kylin.cube.cuboid.CuboidModeEnum;
import org.apache.kylin.cube.cuboid.CuboidUtil;
import org.apache.kylin.engine.mr.CubingJob;
import org.apache.kylin.engine.mr.IMROutput2;
import org.apache.kylin.engine.mr.JobBuilderSupport;
import org.apache.kylin.engine.mr.MRUtil;
import org.apache.kylin.engine.mr.common.AbstractHadoopJob;
import org.apache.kylin.engine.mr.common.MapReduceExecutable;
import org.apache.kylin.engine.mr.steps.CopyDictionaryStep;
import org.apache.kylin.engine.mr.steps.CubingExecutableUtil;
import org.apache.kylin.engine.mr.steps.FilterRecommendCuboidDataJob;
import org.apache.kylin.engine.mr.steps.InMemCuboidFromBaseCuboidJob;
import org.apache.kylin.engine.mr.steps.MergeStatisticsWithOldStep;
import org.apache.kylin.engine.mr.steps.NDCuboidJob;
import org.apache.kylin.engine.mr.steps.UpdateCubeInfoAfterOptimizeStep;
import org.apache.kylin.engine.mr.steps.UpdateOldCuboidShardJob;
import org.apache.kylin.shaded.com.google.common.base.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BatchOptimizeJobBuilder2
extends JobBuilderSupport {
    private static final Logger logger = LoggerFactory.getLogger(BatchOptimizeJobBuilder2.class);
    private final IMROutput2.IMRBatchOptimizeOutputSide2 outputSide;

    public BatchOptimizeJobBuilder2(CubeSegment optimizeSegment, String submitter) {
        super(optimizeSegment, submitter);
        this.outputSide = MRUtil.getBatchOptimizeOutputSide2(optimizeSegment);
    }

    public CubingJob build() {
        logger.info("MR_V2 new job to OPTIMIZE a segment " + this.seg);
        CubingJob result = CubingJob.createOptimizeJob(this.seg, this.submitter, this.config);
        CubingExecutableUtil.setCubeName(this.seg.getRealization().getName(), result.getParams());
        String jobId = result.getId();
        String cuboidRootPath = this.getCuboidRootPath(jobId);
        String optimizeCuboidRootPath = this.getOptimizationCuboidPath(jobId);
        CubeSegment oldSegment = this.seg.getCubeInstance().getOriginalSegmentToOptimize(this.seg);
        Preconditions.checkNotNull(oldSegment, "cannot find the original segment to be optimized by " + this.seg);
        String oldcuboidRootPath = this.getCuboidRootPath(oldSegment) + "*";
        result.addTask(this.createFilterRecommendCuboidDataStep(oldcuboidRootPath, optimizeCuboidRootPath));
        result.addTask(this.createCopyDictionaryStep());
        String optStatsSourcePath = BatchOptimizeJobBuilder2.getBaseCuboidPath(optimizeCuboidRootPath);
        String optStatsDstPath = this.getOptimizationStatisticsPath(jobId);
        result.addTask(this.createCalculateStatsFromBaseCuboid(optStatsSourcePath, optStatsDstPath, CuboidModeEnum.RECOMMEND_MISSING));
        result.addTask(this.createMergeStatisticsWithOldStep(jobId, optStatsDstPath, this.getStatisticsPath(jobId)));
        this.outputSide.addStepPhase2_CreateHTable(result);
        result.addTask(this.createUpdateShardForOldCuboidDataStep(optimizeCuboidRootPath + "*", cuboidRootPath));
        this.addLayerCubingSteps(result, jobId, CuboidModeEnum.RECOMMEND_MISSING_WITH_BASE, cuboidRootPath);
        result.addTask(this.createInMemCubingStep(jobId, CuboidModeEnum.RECOMMEND_MISSING_WITH_BASE, cuboidRootPath));
        this.outputSide.addStepPhase3_BuildCube(result);
        result.addTask(this.createUpdateCubeInfoAfterOptimizeStep(jobId));
        this.outputSide.addStepPhase4_Cleanup(result);
        return result;
    }

    public MapReduceExecutable createFilterRecommendCuboidDataStep(String inputPath, String outputPath) {
        MapReduceExecutable result = new MapReduceExecutable();
        result.setName("Filter Recommend Cuboid Data for Optimization");
        StringBuilder cmd = new StringBuilder();
        this.appendMapReduceParameters(cmd);
        BatchOptimizeJobBuilder2.appendExecCmdParameters(cmd, "cubename", this.seg.getRealization().getName());
        BatchOptimizeJobBuilder2.appendExecCmdParameters(cmd, "segmentId", this.seg.getUuid());
        BatchOptimizeJobBuilder2.appendExecCmdParameters(cmd, "input", inputPath);
        BatchOptimizeJobBuilder2.appendExecCmdParameters(cmd, "output", outputPath);
        BatchOptimizeJobBuilder2.appendExecCmdParameters(cmd, "jobname", "Kylin_Filter_Recommend_Cuboid_Data_" + this.seg.getRealization().getName());
        result.setMapReduceParams(cmd.toString());
        result.setMapReduceJobClass(FilterRecommendCuboidDataJob.class);
        return result;
    }

    public CopyDictionaryStep createCopyDictionaryStep() {
        CopyDictionaryStep result = new CopyDictionaryStep();
        result.setName("Copy dictionary from Old Segment");
        CubingExecutableUtil.setCubeName(this.seg.getRealization().getName(), result.getParams());
        CubingExecutableUtil.setSegmentId(this.seg.getUuid(), result.getParams());
        return result;
    }

    private MapReduceExecutable createUpdateShardForOldCuboidDataStep(String inputPath, String outputPath) {
        MapReduceExecutable result = new MapReduceExecutable();
        result.setName("Update Old Cuboid Shard for Optimization");
        StringBuilder cmd = new StringBuilder();
        this.appendMapReduceParameters(cmd);
        BatchOptimizeJobBuilder2.appendExecCmdParameters(cmd, "cubename", this.seg.getRealization().getName());
        BatchOptimizeJobBuilder2.appendExecCmdParameters(cmd, "segmentId", this.seg.getUuid());
        BatchOptimizeJobBuilder2.appendExecCmdParameters(cmd, "input", inputPath);
        BatchOptimizeJobBuilder2.appendExecCmdParameters(cmd, "output", outputPath);
        BatchOptimizeJobBuilder2.appendExecCmdParameters(cmd, "jobname", "Kylin_Update_Old_Cuboid_Shard_" + this.seg.getRealization().getName());
        result.setMapReduceParams(cmd.toString());
        result.setMapReduceJobClass(UpdateOldCuboidShardJob.class);
        return result;
    }

    private MergeStatisticsWithOldStep createMergeStatisticsWithOldStep(String jobId, String optStatsPath, String mergedStatisticsFolder) {
        MergeStatisticsWithOldStep result = new MergeStatisticsWithOldStep();
        result.setName("Merge Cuboid Statistics with Old for Optimization");
        CubingExecutableUtil.setCubingJobId(jobId, result.getParams());
        CubingExecutableUtil.setCubeName(this.seg.getRealization().getName(), result.getParams());
        CubingExecutableUtil.setSegmentId(this.seg.getUuid(), result.getParams());
        CubingExecutableUtil.setStatisticsPath(optStatsPath, result.getParams());
        CubingExecutableUtil.setMergedStatisticsPath(mergedStatisticsFolder, result.getParams());
        return result;
    }

    private void addLayerCubingSteps(CubingJob result, String jobId, CuboidModeEnum cuboidMode, String cuboidRootPath) {
        int maxLevel = CuboidUtil.getLongestDepth(this.seg.getCubeInstance().getCuboidsByMode(cuboidMode));
        for (int i = 1; i <= maxLevel; ++i) {
            String parentCuboidPath = i == 1 ? BatchOptimizeJobBuilder2.getBaseCuboidPath(cuboidRootPath) : BatchOptimizeJobBuilder2.getCuboidOutputPathsByLevel(cuboidRootPath, i - 1);
            result.addTask(this.createNDimensionCuboidStep(parentCuboidPath, BatchOptimizeJobBuilder2.getCuboidOutputPathsByLevel(cuboidRootPath, i), i, jobId, cuboidMode));
        }
    }

    private MapReduceExecutable createNDimensionCuboidStep(String parentPath, String outputPath, int level, String jobId, CuboidModeEnum cuboidMode) {
        MapReduceExecutable ndCuboidStep = new MapReduceExecutable();
        ndCuboidStep.setName("Build N-Dimension Cuboid : level " + level);
        StringBuilder cmd = new StringBuilder();
        this.appendMapReduceParameters(cmd);
        BatchOptimizeJobBuilder2.appendExecCmdParameters(cmd, "cubename", this.seg.getRealization().getName());
        BatchOptimizeJobBuilder2.appendExecCmdParameters(cmd, "segmentId", this.seg.getUuid());
        BatchOptimizeJobBuilder2.appendExecCmdParameters(cmd, "input", parentPath);
        BatchOptimizeJobBuilder2.appendExecCmdParameters(cmd, "output", outputPath);
        BatchOptimizeJobBuilder2.appendExecCmdParameters(cmd, "jobname", "Kylin_ND-Cuboid_Builder_" + this.seg.getRealization().getName() + "_Step");
        BatchOptimizeJobBuilder2.appendExecCmdParameters(cmd, "level", "" + level);
        BatchOptimizeJobBuilder2.appendExecCmdParameters(cmd, "cubingJobId", jobId);
        BatchOptimizeJobBuilder2.appendExecCmdParameters(cmd, "cuboidMode", cuboidMode.toString());
        ndCuboidStep.setMapReduceParams(cmd.toString());
        ndCuboidStep.setMapReduceJobClass(this.getNDCuboidJob());
        return ndCuboidStep;
    }

    private MapReduceExecutable createInMemCubingStep(String jobId, CuboidModeEnum cuboidMode, String cuboidRootPath) {
        MapReduceExecutable cubeStep = new MapReduceExecutable();
        StringBuilder cmd = new StringBuilder();
        this.appendMapReduceParameters(cmd, "inmem");
        cubeStep.setName("Build Cube In-Mem");
        BatchOptimizeJobBuilder2.appendExecCmdParameters(cmd, "cubename", this.seg.getRealization().getName());
        BatchOptimizeJobBuilder2.appendExecCmdParameters(cmd, "segmentId", this.seg.getUuid());
        BatchOptimizeJobBuilder2.appendExecCmdParameters(cmd, "input", BatchOptimizeJobBuilder2.getBaseCuboidPath(cuboidRootPath));
        BatchOptimizeJobBuilder2.appendExecCmdParameters(cmd, "output", BatchOptimizeJobBuilder2.getInMemCuboidPath(cuboidRootPath));
        BatchOptimizeJobBuilder2.appendExecCmdParameters(cmd, "jobname", "Kylin_Cube_Builder_" + this.seg.getRealization().getName());
        BatchOptimizeJobBuilder2.appendExecCmdParameters(cmd, "cubingJobId", jobId);
        BatchOptimizeJobBuilder2.appendExecCmdParameters(cmd, "cuboidMode", cuboidMode.toString());
        cubeStep.setMapReduceParams(cmd.toString());
        cubeStep.setMapReduceJobClass(InMemCuboidFromBaseCuboidJob.class);
        cubeStep.setCounterSaveAs("sourceRecordCount,sourceSizeBytes,byteSizeBytes");
        return cubeStep;
    }

    public UpdateCubeInfoAfterOptimizeStep createUpdateCubeInfoAfterOptimizeStep(String jobId) {
        UpdateCubeInfoAfterOptimizeStep result = new UpdateCubeInfoAfterOptimizeStep();
        result.setName("Update Cube Info");
        CubingExecutableUtil.setCubeName(this.seg.getRealization().getName(), result.getParams());
        CubingExecutableUtil.setSegmentId(this.seg.getUuid(), result.getParams());
        CubingExecutableUtil.setCubingJobId(jobId, result.getParams());
        return result;
    }

    protected Class<? extends AbstractHadoopJob> getNDCuboidJob() {
        return NDCuboidJob.class;
    }
}

