/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.dict.global;

import java.io.DataInput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.HadoopUtil;
import org.apache.kylin.dict.global.AppendDictSlice;

public class AppendTrieDictionaryChecker {
    public boolean runChecker(String baseDir) throws IOException {
        Path basePath = new Path(baseDir);
        FileSystem fs = HadoopUtil.getFileSystem(basePath);
        ArrayList<Path> sliceList = new ArrayList<Path>();
        ArrayList<Path> corruptedSliceList = new ArrayList<Path>();
        this.listDictSlicePath(fs, fs.getFileStatus(basePath), sliceList);
        for (Path path : sliceList) {
            if (!this.doCheck(fs, path)) {
                System.out.println("AppendDict Slice " + path + " corrupted");
                corruptedSliceList.add(path);
                continue;
            }
            System.out.println("AppendDict Slice " + path + " is right");
        }
        if (corruptedSliceList.isEmpty()) {
            System.out.println("ALL AppendDict Slices is right");
            return true;
        }
        System.out.println("Some AppendDict Slice(s) corrupted: ");
        for (Path path : corruptedSliceList) {
            System.out.println(path.toString());
        }
        return false;
    }

    public void listDictSlicePath(FileSystem fs, FileStatus path, List<Path> list) throws IOException {
        if (path.isDirectory()) {
            for (FileStatus status : fs.listStatus(path.getPath())) {
                this.listDictSlicePath(fs, status, list);
            }
        } else if (path.getPath().getName().startsWith("cached_")) {
            list.add(path.getPath());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean doCheck(FileSystem fs, Path filePath) {
        try (FSDataInputStream input = fs.open(filePath, 0x800000);){
            AppendDictSlice slice = AppendDictSlice.deserializeFrom((DataInput)input);
            boolean bl = slice.doCheck();
            return bl;
        }
        catch (Exception e) {
            return false;
        }
        catch (Error e) {
            return false;
        }
    }

    public static void main(String[] args) throws IOException {
        String path = KylinConfig.getInstanceFromEnv().getHdfsWorkingDirectory() + "resources/GlobalDict/";
        if (args.length > 0) {
            path = args[0];
        }
        System.out.println("Recursive Check AppendTrieDictionary Slices in path " + path);
        AppendTrieDictionaryChecker checker = new AppendTrieDictionaryChecker();
        if (checker.runChecker(path)) {
            System.exit(0);
        } else {
            System.exit(-1);
        }
    }
}

