/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.common.persistence;

import java.io.IOException;
import java.io.InputStream;
import org.apache.kylin.tool.shaded.org.apache.commons.io.IOUtils;

public class RawResource
implements AutoCloseable {
    private final String path;
    private final long lastModified;
    private final InputStream content;

    public RawResource(String path, long lastModified) {
        this(path, lastModified, (InputStream)null);
    }

    public RawResource(String path, long lastModified, InputStream content) {
        this.path = path;
        this.lastModified = lastModified;
        this.content = content;
    }

    public RawResource(String path, long lastModified, IOException brokenContentException) {
        this(path, lastModified, RawResource.wrap(brokenContentException));
    }

    private static InputStream wrap(final IOException brokenContentException) {
        return new InputStream(){

            @Override
            public int read() throws IOException {
                throw brokenContentException;
            }
        };
    }

    public String path() {
        return this.path;
    }

    public long lastModified() {
        return this.lastModified;
    }

    public InputStream content() {
        return this.content;
    }

    @Override
    public void close() {
        if (this.content != null) {
            IOUtils.closeQuietly(this.content);
        }
    }
}

