/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.security;

import java.security.AccessController;
import java.security.Principal;
import java.util.Optional;
import java.util.Set;
import javax.security.auth.Subject;
import org.apache.knox.gateway.security.GroupPrincipal;
import org.apache.knox.gateway.security.ImpersonatedPrincipal;
import org.apache.knox.gateway.security.PrimaryPrincipal;

public class SubjectUtils {
    public static Subject getCurrentSubject() {
        return Subject.getSubject(AccessController.getContext());
    }

    public static String getPrimaryPrincipalName(Subject subject) {
        String name = null;
        Set<PrimaryPrincipal> primaryPrincipals = subject.getPrincipals(PrimaryPrincipal.class);
        if (!primaryPrincipals.isEmpty()) {
            return ((PrimaryPrincipal)primaryPrincipals.toArray()[0]).getName();
        }
        Optional principal = subject.getPrincipals().stream().findFirst();
        if (principal.isPresent()) {
            name = ((Principal)principal.get()).getName();
        }
        return name;
    }

    public static boolean isImpersonating(Subject subject) {
        return !subject.getPrincipals(ImpersonatedPrincipal.class).isEmpty();
    }

    public static String getImpersonatedPrincipalName(Subject subject) {
        String name = null;
        Set<ImpersonatedPrincipal> impPrincipals = subject.getPrincipals(ImpersonatedPrincipal.class);
        if (!impPrincipals.isEmpty()) {
            return ((Principal)impPrincipals.toArray()[0]).getName();
        }
        return name;
    }

    public static String getEffectivePrincipalName(Subject subject) {
        String name = SubjectUtils.getImpersonatedPrincipalName(subject);
        if (name == null) {
            name = SubjectUtils.getPrimaryPrincipalName(subject);
        }
        return name;
    }

    public static String getCurrentEffectivePrincipalName() {
        Subject subject = SubjectUtils.getCurrentSubject();
        return subject == null ? null : SubjectUtils.getEffectivePrincipalName(subject);
    }

    public static Set<GroupPrincipal> getGroupPrincipals(Subject subject) {
        return subject.getPrincipals(GroupPrincipal.class);
    }
}

