/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.mavibot.btree.util;

import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class Strings {
    private static final byte[] HEX_CHAR = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 65, 66, 67, 68, 69, 70};
    public static final byte[] EMPTY_BYTES = new byte[0];
    private static final byte[] UTF8 = new byte[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127};

    public static String dumpBytes(byte[] buffer) {
        if (buffer == null) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        for (byte b : buffer) {
            sb.append("0x").append((char)HEX_CHAR[(b & 0xF0) >> 4]).append((char)HEX_CHAR[b & 0xF]).append(" ");
        }
        return sb.toString();
    }

    public static String dumpByte(byte octet) {
        return new String(new byte[]{48, 120, HEX_CHAR[(octet & 0xF0) >> 4], HEX_CHAR[octet & 0xF]});
    }

    public static char dumpHex(byte hex) {
        return (char)HEX_CHAR[hex & 0xF];
    }

    public static String dumpHexPairs(byte[] buffer) {
        if (buffer == null) {
            return "";
        }
        char[] str = new char[buffer.length << 1];
        int pos = 0;
        for (byte b : buffer) {
            str[pos++] = (char)HEX_CHAR[(b & 0xF0) >> 4];
            str[pos++] = (char)HEX_CHAR[b & 0xF];
        }
        return new String(str);
    }

    public static String toHexString(byte[] res) {
        StringBuffer buf = new StringBuffer(res.length << 1);
        for (byte b : res) {
            String digit = Integer.toHexString(0xFF & b);
            if (digit.length() == 1) {
                digit = '0' + digit;
            }
            buf.append(digit);
        }
        return buf.toString().toUpperCase();
    }

    public static byte[] toByteArray(String hexString) {
        int arrLength = hexString.length() >> 1;
        byte[] buf = new byte[arrLength];
        for (int ii = 0; ii < arrLength; ++ii) {
            int index = ii << 1;
            String digit = hexString.substring(index, index + 2);
            buf[ii] = (byte)Integer.parseInt(digit, 16);
        }
        return buf;
    }

    public static String utf8ToString(byte[] bytes) {
        if (bytes == null) {
            return "";
        }
        char[] chars = new char[bytes.length];
        int pos = 0;
        try {
            for (byte b : bytes) {
                chars[pos++] = (char)UTF8[b];
            }
        }
        catch (ArrayIndexOutOfBoundsException aioobe) {
            try {
                return new String(bytes, "UTF-8");
            }
            catch (UnsupportedEncodingException uee) {
                throw new RuntimeException(uee);
            }
        }
        return new String(chars);
    }

    public static String utf8ToString(ByteBuffer bytes) {
        if (bytes == null) {
            return "";
        }
        char[] chars = new char[bytes.limit()];
        int pos = 0;
        int currentPos = bytes.position();
        do {
            chars[pos++] = (char)UTF8[bytes.get()];
        } while (bytes.position() < bytes.limit());
        bytes.position(currentPos);
        return new String(chars);
    }

    public static String utf8ToString(byte[] bytes, int length) {
        if (bytes == null) {
            return "";
        }
        try {
            return new String(bytes, 0, length, "UTF-8");
        }
        catch (UnsupportedEncodingException uee) {
            throw new RuntimeException(uee);
        }
    }

    public static String utf8ToString(byte[] bytes, int start, int length) {
        if (bytes == null) {
            return "";
        }
        try {
            return new String(bytes, start, length, "UTF-8");
        }
        catch (UnsupportedEncodingException uee) {
            throw new RuntimeException(uee);
        }
    }

    public static boolean isEmpty(String str) {
        return str == null || str.length() == 0;
    }

    public static boolean isEmpty(byte[] bytes) {
        return bytes == null || bytes.length == 0;
    }

    public static byte[] getBytesUtf8(String string) {
        if (string == null) {
            return EMPTY_BYTES;
        }
        try {
            return string.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException uee) {
            throw new RuntimeException(uee);
        }
    }

    public static byte[] getBytesUtf8Ascii(String string) {
        if (string == null) {
            return new byte[0];
        }
        try {
            try {
                char[] chars = string.toCharArray();
                byte[] bytes = new byte[chars.length];
                int pos = 0;
                for (char c : chars) {
                    bytes[pos++] = UTF8[c];
                }
                return bytes;
            }
            catch (ArrayIndexOutOfBoundsException aioobe) {
                return string.getBytes("UTF-8");
            }
        }
        catch (UnsupportedEncodingException uee) {
            throw new RuntimeException(uee);
        }
    }

    public static String listToString(List<?> list) {
        if (list == null || list.size() == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        boolean isFirst = true;
        for (Object elem : list) {
            if (isFirst) {
                isFirst = false;
            } else {
                sb.append(", ");
            }
            sb.append(elem);
        }
        return sb.toString();
    }

    public static String setToString(Set<?> set) {
        if (set == null || set.size() == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        boolean isFirst = true;
        for (Object elem : set) {
            if (isFirst) {
                isFirst = false;
            } else {
                sb.append(", ");
            }
            sb.append(elem);
        }
        return sb.toString();
    }

    public static String listToString(List<?> list, String tabs) {
        if (list == null || list.size() == 0) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        for (Object elem : list) {
            sb.append(tabs);
            sb.append(elem);
            sb.append('\n');
        }
        return sb.toString();
    }

    public static String mapToString(Map<?, ?> map) {
        if (map == null || map.size() == 0) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        boolean isFirst = true;
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            if (isFirst) {
                isFirst = false;
            } else {
                sb.append(", ");
            }
            sb.append(entry.getKey());
            sb.append(" = '").append(entry.getValue()).append("'");
        }
        return sb.toString();
    }

    public static String mapToString(Map<?, ?> map, String tabs) {
        if (map == null || map.size() == 0) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            sb.append(tabs);
            sb.append(entry.getKey());
            sb.append(" = '").append(entry.getValue().toString()).append("'\n");
        }
        return sb.toString();
    }
}

