/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.topology.simple;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.knox.gateway.topology.simple.ProviderConfiguration;
import org.apache.knox.gateway.topology.simple.ProviderOrder;

@JsonPropertyOrder(value={"providers", "readOnly"})
public class JSONProviderConfiguration
implements ProviderConfiguration {
    @JsonProperty(value="providers")
    @JsonSerialize(contentAs=JSONProvider.class)
    @JsonDeserialize(contentAs=JSONProvider.class)
    private Set<ProviderConfiguration.Provider> providers;
    @JsonProperty(value="readOnly")
    private boolean readOnly;

    @Override
    public Set<ProviderConfiguration.Provider> getProviders() {
        return this.providers == null ? Collections.emptySet() : Collections.unmodifiableSet(new TreeSet<ProviderConfiguration.Provider>(this.providers));
    }

    @Override
    public void saveOrUpdateProviders(Set<ProviderConfiguration.Provider> providersToReplace) {
        if (this.providers == null) {
            this.providers = new TreeSet<ProviderConfiguration.Provider>();
            this.providers.addAll(providersToReplace);
        } else {
            providersToReplace.forEach(providerToAdd -> {
                Optional<ProviderConfiguration.Provider> toBeRemoved = this.providers.stream().filter(provider -> provider.getRole().equals(providerToAdd.getRole())).findFirst();
                if (toBeRemoved.isPresent()) {
                    this.providers.remove(toBeRemoved.get());
                }
                this.providers.add((ProviderConfiguration.Provider)providerToAdd);
            });
        }
    }

    @Override
    public boolean isReadOnly() {
        return this.readOnly;
    }

    @Override
    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode((Object)this, (String[])new String[0]);
    }

    public boolean equals(Object obj) {
        return EqualsBuilder.reflectionEquals((Object)this, (Object)obj, (String[])new String[0]);
    }

    @JsonPropertyOrder(value={"role", "name", "enabled", "params"})
    public static class JSONProvider
    implements ProviderConfiguration.Provider,
    Comparable<JSONProvider> {
        @JsonProperty(value="role")
        private String role;
        @JsonProperty(value="name")
        private String name;
        @JsonProperty(value="enabled")
        private boolean enabled;
        @JsonProperty(value="params")
        private Map<String, String> params;

        @Override
        public String getRole() {
            return this.role;
        }

        public void setRole(String role) {
            this.role = role;
        }

        @Override
        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        @Override
        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        @Override
        public Map<String, String> getParams() {
            TreeMap<String, String> result = new TreeMap<String, String>();
            if (this.params != null) {
                result.putAll(this.params);
            }
            return result;
        }

        public void addParam(String key, String value) {
            if (this.params == null) {
                this.params = new TreeMap<String, String>();
            }
            this.params.put(key, value);
        }

        public void removeParam(String key) {
            if (this.params != null) {
                this.params.remove(key);
            }
        }

        public int hashCode() {
            return HashCodeBuilder.reflectionHashCode((Object)this, (String[])new String[0]);
        }

        public boolean equals(Object obj) {
            return EqualsBuilder.reflectionEquals((Object)this, (Object)obj, (String[])new String[0]);
        }

        @Override
        public int compareTo(JSONProvider other) {
            return Integer.compare(ProviderOrder.getOrdinalForRole(this.role), ProviderOrder.getOrdinalForRole(other.role));
        }
    }
}

