/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.oauth.profile.vk;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.github.scribejava.core.model.OAuth2AccessToken;
import java.util.Arrays;
import org.pac4j.core.profile.AttributeLocation;
import org.pac4j.core.profile.BasicUserProfile;
import org.pac4j.core.profile.ProfileHelper;
import org.pac4j.core.profile.converter.AttributeConverter;
import org.pac4j.core.profile.converter.Converters;
import org.pac4j.core.profile.converter.DateConverter;
import org.pac4j.core.profile.converter.GenderConverter;
import org.pac4j.oauth.profile.JsonHelper;
import org.pac4j.oauth.profile.definition.OAuth20ProfileDefinition;
import org.pac4j.oauth.profile.vk.VkConfiguration;
import org.pac4j.oauth.profile.vk.VkProfile;

public class VkProfileDefinition
extends OAuth20ProfileDefinition<VkProfile, VkConfiguration> {
    public static final String LAST_NAME = "last_name";
    public static final String SEX = "sex";
    public static final String BIRTH_DATE = "bdate";
    public static final String PHOTO_50 = "photo_50";
    public static final String PHOTO_100 = "photo_100";
    public static final String PHOTO_200_ORIG = "photo_200_orig";
    public static final String PHOTO_200 = "photo_200";
    public static final String PHOTO_400_ORIG = "photo_400_orig";
    public static final String PHOTO_MAX = "photo_max";
    public static final String PHOTO_MAX_ORIG = "photo_max_orig";
    public static final String ONLINE = "online";
    public static final String ONLINE_MOBILE = "online_mobile";
    public static final String DOMAIN = "domain";
    public static final String HAS_MOBILE = "has_mobile";
    public static final String MOBILE_PHONE = "mobile_phone";
    public static final String HOME_PHONE = "home_phone";
    public static final String SKYPE = "skype";
    public static final String SITE = "site";
    public static final String CAN_POST = "can_post";
    public static final String CAN_SEE_ALL_POST = "can_see_all_posts";
    public static final String CAN_SEE_AUDIO = "can_see_audio";
    public static final String CAN_WRITE_PRIVATE_MESSAGE = "can_write_private_message";
    public static final String STATUS = "status";
    public static final String COMMON_COUNT = "common_count";
    public static final String RELATION = "relation";
    protected static final String BASE_URL = "https://api.vk.com/method/users.get";

    public VkProfileDefinition() {
        super(x -> new VkProfile());
        Arrays.stream(new String[]{LAST_NAME, PHOTO_50, PHOTO_100, PHOTO_200_ORIG, PHOTO_200, PHOTO_400_ORIG, PHOTO_MAX, PHOTO_MAX_ORIG, DOMAIN, MOBILE_PHONE, HOME_PHONE, SKYPE, SITE, STATUS}).forEach(a -> this.primary((String)a, (AttributeConverter)Converters.STRING));
        this.primary(COMMON_COUNT, (AttributeConverter)Converters.INTEGER);
        this.primary(RELATION, (AttributeConverter)Converters.INTEGER);
        Arrays.stream(new String[]{ONLINE, ONLINE_MOBILE, HAS_MOBILE, CAN_POST, CAN_SEE_ALL_POST, CAN_SEE_AUDIO, CAN_WRITE_PRIVATE_MESSAGE}).forEach(a -> this.primary((String)a, (AttributeConverter)Converters.BOOLEAN));
        this.primary(BIRTH_DATE, (AttributeConverter)new DateConverter("dd.MM.yyyy"));
        this.primary(SEX, (AttributeConverter)new GenderConverter("2", "1"));
    }

    @Override
    public String getProfileUrl(OAuth2AccessToken accessToken, VkConfiguration configuration) {
        return "https://api.vk.com/method/users.get?fields=" + configuration.getFields();
    }

    @Override
    public VkProfile extractUserProfile(String body) {
        VkProfile profile = (VkProfile)this.newProfile(new Object[0]);
        JsonNode json = JsonHelper.getFirstNode(body);
        if (json != null) {
            ArrayNode array = (ArrayNode)json.get("response");
            JsonNode userNode = array.get(0);
            if (userNode == null) {
                this.raiseProfileExtractionJsonError(body, "response");
            }
            profile.setId(ProfileHelper.sanitizeIdentifier((BasicUserProfile)profile, (Object)JsonHelper.getElement(userNode, "uid")));
            for (String attribute : this.getPrimaryAttributes()) {
                this.convertAndAdd(profile, AttributeLocation.PROFILE_ATTRIBUTE, attribute, JsonHelper.getElement(userNode, attribute));
            }
        } else {
            this.raiseProfileExtractionJsonError(body);
        }
        return profile;
    }
}

