/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.services;

import java.util.List;
import java.util.Map;
import org.apache.knox.gateway.GatewayMessages;
import org.apache.knox.gateway.config.GatewayConfig;
import org.apache.knox.gateway.deploy.DeploymentContext;
import org.apache.knox.gateway.descriptor.FilterParamDescriptor;
import org.apache.knox.gateway.descriptor.ResourceDescriptor;
import org.apache.knox.gateway.i18n.messages.MessagesFactory;
import org.apache.knox.gateway.services.AbstractGatewayServices;
import org.apache.knox.gateway.services.GatewayMetricsServletContextListener;
import org.apache.knox.gateway.services.GatewayServiceFactory;
import org.apache.knox.gateway.services.GatewayServicesContextListener;
import org.apache.knox.gateway.services.ServiceLifecycleException;
import org.apache.knox.gateway.services.ServiceType;
import org.apache.knox.gateway.services.security.KeystoreService;
import org.apache.knox.gateway.services.security.KeystoreServiceException;
import org.apache.knox.gateway.topology.Provider;
import org.apache.knox.gateway.topology.Service;

public class DefaultGatewayServices
extends AbstractGatewayServices {
    private static GatewayMessages log = (GatewayMessages)MessagesFactory.get(GatewayMessages.class);
    private final GatewayServiceFactory gatewayServiceFactory = new GatewayServiceFactory();

    public DefaultGatewayServices() {
        super("Services", "GatewayServices");
    }

    public void init(GatewayConfig config, Map<String, String> options) throws ServiceLifecycleException {
        this.addService(ServiceType.MASTER_SERVICE, this.gatewayServiceFactory.create(this, ServiceType.MASTER_SERVICE, config, options));
        this.addService(ServiceType.KEYSTORE_SERVICE, this.gatewayServiceFactory.create(this, ServiceType.KEYSTORE_SERVICE, config, options));
        this.addService(ServiceType.REMOTE_REGISTRY_CLIENT_SERVICE, this.gatewayServiceFactory.create(this, ServiceType.REMOTE_REGISTRY_CLIENT_SERVICE, config, options));
        this.addService(ServiceType.ALIAS_SERVICE, this.gatewayServiceFactory.create(this, ServiceType.ALIAS_SERVICE, config, options));
        this.addService(ServiceType.CRYPTO_SERVICE, this.gatewayServiceFactory.create(this, ServiceType.CRYPTO_SERVICE, config, options));
        this.addService(ServiceType.SSL_SERVICE, this.gatewayServiceFactory.create(this, ServiceType.SSL_SERVICE, config, options));
        this.addService(ServiceType.TOKEN_SERVICE, this.gatewayServiceFactory.create(this, ServiceType.TOKEN_SERVICE, config, options));
        this.addService(ServiceType.TOKEN_STATE_SERVICE, this.gatewayServiceFactory.create(this, ServiceType.TOKEN_STATE_SERVICE, config, options));
        this.addService(ServiceType.SERVICE_REGISTRY_SERVICE, this.gatewayServiceFactory.create(this, ServiceType.SERVICE_REGISTRY_SERVICE, config, options));
        this.addService(ServiceType.HOST_MAPPING_SERVICE, this.gatewayServiceFactory.create(this, ServiceType.HOST_MAPPING_SERVICE, config, options));
        this.addService(ServiceType.SERVER_INFO_SERVICE, this.gatewayServiceFactory.create(this, ServiceType.SERVER_INFO_SERVICE, config, options));
        this.addService(ServiceType.CLUSTER_CONFIGURATION_MONITOR_SERVICE, this.gatewayServiceFactory.create(this, ServiceType.CLUSTER_CONFIGURATION_MONITOR_SERVICE, config, options));
        this.addService(ServiceType.TOPOLOGY_SERVICE, this.gatewayServiceFactory.create(this, ServiceType.TOPOLOGY_SERVICE, config, options));
        this.addService(ServiceType.SERVICE_DEFINITION_REGISTRY, this.gatewayServiceFactory.create(this, ServiceType.SERVICE_DEFINITION_REGISTRY, config, options));
        this.addService(ServiceType.METRICS_SERVICE, this.gatewayServiceFactory.create(this, ServiceType.METRICS_SERVICE, config, options));
        this.addService(ServiceType.CONCURRENT_SESSION_VERIFIER, this.gatewayServiceFactory.create(this, ServiceType.CONCURRENT_SESSION_VERIFIER, config, options));
    }

    public void initializeContribution(DeploymentContext context) {
        String clusterName = context.getTopology().getName();
        try {
            KeystoreService ks = (KeystoreService)this.getService(ServiceType.KEYSTORE_SERVICE);
            if (!ks.isCredentialStoreForClusterAvailable(clusterName)) {
                log.creatingCredentialStoreForCluster(clusterName);
                ks.createCredentialStoreForCluster(clusterName);
            } else {
                log.credentialStoreForClusterFoundNotCreating(clusterName);
            }
        }
        catch (KeystoreServiceException e) {
            throw new RuntimeException("Credential store was found but was unable to be loaded - the provided (or persisted) master secret may not match the password for the credential store.", e);
        }
    }

    public void contributeProvider(DeploymentContext context, Provider provider) {
    }

    public void contributeFilter(DeploymentContext context, Provider provider, Service service, ResourceDescriptor resource, List<FilterParamDescriptor> params) {
    }

    public void finalizeContribution(DeploymentContext context) {
        context.getWebAppDescriptor().createListener().listenerClass(GatewayServicesContextListener.class.getName());
        context.getWebAppDescriptor().createListener().listenerClass(GatewayMetricsServletContextListener.class.getName());
    }
}

