/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.ast.decompiled;

import groovyjarjarasm.asm.signature.SignatureVisitor;
import java.util.ArrayList;
import java.util.List;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.GenericsType;
import org.codehaus.groovy.ast.decompiled.AsmReferenceResolver;
import org.codehaus.groovy.ast.decompiled.TypeSignatureParser;
import org.codehaus.groovy.vmplugin.v8.Java8;

abstract class FormalParameterParser
extends SignatureVisitor {
    private final AsmReferenceResolver resolver;
    private String currentTypeParameter;
    private final List<ClassNode> parameterBounds = new ArrayList<ClassNode>();
    private final List<GenericsType> typeParameters = new ArrayList<GenericsType>();

    public FormalParameterParser(AsmReferenceResolver resolver) {
        super(458752);
        this.resolver = resolver;
    }

    @Override
    public void visitFormalTypeParameter(String name) {
        this.flushTypeParameter();
        this.currentTypeParameter = name;
    }

    protected void flushTypeParameter() {
        if (this.currentTypeParameter != null) {
            ClassNode ref = Java8.configureTypeVariableReference(this.currentTypeParameter);
            ClassNode[] boundNodes = this.parameterBounds.toArray(ClassNode.EMPTY_ARRAY);
            this.typeParameters.add(Java8.configureTypeVariableDefinition(ref, boundNodes));
            this.currentTypeParameter = null;
            this.parameterBounds.clear();
        }
    }

    @Override
    public SignatureVisitor visitClassBound() {
        return new TypeSignatureParser(this.resolver){

            @Override
            void finished(ClassNode result) {
                FormalParameterParser.this.parameterBounds.add(result);
            }
        };
    }

    @Override
    public SignatureVisitor visitInterfaceBound() {
        return this.visitClassBound();
    }

    public GenericsType[] getTypeParameters() {
        this.flushTypeParameter();
        return this.typeParameters.toArray(GenericsType.EMPTY_ARRAY);
    }
}

