/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.aci;

import java.util.Collection;
import java.util.Collections;
import org.apache.directory.api.ldap.aci.GrantAndDenial;
import org.apache.directory.api.ldap.aci.Permission;
import org.apache.directory.api.ldap.aci.ProtectedItem;

public class UserPermission
extends Permission {
    private final Collection<ProtectedItem> protectedItems;

    public UserPermission(Integer precedence, Collection<GrantAndDenial> grantsAndDenials, Collection<ProtectedItem> protectedItems) {
        super(precedence, grantsAndDenials);
        this.protectedItems = Collections.unmodifiableCollection(protectedItems);
    }

    public Collection<ProtectedItem> getProtectedItems() {
        return this.protectedItems;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("{ ");
        if (this.getPrecedence() != null) {
            buf.append("precedence ");
            buf.append(this.getPrecedence());
            buf.append(", ");
        }
        buf.append("protectedItems { ");
        boolean isFirst = true;
        for (ProtectedItem item : this.protectedItems) {
            if (isFirst) {
                isFirst = false;
            } else {
                buf.append(", ");
            }
            buf.append(item.toString());
        }
        buf.append(" }, grantsAndDenials { ");
        isFirst = true;
        for (GrantAndDenial grantAndDenial : this.getGrantsAndDenials()) {
            if (isFirst) {
                isFirst = false;
            } else {
                buf.append(", ");
            }
            buf.append(grantAndDenial.toString());
        }
        buf.append(" } }");
        return buf.toString();
    }
}

