/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.extras.controls.transaction;

import java.util.Arrays;
import org.apache.directory.api.ldap.extras.controls.transaction.TransactionSpecification;
import org.apache.directory.api.ldap.model.message.controls.AbstractControl;
import org.apache.directory.api.util.Strings;

public class TransactionSpecificationImpl
extends AbstractControl
implements TransactionSpecification {
    private byte[] identifier;

    public TransactionSpecificationImpl() {
        super("1.3.6.1.1.21.2");
    }

    @Override
    public byte[] getIdentifier() {
        return this.identifier;
    }

    @Override
    public void setIdentifier(byte[] identifier) {
        if (identifier != null) {
            this.identifier = new byte[identifier.length];
            System.arraycopy(identifier, 0, this.identifier, 0, identifier.length);
        }
    }

    public int hashCode() {
        int h = super.hashCode();
        if (this.identifier != null) {
            for (byte b : this.identifier) {
                h = h * 17 + b;
            }
        }
        return h;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TransactionSpecification)) {
            return false;
        }
        TransactionSpecification otherControl = (TransactionSpecification)o;
        return super.equals(o) && Arrays.equals(this.identifier, otherControl.getIdentifier());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("    Transaction Spcecification control :\n");
        sb.append("        oid : ").append(this.getOid()).append('\n');
        sb.append("        critical : ").append(this.isCritical()).append('\n');
        if (this.identifier != null) {
            sb.append("        Transaction ID=null").append('\n');
        } else {
            sb.append("        Transaction ID=").append(Strings.dumpBytes((byte[])this.identifier)).append('\n');
        }
        return sb.toString();
    }
}

