/**
 * @license Angular v5.2.11
 * (c) 2010-2018 Google, Inc. https://angular.io/
 * License: MIT
 */
!function(global,factory){"object"==typeof exports&&"undefined"!=typeof module?factory(exports,require("@angular/core")):"function"==typeof define&&define.amd?define("@angular/common",["exports","@angular/core"],factory):factory((global.ng=global.ng||{},global.ng.common={}),global.ng.core)}(this,function(exports,_angular_core){"use strict";function __extends(d,b){function __(){this.constructor=d}extendStatics(d,b),d.prototype=null===b?Object.create(b):(__.prototype=b.prototype,new __)}function _stripBaseHref(baseHref,url){return baseHref&&url.startsWith(baseHref)?url.substring(baseHref.length):url}function _stripIndexHtml(url){return url.replace(/\/index.html$/,"")}/**
 * @license
 * Copyright Google Inc. All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
function plural(n){var i=Math.floor(Math.abs(n)),v=n.toString().replace(/^[^.]*\.?/,"").length;return 1===i&&0===v?1:5}function registerLocaleData(data,localeId,extraData){"string"!=typeof localeId&&(extraData=localeId,localeId=data[0]),localeId=localeId.toLowerCase().replace(/_/g,"-"),LOCALE_DATA[localeId]=data,extraData&&(LOCALE_DATA[localeId][18]=extraData)}function getLocaleId(locale){return findLocaleData(locale)[0]}function getLocaleDayPeriods(locale,formStyle,width){var data=findLocaleData(locale);return getLastDefinedValue(getLastDefinedValue([data[1],data[2]],formStyle),width)}function getLocaleDayNames(locale,formStyle,width){var data=findLocaleData(locale);return getLastDefinedValue(getLastDefinedValue([data[3],data[4]],formStyle),width)}function getLocaleMonthNames(locale,formStyle,width){var data=findLocaleData(locale);return getLastDefinedValue(getLastDefinedValue([data[5],data[6]],formStyle),width)}function getLocaleEraNames(locale,width){return getLastDefinedValue(findLocaleData(locale)[7],width)}function getLocaleFirstDayOfWeek(locale){return findLocaleData(locale)[8]}function getLocaleWeekEndRange(locale){return findLocaleData(locale)[9]}function getLocaleDateFormat(locale,width){return getLastDefinedValue(findLocaleData(locale)[10],width)}function getLocaleTimeFormat(locale,width){return getLastDefinedValue(findLocaleData(locale)[11],width)}function getLocaleDateTimeFormat(locale,width){return getLastDefinedValue(findLocaleData(locale)[12],width)}function getLocaleNumberSymbol(locale,symbol){var data=findLocaleData(locale),res=data[13][symbol];if(void 0===res){if(symbol===NumberSymbol.CurrencyDecimal)return data[13][NumberSymbol.Decimal];if(symbol===NumberSymbol.CurrencyGroup)return data[13][NumberSymbol.Group]}return res}function getLocaleNumberFormat(locale,type){return findLocaleData(locale)[14][type]}function getLocaleCurrencySymbol(locale){return findLocaleData(locale)[15]||null}function getLocaleCurrencyName(locale){return findLocaleData(locale)[16]||null}function getLocalePluralCase(locale){return findLocaleData(locale)[17]}function checkFullData(data){if(!data[18])throw new Error('Missing extra locale data for the locale "'+data[0]+'". Use "registerLocaleData" to load new data. See the "I18n guide" on angular.io to know more.')}function getLocaleExtraDayPeriodRules(locale){var data=findLocaleData(locale);return checkFullData(data),(data[18][2]||[]).map(function(rule){return"string"==typeof rule?extractTime(rule):[extractTime(rule[0]),extractTime(rule[1])]})}function getLocaleExtraDayPeriods(locale,formStyle,width){var data=findLocaleData(locale);return checkFullData(data),getLastDefinedValue(getLastDefinedValue([data[18][0],data[18][1]],formStyle)||[],width)||[]}function getLastDefinedValue(data,index){for(var i=index;i>-1;i--)if(void 0!==data[i])return data[i];throw new Error("Locale data API: locale data undefined")}function extractTime(time){var _a=time.split(":");return{hours:+_a[0],minutes:+_a[1]}}function findLocaleData(locale){var normalizedLocale=locale.toLowerCase().replace(/_/g,"-"),match=LOCALE_DATA[normalizedLocale];if(match)return match;var parentLocale=normalizedLocale.split("-")[0];if(match=LOCALE_DATA[parentLocale])return match;if("en"===parentLocale)return localeEn;throw new Error('Missing locale data for the locale "'+locale+'".')}function getCurrencySymbol(code,format){var currency=CURRENCIES[code]||[],symbolNarrow=currency[1];return"narrow"===format&&"string"==typeof symbolNarrow?symbolNarrow:currency[0]||code}function getPluralCategory(value,cases,ngLocalization,locale){var key="="+value;if(cases.indexOf(key)>-1)return key;if(key=ngLocalization.getPluralCategory(value,locale),cases.indexOf(key)>-1)return key;if(cases.indexOf("other")>-1)return"other";throw new Error('No plural message found for value "'+value+'"')}function getPluralCase(locale,nLike){"string"==typeof nLike&&(nLike=parseInt(nLike,10));var n=nLike,nDecimal=n.toString().replace(/^[^.]*\.?/,""),i=Math.floor(Math.abs(n)),v=nDecimal.length,f=parseInt(nDecimal,10),t=parseInt(n.toString().replace(/^[^.]*\.?|0+$/g,""),10)||0;switch(locale.split("-")[0].toLowerCase()){case"af":case"asa":case"az":case"bem":case"bez":case"bg":case"brx":case"ce":case"cgg":case"chr":case"ckb":case"ee":case"el":case"eo":case"es":case"eu":case"fo":case"fur":case"gsw":case"ha":case"haw":case"hu":case"jgo":case"jmc":case"ka":case"kk":case"kkj":case"kl":case"ks":case"ksb":case"ky":case"lb":case"lg":case"mas":case"mgo":case"ml":case"mn":case"nb":case"nd":case"ne":case"nn":case"nnh":case"nyn":case"om":case"or":case"os":case"ps":case"rm":case"rof":case"rwk":case"saq":case"seh":case"sn":case"so":case"sq":case"ta":case"te":case"teo":case"tk":case"tr":case"ug":case"uz":case"vo":case"vun":case"wae":case"xog":return 1===n?Plural.One:Plural.Other;case"ak":case"ln":case"mg":case"pa":case"ti":return n===Math.floor(n)&&n>=0&&n<=1?Plural.One:Plural.Other;case"am":case"as":case"bn":case"fa":case"gu":case"hi":case"kn":case"mr":case"zu":return 0===i||1===n?Plural.One:Plural.Other;case"ar":return 0===n?Plural.Zero:1===n?Plural.One:2===n?Plural.Two:n%100===Math.floor(n%100)&&n%100>=3&&n%100<=10?Plural.Few:n%100===Math.floor(n%100)&&n%100>=11&&n%100<=99?Plural.Many:Plural.Other;case"ast":case"ca":case"de":case"en":case"et":case"fi":case"fy":case"gl":case"it":case"nl":case"sv":case"sw":case"ur":case"yi":return 1===i&&0===v?Plural.One:Plural.Other;case"be":return n%10==1&&n%100!=11?Plural.One:n%10===Math.floor(n%10)&&n%10>=2&&n%10<=4&&!(n%100>=12&&n%100<=14)?Plural.Few:n%10==0||n%10===Math.floor(n%10)&&n%10>=5&&n%10<=9||n%100===Math.floor(n%100)&&n%100>=11&&n%100<=14?Plural.Many:Plural.Other;case"br":return n%10==1&&n%100!=11&&n%100!=71&&n%100!=91?Plural.One:n%10==2&&n%100!=12&&n%100!=72&&n%100!=92?Plural.Two:n%10===Math.floor(n%10)&&(n%10>=3&&n%10<=4||n%10==9)&&!(n%100>=10&&n%100<=19||n%100>=70&&n%100<=79||n%100>=90&&n%100<=99)?Plural.Few:0!==n&&n%1e6==0?Plural.Many:Plural.Other;case"bs":case"hr":case"sr":return 0===v&&i%10==1&&i%100!=11||f%10==1&&f%100!=11?Plural.One:0===v&&i%10===Math.floor(i%10)&&i%10>=2&&i%10<=4&&!(i%100>=12&&i%100<=14)||f%10===Math.floor(f%10)&&f%10>=2&&f%10<=4&&!(f%100>=12&&f%100<=14)?Plural.Few:Plural.Other;case"cs":case"sk":return 1===i&&0===v?Plural.One:i===Math.floor(i)&&i>=2&&i<=4&&0===v?Plural.Few:0!==v?Plural.Many:Plural.Other;case"cy":return 0===n?Plural.Zero:1===n?Plural.One:2===n?Plural.Two:3===n?Plural.Few:6===n?Plural.Many:Plural.Other;case"da":return 1===n||0!==t&&(0===i||1===i)?Plural.One:Plural.Other;case"dsb":case"hsb":return 0===v&&i%100==1||f%100==1?Plural.One:0===v&&i%100==2||f%100==2?Plural.Two:0===v&&i%100===Math.floor(i%100)&&i%100>=3&&i%100<=4||f%100===Math.floor(f%100)&&f%100>=3&&f%100<=4?Plural.Few:Plural.Other;case"ff":case"fr":case"hy":case"kab":return 0===i||1===i?Plural.One:Plural.Other;case"fil":return 0===v&&(1===i||2===i||3===i)||0===v&&i%10!=4&&i%10!=6&&i%10!=9||0!==v&&f%10!=4&&f%10!=6&&f%10!=9?Plural.One:Plural.Other;case"ga":return 1===n?Plural.One:2===n?Plural.Two:n===Math.floor(n)&&n>=3&&n<=6?Plural.Few:n===Math.floor(n)&&n>=7&&n<=10?Plural.Many:Plural.Other;case"gd":return 1===n||11===n?Plural.One:2===n||12===n?Plural.Two:n===Math.floor(n)&&(n>=3&&n<=10||n>=13&&n<=19)?Plural.Few:Plural.Other;case"gv":return 0===v&&i%10==1?Plural.One:0===v&&i%10==2?Plural.Two:0!==v||i%100!=0&&i%100!=20&&i%100!=40&&i%100!=60&&i%100!=80?0!==v?Plural.Many:Plural.Other:Plural.Few;case"he":return 1===i&&0===v?Plural.One:2===i&&0===v?Plural.Two:0!==v||n>=0&&n<=10||n%10!=0?Plural.Other:Plural.Many;case"is":return 0===t&&i%10==1&&i%100!=11||0!==t?Plural.One:Plural.Other;case"ksh":return 0===n?Plural.Zero:1===n?Plural.One:Plural.Other;case"kw":case"naq":case"se":case"smn":return 1===n?Plural.One:2===n?Plural.Two:Plural.Other;case"lag":return 0===n?Plural.Zero:0!==i&&1!==i||0===n?Plural.Other:Plural.One;case"lt":return n%10!=1||n%100>=11&&n%100<=19?n%10===Math.floor(n%10)&&n%10>=2&&n%10<=9&&!(n%100>=11&&n%100<=19)?Plural.Few:0!==f?Plural.Many:Plural.Other:Plural.One;case"lv":case"prg":return n%10==0||n%100===Math.floor(n%100)&&n%100>=11&&n%100<=19||2===v&&f%100===Math.floor(f%100)&&f%100>=11&&f%100<=19?Plural.Zero:n%10==1&&n%100!=11||2===v&&f%10==1&&f%100!=11||2!==v&&f%10==1?Plural.One:Plural.Other;case"mk":return 0===v&&i%10==1||f%10==1?Plural.One:Plural.Other;case"mt":return 1===n?Plural.One:0===n||n%100===Math.floor(n%100)&&n%100>=2&&n%100<=10?Plural.Few:n%100===Math.floor(n%100)&&n%100>=11&&n%100<=19?Plural.Many:Plural.Other;case"pl":return 1===i&&0===v?Plural.One:0===v&&i%10===Math.floor(i%10)&&i%10>=2&&i%10<=4&&!(i%100>=12&&i%100<=14)?Plural.Few:0===v&&1!==i&&i%10===Math.floor(i%10)&&i%10>=0&&i%10<=1||0===v&&i%10===Math.floor(i%10)&&i%10>=5&&i%10<=9||0===v&&i%100===Math.floor(i%100)&&i%100>=12&&i%100<=14?Plural.Many:Plural.Other;case"pt":return n===Math.floor(n)&&n>=0&&n<=2&&2!==n?Plural.One:Plural.Other;case"ro":return 1===i&&0===v?Plural.One:0!==v||0===n||1!==n&&n%100===Math.floor(n%100)&&n%100>=1&&n%100<=19?Plural.Few:Plural.Other;case"ru":case"uk":return 0===v&&i%10==1&&i%100!=11?Plural.One:0===v&&i%10===Math.floor(i%10)&&i%10>=2&&i%10<=4&&!(i%100>=12&&i%100<=14)?Plural.Few:0===v&&i%10==0||0===v&&i%10===Math.floor(i%10)&&i%10>=5&&i%10<=9||0===v&&i%100===Math.floor(i%100)&&i%100>=11&&i%100<=14?Plural.Many:Plural.Other;case"shi":return 0===i||1===n?Plural.One:n===Math.floor(n)&&n>=2&&n<=10?Plural.Few:Plural.Other;case"si":return 0===n||1===n||0===i&&1===f?Plural.One:Plural.Other;case"sl":return 0===v&&i%100==1?Plural.One:0===v&&i%100==2?Plural.Two:0===v&&i%100===Math.floor(i%100)&&i%100>=3&&i%100<=4||0!==v?Plural.Few:Plural.Other;case"tzm":return n===Math.floor(n)&&n>=0&&n<=1||n===Math.floor(n)&&n>=11&&n<=99?Plural.One:Plural.Other;default:return Plural.Other}}/**
 * @license
 * Copyright Google Inc. All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
function parseCookieValue(cookieStr,name){name=encodeURIComponent(name);for(var _i=0,_a=cookieStr.split(";");_i<_a.length;_i++){var cookie=_a[_i],eqIndex=cookie.indexOf("="),_b=-1==eqIndex?[cookie,""]:[cookie.slice(0,eqIndex),cookie.slice(eqIndex+1)],cookieName=_b[0],cookieValue=_b[1];if(cookieName.trim()===name)return decodeURIComponent(cookieValue)}return null}function getTypeNameForDebugging(type){return type.name||typeof type}function formatDate(date,format,locale,timezone){format=getNamedFormat(locale,format)||format;for(var match,parts=[];format;){if(!(match=DATE_FORMATS_SPLIT.exec(format))){parts.push(format);break}parts=parts.concat(match.slice(1));var part=parts.pop();if(!part)break;format=part}var dateTimezoneOffset=date.getTimezoneOffset();timezone&&(dateTimezoneOffset=timezoneToOffset(timezone,dateTimezoneOffset),date=convertTimezoneToLocal(date,timezone,!0));var text="";return parts.forEach(function(value){var dateFormatter=getDateFormatter(value);text+=dateFormatter?dateFormatter(date,locale,dateTimezoneOffset):"''"===value?"'":value.replace(/(^'|'$)/g,"").replace(/''/g,"'")}),text}function getNamedFormat(locale,format){var localeId=getLocaleId(locale);if(NAMED_FORMATS[localeId]=NAMED_FORMATS[localeId]||{},NAMED_FORMATS[localeId][format])return NAMED_FORMATS[localeId][format];var formatValue="";switch(format){case"shortDate":formatValue=getLocaleDateFormat(locale,FormatWidth.Short);break;case"mediumDate":formatValue=getLocaleDateFormat(locale,FormatWidth.Medium);break;case"longDate":formatValue=getLocaleDateFormat(locale,FormatWidth.Long);break;case"fullDate":formatValue=getLocaleDateFormat(locale,FormatWidth.Full);break;case"shortTime":formatValue=getLocaleTimeFormat(locale,FormatWidth.Short);break;case"mediumTime":formatValue=getLocaleTimeFormat(locale,FormatWidth.Medium);break;case"longTime":formatValue=getLocaleTimeFormat(locale,FormatWidth.Long);break;case"fullTime":formatValue=getLocaleTimeFormat(locale,FormatWidth.Full);break;case"short":var shortTime=getNamedFormat(locale,"shortTime"),shortDate=getNamedFormat(locale,"shortDate");formatValue=formatDateTime(getLocaleDateTimeFormat(locale,FormatWidth.Short),[shortTime,shortDate]);break;case"medium":var mediumTime=getNamedFormat(locale,"mediumTime"),mediumDate=getNamedFormat(locale,"mediumDate");formatValue=formatDateTime(getLocaleDateTimeFormat(locale,FormatWidth.Medium),[mediumTime,mediumDate]);break;case"long":var longTime=getNamedFormat(locale,"longTime"),longDate=getNamedFormat(locale,"longDate");formatValue=formatDateTime(getLocaleDateTimeFormat(locale,FormatWidth.Long),[longTime,longDate]);break;case"full":var fullTime=getNamedFormat(locale,"fullTime"),fullDate=getNamedFormat(locale,"fullDate");formatValue=formatDateTime(getLocaleDateTimeFormat(locale,FormatWidth.Full),[fullTime,fullDate])}return formatValue&&(NAMED_FORMATS[localeId][format]=formatValue),formatValue}function formatDateTime(str,opt_values){return opt_values&&(str=str.replace(/\{([^}]+)}/g,function(match,key){return null!=opt_values&&key in opt_values?opt_values[key]:match})),str}function padNumber(num,digits,minusSign,trim,negWrap){void 0===minusSign&&(minusSign="-");var neg="";(num<0||negWrap&&num<=0)&&(negWrap?num=1-num:(num=-num,neg=minusSign));for(var strNum=""+num;strNum.length<digits;)strNum="0"+strNum;return trim&&(strNum=strNum.substr(strNum.length-digits)),neg+strNum}function dateGetter(name,size,offset,trim,negWrap){return void 0===offset&&(offset=0),void 0===trim&&(trim=!1),void 0===negWrap&&(negWrap=!1),function(date,locale){var part=getDatePart(name,date,size);return(offset>0||part>-offset)&&(part+=offset),name===DateType.Hours&&0===part&&-12===offset&&(part=12),padNumber(part,size,getLocaleNumberSymbol(locale,NumberSymbol.MinusSign),trim,negWrap)}}function getDatePart(name,date,size){switch(name){case DateType.FullYear:return date.getFullYear();case DateType.Month:return date.getMonth();case DateType.Date:return date.getDate();case DateType.Hours:return date.getHours();case DateType.Minutes:return date.getMinutes();case DateType.Seconds:return date.getSeconds();case DateType.Milliseconds:var div=1===size?100:2===size?10:1;return Math.round(date.getMilliseconds()/div);case DateType.Day:return date.getDay();default:throw new Error('Unknown DateType value "'+name+'".')}}function dateStrGetter(name,width,form,extended){return void 0===form&&(form=FormStyle.Format),void 0===extended&&(extended=!1),function(date,locale){return getDateTranslation(date,locale,name,width,form,extended)}}function getDateTranslation(date,locale,name,width,form,extended){switch(name){case TranslationType.Months:return getLocaleMonthNames(locale,form,width)[date.getMonth()];case TranslationType.Days:return getLocaleDayNames(locale,form,width)[date.getDay()];case TranslationType.DayPeriods:var currentHours_1=date.getHours(),currentMinutes_1=date.getMinutes();if(extended){var result_1,rules=getLocaleExtraDayPeriodRules(locale),dayPeriods_1=getLocaleExtraDayPeriods(locale,form,width);if(rules.forEach(function(rule,index){if(Array.isArray(rule)){var _a=rule[0],hoursFrom=_a.hours,minutesFrom=_a.minutes,_b=rule[1],hoursTo=_b.hours,minutesTo=_b.minutes;currentHours_1>=hoursFrom&&currentMinutes_1>=minutesFrom&&(currentHours_1<hoursTo||currentHours_1===hoursTo&&currentMinutes_1<minutesTo)&&(result_1=dayPeriods_1[index])}else{var hours=rule.hours,minutes=rule.minutes;hours===currentHours_1&&minutes===currentMinutes_1&&(result_1=dayPeriods_1[index])}}),result_1)return result_1}return getLocaleDayPeriods(locale,form,width)[currentHours_1<12?0:1];case TranslationType.Eras:return getLocaleEraNames(locale,width)[date.getFullYear()<=0?0:1];default:var unexpected=name;throw new Error("unexpected translation type "+unexpected)}}function timeZoneGetter(width){return function(date,locale,offset){var zone=-1*offset,minusSign=getLocaleNumberSymbol(locale,NumberSymbol.MinusSign),hours=zone>0?Math.floor(zone/60):Math.ceil(zone/60);switch(width){case ZoneWidth.Short:return(zone>=0?"+":"")+padNumber(hours,2,minusSign)+padNumber(Math.abs(zone%60),2,minusSign);case ZoneWidth.ShortGMT:return"GMT"+(zone>=0?"+":"")+padNumber(hours,1,minusSign);case ZoneWidth.Long:return"GMT"+(zone>=0?"+":"")+padNumber(hours,2,minusSign)+":"+padNumber(Math.abs(zone%60),2,minusSign);case ZoneWidth.Extended:return 0===offset?"Z":(zone>=0?"+":"")+padNumber(hours,2,minusSign)+":"+padNumber(Math.abs(zone%60),2,minusSign);default:throw new Error('Unknown zone width "'+width+'"')}}}function getFirstThursdayOfYear(year){var firstDayOfYear=new Date(year,JANUARY,1).getDay();return new Date(year,0,1+(firstDayOfYear<=THURSDAY?THURSDAY:THURSDAY+7)-firstDayOfYear)}function getThursdayThisWeek(datetime){return new Date(datetime.getFullYear(),datetime.getMonth(),datetime.getDate()+(THURSDAY-datetime.getDay()))}function weekGetter(size,monthBased){return void 0===monthBased&&(monthBased=!1),function(date,locale){var result;if(monthBased){var nbDaysBefore1stDayOfMonth=new Date(date.getFullYear(),date.getMonth(),1).getDay()-1,today=date.getDate();result=1+Math.floor((today+nbDaysBefore1stDayOfMonth)/7)}else{var firstThurs=getFirstThursdayOfYear(date.getFullYear()),thisThurs=getThursdayThisWeek(date),diff=thisThurs.getTime()-firstThurs.getTime();result=1+Math.round(diff/6048e5)}return padNumber(result,size,getLocaleNumberSymbol(locale,NumberSymbol.MinusSign))}}function getDateFormatter(format){if(DATE_FORMATS[format])return DATE_FORMATS[format];var formatter;switch(format){case"G":case"GG":case"GGG":formatter=dateStrGetter(TranslationType.Eras,TranslationWidth.Abbreviated);break;case"GGGG":formatter=dateStrGetter(TranslationType.Eras,TranslationWidth.Wide);break;case"GGGGG":formatter=dateStrGetter(TranslationType.Eras,TranslationWidth.Narrow);break;case"y":formatter=dateGetter(DateType.FullYear,1,0,!1,!0);break;case"yy":formatter=dateGetter(DateType.FullYear,2,0,!0,!0);break;case"yyy":formatter=dateGetter(DateType.FullYear,3,0,!1,!0);break;case"yyyy":formatter=dateGetter(DateType.FullYear,4,0,!1,!0);break;case"M":case"L":formatter=dateGetter(DateType.Month,1,1);break;case"MM":case"LL":formatter=dateGetter(DateType.Month,2,1);break;case"MMM":formatter=dateStrGetter(TranslationType.Months,TranslationWidth.Abbreviated);break;case"MMMM":formatter=dateStrGetter(TranslationType.Months,TranslationWidth.Wide);break;case"MMMMM":formatter=dateStrGetter(TranslationType.Months,TranslationWidth.Narrow);break;case"LLL":formatter=dateStrGetter(TranslationType.Months,TranslationWidth.Abbreviated,FormStyle.Standalone);break;case"LLLL":formatter=dateStrGetter(TranslationType.Months,TranslationWidth.Wide,FormStyle.Standalone);break;case"LLLLL":formatter=dateStrGetter(TranslationType.Months,TranslationWidth.Narrow,FormStyle.Standalone);break;case"w":formatter=weekGetter(1);break;case"ww":formatter=weekGetter(2);break;case"W":formatter=weekGetter(1,!0);break;case"d":formatter=dateGetter(DateType.Date,1);break;case"dd":formatter=dateGetter(DateType.Date,2);break;case"E":case"EE":case"EEE":formatter=dateStrGetter(TranslationType.Days,TranslationWidth.Abbreviated);break;case"EEEE":formatter=dateStrGetter(TranslationType.Days,TranslationWidth.Wide);break;case"EEEEE":formatter=dateStrGetter(TranslationType.Days,TranslationWidth.Narrow);break;case"EEEEEE":formatter=dateStrGetter(TranslationType.Days,TranslationWidth.Short);break;case"a":case"aa":case"aaa":formatter=dateStrGetter(TranslationType.DayPeriods,TranslationWidth.Abbreviated);break;case"aaaa":formatter=dateStrGetter(TranslationType.DayPeriods,TranslationWidth.Wide);break;case"aaaaa":formatter=dateStrGetter(TranslationType.DayPeriods,TranslationWidth.Narrow);break;case"b":case"bb":case"bbb":formatter=dateStrGetter(TranslationType.DayPeriods,TranslationWidth.Abbreviated,FormStyle.Standalone,!0);break;case"bbbb":formatter=dateStrGetter(TranslationType.DayPeriods,TranslationWidth.Wide,FormStyle.Standalone,!0);break;case"bbbbb":formatter=dateStrGetter(TranslationType.DayPeriods,TranslationWidth.Narrow,FormStyle.Standalone,!0);break;case"B":case"BB":case"BBB":formatter=dateStrGetter(TranslationType.DayPeriods,TranslationWidth.Abbreviated,FormStyle.Format,!0);break;case"BBBB":formatter=dateStrGetter(TranslationType.DayPeriods,TranslationWidth.Wide,FormStyle.Format,!0);break;case"BBBBB":formatter=dateStrGetter(TranslationType.DayPeriods,TranslationWidth.Narrow,FormStyle.Format,!0);break;case"h":formatter=dateGetter(DateType.Hours,1,-12);break;case"hh":formatter=dateGetter(DateType.Hours,2,-12);break;case"H":formatter=dateGetter(DateType.Hours,1);break;case"HH":formatter=dateGetter(DateType.Hours,2);break;case"m":formatter=dateGetter(DateType.Minutes,1);break;case"mm":formatter=dateGetter(DateType.Minutes,2);break;case"s":formatter=dateGetter(DateType.Seconds,1);break;case"ss":formatter=dateGetter(DateType.Seconds,2);break;case"S":formatter=dateGetter(DateType.Milliseconds,1);break;case"SS":formatter=dateGetter(DateType.Milliseconds,2);break;case"SSS":formatter=dateGetter(DateType.Milliseconds,3);break;case"Z":case"ZZ":case"ZZZ":formatter=timeZoneGetter(ZoneWidth.Short);break;case"ZZZZZ":formatter=timeZoneGetter(ZoneWidth.Extended);break;case"O":case"OO":case"OOO":case"z":case"zz":case"zzz":formatter=timeZoneGetter(ZoneWidth.ShortGMT);break;case"OOOO":case"ZZZZ":case"zzzz":formatter=timeZoneGetter(ZoneWidth.Long);break;default:return null}return DATE_FORMATS[format]=formatter,formatter}function timezoneToOffset(timezone,fallback){timezone=timezone.replace(/:/g,"");var requestedTimezoneOffset=Date.parse("Jan 01, 1970 00:00:00 "+timezone)/6e4;return isNaN(requestedTimezoneOffset)?fallback:requestedTimezoneOffset}function addDateMinutes(date,minutes){return date=new Date(date.getTime()),date.setMinutes(date.getMinutes()+minutes),date}function convertTimezoneToLocal(date,timezone,reverse){var reverseValue=reverse?-1:1,dateTimezoneOffset=date.getTimezoneOffset();return addDateMinutes(date,reverseValue*(timezoneToOffset(timezone,dateTimezoneOffset)-dateTimezoneOffset))}/**
 * @license
 * Copyright Google Inc. All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
function invalidPipeArgumentError(type,value){return Error("InvalidPipeArgument: '"+value+"' for pipe '"+_angular_core.ɵstringify(type)+"'")}function isoStringToDate(match){var date=new Date(0),tzHour=0,tzMin=0,dateSetter=match[8]?date.setUTCFullYear:date.setFullYear,timeSetter=match[8]?date.setUTCHours:date.setHours;match[9]&&(tzHour=+(match[9]+match[10]),tzMin=+(match[9]+match[11])),dateSetter.call(date,+match[1],+match[2]-1,+match[3]);var h=+(match[4]||"0")-tzHour,m=+(match[5]||"0")-tzMin,s=+(match[6]||"0"),ms=Math.round(1e3*parseFloat("0."+(match[7]||0)));return timeSetter.call(date,h,m,s,ms),date}function isDate$1(value){return value instanceof Date&&!isNaN(value.valueOf())}function digitModifier(inner){return function(date,locale){var result=inner(date,locale);return 1==result.length?"0"+result:result}}function hourExtractor(inner){return function(date,locale){return inner(date,locale).split(" ")[0]}}function intlDateFormat(date,locale,options){return new Intl.DateTimeFormat(locale,options).format(date).replace(/[\u200e\u200f]/g,"")}function timeZoneGetter$1(timezone){var options={hour:"2-digit",hour12:!1,timeZoneName:timezone};return function(date,locale){var result=intlDateFormat(date,locale,options);return result?result.substring(3):""}}function hour12Modify(options,value){return options.hour12=value,options}function digitCondition(prop,len){var result={};return result[prop]=2===len?"2-digit":"numeric",result}function nameCondition(prop,len){var result={};return result[prop]=len<4?len>1?"short":"narrow":"long",result}function combine(options){return options.reduce(function(merged,opt){return __assign({},merged,opt)},{})}function datePartGetterFactory(ret){return function(date,locale){return intlDateFormat(date,locale,ret)}}function dateFormatter(format,date,locale){var fn=PATTERN_ALIASES[format];if(fn)return fn(date,locale);var cacheKey=format,parts=DATE_FORMATTER_CACHE.get(cacheKey);if(!parts){parts=[];var match=void 0;DATE_FORMATS_SPLIT$1.exec(format);for(var _format=format;_format;)match=DATE_FORMATS_SPLIT$1.exec(_format),match?(parts=parts.concat(match.slice(1)),_format=parts.pop()):(parts.push(_format),_format=null);DATE_FORMATTER_CACHE.set(cacheKey,parts)}return parts.reduce(function(text,part){var fn=DATE_FORMATS$1[part];return text+(fn?fn(date,locale):partToTime(part))},"")}function partToTime(part){return"''"===part?"'":part.replace(/(^'|'$)/g,"").replace(/''/g,"'")}function isDate(value){return value instanceof Date&&!isNaN(value.valueOf())}function formatNumber$1(value,locale,style,digitsInfo,currency){void 0===currency&&(currency=null);var num,res={str:null},format=getLocaleNumberFormat(locale,style);if("string"!=typeof value||isNaN(+value-parseFloat(value))){if("number"!=typeof value)return res.error=value+" is not a number",res;num=value}else num=+value;var pattern=parseNumberFormat(format,getLocaleNumberSymbol(locale,NumberSymbol.MinusSign)),formattedText="",isZero=!1;if(isFinite(num)){var parsedNumber=parseNumber(num);style===NumberFormatStyle.Percent&&(parsedNumber=toPercent(parsedNumber));var minInt=pattern.minInt,minFraction=pattern.minFrac,maxFraction=pattern.maxFrac;if(digitsInfo){var parts=digitsInfo.match(NUMBER_FORMAT_REGEXP);if(null===parts)return res.error=digitsInfo+" is not a valid digit info",res;var minIntPart=parts[1],minFractionPart=parts[3],maxFractionPart=parts[5];null!=minIntPart&&(minInt=parseIntAutoRadix(minIntPart)),null!=minFractionPart&&(minFraction=parseIntAutoRadix(minFractionPart)),null!=maxFractionPart?maxFraction=parseIntAutoRadix(maxFractionPart):null!=minFractionPart&&minFraction>maxFraction&&(maxFraction=minFraction)}roundNumber(parsedNumber,minFraction,maxFraction);var digits=parsedNumber.digits,integerLen=parsedNumber.integerLen,exponent=parsedNumber.exponent,decimals=[];for(isZero=digits.every(function(d){return!d});integerLen<minInt;integerLen++)digits.unshift(0);for(;integerLen<0;integerLen++)digits.unshift(0);integerLen>0?decimals=digits.splice(integerLen,digits.length):(decimals=digits,digits=[0]);var groups=[];for(digits.length>=pattern.lgSize&&groups.unshift(digits.splice(-pattern.lgSize,digits.length).join(""));digits.length>pattern.gSize;)groups.unshift(digits.splice(-pattern.gSize,digits.length).join(""));digits.length&&groups.unshift(digits.join(""));var groupSymbol=currency?NumberSymbol.CurrencyGroup:NumberSymbol.Group;if(formattedText=groups.join(getLocaleNumberSymbol(locale,groupSymbol)),decimals.length){formattedText+=getLocaleNumberSymbol(locale,currency?NumberSymbol.CurrencyDecimal:NumberSymbol.Decimal)+decimals.join("")}exponent&&(formattedText+=getLocaleNumberSymbol(locale,NumberSymbol.Exponential)+"+"+exponent)}else formattedText=getLocaleNumberSymbol(locale,NumberSymbol.Infinity);return formattedText=num<0&&!isZero?pattern.negPre+formattedText+pattern.negSuf:pattern.posPre+formattedText+pattern.posSuf,style===NumberFormatStyle.Currency&&null!==currency?(res.str=formattedText.replace(CURRENCY_CHAR,currency).replace(CURRENCY_CHAR,""),res):style===NumberFormatStyle.Percent?(res.str=formattedText.replace(new RegExp(PERCENT_CHAR,"g"),getLocaleNumberSymbol(locale,NumberSymbol.PercentSign)),res):(res.str=formattedText,res)}function parseNumberFormat(format,minusSign){void 0===minusSign&&(minusSign="-");var p={minInt:1,minFrac:0,maxFrac:0,posPre:"",posSuf:"",negPre:"",negSuf:"",gSize:0,lgSize:0},patternParts=format.split(PATTERN_SEP),positive=patternParts[0],negative=patternParts[1],positiveParts=-1!==positive.indexOf(DECIMAL_SEP)?positive.split(DECIMAL_SEP):[positive.substring(0,positive.lastIndexOf(ZERO_CHAR)+1),positive.substring(positive.lastIndexOf(ZERO_CHAR)+1)],integer=positiveParts[0],fraction=positiveParts[1]||"";p.posPre=integer.substr(0,integer.indexOf(DIGIT_CHAR));for(var i=0;i<fraction.length;i++){var ch=fraction.charAt(i);ch===ZERO_CHAR?p.minFrac=p.maxFrac=i+1:ch===DIGIT_CHAR?p.maxFrac=i+1:p.posSuf+=ch}var groups=integer.split(GROUP_SEP);if(p.gSize=groups[1]?groups[1].length:0,p.lgSize=groups[2]||groups[1]?(groups[2]||groups[1]).length:0,negative){var trunkLen=positive.length-p.posPre.length-p.posSuf.length,pos=negative.indexOf(DIGIT_CHAR);p.negPre=negative.substr(0,pos).replace(/'/g,""),p.negSuf=negative.substr(pos+trunkLen).replace(/'/g,"")}else p.negPre=minusSign+p.posPre,p.negSuf=p.posSuf;return p}function toPercent(parsedNumber){if(0===parsedNumber.digits[0])return parsedNumber;var fractionLen=parsedNumber.digits.length-parsedNumber.integerLen;return parsedNumber.exponent?parsedNumber.exponent+=2:(0===fractionLen?parsedNumber.digits.push(0,0):1===fractionLen&&parsedNumber.digits.push(0),parsedNumber.integerLen+=2),parsedNumber}function parseNumber(num){var digits,integerLen,i,j,zeros,numStr=Math.abs(num)+"",exponent=0;for((integerLen=numStr.indexOf(DECIMAL_SEP))>-1&&(numStr=numStr.replace(DECIMAL_SEP,"")),(i=numStr.search(/e/i))>0?(integerLen<0&&(integerLen=i),integerLen+=+numStr.slice(i+1),numStr=numStr.substring(0,i)):integerLen<0&&(integerLen=numStr.length),i=0;numStr.charAt(i)===ZERO_CHAR;i++);if(i===(zeros=numStr.length))digits=[0],integerLen=1;else{for(zeros--;numStr.charAt(zeros)===ZERO_CHAR;)zeros--;for(integerLen-=i,digits=[],j=0;i<=zeros;i++,j++)digits[j]=+numStr.charAt(i)}return integerLen>MAX_DIGITS&&(digits=digits.splice(0,MAX_DIGITS-1),exponent=integerLen-1,integerLen=1),{digits:digits,exponent:exponent,integerLen:integerLen}}function roundNumber(parsedNumber,minFrac,maxFrac){if(minFrac>maxFrac)throw new Error("The minimum number of digits after fraction ("+minFrac+") is higher than the maximum ("+maxFrac+").");var digits=parsedNumber.digits,fractionLen=digits.length-parsedNumber.integerLen,fractionSize=Math.min(Math.max(minFrac,fractionLen),maxFrac),roundAt=fractionSize+parsedNumber.integerLen,digit=digits[roundAt];if(roundAt>0){digits.splice(Math.max(parsedNumber.integerLen,roundAt));for(var j=roundAt;j<digits.length;j++)digits[j]=0}else{fractionLen=Math.max(0,fractionLen),parsedNumber.integerLen=1,digits.length=Math.max(1,roundAt=fractionSize+1),digits[0]=0;for(var i=1;i<roundAt;i++)digits[i]=0}if(digit>=5)if(roundAt-1<0){for(var k=0;k>roundAt;k--)digits.unshift(0),parsedNumber.integerLen++;digits.unshift(1),parsedNumber.integerLen++}else digits[roundAt-1]++;for(;fractionLen<Math.max(0,fractionSize);fractionLen++)digits.push(0);var dropTrailingZeros=0!==fractionSize,minLen=minFrac+parsedNumber.integerLen,carry=digits.reduceRight(function(carry,d,i,digits){return d+=carry,digits[i]=d<10?d:d-10,dropTrailingZeros&&(0===digits[i]&&i>=minLen?digits.pop():dropTrailingZeros=!1),d>=10?1:0},0);carry&&(digits.unshift(carry),parsedNumber.integerLen++)}function parseIntAutoRadix(text){var result=parseInt(text);if(isNaN(result))throw new Error("Invalid integer literal when parsing "+text);return result}/**
 * @license
 * Copyright Google Inc. All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
function formatNumber(pipe,locale,value,style,digits,currency,currencyAsSymbol){if(void 0===currency&&(currency=null),void 0===currencyAsSymbol&&(currencyAsSymbol=!1),null==value)return null;if("number"!=typeof(value="string"!=typeof value||isNaN(+value-parseFloat(value))?value:+value))throw invalidPipeArgumentError(pipe,value);var minInt,minFraction,maxFraction;if(style!==NumberFormatStyle.Currency&&(minInt=1,minFraction=0,maxFraction=3),digits){var parts=digits.match(NUMBER_FORMAT_REGEXP);if(null===parts)throw new Error(digits+" is not a valid digit info for number pipes");null!=parts[1]&&(minInt=parseIntAutoRadix(parts[1])),null!=parts[3]&&(minFraction=parseIntAutoRadix(parts[3])),null!=parts[5]&&(maxFraction=parseIntAutoRadix(parts[5]))}return NumberFormatter.format(value,locale,style,{minimumIntegerDigits:minInt,minimumFractionDigits:minFraction,maximumFractionDigits:maxFraction,currency:currency,currencyAsSymbol:currencyAsSymbol})}function titleCaseWord(word){return word?word[0].toUpperCase()+word.substr(1).toLowerCase():word}function isEmpty(value){return null==value||""===value||value!==value}function isPlatformBrowser(platformId){return platformId===PLATFORM_BROWSER_ID}function isPlatformServer(platformId){return platformId===PLATFORM_SERVER_ID}function isPlatformWorkerApp(platformId){return platformId===PLATFORM_WORKER_APP_ID}function isPlatformWorkerUi(platformId){return platformId===PLATFORM_WORKER_UI_ID}var extendStatics=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(d,b){d.__proto__=b}||function(d,b){for(var p in b)b.hasOwnProperty(p)&&(d[p]=b[p])},__assign=Object.assign||function(t){for(var s,i=1,n=arguments.length;i<n;i++){s=arguments[i];for(var p in s)Object.prototype.hasOwnProperty.call(s,p)&&(t[p]=s[p])}return t},PlatformLocation=function(){function PlatformLocation(){}return PlatformLocation}(),LOCATION_INITIALIZED=new _angular_core.InjectionToken("Location Initialized"),LocationStrategy=function(){function LocationStrategy(){}return LocationStrategy}(),APP_BASE_HREF=new _angular_core.InjectionToken("appBaseHref"),Location=function(){function Location(platformStrategy){var _this=this;this._subject=new _angular_core.EventEmitter,this._platformStrategy=platformStrategy;var browserBaseHref=this._platformStrategy.getBaseHref();this._baseHref=Location.stripTrailingSlash(_stripIndexHtml(browserBaseHref)),this._platformStrategy.onPopState(function(ev){_this._subject.emit({url:_this.path(!0),pop:!0,type:ev.type})})}return Location.prototype.path=function(includeHash){return void 0===includeHash&&(includeHash=!1),this.normalize(this._platformStrategy.path(includeHash))},Location.prototype.isCurrentPathEqualTo=function(path,query){return void 0===query&&(query=""),this.path()==this.normalize(path+Location.normalizeQueryParams(query))},Location.prototype.normalize=function(url){return Location.stripTrailingSlash(_stripBaseHref(this._baseHref,_stripIndexHtml(url)))},Location.prototype.prepareExternalUrl=function(url){return url&&"/"!==url[0]&&(url="/"+url),this._platformStrategy.prepareExternalUrl(url)},Location.prototype.go=function(path,query){void 0===query&&(query=""),this._platformStrategy.pushState(null,"",path,query)},Location.prototype.replaceState=function(path,query){void 0===query&&(query=""),this._platformStrategy.replaceState(null,"",path,query)},Location.prototype.forward=function(){this._platformStrategy.forward()},Location.prototype.back=function(){this._platformStrategy.back()},Location.prototype.subscribe=function(onNext,onThrow,onReturn){return this._subject.subscribe({next:onNext,error:onThrow,complete:onReturn})},Location.normalizeQueryParams=function(params){return params&&"?"!==params[0]?"?"+params:params},Location.joinWithSlash=function(start,end){if(0==start.length)return end;if(0==end.length)return start;var slashes=0;return start.endsWith("/")&&slashes++,end.startsWith("/")&&slashes++,2==slashes?start+end.substring(1):1==slashes?start+end:start+"/"+end},Location.stripTrailingSlash=function(url){var match=url.match(/#|\?|$/),pathEndIdx=match&&match.index||url.length,droppedSlashIdx=pathEndIdx-("/"===url[pathEndIdx-1]?1:0);return url.slice(0,droppedSlashIdx)+url.slice(pathEndIdx)},Location.decorators=[{type:_angular_core.Injectable}],Location.ctorParameters=function(){return[{type:LocationStrategy}]},Location}(),HashLocationStrategy=function(_super){function HashLocationStrategy(_platformLocation,_baseHref){var _this=_super.call(this)||this;return _this._platformLocation=_platformLocation,_this._baseHref="",null!=_baseHref&&(_this._baseHref=_baseHref),_this}return __extends(HashLocationStrategy,_super),HashLocationStrategy.prototype.onPopState=function(fn){this._platformLocation.onPopState(fn),this._platformLocation.onHashChange(fn)},HashLocationStrategy.prototype.getBaseHref=function(){return this._baseHref},HashLocationStrategy.prototype.path=function(includeHash){void 0===includeHash&&(includeHash=!1);var path=this._platformLocation.hash;return null==path&&(path="#"),path.length>0?path.substring(1):path},HashLocationStrategy.prototype.prepareExternalUrl=function(internal){var url=Location.joinWithSlash(this._baseHref,internal);return url.length>0?"#"+url:url},HashLocationStrategy.prototype.pushState=function(state,title,path,queryParams){var url=this.prepareExternalUrl(path+Location.normalizeQueryParams(queryParams));0==url.length&&(url=this._platformLocation.pathname),this._platformLocation.pushState(state,title,url)},HashLocationStrategy.prototype.replaceState=function(state,title,path,queryParams){var url=this.prepareExternalUrl(path+Location.normalizeQueryParams(queryParams));0==url.length&&(url=this._platformLocation.pathname),this._platformLocation.replaceState(state,title,url)},HashLocationStrategy.prototype.forward=function(){this._platformLocation.forward()},HashLocationStrategy.prototype.back=function(){this._platformLocation.back()},HashLocationStrategy.decorators=[{type:_angular_core.Injectable}],HashLocationStrategy.ctorParameters=function(){return[{type:PlatformLocation},{type:void 0,decorators:[{type:_angular_core.Optional},{type:_angular_core.Inject,args:[APP_BASE_HREF]}]}]},HashLocationStrategy}(LocationStrategy),PathLocationStrategy=function(_super){function PathLocationStrategy(_platformLocation,href){var _this=_super.call(this)||this;if(_this._platformLocation=_platformLocation,null==href&&(href=_this._platformLocation.getBaseHrefFromDOM()),null==href)throw new Error("No base href set. Please provide a value for the APP_BASE_HREF token or add a base element to the document.");return _this._baseHref=href,_this}return __extends(PathLocationStrategy,_super),PathLocationStrategy.prototype.onPopState=function(fn){this._platformLocation.onPopState(fn),this._platformLocation.onHashChange(fn)},PathLocationStrategy.prototype.getBaseHref=function(){return this._baseHref},PathLocationStrategy.prototype.prepareExternalUrl=function(internal){return Location.joinWithSlash(this._baseHref,internal)},PathLocationStrategy.prototype.path=function(includeHash){void 0===includeHash&&(includeHash=!1);var pathname=this._platformLocation.pathname+Location.normalizeQueryParams(this._platformLocation.search),hash=this._platformLocation.hash;return hash&&includeHash?""+pathname+hash:pathname},PathLocationStrategy.prototype.pushState=function(state,title,url,queryParams){var externalUrl=this.prepareExternalUrl(url+Location.normalizeQueryParams(queryParams));this._platformLocation.pushState(state,title,externalUrl)},PathLocationStrategy.prototype.replaceState=function(state,title,url,queryParams){var externalUrl=this.prepareExternalUrl(url+Location.normalizeQueryParams(queryParams));this._platformLocation.replaceState(state,title,externalUrl)},PathLocationStrategy.prototype.forward=function(){this._platformLocation.forward()},PathLocationStrategy.prototype.back=function(){this._platformLocation.back()},PathLocationStrategy.decorators=[{type:_angular_core.Injectable}],PathLocationStrategy.ctorParameters=function(){return[{type:PlatformLocation},{type:void 0,decorators:[{type:_angular_core.Optional},{type:_angular_core.Inject,args:[APP_BASE_HREF]}]}]},PathLocationStrategy}(LocationStrategy),CURRENCIES={AOA:[,"Kz"],ARS:[,"$"],AUD:["A$","$"],BAM:[,"KM"],BBD:[,"$"],BDT:[,"৳"],BMD:[,"$"],BND:[,"$"],BOB:[,"Bs"],BRL:["R$"],BSD:[,"$"],BWP:[,"P"],BYN:[,"р."],BZD:[,"$"],CAD:["CA$","$"],CLP:[,"$"],CNY:["CN¥","¥"],COP:[,"$"],CRC:[,"₡"],CUC:[,"$"],CUP:[,"$"],CZK:[,"Kč"],DKK:[,"kr"],DOP:[,"$"],EGP:[,"E£"],ESP:[,"₧"],EUR:["€"],FJD:[,"$"],FKP:[,"£"],GBP:["£"],GEL:[,"₾"],GIP:[,"£"],GNF:[,"FG"],GTQ:[,"Q"],GYD:[,"$"],HKD:["HK$","$"],HNL:[,"L"],HRK:[,"kn"],HUF:[,"Ft"],IDR:[,"Rp"],ILS:["₪"],INR:["₹"],ISK:[,"kr"],JMD:[,"$"],JPY:["¥"],KHR:[,"៛"],KMF:[,"CF"],KPW:[,"₩"],KRW:["₩"],KYD:[,"$"],KZT:[,"₸"],LAK:[,"₭"],LBP:[,"L£"],LKR:[,"Rs"],LRD:[,"$"],LTL:[,"Lt"],LVL:[,"Ls"],MGA:[,"Ar"],MMK:[,"K"],MNT:[,"₮"],MUR:[,"Rs"],MXN:["MX$","$"],MYR:[,"RM"],NAD:[,"$"],NGN:[,"₦"],NIO:[,"C$"],NOK:[,"kr"],NPR:[,"Rs"],NZD:["NZ$","$"],PHP:[,"₱"],PKR:[,"Rs"],PLN:[,"zł"],PYG:[,"₲"],RON:[,"lei"],RUB:[,"₽"],RUR:[,"р."],RWF:[,"RF"],SBD:[,"$"],SEK:[,"kr"],SGD:[,"$"],SHP:[,"£"],SRD:[,"$"],SSP:[,"£"],STD:[,"Db"],SYP:[,"£"],THB:[,"฿"],TOP:[,"T$"],TRY:[,"₺"],TTD:[,"$"],TWD:["NT$","$"],UAH:[,"₴"],USD:["$"],UYU:[,"$"],VEF:[,"Bs"],VND:["₫"],XAF:["FCFA"],XCD:["EC$","$"],XOF:["CFA"],XPF:["CFPF"],ZAR:[,"R"],ZMW:[,"ZK"]},localeEn=["en",[["a","p"],["AM","PM"]],[["AM","PM"],,],[["S","M","T","W","T","F","S"],["Sun","Mon","Tue","Wed","Thu","Fri","Sat"],["Sunday","Monday","Tuesday","Wednesday","Thursday","Friday","Saturday"],["Su","Mo","Tu","We","Th","Fr","Sa"]],,[["J","F","M","A","M","J","J","A","S","O","N","D"],["Jan","Feb","Mar","Apr","May","Jun","Jul","Aug","Sep","Oct","Nov","Dec"],["January","February","March","April","May","June","July","August","September","October","November","December"]],,[["B","A"],["BC","AD"],["Before Christ","Anno Domini"]],0,[6,0],["M/d/yy","MMM d, y","MMMM d, y","EEEE, MMMM d, y"],["h:mm a","h:mm:ss a","h:mm:ss a z","h:mm:ss a zzzz"],["{1}, {0}",,"{1} 'at' {0}"],[".",",",";","%","+","-","E","×","‰","∞","NaN",":"],["#,##0.###","#,##0%","¤#,##0.00","#E0"],"$","US Dollar",plural],LOCALE_DATA={},NumberFormatStyle={Decimal:0,Percent:1,Currency:2,Scientific:3};NumberFormatStyle[NumberFormatStyle.Decimal]="Decimal",NumberFormatStyle[NumberFormatStyle.Percent]="Percent",NumberFormatStyle[NumberFormatStyle.Currency]="Currency",NumberFormatStyle[NumberFormatStyle.Scientific]="Scientific";var Plural={Zero:0,One:1,Two:2,Few:3,Many:4,Other:5};Plural[Plural.Zero]="Zero",Plural[Plural.One]="One",Plural[Plural.Two]="Two",Plural[Plural.Few]="Few",Plural[Plural.Many]="Many",Plural[Plural.Other]="Other";var FormStyle={Format:0,Standalone:1};FormStyle[FormStyle.Format]="Format",FormStyle[FormStyle.Standalone]="Standalone";var TranslationWidth={Narrow:0,Abbreviated:1,Wide:2,Short:3};TranslationWidth[TranslationWidth.Narrow]="Narrow",TranslationWidth[TranslationWidth.Abbreviated]="Abbreviated",TranslationWidth[TranslationWidth.Wide]="Wide",TranslationWidth[TranslationWidth.Short]="Short";var FormatWidth={Short:0,Medium:1,Long:2,Full:3};FormatWidth[FormatWidth.Short]="Short",FormatWidth[FormatWidth.Medium]="Medium",FormatWidth[FormatWidth.Long]="Long",FormatWidth[FormatWidth.Full]="Full";var NumberSymbol={Decimal:0,Group:1,List:2,PercentSign:3,PlusSign:4,MinusSign:5,Exponential:6,SuperscriptingExponent:7,PerMille:8,Infinity:9,NaN:10,TimeSeparator:11,CurrencyDecimal:12,CurrencyGroup:13};NumberSymbol[NumberSymbol.Decimal]="Decimal",NumberSymbol[NumberSymbol.Group]="Group",NumberSymbol[NumberSymbol.List]="List",NumberSymbol[NumberSymbol.PercentSign]="PercentSign",NumberSymbol[NumberSymbol.PlusSign]="PlusSign",NumberSymbol[NumberSymbol.MinusSign]="MinusSign",NumberSymbol[NumberSymbol.Exponential]="Exponential",NumberSymbol[NumberSymbol.SuperscriptingExponent]="SuperscriptingExponent",NumberSymbol[NumberSymbol.PerMille]="PerMille",NumberSymbol[NumberSymbol.Infinity]="Infinity",NumberSymbol[NumberSymbol.NaN]="NaN",NumberSymbol[NumberSymbol.TimeSeparator]="TimeSeparator",NumberSymbol[NumberSymbol.CurrencyDecimal]="CurrencyDecimal",NumberSymbol[NumberSymbol.CurrencyGroup]="CurrencyGroup";var WeekDay={Sunday:0,Monday:1,Tuesday:2,Wednesday:3,Thursday:4,Friday:5,Saturday:6};WeekDay[WeekDay.Sunday]="Sunday",WeekDay[WeekDay.Monday]="Monday",WeekDay[WeekDay.Tuesday]="Tuesday",WeekDay[WeekDay.Wednesday]="Wednesday",WeekDay[WeekDay.Thursday]="Thursday",WeekDay[WeekDay.Friday]="Friday",WeekDay[WeekDay.Saturday]="Saturday";/**
 * @license
 * Copyright Google Inc. All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
var DEPRECATED_PLURAL_FN=new _angular_core.InjectionToken("UseV4Plurals"),NgLocalization=function(){function NgLocalization(){}return NgLocalization}(),NgLocaleLocalization=function(_super){function NgLocaleLocalization(locale,deprecatedPluralFn){var _this=_super.call(this)||this;return _this.locale=locale,_this.deprecatedPluralFn=deprecatedPluralFn,_this}return __extends(NgLocaleLocalization,_super),NgLocaleLocalization.prototype.getPluralCategory=function(value,locale){switch(this.deprecatedPluralFn?this.deprecatedPluralFn(locale||this.locale,value):getLocalePluralCase(locale||this.locale)(value)){case Plural.Zero:return"zero";case Plural.One:return"one";case Plural.Two:return"two";case Plural.Few:return"few";case Plural.Many:return"many";default:return"other"}},NgLocaleLocalization.decorators=[{type:_angular_core.Injectable}],NgLocaleLocalization.ctorParameters=function(){return[{type:void 0,decorators:[{type:_angular_core.Inject,args:[_angular_core.LOCALE_ID]}]},{type:void 0,decorators:[{type:_angular_core.Optional},{type:_angular_core.Inject,args:[DEPRECATED_PLURAL_FN]}]}]},NgLocaleLocalization}(NgLocalization),NgClass=function(){function NgClass(_iterableDiffers,_keyValueDiffers,_ngEl,_renderer){this._iterableDiffers=_iterableDiffers,this._keyValueDiffers=_keyValueDiffers,this._ngEl=_ngEl,this._renderer=_renderer,this._initialClasses=[]}return Object.defineProperty(NgClass.prototype,"klass",{set:function(v){this._removeClasses(this._initialClasses),this._initialClasses="string"==typeof v?v.split(/\s+/):[],this._applyClasses(this._initialClasses),this._applyClasses(this._rawClass)},enumerable:!0,configurable:!0}),Object.defineProperty(NgClass.prototype,"ngClass",{set:function(v){this._removeClasses(this._rawClass),this._applyClasses(this._initialClasses),this._iterableDiffer=null,this._keyValueDiffer=null,this._rawClass="string"==typeof v?v.split(/\s+/):v,this._rawClass&&(_angular_core.ɵisListLikeIterable(this._rawClass)?this._iterableDiffer=this._iterableDiffers.find(this._rawClass).create():this._keyValueDiffer=this._keyValueDiffers.find(this._rawClass).create())},enumerable:!0,configurable:!0}),NgClass.prototype.ngDoCheck=function(){if(this._iterableDiffer){var iterableChanges=this._iterableDiffer.diff(this._rawClass);iterableChanges&&this._applyIterableChanges(iterableChanges)}else if(this._keyValueDiffer){var keyValueChanges=this._keyValueDiffer.diff(this._rawClass);keyValueChanges&&this._applyKeyValueChanges(keyValueChanges)}},NgClass.prototype._applyKeyValueChanges=function(changes){var _this=this;changes.forEachAddedItem(function(record){return _this._toggleClass(record.key,record.currentValue)}),changes.forEachChangedItem(function(record){return _this._toggleClass(record.key,record.currentValue)}),changes.forEachRemovedItem(function(record){record.previousValue&&_this._toggleClass(record.key,!1)})},NgClass.prototype._applyIterableChanges=function(changes){var _this=this;changes.forEachAddedItem(function(record){if("string"!=typeof record.item)throw new Error("NgClass can only toggle CSS classes expressed as strings, got "+_angular_core.ɵstringify(record.item));_this._toggleClass(record.item,!0)}),changes.forEachRemovedItem(function(record){return _this._toggleClass(record.item,!1)})},NgClass.prototype._applyClasses=function(rawClassVal){var _this=this;rawClassVal&&(Array.isArray(rawClassVal)||rawClassVal instanceof Set?rawClassVal.forEach(function(klass){return _this._toggleClass(klass,!0)}):Object.keys(rawClassVal).forEach(function(klass){return _this._toggleClass(klass,!!rawClassVal[klass])}))},NgClass.prototype._removeClasses=function(rawClassVal){var _this=this;rawClassVal&&(Array.isArray(rawClassVal)||rawClassVal instanceof Set?rawClassVal.forEach(function(klass){return _this._toggleClass(klass,!1)}):Object.keys(rawClassVal).forEach(function(klass){return _this._toggleClass(klass,!1)}))},NgClass.prototype._toggleClass=function(klass,enabled){var _this=this;(klass=klass.trim())&&klass.split(/\s+/g).forEach(function(klass){enabled?_this._renderer.addClass(_this._ngEl.nativeElement,klass):_this._renderer.removeClass(_this._ngEl.nativeElement,klass)})},NgClass.decorators=[{type:_angular_core.Directive,args:[{selector:"[ngClass]"}]}],NgClass.ctorParameters=function(){return[{type:_angular_core.IterableDiffers},{type:_angular_core.KeyValueDiffers},{type:_angular_core.ElementRef},{type:_angular_core.Renderer2}]},NgClass.propDecorators={klass:[{type:_angular_core.Input,args:["class"]}],ngClass:[{type:_angular_core.Input}]},NgClass}(),NgComponentOutlet=function(){function NgComponentOutlet(_viewContainerRef){this._viewContainerRef=_viewContainerRef,this._componentRef=null,this._moduleRef=null}return NgComponentOutlet.prototype.ngOnChanges=function(changes){if(this._viewContainerRef.clear(),this._componentRef=null,this.ngComponentOutlet){var elInjector=this.ngComponentOutletInjector||this._viewContainerRef.parentInjector;if(changes.ngComponentOutletNgModuleFactory)if(this._moduleRef&&this._moduleRef.destroy(),this.ngComponentOutletNgModuleFactory){var parentModule=elInjector.get(_angular_core.NgModuleRef);this._moduleRef=this.ngComponentOutletNgModuleFactory.create(parentModule.injector)}else this._moduleRef=null;var componentFactoryResolver=this._moduleRef?this._moduleRef.componentFactoryResolver:elInjector.get(_angular_core.ComponentFactoryResolver),componentFactory=componentFactoryResolver.resolveComponentFactory(this.ngComponentOutlet);this._componentRef=this._viewContainerRef.createComponent(componentFactory,this._viewContainerRef.length,elInjector,this.ngComponentOutletContent)}},NgComponentOutlet.prototype.ngOnDestroy=function(){this._moduleRef&&this._moduleRef.destroy()},NgComponentOutlet.decorators=[{type:_angular_core.Directive,args:[{selector:"[ngComponentOutlet]"}]}],NgComponentOutlet.ctorParameters=function(){return[{type:_angular_core.ViewContainerRef}]},NgComponentOutlet.propDecorators={ngComponentOutlet:[{type:_angular_core.Input}],ngComponentOutletInjector:[{type:_angular_core.Input}],ngComponentOutletContent:[{type:_angular_core.Input}],ngComponentOutletNgModuleFactory:[{type:_angular_core.Input}]},NgComponentOutlet}(),NgForOfContext=function(){function NgForOfContext($implicit,ngForOf,index,count){this.$implicit=$implicit,this.ngForOf=ngForOf,this.index=index,this.count=count}return Object.defineProperty(NgForOfContext.prototype,"first",{get:function(){return 0===this.index},enumerable:!0,configurable:!0}),Object.defineProperty(NgForOfContext.prototype,"last",{get:function(){return this.index===this.count-1},enumerable:!0,configurable:!0}),Object.defineProperty(NgForOfContext.prototype,"even",{get:function(){return this.index%2==0},enumerable:!0,configurable:!0}),Object.defineProperty(NgForOfContext.prototype,"odd",{get:function(){return!this.even},enumerable:!0,configurable:!0}),NgForOfContext}(),NgForOf=function(){function NgForOf(_viewContainer,_template,_differs){this._viewContainer=_viewContainer,this._template=_template,this._differs=_differs,this._differ=null}return Object.defineProperty(NgForOf.prototype,"ngForTrackBy",{get:function(){return this._trackByFn},set:function(fn){_angular_core.isDevMode()&&null!=fn&&"function"!=typeof fn&&console&&console.warn&&console.warn("trackBy must be a function, but received "+JSON.stringify(fn)+". See https://angular.io/docs/ts/latest/api/common/index/NgFor-directive.html#!#change-propagation for more information."),this._trackByFn=fn},enumerable:!0,configurable:!0}),Object.defineProperty(NgForOf.prototype,"ngForTemplate",{set:function(value){value&&(this._template=value)},enumerable:!0,configurable:!0}),NgForOf.prototype.ngOnChanges=function(changes){if("ngForOf"in changes){var value=changes.ngForOf.currentValue;if(!this._differ&&value)try{this._differ=this._differs.find(value).create(this.ngForTrackBy)}catch(e){throw new Error("Cannot find a differ supporting object '"+value+"' of type '"+getTypeNameForDebugging(value)+"'. NgFor only supports binding to Iterables such as Arrays.")}}},NgForOf.prototype.ngDoCheck=function(){if(this._differ){var changes=this._differ.diff(this.ngForOf);changes&&this._applyChanges(changes)}},NgForOf.prototype._applyChanges=function(changes){var _this=this,insertTuples=[];changes.forEachOperation(function(item,adjustedPreviousIndex,currentIndex){if(null==item.previousIndex){var view=_this._viewContainer.createEmbeddedView(_this._template,new NgForOfContext(null,_this.ngForOf,-1,-1),currentIndex),tuple=new RecordViewTuple(item,view);insertTuples.push(tuple)}else if(null==currentIndex)_this._viewContainer.remove(adjustedPreviousIndex);else{var view=_this._viewContainer.get(adjustedPreviousIndex);_this._viewContainer.move(view,currentIndex);var tuple=new RecordViewTuple(item,view);insertTuples.push(tuple)}});for(var i=0;i<insertTuples.length;i++)this._perViewChange(insertTuples[i].view,insertTuples[i].record);for(var i=0,ilen=this._viewContainer.length;i<ilen;i++){var viewRef=this._viewContainer.get(i);viewRef.context.index=i,viewRef.context.count=ilen}changes.forEachIdentityChange(function(record){_this._viewContainer.get(record.currentIndex).context.$implicit=record.item})},NgForOf.prototype._perViewChange=function(view,record){view.context.$implicit=record.item},NgForOf.decorators=[{type:_angular_core.Directive,args:[{selector:"[ngFor][ngForOf]"}]}],NgForOf.ctorParameters=function(){return[{type:_angular_core.ViewContainerRef},{type:_angular_core.TemplateRef},{type:_angular_core.IterableDiffers}]},NgForOf.propDecorators={ngForOf:[{type:_angular_core.Input}],ngForTrackBy:[{type:_angular_core.Input}],ngForTemplate:[{type:_angular_core.Input}]},NgForOf}(),RecordViewTuple=function(){function RecordViewTuple(record,view){this.record=record,this.view=view}return RecordViewTuple}(),NgIf=function(){function NgIf(_viewContainer,templateRef){this._viewContainer=_viewContainer,this._context=new NgIfContext,this._thenTemplateRef=null,this._elseTemplateRef=null,this._thenViewRef=null,this._elseViewRef=null,this._thenTemplateRef=templateRef}return Object.defineProperty(NgIf.prototype,"ngIf",{set:function(condition){this._context.$implicit=this._context.ngIf=condition,this._updateView()},enumerable:!0,configurable:!0}),Object.defineProperty(NgIf.prototype,"ngIfThen",{set:function(templateRef){this._thenTemplateRef=templateRef,this._thenViewRef=null,this._updateView()},enumerable:!0,configurable:!0}),Object.defineProperty(NgIf.prototype,"ngIfElse",{set:function(templateRef){this._elseTemplateRef=templateRef,this._elseViewRef=null,this._updateView()},enumerable:!0,configurable:!0}),NgIf.prototype._updateView=function(){this._context.$implicit?this._thenViewRef||(this._viewContainer.clear(),this._elseViewRef=null,this._thenTemplateRef&&(this._thenViewRef=this._viewContainer.createEmbeddedView(this._thenTemplateRef,this._context))):this._elseViewRef||(this._viewContainer.clear(),this._thenViewRef=null,this._elseTemplateRef&&(this._elseViewRef=this._viewContainer.createEmbeddedView(this._elseTemplateRef,this._context)))},NgIf.decorators=[{type:_angular_core.Directive,args:[{selector:"[ngIf]"}]}],NgIf.ctorParameters=function(){return[{type:_angular_core.ViewContainerRef},{type:_angular_core.TemplateRef}]},NgIf.propDecorators={ngIf:[{type:_angular_core.Input}],ngIfThen:[{type:_angular_core.Input}],ngIfElse:[{type:_angular_core.Input}]},NgIf}(),NgIfContext=function(){function NgIfContext(){this.$implicit=null,this.ngIf=null}return NgIfContext}(),SwitchView=function(){function SwitchView(_viewContainerRef,_templateRef){this._viewContainerRef=_viewContainerRef,this._templateRef=_templateRef,this._created=!1}return SwitchView.prototype.create=function(){this._created=!0,this._viewContainerRef.createEmbeddedView(this._templateRef)},SwitchView.prototype.destroy=function(){this._created=!1,this._viewContainerRef.clear()},SwitchView.prototype.enforceState=function(created){created&&!this._created?this.create():!created&&this._created&&this.destroy()},SwitchView}(),NgSwitch=function(){function NgSwitch(){this._defaultUsed=!1,this._caseCount=0,this._lastCaseCheckIndex=0,this._lastCasesMatched=!1}return Object.defineProperty(NgSwitch.prototype,"ngSwitch",{set:function(newValue){this._ngSwitch=newValue,0===this._caseCount&&this._updateDefaultCases(!0)},enumerable:!0,configurable:!0}),NgSwitch.prototype._addCase=function(){return this._caseCount++},NgSwitch.prototype._addDefault=function(view){this._defaultViews||(this._defaultViews=[]),this._defaultViews.push(view)},NgSwitch.prototype._matchCase=function(value){var matched=value==this._ngSwitch;return this._lastCasesMatched=this._lastCasesMatched||matched,this._lastCaseCheckIndex++,this._lastCaseCheckIndex===this._caseCount&&(this._updateDefaultCases(!this._lastCasesMatched),this._lastCaseCheckIndex=0,this._lastCasesMatched=!1),matched},NgSwitch.prototype._updateDefaultCases=function(useDefault){if(this._defaultViews&&useDefault!==this._defaultUsed){this._defaultUsed=useDefault;for(var i=0;i<this._defaultViews.length;i++){this._defaultViews[i].enforceState(useDefault)}}},NgSwitch.decorators=[{type:_angular_core.Directive,args:[{selector:"[ngSwitch]"}]}],NgSwitch.ctorParameters=function(){return[]},NgSwitch.propDecorators={ngSwitch:[{type:_angular_core.Input}]},NgSwitch}(),NgSwitchCase=function(){function NgSwitchCase(viewContainer,templateRef,ngSwitch){this.ngSwitch=ngSwitch,ngSwitch._addCase(),this._view=new SwitchView(viewContainer,templateRef)}return NgSwitchCase.prototype.ngDoCheck=function(){this._view.enforceState(this.ngSwitch._matchCase(this.ngSwitchCase))},NgSwitchCase.decorators=[{type:_angular_core.Directive,args:[{selector:"[ngSwitchCase]"}]}],NgSwitchCase.ctorParameters=function(){return[{type:_angular_core.ViewContainerRef},{type:_angular_core.TemplateRef},{type:NgSwitch,decorators:[{type:_angular_core.Host}]}]},NgSwitchCase.propDecorators={ngSwitchCase:[{type:_angular_core.Input}]},NgSwitchCase}(),NgSwitchDefault=function(){function NgSwitchDefault(viewContainer,templateRef,ngSwitch){ngSwitch._addDefault(new SwitchView(viewContainer,templateRef))}return NgSwitchDefault.decorators=[{type:_angular_core.Directive,args:[{selector:"[ngSwitchDefault]"}]}],NgSwitchDefault.ctorParameters=function(){return[{type:_angular_core.ViewContainerRef},{type:_angular_core.TemplateRef},{type:NgSwitch,decorators:[{type:_angular_core.Host}]}]},NgSwitchDefault}(),NgPlural=function(){function NgPlural(_localization){this._localization=_localization,this._caseViews={}}return Object.defineProperty(NgPlural.prototype,"ngPlural",{set:function(value){this._switchValue=value,this._updateView()},enumerable:!0,configurable:!0}),NgPlural.prototype.addCase=function(value,switchView){this._caseViews[value]=switchView},NgPlural.prototype._updateView=function(){this._clearViews();var cases=Object.keys(this._caseViews),key=getPluralCategory(this._switchValue,cases,this._localization);this._activateView(this._caseViews[key])},NgPlural.prototype._clearViews=function(){this._activeView&&this._activeView.destroy()},NgPlural.prototype._activateView=function(view){view&&(this._activeView=view,this._activeView.create())},NgPlural.decorators=[{type:_angular_core.Directive,args:[{selector:"[ngPlural]"}]}],NgPlural.ctorParameters=function(){return[{type:NgLocalization}]},NgPlural.propDecorators={ngPlural:[{type:_angular_core.Input}]},NgPlural}(),NgPluralCase=function(){function NgPluralCase(value,template,viewContainer,ngPlural){this.value=value;var isANumber=!isNaN(Number(value));ngPlural.addCase(isANumber?"="+value:value,new SwitchView(viewContainer,template))}return NgPluralCase.decorators=[{type:_angular_core.Directive,args:[{selector:"[ngPluralCase]"}]}],NgPluralCase.ctorParameters=function(){return[{type:void 0,decorators:[{type:_angular_core.Attribute,args:["ngPluralCase"]}]},{type:_angular_core.TemplateRef},{type:_angular_core.ViewContainerRef},{type:NgPlural,decorators:[{type:_angular_core.Host}]}]},NgPluralCase}(),NgStyle=function(){function NgStyle(_differs,_ngEl,_renderer){this._differs=_differs,this._ngEl=_ngEl,this._renderer=_renderer}return Object.defineProperty(NgStyle.prototype,"ngStyle",{set:function(v){this._ngStyle=v,!this._differ&&v&&(this._differ=this._differs.find(v).create())},enumerable:!0,configurable:!0}),NgStyle.prototype.ngDoCheck=function(){if(this._differ){var changes=this._differ.diff(this._ngStyle);changes&&this._applyChanges(changes)}},NgStyle.prototype._applyChanges=function(changes){var _this=this;changes.forEachRemovedItem(function(record){return _this._setStyle(record.key,null)}),changes.forEachAddedItem(function(record){return _this._setStyle(record.key,record.currentValue)}),changes.forEachChangedItem(function(record){return _this._setStyle(record.key,record.currentValue)})},NgStyle.prototype._setStyle=function(nameAndUnit,value){var _a=nameAndUnit.split("."),name=_a[0],unit=_a[1];value=null!=value&&unit?""+value+unit:value,null!=value?this._renderer.setStyle(this._ngEl.nativeElement,name,value):this._renderer.removeStyle(this._ngEl.nativeElement,name)},NgStyle.decorators=[{type:_angular_core.Directive,args:[{selector:"[ngStyle]"}]}],NgStyle.ctorParameters=function(){return[{type:_angular_core.KeyValueDiffers},{type:_angular_core.ElementRef},{type:_angular_core.Renderer2}]},NgStyle.propDecorators={ngStyle:[{type:_angular_core.Input}]},NgStyle}(),NgTemplateOutlet=function(){function NgTemplateOutlet(_viewContainerRef){this._viewContainerRef=_viewContainerRef}return NgTemplateOutlet.prototype.ngOnChanges=function(changes){this._shouldRecreateView(changes)?(this._viewRef&&this._viewContainerRef.remove(this._viewContainerRef.indexOf(this._viewRef)),this.ngTemplateOutlet&&(this._viewRef=this._viewContainerRef.createEmbeddedView(this.ngTemplateOutlet,this.ngTemplateOutletContext))):this._viewRef&&this.ngTemplateOutletContext&&this._updateExistingContext(this.ngTemplateOutletContext)},NgTemplateOutlet.prototype._shouldRecreateView=function(changes){var ctxChange=changes.ngTemplateOutletContext;return!!changes.ngTemplateOutlet||ctxChange&&this._hasContextShapeChanged(ctxChange)},NgTemplateOutlet.prototype._hasContextShapeChanged=function(ctxChange){var prevCtxKeys=Object.keys(ctxChange.previousValue||{}),currCtxKeys=Object.keys(ctxChange.currentValue||{});if(prevCtxKeys.length===currCtxKeys.length){for(var _i=0,currCtxKeys_1=currCtxKeys;_i<currCtxKeys_1.length;_i++){var propName=currCtxKeys_1[_i];if(-1===prevCtxKeys.indexOf(propName))return!0}return!1}return!0},NgTemplateOutlet.prototype._updateExistingContext=function(ctx){for(var _i=0,_a=Object.keys(ctx);_i<_a.length;_i++){var propName=_a[_i];this._viewRef.context[propName]=this.ngTemplateOutletContext[propName]}},NgTemplateOutlet.decorators=[{type:_angular_core.Directive,args:[{selector:"[ngTemplateOutlet]"}]}],NgTemplateOutlet.ctorParameters=function(){return[{type:_angular_core.ViewContainerRef}]},NgTemplateOutlet.propDecorators={ngTemplateOutletContext:[{type:_angular_core.Input}],ngTemplateOutlet:[{type:_angular_core.Input}]},NgTemplateOutlet}(),COMMON_DIRECTIVES=[NgClass,NgComponentOutlet,NgForOf,NgIf,NgTemplateOutlet,NgStyle,NgSwitch,NgSwitchCase,NgSwitchDefault,NgPlural,NgPluralCase],NAMED_FORMATS={},DATE_FORMATS_SPLIT=/((?:[^GyMLwWdEabBhHmsSzZO']+)|(?:'(?:[^']|'')*')|(?:G{1,5}|y{1,4}|M{1,5}|L{1,5}|w{1,2}|W{1}|d{1,2}|E{1,6}|a{1,5}|b{1,5}|B{1,5}|h{1,2}|H{1,2}|m{1,2}|s{1,2}|S{1,3}|z{1,4}|Z{1,5}|O{1,4}))([\s\S]*)/,ZoneWidth={Short:0,ShortGMT:1,Long:2,Extended:3};ZoneWidth[ZoneWidth.Short]="Short",ZoneWidth[ZoneWidth.ShortGMT]="ShortGMT",ZoneWidth[ZoneWidth.Long]="Long",ZoneWidth[ZoneWidth.Extended]="Extended";var DateType={FullYear:0,Month:1,Date:2,Hours:3,Minutes:4,Seconds:5,Milliseconds:6,Day:7};DateType[DateType.FullYear]="FullYear",DateType[DateType.Month]="Month",DateType[DateType.Date]="Date",DateType[DateType.Hours]="Hours",DateType[DateType.Minutes]="Minutes",DateType[DateType.Seconds]="Seconds",DateType[DateType.Milliseconds]="Milliseconds",DateType[DateType.Day]="Day";var TranslationType={DayPeriods:0,Days:1,Months:2,Eras:3};TranslationType[TranslationType.DayPeriods]="DayPeriods",TranslationType[TranslationType.Days]="Days",TranslationType[TranslationType.Months]="Months",TranslationType[TranslationType.Eras]="Eras";var JANUARY=0,THURSDAY=4,DATE_FORMATS={},ISO8601_DATE_REGEX=/^(\d{4})-?(\d\d)-?(\d\d)(?:T(\d\d)(?::?(\d\d)(?::?(\d\d)(?:\.(\d+))?)?)?(Z|([+-])(\d\d):?(\d\d))?)?$/,DatePipe=function(){function DatePipe(locale){this.locale=locale}return DatePipe.prototype.transform=function(value,format,timezone,locale){if(void 0===format&&(format="mediumDate"),null==value||""===value||value!==value)return null;"string"==typeof value&&(value=value.trim());var date,match;if(isDate$1(value))date=value;else if(isNaN(value-parseFloat(value)))if("string"==typeof value&&/^(\d{4}-\d{1,2}-\d{1,2})$/.test(value)){var _a=value.split("-").map(function(val){return+val}),y=_a[0],m=_a[1],d=_a[2];date=new Date(y,m-1,d)}else date="string"==typeof value&&(match=value.match(ISO8601_DATE_REGEX))?isoStringToDate(match):new Date(value);else date=new Date(parseFloat(value));if(!isDate$1(date))throw invalidPipeArgumentError(DatePipe,value);return formatDate(date,format,locale||this.locale,timezone)},DatePipe.decorators=[{type:_angular_core.Pipe,args:[{name:"date",pure:!0}]}],DatePipe.ctorParameters=function(){return[{type:void 0,decorators:[{type:_angular_core.Inject,args:[_angular_core.LOCALE_ID]}]}]},DatePipe}(),NumberFormatter=function(){function NumberFormatter(){}return NumberFormatter.format=function(num,locale,style,opts){void 0===opts&&(opts={});var minimumIntegerDigits=opts.minimumIntegerDigits,minimumFractionDigits=opts.minimumFractionDigits,maximumFractionDigits=opts.maximumFractionDigits,currency=opts.currency,_a=opts.currencyAsSymbol,currencyAsSymbol=void 0!==_a&&_a,options={minimumIntegerDigits:minimumIntegerDigits,minimumFractionDigits:minimumFractionDigits,maximumFractionDigits:maximumFractionDigits,style:NumberFormatStyle[style].toLowerCase()};return style==NumberFormatStyle.Currency&&(options.currency="string"==typeof currency?currency:void 0,options.currencyDisplay=currencyAsSymbol?"symbol":"code"),new Intl.NumberFormat(locale,options).format(num)},NumberFormatter}(),DATE_FORMATS_SPLIT$1=/((?:[^yMLdHhmsazZEwGjJ']+)|(?:'(?:[^']|'')*')|(?:E+|y+|M+|L+|d+|H+|h+|J+|j+|m+|s+|a|z|Z|G+|w+))(.*)/,PATTERN_ALIASES={yMMMdjms:datePartGetterFactory(combine([digitCondition("year",1),nameCondition("month",3),digitCondition("day",1),digitCondition("hour",1),digitCondition("minute",1),digitCondition("second",1)])),yMdjm:datePartGetterFactory(combine([digitCondition("year",1),digitCondition("month",1),digitCondition("day",1),digitCondition("hour",1),digitCondition("minute",1)])),yMMMMEEEEd:datePartGetterFactory(combine([digitCondition("year",1),nameCondition("month",4),nameCondition("weekday",4),digitCondition("day",1)])),yMMMMd:datePartGetterFactory(combine([digitCondition("year",1),nameCondition("month",4),digitCondition("day",1)])),yMMMd:datePartGetterFactory(combine([digitCondition("year",1),nameCondition("month",3),digitCondition("day",1)])),yMd:datePartGetterFactory(combine([digitCondition("year",1),digitCondition("month",1),digitCondition("day",1)])),jms:datePartGetterFactory(combine([digitCondition("hour",1),digitCondition("second",1),digitCondition("minute",1)])),jm:datePartGetterFactory(combine([digitCondition("hour",1),digitCondition("minute",1)]))},DATE_FORMATS$1={yyyy:datePartGetterFactory(digitCondition("year",4)),yy:datePartGetterFactory(digitCondition("year",2)),y:datePartGetterFactory(digitCondition("year",1)),MMMM:datePartGetterFactory(nameCondition("month",4)),MMM:datePartGetterFactory(nameCondition("month",3)),MM:datePartGetterFactory(digitCondition("month",2)),M:datePartGetterFactory(digitCondition("month",1)),LLLL:datePartGetterFactory(nameCondition("month",4)),L:datePartGetterFactory(nameCondition("month",1)),dd:datePartGetterFactory(digitCondition("day",2)),d:datePartGetterFactory(digitCondition("day",1)),HH:digitModifier(hourExtractor(datePartGetterFactory(hour12Modify(digitCondition("hour",2),!1)))),H:hourExtractor(datePartGetterFactory(hour12Modify(digitCondition("hour",1),!1))),hh:digitModifier(hourExtractor(datePartGetterFactory(hour12Modify(digitCondition("hour",2),!0)))),h:hourExtractor(datePartGetterFactory(hour12Modify(digitCondition("hour",1),!0))),jj:datePartGetterFactory(digitCondition("hour",2)),j:datePartGetterFactory(digitCondition("hour",1)),mm:digitModifier(datePartGetterFactory(digitCondition("minute",2))),m:datePartGetterFactory(digitCondition("minute",1)),ss:digitModifier(datePartGetterFactory(digitCondition("second",2))),s:datePartGetterFactory(digitCondition("second",1)),sss:datePartGetterFactory(digitCondition("second",3)),EEEE:datePartGetterFactory(nameCondition("weekday",4)),EEE:datePartGetterFactory(nameCondition("weekday",3)),EE:datePartGetterFactory(nameCondition("weekday",2)),E:datePartGetterFactory(nameCondition("weekday",1)),a:function(inner){return function(date,locale){return inner(date,locale).split(" ")[1]}}(datePartGetterFactory(hour12Modify(digitCondition("hour",1),!0))),Z:timeZoneGetter$1("short"),z:timeZoneGetter$1("long"),ww:datePartGetterFactory({}),w:datePartGetterFactory({}),G:datePartGetterFactory(nameCondition("era",1)),GG:datePartGetterFactory(nameCondition("era",2)),GGG:datePartGetterFactory(nameCondition("era",3)),GGGG:datePartGetterFactory(nameCondition("era",4))},DATE_FORMATTER_CACHE=new Map,DateFormatter=function(){function DateFormatter(){}return DateFormatter.format=function(date,locale,pattern){return dateFormatter(pattern,date,locale)},DateFormatter}(),DeprecatedDatePipe=function(){function DeprecatedDatePipe(_locale){this._locale=_locale}return DeprecatedDatePipe.prototype.transform=function(value,pattern){if(void 0===pattern&&(pattern="mediumDate"),null==value||""===value||value!==value)return null;var date;if("string"==typeof value&&(value=value.trim()),isDate(value))date=value;else if(isNaN(value-parseFloat(value)))if("string"==typeof value&&/^(\d{4}-\d{1,2}-\d{1,2})$/.test(value)){var _a=value.split("-").map(function(val){return parseInt(val,10)}),y=_a[0],m=_a[1],d=_a[2];date=new Date(y,m-1,d)}else date=new Date(value);else date=new Date(parseFloat(value));if(!isDate(date)){var match=void 0;if("string"!=typeof value||!(match=value.match(ISO8601_DATE_REGEX)))throw invalidPipeArgumentError(DeprecatedDatePipe,value);date=isoStringToDate(match)}return DateFormatter.format(date,this._locale,DeprecatedDatePipe._ALIASES[pattern]||pattern)},DeprecatedDatePipe._ALIASES={medium:"yMMMdjms",short:"yMdjm",fullDate:"yMMMMEEEEd",longDate:"yMMMMd",mediumDate:"yMMMd",shortDate:"yMd",mediumTime:"jms",shortTime:"jm"},DeprecatedDatePipe.decorators=[{type:_angular_core.Pipe,args:[{name:"date",pure:!0}]}],DeprecatedDatePipe.ctorParameters=function(){return[{type:void 0,decorators:[{type:_angular_core.Inject,args:[_angular_core.LOCALE_ID]}]}]},DeprecatedDatePipe}(),NUMBER_FORMAT_REGEXP=/^(\d+)?\.((\d+)(-(\d+))?)?$/,MAX_DIGITS=22,DECIMAL_SEP=".",ZERO_CHAR="0",PATTERN_SEP=";",GROUP_SEP=",",DIGIT_CHAR="#",CURRENCY_CHAR="¤",PERCENT_CHAR="%",DeprecatedDecimalPipe=function(){function DeprecatedDecimalPipe(_locale){this._locale=_locale}return DeprecatedDecimalPipe.prototype.transform=function(value,digits){return formatNumber(DeprecatedDecimalPipe,this._locale,value,NumberFormatStyle.Decimal,digits)},DeprecatedDecimalPipe.decorators=[{type:_angular_core.Pipe,args:[{name:"number"}]}],DeprecatedDecimalPipe.ctorParameters=function(){return[{type:void 0,decorators:[{type:_angular_core.Inject,args:[_angular_core.LOCALE_ID]}]}]},DeprecatedDecimalPipe}(),DeprecatedPercentPipe=function(){function DeprecatedPercentPipe(_locale){this._locale=_locale}return DeprecatedPercentPipe.prototype.transform=function(value,digits){return formatNumber(DeprecatedPercentPipe,this._locale,value,NumberFormatStyle.Percent,digits)},DeprecatedPercentPipe.decorators=[{type:_angular_core.Pipe,args:[{name:"percent"}]}],DeprecatedPercentPipe.ctorParameters=function(){return[{type:void 0,decorators:[{type:_angular_core.Inject,args:[_angular_core.LOCALE_ID]}]}]},DeprecatedPercentPipe}(),DeprecatedCurrencyPipe=function(){function DeprecatedCurrencyPipe(_locale){this._locale=_locale}return DeprecatedCurrencyPipe.prototype.transform=function(value,currencyCode,symbolDisplay,digits){return void 0===currencyCode&&(currencyCode="USD"),void 0===symbolDisplay&&(symbolDisplay=!1),formatNumber(DeprecatedCurrencyPipe,this._locale,value,NumberFormatStyle.Currency,digits,currencyCode,symbolDisplay)},DeprecatedCurrencyPipe.decorators=[{type:_angular_core.Pipe,args:[{name:"currency"}]}],DeprecatedCurrencyPipe.ctorParameters=function(){return[{type:void 0,decorators:[{type:_angular_core.Inject,args:[_angular_core.LOCALE_ID]}]}]},DeprecatedCurrencyPipe}(),COMMON_DEPRECATED_I18N_PIPES=[DeprecatedDecimalPipe,DeprecatedPercentPipe,DeprecatedCurrencyPipe,DeprecatedDatePipe],ObservableStrategy=function(){function ObservableStrategy(){}return ObservableStrategy.prototype.createSubscription=function(async,updateLatestValue){return async.subscribe({next:updateLatestValue,error:function(e){throw e}})},ObservableStrategy.prototype.dispose=function(subscription){subscription.unsubscribe()},ObservableStrategy.prototype.onDestroy=function(subscription){subscription.unsubscribe()},ObservableStrategy}(),PromiseStrategy=function(){function PromiseStrategy(){}return PromiseStrategy.prototype.createSubscription=function(async,updateLatestValue){return async.then(updateLatestValue,function(e){throw e})},PromiseStrategy.prototype.dispose=function(subscription){},PromiseStrategy.prototype.onDestroy=function(subscription){},PromiseStrategy}(),_promiseStrategy=new PromiseStrategy,_observableStrategy=new ObservableStrategy,AsyncPipe=function(){function AsyncPipe(_ref){this._ref=_ref,this._latestValue=null,this._latestReturnedValue=null,this._subscription=null,this._obj=null,this._strategy=null}return AsyncPipe.prototype.ngOnDestroy=function(){this._subscription&&this._dispose()},AsyncPipe.prototype.transform=function(obj){return this._obj?obj!==this._obj?(this._dispose(),this.transform(obj)):this._latestValue===this._latestReturnedValue?this._latestReturnedValue:(this._latestReturnedValue=this._latestValue,_angular_core.WrappedValue.wrap(this._latestValue)):(obj&&this._subscribe(obj),this._latestReturnedValue=this._latestValue,this._latestValue)},AsyncPipe.prototype._subscribe=function(obj){var _this=this;this._obj=obj,this._strategy=this._selectStrategy(obj),this._subscription=this._strategy.createSubscription(obj,function(value){return _this._updateLatestValue(obj,value)})},AsyncPipe.prototype._selectStrategy=function(obj){if(_angular_core.ɵisPromise(obj))return _promiseStrategy;if(_angular_core.ɵisObservable(obj))return _observableStrategy;throw invalidPipeArgumentError(AsyncPipe,obj)},AsyncPipe.prototype._dispose=function(){this._strategy.dispose(this._subscription),this._latestValue=null,this._latestReturnedValue=null,this._subscription=null,this._obj=null},AsyncPipe.prototype._updateLatestValue=function(async,value){async===this._obj&&(this._latestValue=value,this._ref.markForCheck())},AsyncPipe.decorators=[{type:_angular_core.Pipe,args:[{name:"async",pure:!1}]}],AsyncPipe.ctorParameters=function(){return[{type:_angular_core.ChangeDetectorRef}]},AsyncPipe}(),LowerCasePipe=function(){function LowerCasePipe(){}return LowerCasePipe.prototype.transform=function(value){if(!value)return value;if("string"!=typeof value)throw invalidPipeArgumentError(LowerCasePipe,value);return value.toLowerCase()},LowerCasePipe.decorators=[{type:_angular_core.Pipe,args:[{name:"lowercase"}]}],LowerCasePipe.ctorParameters=function(){return[]},LowerCasePipe}(),TitleCasePipe=function(){function TitleCasePipe(){}return TitleCasePipe.prototype.transform=function(value){if(!value)return value;if("string"!=typeof value)throw invalidPipeArgumentError(TitleCasePipe,value);return value.split(/\b/g).map(function(word){return titleCaseWord(word)}).join("")},
TitleCasePipe.decorators=[{type:_angular_core.Pipe,args:[{name:"titlecase"}]}],TitleCasePipe.ctorParameters=function(){return[]},TitleCasePipe}(),UpperCasePipe=function(){function UpperCasePipe(){}return UpperCasePipe.prototype.transform=function(value){if(!value)return value;if("string"!=typeof value)throw invalidPipeArgumentError(UpperCasePipe,value);return value.toUpperCase()},UpperCasePipe.decorators=[{type:_angular_core.Pipe,args:[{name:"uppercase"}]}],UpperCasePipe.ctorParameters=function(){return[]},UpperCasePipe}(),_INTERPOLATION_REGEXP=/#/g,I18nPluralPipe=function(){function I18nPluralPipe(_localization){this._localization=_localization}return I18nPluralPipe.prototype.transform=function(value,pluralMap,locale){if(null==value)return"";if("object"!=typeof pluralMap||null===pluralMap)throw invalidPipeArgumentError(I18nPluralPipe,pluralMap);return pluralMap[getPluralCategory(value,Object.keys(pluralMap),this._localization,locale)].replace(_INTERPOLATION_REGEXP,value.toString())},I18nPluralPipe.decorators=[{type:_angular_core.Pipe,args:[{name:"i18nPlural",pure:!0}]}],I18nPluralPipe.ctorParameters=function(){return[{type:NgLocalization}]},I18nPluralPipe}(),I18nSelectPipe=function(){function I18nSelectPipe(){}return I18nSelectPipe.prototype.transform=function(value,mapping){if(null==value)return"";if("object"!=typeof mapping||"string"!=typeof value)throw invalidPipeArgumentError(I18nSelectPipe,mapping);return mapping.hasOwnProperty(value)?mapping[value]:mapping.hasOwnProperty("other")?mapping.other:""},I18nSelectPipe.decorators=[{type:_angular_core.Pipe,args:[{name:"i18nSelect",pure:!0}]}],I18nSelectPipe.ctorParameters=function(){return[]},I18nSelectPipe}(),JsonPipe=function(){function JsonPipe(){}return JsonPipe.prototype.transform=function(value){return JSON.stringify(value,null,2)},JsonPipe.decorators=[{type:_angular_core.Pipe,args:[{name:"json",pure:!1}]}],JsonPipe.ctorParameters=function(){return[]},JsonPipe}(),DecimalPipe=function(){function DecimalPipe(_locale){this._locale=_locale}return DecimalPipe.prototype.transform=function(value,digits,locale){if(isEmpty(value))return null;locale=locale||this._locale;var _a=formatNumber$1(value,locale,NumberFormatStyle.Decimal,digits),str=_a.str,error=_a.error;if(error)throw invalidPipeArgumentError(DecimalPipe,error);return str},DecimalPipe.decorators=[{type:_angular_core.Pipe,args:[{name:"number"}]}],DecimalPipe.ctorParameters=function(){return[{type:void 0,decorators:[{type:_angular_core.Inject,args:[_angular_core.LOCALE_ID]}]}]},DecimalPipe}(),PercentPipe=function(){function PercentPipe(_locale){this._locale=_locale}return PercentPipe.prototype.transform=function(value,digits,locale){if(isEmpty(value))return null;locale=locale||this._locale;var _a=formatNumber$1(value,locale,NumberFormatStyle.Percent,digits),str=_a.str,error=_a.error;if(error)throw invalidPipeArgumentError(PercentPipe,error);return str},PercentPipe.decorators=[{type:_angular_core.Pipe,args:[{name:"percent"}]}],PercentPipe.ctorParameters=function(){return[{type:void 0,decorators:[{type:_angular_core.Inject,args:[_angular_core.LOCALE_ID]}]}]},PercentPipe}(),CurrencyPipe=function(){function CurrencyPipe(_locale){this._locale=_locale}return CurrencyPipe.prototype.transform=function(value,currencyCode,display,digits,locale){if(void 0===display&&(display="symbol"),isEmpty(value))return null;locale=locale||this._locale,"boolean"==typeof display&&(console&&console.warn&&console.warn('Warning: the currency pipe has been changed in Angular v5. The symbolDisplay option (third parameter) is now a string instead of a boolean. The accepted values are "code", "symbol" or "symbol-narrow".'),display=display?"symbol":"code");var currency=currencyCode||"USD";"code"!==display&&(currency=getCurrencySymbol(currency,"symbol"===display?"wide":"narrow"));var _a=formatNumber$1(value,locale,NumberFormatStyle.Currency,digits,currency),str=_a.str,error=_a.error;if(error)throw invalidPipeArgumentError(CurrencyPipe,error);return str},CurrencyPipe.decorators=[{type:_angular_core.Pipe,args:[{name:"currency"}]}],CurrencyPipe.ctorParameters=function(){return[{type:void 0,decorators:[{type:_angular_core.Inject,args:[_angular_core.LOCALE_ID]}]}]},CurrencyPipe}(),SlicePipe=function(){function SlicePipe(){}return SlicePipe.prototype.transform=function(value,start,end){if(null==value)return value;if(!this.supports(value))throw invalidPipeArgumentError(SlicePipe,value);return value.slice(start,end)},SlicePipe.prototype.supports=function(obj){return"string"==typeof obj||Array.isArray(obj)},SlicePipe.decorators=[{type:_angular_core.Pipe,args:[{name:"slice",pure:!1}]}],SlicePipe.ctorParameters=function(){return[]},SlicePipe}(),COMMON_PIPES=[AsyncPipe,UpperCasePipe,LowerCasePipe,JsonPipe,SlicePipe,DecimalPipe,PercentPipe,TitleCasePipe,CurrencyPipe,DatePipe,I18nPluralPipe,I18nSelectPipe],CommonModule=function(){function CommonModule(){}return CommonModule.decorators=[{type:_angular_core.NgModule,args:[{declarations:[COMMON_DIRECTIVES,COMMON_PIPES],exports:[COMMON_DIRECTIVES,COMMON_PIPES],providers:[{provide:NgLocalization,useClass:NgLocaleLocalization}]}]}],CommonModule.ctorParameters=function(){return[]},CommonModule}(),ɵ0=getPluralCase,DeprecatedI18NPipesModule=function(){function DeprecatedI18NPipesModule(){}return DeprecatedI18NPipesModule.decorators=[{type:_angular_core.NgModule,args:[{declarations:[COMMON_DEPRECATED_I18N_PIPES],exports:[COMMON_DEPRECATED_I18N_PIPES],providers:[{provide:DEPRECATED_PLURAL_FN,useValue:ɵ0}]}]}],DeprecatedI18NPipesModule.ctorParameters=function(){return[]},DeprecatedI18NPipesModule}(),DOCUMENT=new _angular_core.InjectionToken("DocumentToken"),PLATFORM_BROWSER_ID="browser",PLATFORM_SERVER_ID="server",PLATFORM_WORKER_APP_ID="browserWorkerApp",PLATFORM_WORKER_UI_ID="browserWorkerUi",VERSION=new _angular_core.Version("5.2.11");exports.ɵregisterLocaleData=registerLocaleData,exports.NgLocaleLocalization=NgLocaleLocalization,exports.NgLocalization=NgLocalization,exports.registerLocaleData=registerLocaleData,exports.Plural=Plural,exports.NumberFormatStyle=NumberFormatStyle,exports.FormStyle=FormStyle,exports.TranslationWidth=TranslationWidth,exports.FormatWidth=FormatWidth,exports.NumberSymbol=NumberSymbol,exports.WeekDay=WeekDay,exports.getCurrencySymbol=getCurrencySymbol,exports.getLocaleDayPeriods=getLocaleDayPeriods,exports.getLocaleDayNames=getLocaleDayNames,exports.getLocaleMonthNames=getLocaleMonthNames,exports.getLocaleId=getLocaleId,exports.getLocaleEraNames=getLocaleEraNames,exports.getLocaleWeekEndRange=getLocaleWeekEndRange,exports.getLocaleFirstDayOfWeek=getLocaleFirstDayOfWeek,exports.getLocaleDateFormat=getLocaleDateFormat,exports.getLocaleDateTimeFormat=getLocaleDateTimeFormat,exports.getLocaleExtraDayPeriodRules=getLocaleExtraDayPeriodRules,exports.getLocaleExtraDayPeriods=getLocaleExtraDayPeriods,exports.getLocalePluralCase=getLocalePluralCase,exports.getLocaleTimeFormat=getLocaleTimeFormat,exports.getLocaleNumberSymbol=getLocaleNumberSymbol,exports.getLocaleNumberFormat=getLocaleNumberFormat,exports.getLocaleCurrencyName=getLocaleCurrencyName,exports.getLocaleCurrencySymbol=getLocaleCurrencySymbol,exports.ɵparseCookieValue=parseCookieValue,exports.CommonModule=CommonModule,exports.DeprecatedI18NPipesModule=DeprecatedI18NPipesModule,exports.NgClass=NgClass,exports.NgForOf=NgForOf,exports.NgForOfContext=NgForOfContext,exports.NgIf=NgIf,exports.NgIfContext=NgIfContext,exports.NgPlural=NgPlural,exports.NgPluralCase=NgPluralCase,exports.NgStyle=NgStyle,exports.NgSwitch=NgSwitch,exports.NgSwitchCase=NgSwitchCase,exports.NgSwitchDefault=NgSwitchDefault,exports.NgTemplateOutlet=NgTemplateOutlet,exports.NgComponentOutlet=NgComponentOutlet,exports.DOCUMENT=DOCUMENT,exports.AsyncPipe=AsyncPipe,exports.DatePipe=DatePipe,exports.I18nPluralPipe=I18nPluralPipe,exports.I18nSelectPipe=I18nSelectPipe,exports.JsonPipe=JsonPipe,exports.LowerCasePipe=LowerCasePipe,exports.CurrencyPipe=CurrencyPipe,exports.DecimalPipe=DecimalPipe,exports.PercentPipe=PercentPipe,exports.SlicePipe=SlicePipe,exports.UpperCasePipe=UpperCasePipe,exports.TitleCasePipe=TitleCasePipe,exports.DeprecatedDatePipe=DeprecatedDatePipe,exports.DeprecatedCurrencyPipe=DeprecatedCurrencyPipe,exports.DeprecatedDecimalPipe=DeprecatedDecimalPipe,exports.DeprecatedPercentPipe=DeprecatedPercentPipe,exports.ɵPLATFORM_BROWSER_ID=PLATFORM_BROWSER_ID,exports.ɵPLATFORM_SERVER_ID=PLATFORM_SERVER_ID,exports.ɵPLATFORM_WORKER_APP_ID=PLATFORM_WORKER_APP_ID,exports.ɵPLATFORM_WORKER_UI_ID=PLATFORM_WORKER_UI_ID,exports.isPlatformBrowser=isPlatformBrowser,exports.isPlatformServer=isPlatformServer,exports.isPlatformWorkerApp=isPlatformWorkerApp,exports.isPlatformWorkerUi=isPlatformWorkerUi,exports.VERSION=VERSION,exports.PlatformLocation=PlatformLocation,exports.LOCATION_INITIALIZED=LOCATION_INITIALIZED,exports.LocationStrategy=LocationStrategy,exports.APP_BASE_HREF=APP_BASE_HREF,exports.HashLocationStrategy=HashLocationStrategy,exports.PathLocationStrategy=PathLocationStrategy,exports.Location=Location,exports.ɵe=COMMON_DIRECTIVES,exports.ɵd=findLocaleData,exports.ɵa=DEPRECATED_PLURAL_FN,exports.ɵb=getPluralCase,exports.ɵg=COMMON_DEPRECATED_I18N_PIPES,exports.ɵf=COMMON_PIPES,Object.defineProperty(exports,"__esModule",{value:!0})});
//# sourceMappingURL=common.umd.min.js.map