/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.codec.api;

import java.io.InputStream;
import java.nio.ByteBuffer;
import org.apache.directory.api.asn1.DecoderException;
import org.apache.directory.api.asn1.ber.Asn1Decoder;
import org.apache.directory.api.asn1.ber.tlv.TLVStateEnum;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.codec.api.LdapMessageContainer;
import org.apache.directory.api.ldap.codec.api.MessageDecorator;
import org.apache.directory.api.ldap.model.message.Message;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LdapDecoder {
    private static final Logger LOG = LoggerFactory.getLogger(LdapDecoder.class);
    private Asn1Decoder asn1Decoder = new Asn1Decoder();
    public static final String MESSAGE_CONTAINER_ATTR = "LDAP-container";
    public static final String MAX_PDU_SIZE_ATTR = "LDAP-maxPduSize";

    public Message decode(InputStream in, LdapMessageContainer<MessageDecorator<? extends Message>> container) throws DecoderException {
        try {
            byte[] buf;
            int amount;
            while (in.available() > 0 && (amount = in.read(buf = new byte[in.available()])) != -1) {
                this.asn1Decoder.decode(ByteBuffer.wrap(buf, 0, amount), container);
            }
        }
        catch (Exception e) {
            String message = I18n.err((I18n)I18n.ERR_05204_LDAP_DECODER_FAILURE, (Object[])new Object[]{e.getLocalizedMessage()});
            LOG.error(message);
            throw new DecoderException(message, (Throwable)e);
        }
        if (container.getState() == TLVStateEnum.PDU_DECODED) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(I18n.msg((I18n)I18n.MSG_5200_DECODED_LDAP_MESSAGE, (Object[])new Object[]{container}));
            }
            return container.getMessage();
        }
        LOG.error(I18n.err((I18n)I18n.ERR_05205_PDU_DOES_NOT_CONTAIN_ENOUGH_DATA, (Object[])new Object[0]));
        throw new DecoderException(I18n.err((I18n)I18n.ERR_05206_INPUT_STREAM_TOO_SHORT_PDU, (Object[])new Object[0]));
    }
}

