/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.management.internal;

import java.io.ObjectInputStream;
import java.util.Objects;
import java.util.Set;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.InvalidAttributeValueException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.NotCompliantMBeanException;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.OperationsException;
import javax.management.QueryExp;
import javax.management.ReflectionException;
import javax.management.loading.ClassLoaderRepository;
import org.apache.karaf.management.internal.EventAdminLogger;

public class EventAdminMBeanServerWrapper
implements MBeanServer {
    private static final String[] NO_ARGS_SIG = new String[]{ObjectName.class.getName()};
    private static final String[] OBJECT_NAME_ONLY_SIG = new String[]{ObjectName.class.getName()};
    private static final String CREATE_MBEAN = "createMBean";
    private static final String[] CREATE_MBEAN_SIG_1 = new String[]{String.class.getName(), ObjectName.class.getName()};
    private static final String[] CREATE_MBEAN_SIG_2 = new String[]{String.class.getName(), ObjectName.class.getName(), ObjectName.class.getName()};
    private static final String[] CREATE_MBEAN_SIG_3 = new String[]{String.class.getName(), Object[].class.getName(), String[].class.getName()};
    private static final String[] CREATE_MBEAN_SIG_4 = new String[]{String.class.getName(), ObjectName.class.getName(), ObjectName.class.getName(), Object[].class.getName(), String[].class.getName()};
    private static final String REGISTER_MBEAN = "registerMBean";
    private static final String[] REGISTER_MBEAN_SIG = new String[]{Object.class.getName(), ObjectName.class.getName()};
    private static final String UNREGISTER_MBEAN = "unregisterMBean";
    private static final String[] UNREGISTER_MBEAN_SIG = OBJECT_NAME_ONLY_SIG;
    private static final String GET_OBJECT_INSTANCE = "getObjectInstance";
    private static final String[] GET_OBJECT_INSTANCE_SIG = OBJECT_NAME_ONLY_SIG;
    private static final String QUERY_MBEANS = "queryMBeans";
    private static final String[] QUERY_MBEANS_SIG = new String[]{ObjectName.class.getName(), QueryExp.class.getName()};
    private static final String QUERY_NAMES = "queryMBeans";
    private static final String[] QUERY_NAMES_SIG = QUERY_MBEANS_SIG;
    private static final String IS_REGISTERED = "isRegistered";
    private static final String[] IS_REGISTERED_SIG = OBJECT_NAME_ONLY_SIG;
    private static final String GET_MBEAN_COUNT = "getMBeanCount";
    private static final String[] GET_MBEAN_COUNT_SIG = NO_ARGS_SIG;
    private static final String GET_ATTRIBUTE = "getAttribute";
    private static final String[] GET_ATTRIBUTE_SIG = new String[]{ObjectName.class.getName(), String.class.getName()};
    private static final String GET_ATTRIBUTES = "getAttributes";
    private static final String[] GET_ATTRIBUTES_SIG = new String[]{ObjectName.class.getName(), String[].class.getName()};
    private static final String SET_ATTRIBUTE = "setAttribute";
    private static final String[] SET_ATTRIBUTE_SIG = new String[]{ObjectName.class.getName(), Attribute.class.getName()};
    private static final String SET_ATTRIBUTES = "setAttributes";
    private static final String[] SET_ATTRIBUTES_SIG = new String[]{ObjectName.class.getName(), AttributeList.class.getName()};
    private static final String INVOKE = "invoke";
    private static final String[] INVOKE_SIG = new String[]{ObjectName.class.getName(), String.class.getName(), Object[].class.getName(), String[].class.getName()};
    private static final String GET_DEFAULT_DOMAIN = "getDefaultDomain";
    private static final String[] GET_DEFAULT_DOMAIN_SIG = NO_ARGS_SIG;
    private static final String GET_DOMAINS = "getDomains";
    private static final String[] GET_DOMAINS_SIG = NO_ARGS_SIG;
    private static final String ADD_NOTIFICATION_LISTENER = "addNotificationListener";
    private static final String[] ADD_NOTIFICATION_LISTENER_SIG_1 = new String[]{ObjectName.class.getName(), NotificationListener.class.getName(), NotificationFilter.class.getName(), Object.class.getName()};
    private static final String[] ADD_NOTIFICATION_LISTENER_SIG_2 = new String[]{ObjectName.class.getName(), ObjectName.class.getName(), NotificationFilter.class.getName(), Object.class.getName()};
    private static final String REMOVE_NOTIFICATION_LISTENER = "addNotificationListener";
    private static final String[] REMOVE_NOTIFICATION_LISTENER_SIG_1 = new String[]{ObjectName.class.getName(), ObjectName.class.getName()};
    private static final String[] REMOVE_NOTIFICATION_LISTENER_SIG_2 = new String[]{ObjectName.class.getName(), ObjectName.class.getName(), NotificationFilter.class.getName(), Object.class.getName()};
    private static final String[] REMOVE_NOTIFICATION_LISTENER_SIG_3 = new String[]{ObjectName.class.getName(), NotificationListener.class.getName()};
    private static final String[] REMOVE_NOTIFICATION_LISTENER_SIG_4 = new String[]{ObjectName.class.getName(), NotificationListener.class.getName(), NotificationFilter.class.getName(), Object.class.getName()};
    private static final String GET_MBEAN_INFO = "getMBeanInfo";
    private static final String[] GET_MBEAN_INFO_SIG = OBJECT_NAME_ONLY_SIG;
    private static final String IS_INSTANCE_OF = "isInstanceOf";
    private static final String[] IS_INSTANCE_OF_SIG = new String[]{ObjectName.class.getName(), String.class.getName()};
    private static final String INSTANTIATE = "instantiate";
    private static final String[] INSTANTIATE_SIG1 = new String[]{String.class.getName()};
    private static final String[] INSTANTIATE_SIG2 = new String[]{String.class.getName(), ObjectName.class.getName()};
    private static final String[] INSTANTIATE_SIG3 = new String[]{String.class.getName(), Object[].class.getName(), String[].class.getName()};
    private static final String[] INSTANTIATE_SIG4 = new String[]{String.class.getName(), ObjectName.class.getName(), Object[].class.getName(), String[].class.getName()};
    private static final String DESERIALIZE = "deserialize";
    private static final String[] DESERIALIZE_SIG1 = new String[]{ObjectName.class.getName(), byte[].class.getName()};
    private static final String[] DESERIALIZE_SIG2 = new String[]{String.class.getName(), byte[].class.getName()};
    private static final String[] DESERIALIZE_SIG3 = new String[]{String.class.getName(), ObjectName.class.getName(), byte[].class.getName()};
    private static final String GET_CLASSLOADER_FOR = "getClassLoaderFor";
    private static final String[] GET_CLASSLOADER_FOR_SIG = OBJECT_NAME_ONLY_SIG;
    private static final String GET_CLASSLOADER = "getClassLoader";
    private static final String[] GET_CLASSLOADER_SIG = OBJECT_NAME_ONLY_SIG;
    private static final String GET_CLASSLOADER_REPOSITORY = "getClassLoaderRepository";
    private static final String[] GET_CLASSLOADER_REPOSITORY_SIG = NO_ARGS_SIG;
    private final MBeanServer delegate;
    private final EventAdminLogger logger;

    public EventAdminMBeanServerWrapper(MBeanServer delegate, EventAdminLogger logger) {
        this.delegate = Objects.requireNonNull(delegate);
        this.logger = Objects.requireNonNull(logger);
    }

    private void log(String methodName, String[] signature, Object result, Throwable error, Object ... params) {
        this.logger.log(methodName, signature, result, error, params);
    }

    @Override
    public ObjectInstance createMBean(String className, ObjectName name) throws ReflectionException, InstanceAlreadyExistsException, MBeanException, NotCompliantMBeanException {
        ObjectInstance objectInstance;
        Throwable error = null;
        ObjectInstance result = null;
        try {
            objectInstance = result = this.delegate.createMBean(className, name);
        }
        catch (Throwable e) {
            try {
                error = e;
                throw e;
            }
            catch (Throwable throwable) {
                this.log(CREATE_MBEAN, CREATE_MBEAN_SIG_1, result, error, className, name);
                throw throwable;
            }
        }
        this.log(CREATE_MBEAN, CREATE_MBEAN_SIG_1, result, error, className, name);
        return objectInstance;
    }

    @Override
    public ObjectInstance createMBean(String className, ObjectName name, ObjectName loaderName) throws ReflectionException, InstanceAlreadyExistsException, MBeanException, NotCompliantMBeanException, InstanceNotFoundException {
        ObjectInstance objectInstance;
        Throwable error = null;
        ObjectInstance result = null;
        try {
            objectInstance = result = this.delegate.createMBean(className, name, loaderName);
        }
        catch (Throwable e) {
            try {
                error = e;
                throw e;
            }
            catch (Throwable throwable) {
                this.log(CREATE_MBEAN, CREATE_MBEAN_SIG_2, result, error, className, name, loaderName);
                throw throwable;
            }
        }
        this.log(CREATE_MBEAN, CREATE_MBEAN_SIG_2, result, error, className, name, loaderName);
        return objectInstance;
    }

    @Override
    public ObjectInstance createMBean(String className, ObjectName name, Object[] params, String[] signature) throws ReflectionException, InstanceAlreadyExistsException, MBeanException, NotCompliantMBeanException {
        ObjectInstance objectInstance;
        Throwable error = null;
        ObjectInstance result = null;
        try {
            objectInstance = result = this.delegate.createMBean(className, name, params, signature);
        }
        catch (Throwable e) {
            try {
                error = e;
                throw e;
            }
            catch (Throwable throwable) {
                this.log(CREATE_MBEAN, CREATE_MBEAN_SIG_3, result, error, className, name, params, signature);
                throw throwable;
            }
        }
        this.log(CREATE_MBEAN, CREATE_MBEAN_SIG_3, result, error, className, name, params, signature);
        return objectInstance;
    }

    @Override
    public ObjectInstance createMBean(String className, ObjectName name, ObjectName loaderName, Object[] params, String[] signature) throws ReflectionException, InstanceAlreadyExistsException, MBeanException, NotCompliantMBeanException, InstanceNotFoundException {
        ObjectInstance objectInstance;
        Throwable error = null;
        ObjectInstance result = null;
        try {
            objectInstance = result = this.delegate.createMBean(className, name, loaderName, params, signature);
        }
        catch (Throwable e) {
            try {
                error = e;
                throw e;
            }
            catch (Throwable throwable) {
                this.log(CREATE_MBEAN, CREATE_MBEAN_SIG_4, result, error, className, name, loaderName, params, signature);
                throw throwable;
            }
        }
        this.log(CREATE_MBEAN, CREATE_MBEAN_SIG_4, result, error, className, name, loaderName, params, signature);
        return objectInstance;
    }

    @Override
    public ObjectInstance registerMBean(Object object, ObjectName name) throws InstanceAlreadyExistsException, MBeanRegistrationException, NotCompliantMBeanException {
        ObjectInstance objectInstance;
        Throwable error = null;
        ObjectInstance result = null;
        try {
            objectInstance = result = this.delegate.registerMBean(object, name);
        }
        catch (Throwable e) {
            try {
                error = e;
                throw e;
            }
            catch (Throwable throwable) {
                this.log(REGISTER_MBEAN, REGISTER_MBEAN_SIG, result, error, object, name);
                throw throwable;
            }
        }
        this.log(REGISTER_MBEAN, REGISTER_MBEAN_SIG, result, error, object, name);
        return objectInstance;
    }

    @Override
    public void unregisterMBean(ObjectName name) throws InstanceNotFoundException, MBeanRegistrationException {
        Throwable error = null;
        try {
            this.delegate.unregisterMBean(name);
        }
        catch (Throwable e) {
            try {
                error = e;
                throw e;
            }
            catch (Throwable throwable) {
                this.log(UNREGISTER_MBEAN, UNREGISTER_MBEAN_SIG, null, error, name);
                throw throwable;
            }
        }
        this.log(UNREGISTER_MBEAN, UNREGISTER_MBEAN_SIG, null, error, name);
    }

    @Override
    public ObjectInstance getObjectInstance(ObjectName name) throws InstanceNotFoundException {
        ObjectInstance objectInstance;
        Throwable error = null;
        ObjectInstance result = null;
        try {
            objectInstance = result = this.delegate.getObjectInstance(name);
        }
        catch (Throwable e) {
            try {
                error = e;
                throw e;
            }
            catch (Throwable throwable) {
                this.log(GET_OBJECT_INSTANCE, GET_OBJECT_INSTANCE_SIG, result, error, name);
                throw throwable;
            }
        }
        this.log(GET_OBJECT_INSTANCE, GET_OBJECT_INSTANCE_SIG, result, error, name);
        return objectInstance;
    }

    @Override
    public Set<ObjectInstance> queryMBeans(ObjectName name, QueryExp query) {
        Set<ObjectInstance> set;
        Throwable error = null;
        Set<ObjectInstance> result = null;
        try {
            set = result = this.delegate.queryMBeans(name, query);
        }
        catch (Throwable e) {
            try {
                error = e;
                throw e;
            }
            catch (Throwable throwable) {
                this.log("queryMBeans", QUERY_MBEANS_SIG, result, error, name, query);
                throw throwable;
            }
        }
        this.log("queryMBeans", QUERY_MBEANS_SIG, result, error, name, query);
        return set;
    }

    @Override
    public Set<ObjectName> queryNames(ObjectName name, QueryExp query) {
        Set<ObjectName> set;
        Throwable error = null;
        Set<ObjectName> result = null;
        try {
            set = result = this.delegate.queryNames(name, query);
        }
        catch (Throwable e) {
            try {
                error = e;
                throw e;
            }
            catch (Throwable throwable) {
                this.log("queryMBeans", QUERY_NAMES_SIG, result, error, name, query);
                throw throwable;
            }
        }
        this.log("queryMBeans", QUERY_NAMES_SIG, result, error, name, query);
        return set;
    }

    @Override
    public boolean isRegistered(ObjectName name) {
        boolean bl;
        Throwable error = null;
        Boolean result = null;
        try {
            result = this.delegate.isRegistered(name);
            bl = result;
        }
        catch (Throwable e) {
            try {
                error = e;
                throw e;
            }
            catch (Throwable throwable) {
                this.log(IS_REGISTERED, IS_REGISTERED_SIG, result, error, name);
                throw throwable;
            }
        }
        this.log(IS_REGISTERED, IS_REGISTERED_SIG, result, error, name);
        return bl;
    }

    @Override
    public Integer getMBeanCount() {
        Throwable error = null;
        Integer result = null;
        try {
            Integer n = result = this.delegate.getMBeanCount();
            return n;
        }
        catch (Throwable e) {
            error = e;
            throw e;
        }
        finally {
            this.log(GET_MBEAN_COUNT, GET_MBEAN_COUNT_SIG, result, error, new Object[0]);
        }
    }

    @Override
    public Object getAttribute(ObjectName name, String attribute) throws MBeanException, AttributeNotFoundException, InstanceNotFoundException, ReflectionException {
        Object object;
        Throwable error = null;
        Object result = null;
        try {
            object = result = this.delegate.getAttribute(name, attribute);
        }
        catch (Throwable e) {
            try {
                error = e;
                throw e;
            }
            catch (Throwable throwable) {
                this.log(GET_ATTRIBUTE, GET_ATTRIBUTE_SIG, result, error, name, attribute);
                throw throwable;
            }
        }
        this.log(GET_ATTRIBUTE, GET_ATTRIBUTE_SIG, result, error, name, attribute);
        return object;
    }

    @Override
    public AttributeList getAttributes(ObjectName name, String[] attributes) throws InstanceNotFoundException, ReflectionException {
        AttributeList attributeList;
        Throwable error = null;
        AttributeList result = null;
        try {
            attributeList = result = this.delegate.getAttributes(name, attributes);
        }
        catch (Throwable e) {
            try {
                error = e;
                throw e;
            }
            catch (Throwable throwable) {
                this.log(GET_ATTRIBUTES, GET_ATTRIBUTES_SIG, result, error, name, attributes);
                throw throwable;
            }
        }
        this.log(GET_ATTRIBUTES, GET_ATTRIBUTES_SIG, result, error, name, attributes);
        return attributeList;
    }

    @Override
    public void setAttribute(ObjectName name, Attribute attribute) throws InstanceNotFoundException, AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        Throwable error = null;
        try {
            this.delegate.setAttribute(name, attribute);
        }
        catch (Throwable e) {
            try {
                error = e;
                throw e;
            }
            catch (Throwable throwable) {
                this.log(SET_ATTRIBUTE, SET_ATTRIBUTE_SIG, null, error, name, attribute);
                throw throwable;
            }
        }
        this.log(SET_ATTRIBUTE, SET_ATTRIBUTE_SIG, null, error, name, attribute);
    }

    @Override
    public AttributeList setAttributes(ObjectName name, AttributeList attributes) throws InstanceNotFoundException, ReflectionException {
        AttributeList attributeList;
        Throwable error = null;
        AttributeList result = null;
        try {
            attributeList = result = this.delegate.setAttributes(name, attributes);
        }
        catch (Throwable e) {
            try {
                error = e;
                throw e;
            }
            catch (Throwable throwable) {
                this.log(SET_ATTRIBUTES, SET_ATTRIBUTES_SIG, result, error, name, attributes);
                throw throwable;
            }
        }
        this.log(SET_ATTRIBUTES, SET_ATTRIBUTES_SIG, result, error, name, attributes);
        return attributeList;
    }

    @Override
    public Object invoke(ObjectName name, String operationName, Object[] params, String[] signature) throws InstanceNotFoundException, MBeanException, ReflectionException {
        Object object;
        Throwable error = null;
        Object result = null;
        try {
            object = result = this.delegate.invoke(name, operationName, params, signature);
        }
        catch (Throwable e) {
            try {
                error = e;
                throw e;
            }
            catch (Throwable throwable) {
                this.log(INVOKE, INVOKE_SIG, result, error, name, operationName, params, signature);
                throw throwable;
            }
        }
        this.log(INVOKE, INVOKE_SIG, result, error, name, operationName, params, signature);
        return object;
    }

    @Override
    public String getDefaultDomain() {
        Throwable error = null;
        String result = null;
        try {
            String string = result = this.delegate.getDefaultDomain();
            return string;
        }
        catch (Throwable e) {
            error = e;
            throw e;
        }
        finally {
            this.log(GET_DEFAULT_DOMAIN, GET_DEFAULT_DOMAIN_SIG, result, error, new Object[0]);
        }
    }

    @Override
    public String[] getDomains() {
        Throwable error = null;
        String[] result = null;
        try {
            String[] stringArray = result = this.delegate.getDomains();
            return stringArray;
        }
        catch (Throwable e) {
            error = e;
            throw e;
        }
        finally {
            this.log(GET_DOMAINS, GET_DOMAINS_SIG, result, error, new Object[0]);
        }
    }

    @Override
    public void addNotificationListener(ObjectName name, NotificationListener listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException {
        Throwable error = null;
        try {
            this.delegate.addNotificationListener(name, listener, filter, handback);
        }
        catch (Throwable e) {
            try {
                error = e;
                throw e;
            }
            catch (Throwable throwable) {
                this.log("addNotificationListener", ADD_NOTIFICATION_LISTENER_SIG_1, null, error, name, listener, filter, handback);
                throw throwable;
            }
        }
        this.log("addNotificationListener", ADD_NOTIFICATION_LISTENER_SIG_1, null, error, name, listener, filter, handback);
    }

    @Override
    public void addNotificationListener(ObjectName name, ObjectName listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException {
        Throwable error = null;
        try {
            this.delegate.addNotificationListener(name, listener, filter, handback);
        }
        catch (Throwable e) {
            try {
                error = e;
                throw e;
            }
            catch (Throwable throwable) {
                this.log("addNotificationListener", ADD_NOTIFICATION_LISTENER_SIG_2, null, error, name, listener, filter, handback);
                throw throwable;
            }
        }
        this.log("addNotificationListener", ADD_NOTIFICATION_LISTENER_SIG_2, null, error, name, listener, filter, handback);
    }

    @Override
    public void removeNotificationListener(ObjectName name, ObjectName listener) throws InstanceNotFoundException, ListenerNotFoundException {
        Throwable error = null;
        try {
            this.delegate.removeNotificationListener(name, listener);
        }
        catch (Throwable e) {
            try {
                error = e;
                throw e;
            }
            catch (Throwable throwable) {
                this.log("addNotificationListener", REMOVE_NOTIFICATION_LISTENER_SIG_1, null, error, name, listener);
                throw throwable;
            }
        }
        this.log("addNotificationListener", REMOVE_NOTIFICATION_LISTENER_SIG_1, null, error, name, listener);
    }

    @Override
    public void removeNotificationListener(ObjectName name, ObjectName listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException, ListenerNotFoundException {
        Throwable error = null;
        try {
            this.delegate.removeNotificationListener(name, listener, filter, handback);
        }
        catch (Throwable e) {
            try {
                error = e;
                throw e;
            }
            catch (Throwable throwable) {
                this.log("addNotificationListener", REMOVE_NOTIFICATION_LISTENER_SIG_2, null, error, name, listener, filter, handback);
                throw throwable;
            }
        }
        this.log("addNotificationListener", REMOVE_NOTIFICATION_LISTENER_SIG_2, null, error, name, listener, filter, handback);
    }

    @Override
    public void removeNotificationListener(ObjectName name, NotificationListener listener) throws InstanceNotFoundException, ListenerNotFoundException {
        Throwable error = null;
        try {
            this.delegate.removeNotificationListener(name, listener);
        }
        catch (Throwable e) {
            try {
                error = e;
                throw e;
            }
            catch (Throwable throwable) {
                this.log("addNotificationListener", REMOVE_NOTIFICATION_LISTENER_SIG_3, null, error, name, listener);
                throw throwable;
            }
        }
        this.log("addNotificationListener", REMOVE_NOTIFICATION_LISTENER_SIG_3, null, error, name, listener);
    }

    @Override
    public void removeNotificationListener(ObjectName name, NotificationListener listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException, ListenerNotFoundException {
        Throwable error = null;
        try {
            this.delegate.removeNotificationListener(name, listener, filter, handback);
        }
        catch (Throwable e) {
            try {
                error = e;
                throw e;
            }
            catch (Throwable throwable) {
                this.log("addNotificationListener", REMOVE_NOTIFICATION_LISTENER_SIG_4, null, error, name, listener, filter, handback);
                throw throwable;
            }
        }
        this.log("addNotificationListener", REMOVE_NOTIFICATION_LISTENER_SIG_4, null, error, name, listener, filter, handback);
    }

    @Override
    public MBeanInfo getMBeanInfo(ObjectName name) throws InstanceNotFoundException, IntrospectionException, ReflectionException {
        MBeanInfo mBeanInfo;
        Throwable error = null;
        MBeanInfo result = null;
        try {
            mBeanInfo = result = this.delegate.getMBeanInfo(name);
        }
        catch (Throwable e) {
            try {
                error = e;
                throw e;
            }
            catch (Throwable throwable) {
                this.log(GET_MBEAN_INFO, GET_MBEAN_INFO_SIG, result, error, name);
                throw throwable;
            }
        }
        this.log(GET_MBEAN_INFO, GET_MBEAN_INFO_SIG, result, error, name);
        return mBeanInfo;
    }

    @Override
    public boolean isInstanceOf(ObjectName name, String className) throws InstanceNotFoundException {
        boolean bl;
        Throwable error = null;
        Boolean result = null;
        try {
            result = this.delegate.isInstanceOf(name, className);
            bl = result;
        }
        catch (Throwable e) {
            try {
                error = e;
                throw e;
            }
            catch (Throwable throwable) {
                this.log(IS_INSTANCE_OF, IS_INSTANCE_OF_SIG, result, error, name, className);
                throw throwable;
            }
        }
        this.log(IS_INSTANCE_OF, IS_INSTANCE_OF_SIG, result, error, name, className);
        return bl;
    }

    @Override
    public Object instantiate(String className) throws ReflectionException, MBeanException {
        Object object;
        Throwable error = null;
        Object result = null;
        try {
            object = result = this.delegate.instantiate(className);
        }
        catch (Throwable e) {
            try {
                error = e;
                throw e;
            }
            catch (Throwable throwable) {
                this.log(INSTANTIATE, INSTANTIATE_SIG1, result, error, className);
                throw throwable;
            }
        }
        this.log(INSTANTIATE, INSTANTIATE_SIG1, result, error, className);
        return object;
    }

    @Override
    public Object instantiate(String className, ObjectName loaderName) throws ReflectionException, MBeanException, InstanceNotFoundException {
        Object object;
        Throwable error = null;
        Object result = null;
        try {
            object = result = this.delegate.instantiate(className, loaderName);
        }
        catch (Throwable e) {
            try {
                error = e;
                throw e;
            }
            catch (Throwable throwable) {
                this.log(INSTANTIATE, INSTANTIATE_SIG2, result, error, className, loaderName);
                throw throwable;
            }
        }
        this.log(INSTANTIATE, INSTANTIATE_SIG2, result, error, className, loaderName);
        return object;
    }

    @Override
    public Object instantiate(String className, Object[] params, String[] signature) throws ReflectionException, MBeanException {
        Object object;
        Throwable error = null;
        Object result = null;
        try {
            object = result = this.delegate.instantiate(className, params, signature);
        }
        catch (Throwable e) {
            try {
                error = e;
                throw e;
            }
            catch (Throwable throwable) {
                this.log(INSTANTIATE, INSTANTIATE_SIG3, result, error, className, params, signature);
                throw throwable;
            }
        }
        this.log(INSTANTIATE, INSTANTIATE_SIG3, result, error, className, params, signature);
        return object;
    }

    @Override
    public Object instantiate(String className, ObjectName loaderName, Object[] params, String[] signature) throws ReflectionException, MBeanException, InstanceNotFoundException {
        Object object;
        Throwable error = null;
        Object result = null;
        try {
            object = result = this.delegate.instantiate(className, loaderName, params, signature);
        }
        catch (Throwable e) {
            try {
                error = e;
                throw e;
            }
            catch (Throwable throwable) {
                this.log(INSTANTIATE, INSTANTIATE_SIG4, result, error, className, loaderName, params, signature);
                throw throwable;
            }
        }
        this.log(INSTANTIATE, INSTANTIATE_SIG4, result, error, className, loaderName, params, signature);
        return object;
    }

    @Override
    @Deprecated
    public ObjectInputStream deserialize(ObjectName name, byte[] data) throws OperationsException {
        ObjectInputStream objectInputStream;
        Throwable error = null;
        ObjectInputStream result = null;
        try {
            objectInputStream = result = this.delegate.deserialize(name, data);
        }
        catch (Throwable e) {
            try {
                error = e;
                throw e;
            }
            catch (Throwable throwable) {
                this.log(DESERIALIZE, DESERIALIZE_SIG1, result, error, name, data);
                throw throwable;
            }
        }
        this.log(DESERIALIZE, DESERIALIZE_SIG1, result, error, name, data);
        return objectInputStream;
    }

    @Override
    @Deprecated
    public ObjectInputStream deserialize(String className, byte[] data) throws OperationsException, ReflectionException {
        ObjectInputStream objectInputStream;
        Throwable error = null;
        ObjectInputStream result = null;
        try {
            objectInputStream = result = this.delegate.deserialize(className, data);
        }
        catch (Throwable e) {
            try {
                error = e;
                throw e;
            }
            catch (Throwable throwable) {
                this.log(DESERIALIZE, DESERIALIZE_SIG2, result, error, className, data);
                throw throwable;
            }
        }
        this.log(DESERIALIZE, DESERIALIZE_SIG2, result, error, className, data);
        return objectInputStream;
    }

    @Override
    @Deprecated
    public ObjectInputStream deserialize(String className, ObjectName loaderName, byte[] data) throws OperationsException, ReflectionException {
        ObjectInputStream objectInputStream;
        Throwable error = null;
        ObjectInputStream result = null;
        try {
            objectInputStream = result = this.delegate.deserialize(className, loaderName, data);
        }
        catch (Throwable e) {
            try {
                error = e;
                throw e;
            }
            catch (Throwable throwable) {
                this.log(DESERIALIZE, DESERIALIZE_SIG3, result, error, className, loaderName, data);
                throw throwable;
            }
        }
        this.log(DESERIALIZE, DESERIALIZE_SIG3, result, error, className, loaderName, data);
        return objectInputStream;
    }

    @Override
    public ClassLoader getClassLoaderFor(ObjectName mbeanName) throws InstanceNotFoundException {
        ClassLoader classLoader;
        Throwable error = null;
        ClassLoader result = null;
        try {
            classLoader = result = this.delegate.getClassLoaderFor(mbeanName);
        }
        catch (Throwable e) {
            try {
                error = e;
                throw e;
            }
            catch (Throwable throwable) {
                this.log(GET_CLASSLOADER_FOR, GET_CLASSLOADER_FOR_SIG, result, error, mbeanName);
                throw throwable;
            }
        }
        this.log(GET_CLASSLOADER_FOR, GET_CLASSLOADER_FOR_SIG, result, error, mbeanName);
        return classLoader;
    }

    @Override
    public ClassLoader getClassLoader(ObjectName loaderName) throws InstanceNotFoundException {
        ClassLoader classLoader;
        Throwable error = null;
        ClassLoader result = null;
        try {
            classLoader = result = this.delegate.getClassLoader(loaderName);
        }
        catch (Throwable e) {
            try {
                error = e;
                throw e;
            }
            catch (Throwable throwable) {
                this.log(GET_CLASSLOADER, GET_CLASSLOADER_SIG, result, error, loaderName);
                throw throwable;
            }
        }
        this.log(GET_CLASSLOADER, GET_CLASSLOADER_SIG, result, error, loaderName);
        return classLoader;
    }

    @Override
    public ClassLoaderRepository getClassLoaderRepository() {
        Throwable error = null;
        ClassLoaderRepository result = null;
        try {
            ClassLoaderRepository classLoaderRepository = result = this.delegate.getClassLoaderRepository();
            return classLoaderRepository;
        }
        catch (Throwable e) {
            error = e;
            throw e;
        }
        finally {
            this.log(GET_CLASSLOADER_REPOSITORY, GET_CLASSLOADER_REPOSITORY_SIG, result, error, new Object[0]);
        }
    }

    public MBeanServer getDelegate() {
        return this.delegate;
    }
}

