/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.server.scp;

import java.io.IOException;
import java.util.Collections;
import org.apache.sshd.common.scp.ScpException;
import org.apache.sshd.common.scp.ScpFileOpener;
import org.apache.sshd.common.scp.ScpHelper;
import org.apache.sshd.common.scp.ScpTransferEventListener;
import org.apache.sshd.common.scp.helpers.DefaultScpFileOpener;
import org.apache.sshd.common.session.Session;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.threads.CloseableExecutorService;
import org.apache.sshd.server.Environment;
import org.apache.sshd.server.ExitCallback;
import org.apache.sshd.server.channel.ChannelSession;
import org.apache.sshd.server.command.AbstractFileSystemCommand;
import org.apache.sshd.server.session.ServerSession;

public class ScpCommand
extends AbstractFileSystemCommand {
    protected final int sendBufferSize;
    protected final int receiveBufferSize;
    protected final ScpFileOpener opener;
    protected boolean optR;
    protected boolean optT;
    protected boolean optF;
    protected boolean optD;
    protected boolean optP;
    protected String path;
    protected IOException error;
    protected ScpTransferEventListener listener;

    public ScpCommand(String command, CloseableExecutorService executorService, int sendSize, int receiveSize, ScpFileOpener fileOpener, ScpTransferEventListener eventListener) {
        super(command, executorService);
        if (sendSize < 127) {
            throw new IllegalArgumentException("<ScpCommmand>(" + command + ") send buffer size (" + sendSize + ") below minimum required (" + 127 + ")");
        }
        this.sendBufferSize = sendSize;
        if (receiveSize < 127) {
            throw new IllegalArgumentException("<ScpCommmand>(" + command + ") receive buffer size (" + sendSize + ") below minimum required (" + 127 + ")");
        }
        this.receiveBufferSize = receiveSize;
        this.opener = fileOpener == null ? DefaultScpFileOpener.INSTANCE : fileOpener;
        this.listener = eventListener == null ? ScpTransferEventListener.EMPTY : eventListener;
        boolean debugEnabled = this.log.isDebugEnabled();
        if (debugEnabled) {
            this.log.debug("Executing command {}", (Object)command);
        }
        Object[] args = GenericUtils.split((String)command, (char)' ');
        int numArgs = GenericUtils.length((Object[])args);
        for (int i = 1; i < numArgs; ++i) {
            char endDelim;
            Object argVal = args[i];
            if (((String)argVal).charAt(0) == '-') {
                block8: for (int j = 1; j < ((String)argVal).length(); ++j) {
                    char option = ((String)argVal).charAt(j);
                    switch (option) {
                        case 'f': {
                            this.optF = true;
                            continue block8;
                        }
                        case 'p': {
                            this.optP = true;
                            continue block8;
                        }
                        case 'r': {
                            this.optR = true;
                            continue block8;
                        }
                        case 't': {
                            this.optT = true;
                            continue block8;
                        }
                        case 'd': {
                            this.optD = true;
                            continue block8;
                        }
                        default: {
                            if (!debugEnabled) continue block8;
                            this.log.debug("Unknown flag ('{}') in command={}", (Object)Character.valueOf(option), (Object)command);
                        }
                    }
                }
                continue;
            }
            Object prevArg = args[i - 1];
            this.path = command.substring(command.indexOf((String)prevArg) + ((String)prevArg).length() + 1);
            int pathLen = this.path.length();
            char startDelim = this.path.charAt(0);
            char c = endDelim = pathLen > 2 ? this.path.charAt(pathLen - 1) : (char)'\u0000';
            if (pathLen <= 2 || startDelim != endDelim || startDelim != '\'' && startDelim != '\"') break;
            this.path = this.path.substring(1, pathLen - 1);
            break;
        }
        if (!this.optF && !this.optT) {
            this.error = new IOException("Either -f or -t option should be set for " + command);
        }
    }

    public void start(ChannelSession channel, Environment env) throws IOException {
        if (this.error != null) {
            throw this.error;
        }
        super.start(channel, env);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        String exitMessage;
        int exitValue;
        block14: {
            exitValue = 0;
            exitMessage = null;
            ServerSession session = this.getServerSession();
            String command = this.getCommand();
            ScpHelper helper = new ScpHelper((Session)session, this.getInputStream(), this.getOutputStream(), this.fileSystem, this.opener, this.listener);
            try {
                if (this.optT) {
                    helper.receive(helper.resolveLocalPath(this.path), this.optR, this.optD, this.optP, this.receiveBufferSize);
                    break block14;
                }
                if (this.optF) {
                    helper.send(Collections.singletonList(this.path), this.optR, this.optP, this.sendBufferSize);
                    break block14;
                }
                throw new IOException("Unsupported mode");
            }
            catch (IOException e) {
                ExitCallback callback;
                block16: {
                    try {
                        boolean debugEnabled;
                        block15: {
                            debugEnabled = this.log.isDebugEnabled();
                            try {
                                Integer statusCode = null;
                                if (e instanceof ScpException) {
                                    statusCode = ((ScpException)e).getExitStatus();
                                }
                                int n = exitValue = statusCode == null ? 2 : statusCode;
                                if (exitValue == 0 || exitValue == 1) {
                                    if (debugEnabled) {
                                        this.log.debug("run({})[{}] normalize status code={}", new Object[]{session, command, exitValue});
                                    }
                                    exitValue = 2;
                                }
                                exitMessage = GenericUtils.trimToEmpty((String)e.getMessage());
                                this.writeCommandResponseMessage(command, exitValue, exitMessage);
                            }
                            catch (IOException e2) {
                                this.log.error("run({})[{}] Failed ({}) to send error response: {}", new Object[]{session, command, e.getClass().getSimpleName(), e.getMessage()});
                                if (!debugEnabled) break block15;
                                this.log.error("run(" + session + ")[" + command + "] error response failure details", (Throwable)e2);
                            }
                        }
                        this.log.error("run({})[{}] Failed ({}) to run command: {}", new Object[]{session, command, e.getClass().getSimpleName(), e.getMessage()});
                        if (!debugEnabled) break block16;
                        this.log.error("run(" + session + ")[" + command + "] command execution failure details", (Throwable)e);
                    }
                    catch (Throwable throwable) {
                        ExitCallback callback2 = this.getExitCallback();
                        if (callback2 != null) {
                            callback2.onExit(exitValue, GenericUtils.trimToEmpty(exitMessage));
                        }
                        throw throwable;
                    }
                }
                if ((callback = this.getExitCallback()) != null) {
                    callback.onExit(exitValue, GenericUtils.trimToEmpty((String)exitMessage));
                }
            }
        }
        ExitCallback callback = this.getExitCallback();
        if (callback != null) {
            callback.onExit(exitValue, GenericUtils.trimToEmpty(exitMessage));
        }
    }

    protected void writeCommandResponseMessage(String command, int exitValue, String exitMessage) throws IOException {
        if (this.log.isDebugEnabled()) {
            this.log.debug("writeCommandResponseMessage({}) command='{}', exit-status={}: {}", new Object[]{this.getServerSession(), command, exitValue, exitMessage});
        }
        ScpHelper.sendResponseMessage(this.getOutputStream(), exitValue, exitMessage);
    }

    public String toString() {
        return super.toString() + "[" + this.getSession() + "]";
    }
}

