/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.eventadmin.impl;

import java.util.Dictionary;
import java.util.Hashtable;
import java.util.StringTokenizer;
import org.apache.felix.eventadmin.impl.MetaTypeProviderImpl;
import org.apache.felix.eventadmin.impl.adapter.AbstractAdapter;
import org.apache.felix.eventadmin.impl.adapter.BundleEventAdapter;
import org.apache.felix.eventadmin.impl.adapter.FrameworkEventAdapter;
import org.apache.felix.eventadmin.impl.adapter.LogEventAdapter;
import org.apache.felix.eventadmin.impl.adapter.ServiceEventAdapter;
import org.apache.felix.eventadmin.impl.handler.EventAdminImpl;
import org.apache.felix.eventadmin.impl.security.SecureEventAdminFactory;
import org.apache.felix.eventadmin.impl.tasks.DefaultThreadPool;
import org.apache.felix.eventadmin.impl.util.LogWrapper;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.cm.ManagedService;
import org.osgi.service.event.EventAdmin;
import org.osgi.service.metatype.MetaTypeProvider;

public class Configuration {
    static final String PID = "org.apache.felix.eventadmin.impl.EventAdmin";
    static final String PROP_THREAD_POOL_SIZE = "org.apache.felix.eventadmin.ThreadPoolSize";
    static final String PROP_ASYNC_TO_SYNC_THREAD_RATIO = "org.apache.felix.eventadmin.AsyncToSyncThreadRatio";
    static final String PROP_TIMEOUT = "org.apache.felix.eventadmin.Timeout";
    static final String PROP_REQUIRE_TOPIC = "org.apache.felix.eventadmin.RequireTopic";
    static final String PROP_IGNORE_TIMEOUT = "org.apache.felix.eventadmin.IgnoreTimeout";
    static final String PROP_IGNORE_TOPIC = "org.apache.felix.eventadmin.IgnoreTopic";
    static final String PROP_LOG_LEVEL = "org.apache.felix.eventadmin.LogLevel";
    static final String PROP_ADD_TIMESTAMP = "org.apache.felix.eventadmin.AddTimestamp";
    static final String PROP_ADD_SUBJECT = "org.apache.felix.eventadmin.AddSubject";
    private final BundleContext m_bundleContext;
    private int m_threadPoolSize;
    private double m_asyncToSyncThreadRatio;
    private int m_asyncThreadPoolSize;
    private int m_timeout;
    private boolean m_requireTopic;
    private String[] m_ignoreTimeout;
    private String[] m_ignoreTopics;
    private int m_logLevel;
    private boolean m_addTimestamp;
    private boolean m_addSubject;
    private volatile DefaultThreadPool m_sync_pool;
    private volatile DefaultThreadPool m_async_pool;
    private volatile EventAdminImpl m_admin;
    private volatile ServiceRegistration m_registration;
    private AbstractAdapter[] m_adapters;
    private ServiceRegistration m_managedServiceReg;

    public Configuration(BundleContext bundleContext) {
        this.m_bundleContext = bundleContext;
        this.configure(null);
        this.startOrUpdate();
        try {
            Object service = this.tryToCreateManagedService();
            if (service != null) {
                String[] interfaceNames;
                Object enhancedService = this.tryToCreateMetaTypeProvider(service);
                if (enhancedService == null) {
                    interfaceNames = new String[]{ManagedService.class.getName()};
                } else {
                    interfaceNames = new String[]{ManagedService.class.getName(), MetaTypeProvider.class.getName()};
                    service = enhancedService;
                }
                Hashtable<String, String> props = new Hashtable<String, String>();
                ((Dictionary)props).put("service.pid", PID);
                this.m_managedServiceReg = this.m_bundleContext.registerService(interfaceNames, service, props);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    void updateFromConfigAdmin(final Dictionary<String, ?> config) {
        new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Configuration configuration = Configuration.this;
                synchronized (configuration) {
                    Configuration.this.configure(config);
                    Configuration.this.startOrUpdate();
                }
            }
        }.start();
    }

    void configure(Dictionary<String, ?> config) {
        if (config == null) {
            this.m_threadPoolSize = this.getIntProperty(PROP_THREAD_POOL_SIZE, this.m_bundleContext.getProperty(PROP_THREAD_POOL_SIZE), 20, 2);
            this.m_asyncToSyncThreadRatio = this.getDoubleProperty(PROP_ASYNC_TO_SYNC_THREAD_RATIO, this.m_bundleContext.getProperty(PROP_ASYNC_TO_SYNC_THREAD_RATIO), 0.5, 0.0);
            this.m_timeout = this.getIntProperty(PROP_TIMEOUT, this.m_bundleContext.getProperty(PROP_TIMEOUT), 5000, Integer.MIN_VALUE);
            this.m_requireTopic = this.getBooleanProperty(this.m_bundleContext.getProperty(PROP_REQUIRE_TOPIC), true);
            String value = this.m_bundleContext.getProperty(PROP_IGNORE_TIMEOUT);
            if (value == null) {
                this.m_ignoreTimeout = null;
            } else {
                StringTokenizer st = new StringTokenizer(value, ",");
                this.m_ignoreTimeout = new String[st.countTokens()];
                for (int i = 0; i < this.m_ignoreTimeout.length; ++i) {
                    this.m_ignoreTimeout[i] = st.nextToken();
                }
            }
            String valueIgnoreTopic = this.m_bundleContext.getProperty(PROP_IGNORE_TOPIC);
            if (valueIgnoreTopic == null) {
                this.m_ignoreTopics = null;
            } else {
                StringTokenizer st = new StringTokenizer(valueIgnoreTopic, ",");
                this.m_ignoreTopics = new String[st.countTokens()];
                for (int i = 0; i < this.m_ignoreTopics.length; ++i) {
                    this.m_ignoreTopics[i] = st.nextToken();
                }
            }
            this.m_logLevel = this.getIntProperty(PROP_LOG_LEVEL, this.m_bundleContext.getProperty(PROP_LOG_LEVEL), 2, 1);
            this.m_addTimestamp = this.getBooleanProperty(this.m_bundleContext.getProperty(PROP_ADD_TIMESTAMP), false);
            this.m_addSubject = this.getBooleanProperty(this.m_bundleContext.getProperty(PROP_ADD_SUBJECT), false);
        } else {
            this.m_threadPoolSize = this.getIntProperty(PROP_THREAD_POOL_SIZE, config.get(PROP_THREAD_POOL_SIZE), 20, 2);
            this.m_asyncToSyncThreadRatio = this.getDoubleProperty(PROP_ASYNC_TO_SYNC_THREAD_RATIO, this.m_bundleContext.getProperty(PROP_ASYNC_TO_SYNC_THREAD_RATIO), 0.5, 0.0);
            this.m_timeout = this.getIntProperty(PROP_TIMEOUT, config.get(PROP_TIMEOUT), 5000, Integer.MIN_VALUE);
            this.m_requireTopic = this.getBooleanProperty(config.get(PROP_REQUIRE_TOPIC), true);
            this.m_ignoreTimeout = null;
            Object value = config.get(PROP_IGNORE_TIMEOUT);
            if (value instanceof String) {
                this.m_ignoreTimeout = new String[]{(String)value};
            } else if (value instanceof String[]) {
                this.m_ignoreTimeout = (String[])value;
            } else if (value != null) {
                LogWrapper.getLogger().log(2, "Value for property: org.apache.felix.eventadmin.IgnoreTimeout is neither a string nor a string array - Using default");
            }
            this.m_ignoreTopics = null;
            Object valueIT = config.get(PROP_IGNORE_TOPIC);
            if (valueIT instanceof String) {
                this.m_ignoreTopics = new String[]{(String)valueIT};
            } else if (valueIT instanceof String[]) {
                this.m_ignoreTopics = (String[])valueIT;
            } else if (valueIT != null) {
                LogWrapper.getLogger().log(2, "Value for property: org.apache.felix.eventadmin.IgnoreTopic is neither a string nor a string array - Using default");
            }
            this.m_logLevel = this.getIntProperty(PROP_LOG_LEVEL, config.get(PROP_LOG_LEVEL), 2, 1);
            this.m_addTimestamp = this.getBooleanProperty(config.get(PROP_ADD_TIMESTAMP), false);
            this.m_addSubject = this.getBooleanProperty(config.get(PROP_ADD_SUBJECT), false);
        }
        if (this.m_timeout <= 100) {
            this.m_timeout = 0;
        }
        this.m_asyncThreadPoolSize = this.m_threadPoolSize > 5 ? (int)Math.floor((double)this.m_threadPoolSize * this.m_asyncToSyncThreadRatio) : 2;
    }

    private void startOrUpdate() {
        LogWrapper.getLogger().setLogLevel(this.m_logLevel);
        LogWrapper.getLogger().log(4, "org.apache.felix.eventadmin.LogLevel=" + this.m_logLevel);
        LogWrapper.getLogger().log(4, "org.apache.felix.eventadmin.ThreadPoolSize=" + this.m_threadPoolSize);
        LogWrapper.getLogger().log(4, "org.apache.felix.eventadmin.AsyncToSyncThreadRatio=" + this.m_asyncToSyncThreadRatio);
        LogWrapper.getLogger().log(4, "Async Pool Size=" + this.m_asyncThreadPoolSize);
        LogWrapper.getLogger().log(4, "org.apache.felix.eventadmin.Timeout=" + this.m_timeout);
        LogWrapper.getLogger().log(4, "org.apache.felix.eventadmin.RequireTopic=" + this.m_requireTopic);
        if (this.m_sync_pool == null) {
            this.m_sync_pool = new DefaultThreadPool(this.m_threadPoolSize, true);
        } else {
            this.m_sync_pool.configure(this.m_threadPoolSize);
        }
        int asyncThreadPoolSize = this.m_asyncThreadPoolSize;
        if (this.m_async_pool == null) {
            this.m_async_pool = new DefaultThreadPool(asyncThreadPoolSize, false);
        } else {
            this.m_async_pool.configure(asyncThreadPoolSize);
        }
        if (this.m_admin == null) {
            this.m_admin = new EventAdminImpl(this.m_bundleContext, this.m_sync_pool, this.m_async_pool, this.m_timeout, this.m_ignoreTimeout, this.m_requireTopic, this.m_ignoreTopics, this.m_addTimestamp, this.m_addSubject);
            this.adaptEvents(this.m_admin);
            this.m_registration = this.m_bundleContext.registerService(EventAdmin.class.getName(), (Object)new SecureEventAdminFactory(this.m_admin), null);
        } else {
            this.m_admin.update(this.m_timeout, this.m_ignoreTimeout, this.m_requireTopic, this.m_ignoreTopics, this.m_addTimestamp, this.m_addSubject);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        Configuration configuration = this;
        synchronized (configuration) {
            if (this.m_adapters != null) {
                for (int i = 0; i < this.m_adapters.length; ++i) {
                    this.m_adapters[i].destroy(this.m_bundleContext);
                }
                this.m_adapters = null;
            }
            if (this.m_managedServiceReg != null) {
                this.m_managedServiceReg.unregister();
                this.m_managedServiceReg = null;
            }
            if (this.m_registration != null) {
                this.m_registration.unregister();
                this.m_registration = null;
            }
            if (this.m_admin != null) {
                this.m_admin.stop();
                this.m_admin = null;
            }
            if (this.m_async_pool != null) {
                this.m_async_pool.close();
                this.m_async_pool = null;
            }
            if (this.m_sync_pool != null) {
                this.m_sync_pool.close();
                this.m_sync_pool = null;
            }
        }
    }

    private void adaptEvents(EventAdmin admin) {
        this.m_adapters = new AbstractAdapter[4];
        this.m_adapters[0] = new FrameworkEventAdapter(this.m_bundleContext, admin);
        this.m_adapters[1] = new BundleEventAdapter(this.m_bundleContext, admin);
        this.m_adapters[2] = new ServiceEventAdapter(this.m_bundleContext, admin);
        this.m_adapters[3] = new LogEventAdapter(this.m_bundleContext, admin);
    }

    private Object tryToCreateMetaTypeProvider(Object managedService) {
        try {
            return new MetaTypeProviderImpl((ManagedService)managedService, this.m_threadPoolSize, this.m_timeout, this.m_requireTopic, this.m_ignoreTimeout, this.m_ignoreTopics, this.m_asyncToSyncThreadRatio);
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    private Object tryToCreateManagedService() {
        try {
            return new ManagedService(){

                public void updated(Dictionary<String, ?> properties) throws ConfigurationException {
                    Configuration.this.updateFromConfigAdmin(properties);
                }
            };
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    private int getIntProperty(String key, Object value, int defaultValue, int min) {
        if (null != value) {
            int result;
            if (value instanceof Integer) {
                result = (Integer)value;
            } else {
                try {
                    result = Integer.parseInt(value.toString());
                }
                catch (NumberFormatException e) {
                    LogWrapper.getLogger().log(2, "Unable to parse property: " + key + " - Using default", e);
                    return defaultValue;
                }
            }
            if (result >= min) {
                return result;
            }
            LogWrapper.getLogger().log(2, "Value for property: " + key + " is to low - Using default");
        }
        return defaultValue;
    }

    private double getDoubleProperty(String key, Object value, double defaultValue, double min) {
        if (null != value) {
            double result;
            if (value instanceof Double) {
                result = (Double)value;
            } else {
                try {
                    result = Double.parseDouble(value.toString());
                }
                catch (NumberFormatException e) {
                    LogWrapper.getLogger().log(2, "Unable to parse property: " + key + " - Using default", e);
                    return defaultValue;
                }
            }
            if (result >= min) {
                return result;
            }
            LogWrapper.getLogger().log(2, "Value for property: " + key + " is to low - Using default");
        }
        return defaultValue;
    }

    private boolean getBooleanProperty(Object obj, boolean defaultValue) {
        if (null != obj) {
            if (obj instanceof Boolean) {
                return (Boolean)obj;
            }
            String value = obj.toString().trim().toLowerCase();
            if (0 < value.length() && ("0".equals(value) || "false".equals(value) || "no".equals(value))) {
                return false;
            }
            if (0 < value.length() && ("1".equals(value) || "true".equals(value) || "yes".equals(value))) {
                return true;
            }
        }
        return defaultValue;
    }
}

