/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.runtime.isolation;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.connect.runtime.isolation.PluginDesc;
import org.apache.kafka.connect.runtime.isolation.Plugins;
import org.apache.kafka.connect.transforms.Transformation;
import org.apache.kafka.connect.transforms.predicates.Predicate;

public class PluginsRecommenders {
    private final Plugins plugins;
    private final ConverterPluginRecommender converterPluginRecommender;
    private final ConnectorPluginVersionRecommender connectorPluginVersionRecommender;
    private final HeaderConverterPluginRecommender headerConverterPluginRecommender;
    private final KeyConverterPluginVersionRecommender keyConverterPluginVersionRecommender;
    private final ValueConverterPluginVersionRecommender valueConverterPluginVersionRecommender;
    private final HeaderConverterPluginVersionRecommender headerConverterPluginVersionRecommender;

    public PluginsRecommenders() {
        this(null);
    }

    public PluginsRecommenders(Plugins plugins) {
        this.plugins = plugins;
        this.converterPluginRecommender = new ConverterPluginRecommender();
        this.connectorPluginVersionRecommender = new ConnectorPluginVersionRecommender();
        this.headerConverterPluginRecommender = new HeaderConverterPluginRecommender();
        this.keyConverterPluginVersionRecommender = new KeyConverterPluginVersionRecommender();
        this.valueConverterPluginVersionRecommender = new ValueConverterPluginVersionRecommender();
        this.headerConverterPluginVersionRecommender = new HeaderConverterPluginVersionRecommender();
    }

    public ConverterPluginRecommender converterPluginRecommender() {
        return this.converterPluginRecommender;
    }

    public ConnectorPluginVersionRecommender connectorPluginVersionRecommender() {
        return this.connectorPluginVersionRecommender;
    }

    public HeaderConverterPluginRecommender headerConverterPluginRecommender() {
        return this.headerConverterPluginRecommender;
    }

    public KeyConverterPluginVersionRecommender keyConverterPluginVersionRecommender() {
        return this.keyConverterPluginVersionRecommender;
    }

    public ValueConverterPluginVersionRecommender valueConverterPluginVersionRecommender() {
        return this.valueConverterPluginVersionRecommender;
    }

    public HeaderConverterPluginVersionRecommender headerConverterPluginVersionRecommender() {
        return this.headerConverterPluginVersionRecommender;
    }

    public TransformationPluginRecommender transformationPluginRecommender(String classOrAliasConfig) {
        return new TransformationPluginRecommender(classOrAliasConfig);
    }

    public PredicatePluginRecommender predicatePluginRecommender(String classOrAliasConfig) {
        return new PredicatePluginRecommender(classOrAliasConfig);
    }

    public class ConverterPluginRecommender
    implements ConfigDef.Recommender {
        public List<Object> validValues(String name, Map<String, Object> parsedConfig) {
            if (PluginsRecommenders.this.plugins == null) {
                return List.of();
            }
            return PluginsRecommenders.this.plugins.converters().stream().map(PluginDesc::pluginClass).distinct().collect(Collectors.toList());
        }

        public boolean visible(String name, Map<String, Object> parsedConfig) {
            return true;
        }
    }

    public class ConnectorPluginVersionRecommender
    implements ConfigDef.Recommender {
        public List<Object> validValues(String name, Map<String, Object> parsedConfig) {
            if (PluginsRecommenders.this.plugins == null) {
                return List.of();
            }
            String connectorClassOrAlias = (String)parsedConfig.get("connector.class");
            if (connectorClassOrAlias == null) {
                return List.of();
            }
            List<Object> sourceConnectors = PluginsRecommenders.this.plugins.sourceConnectors(connectorClassOrAlias).stream().map(PluginDesc::version).distinct().collect(Collectors.toList());
            if (!sourceConnectors.isEmpty()) {
                return sourceConnectors;
            }
            return PluginsRecommenders.this.plugins.sinkConnectors(connectorClassOrAlias).stream().map(PluginDesc::version).distinct().collect(Collectors.toList());
        }

        public boolean visible(String name, Map<String, Object> parsedConfig) {
            return parsedConfig.get("connector.class") != null;
        }
    }

    public class HeaderConverterPluginRecommender
    implements ConfigDef.Recommender {
        public List<Object> validValues(String name, Map<String, Object> parsedConfig) {
            if (PluginsRecommenders.this.plugins == null) {
                return List.of();
            }
            return PluginsRecommenders.this.plugins.headerConverters().stream().map(PluginDesc::pluginClass).distinct().collect(Collectors.toList());
        }

        public boolean visible(String name, Map<String, Object> parsedConfig) {
            return true;
        }
    }

    public class KeyConverterPluginVersionRecommender
    extends ConverterPluginVersionRecommender {
        @Override
        protected String converterConfig() {
            return "key.converter";
        }
    }

    public class ValueConverterPluginVersionRecommender
    extends ConverterPluginVersionRecommender {
        @Override
        protected String converterConfig() {
            return "value.converter";
        }
    }

    public class HeaderConverterPluginVersionRecommender
    extends ConverterPluginVersionRecommender {
        @Override
        protected String converterConfig() {
            return "header.converter";
        }

        @Override
        protected Function<String, List<Object>> recommendations() {
            return converterClass -> PluginsRecommenders.this.plugins.headerConverters((String)converterClass).stream().map(PluginDesc::version).distinct().collect(Collectors.toList());
        }
    }

    public class TransformationPluginRecommender
    extends SMTPluginRecommender<Transformation<?>> {
        public TransformationPluginRecommender(String classOrAliasConfig) {
            super(classOrAliasConfig);
        }

        @Override
        protected Function<String, Set<PluginDesc<Transformation<?>>>> plugins() {
            return PluginsRecommenders.this.plugins::transformations;
        }
    }

    public class PredicatePluginRecommender
    extends SMTPluginRecommender<Predicate<?>> {
        public PredicatePluginRecommender(String classOrAliasConfig) {
            super(classOrAliasConfig);
        }

        @Override
        protected Function<String, Set<PluginDesc<Predicate<?>>>> plugins() {
            return PluginsRecommenders.this.plugins::predicates;
        }
    }

    public abstract class SMTPluginRecommender<T>
    implements ConfigDef.Recommender {
        protected final String classOrAliasConfig;

        protected abstract Function<String, Set<PluginDesc<T>>> plugins();

        public SMTPluginRecommender(String classOrAliasConfig) {
            this.classOrAliasConfig = classOrAliasConfig;
        }

        public List<Object> validValues(String name, Map<String, Object> parsedConfig) {
            if (PluginsRecommenders.this.plugins == null) {
                return List.of();
            }
            if (parsedConfig.get(this.classOrAliasConfig) == null) {
                return List.of();
            }
            Class classOrAlias = (Class)parsedConfig.get(this.classOrAliasConfig);
            return this.plugins().apply(classOrAlias.getName()).stream().map(PluginDesc::version).distinct().collect(Collectors.toList());
        }

        public boolean visible(String name, Map<String, Object> parsedConfig) {
            return true;
        }
    }

    public abstract class ConverterPluginVersionRecommender
    implements ConfigDef.Recommender {
        protected Function<String, List<Object>> recommendations() {
            return converterClass -> PluginsRecommenders.this.plugins.converters((String)converterClass).stream().map(PluginDesc::version).distinct().collect(Collectors.toList());
        }

        protected abstract String converterConfig();

        public List<Object> validValues(String name, Map<String, Object> parsedConfig) {
            if (PluginsRecommenders.this.plugins == null) {
                return List.of();
            }
            if (parsedConfig.get(this.converterConfig()) == null) {
                return List.of();
            }
            Class converterClass = (Class)parsedConfig.get(this.converterConfig());
            return this.recommendations().apply(converterClass.getName());
        }

        public boolean visible(String name, Map<String, Object> parsedConfig) {
            return parsedConfig.get(this.converterConfig()) != null;
        }
    }
}

