/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.processor.internals.assignment;

import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.PriorityQueue;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.apache.kafka.streams.processor.TaskId;
import org.apache.kafka.streams.processor.assignment.ProcessId;

public class ConstrainedPrioritySet {
    private final PriorityQueue<ProcessId> clientsByTaskLoad;
    private final BiFunction<ProcessId, TaskId, Boolean> constraint;
    private final Set<ProcessId> uniqueClients = new HashSet<ProcessId>();

    public ConstrainedPrioritySet(BiFunction<ProcessId, TaskId, Boolean> constraint, Function<ProcessId, Double> weight) {
        this.constraint = constraint;
        this.clientsByTaskLoad = new PriorityQueue<ProcessId>(Comparator.comparing(weight).thenComparing(clientId -> clientId));
    }

    public ProcessId poll(TaskId task, Function<ProcessId, Boolean> extraConstraint) {
        HashSet<ProcessId> invalidPolledClients = new HashSet<ProcessId>();
        while (!this.clientsByTaskLoad.isEmpty()) {
            ProcessId candidateClient = this.pollNextClient();
            if (this.constraint.apply(candidateClient, task).booleanValue() && extraConstraint.apply(candidateClient).booleanValue()) {
                this.offerAll(invalidPolledClients);
                return candidateClient;
            }
            invalidPolledClients.add(candidateClient);
        }
        this.offerAll(invalidPolledClients);
        return null;
    }

    public ProcessId poll(TaskId task) {
        return this.poll(task, client -> true);
    }

    public void offerAll(Collection<ProcessId> clients) {
        for (ProcessId client : clients) {
            this.offer(client);
        }
    }

    public void offer(ProcessId client) {
        if (this.uniqueClients.contains(client)) {
            this.clientsByTaskLoad.remove(client);
        } else {
            this.uniqueClients.add(client);
        }
        this.clientsByTaskLoad.offer(client);
    }

    private ProcessId pollNextClient() {
        ProcessId client = (ProcessId)this.clientsByTaskLoad.remove();
        this.uniqueClients.remove(client);
        return client;
    }
}

