/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.coordinator.group.runtime;

import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;

public class CoordinatorResult<T, U> {
    private final List<U> records;
    private final T response;
    private final CompletableFuture<Void> appendFuture;
    private final boolean replayRecords;

    public CoordinatorResult(List<U> records, T response) {
        this(records, response, null, true);
    }

    public CoordinatorResult(List<U> records, CompletableFuture<Void> appendFuture, boolean replayRecords) {
        this(records, null, appendFuture, replayRecords);
    }

    public CoordinatorResult(List<U> records, T response, CompletableFuture<Void> appendFuture, boolean replayRecords) {
        this.records = Objects.requireNonNull(records);
        this.response = response;
        this.appendFuture = appendFuture;
        this.replayRecords = replayRecords;
    }

    public CoordinatorResult(List<U> records) {
        this(records, null, null, true);
    }

    public List<U> records() {
        return this.records;
    }

    public T response() {
        return this.response;
    }

    public CompletableFuture<Void> appendFuture() {
        return this.appendFuture;
    }

    public boolean replayRecords() {
        return this.replayRecords;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CoordinatorResult that = (CoordinatorResult)o;
        if (!Objects.equals(this.records, that.records)) {
            return false;
        }
        if (!Objects.equals(this.response, that.response)) {
            return false;
        }
        if (!Objects.equals(this.replayRecords, that.replayRecords)) {
            return false;
        }
        return Objects.equals(this.appendFuture, that.appendFuture);
    }

    public int hashCode() {
        int result = this.records != null ? this.records.hashCode() : 0;
        result = 31 * result + (this.response != null ? this.response.hashCode() : 0);
        result = 31 * result + (this.appendFuture != null ? this.appendFuture.hashCode() : 0);
        result = 31 * result + (this.replayRecords ? 1 : 0);
        return result;
    }

    public String toString() {
        return "CoordinatorResult(records=" + this.records + ", response=" + this.response + ", appendFuture=" + this.appendFuture + ", replayRecords=" + this.replayRecords + ")";
    }
}

