/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.http.part;

import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import org.apache.juneau.assertions.FluentListAssertion;
import org.apache.juneau.commons.utils.CollectionUtils;
import org.apache.juneau.commons.utils.StringUtils;
import org.apache.juneau.commons.utils.Utils;
import org.apache.juneau.http.part.BasicPart;

public class BasicCsvArrayPart
extends BasicPart {
    private static final String[] EMPTY = new String[0];
    private final String[] value;
    private final Supplier<String[]> supplier;
    private String stringValue;

    public static BasicCsvArrayPart of(String name, String ... value) {
        if (StringUtils.isEmpty((String)name) || value == null) {
            return null;
        }
        return new BasicCsvArrayPart(name, value);
    }

    public static BasicCsvArrayPart of(String name, Supplier<String[]> value) {
        if (StringUtils.isEmpty((String)name) || value == null) {
            return null;
        }
        return new BasicCsvArrayPart(name, value);
    }

    public BasicCsvArrayPart(String name, String ... value) {
        super(name, value);
        this.value = value;
        this.supplier = null;
        this.stringValue = null;
    }

    public BasicCsvArrayPart(String name, String value) {
        super(name, value);
        this.value = StringUtils.splita((String)value);
        this.supplier = null;
        this.stringValue = value;
    }

    public BasicCsvArrayPart(String name, Supplier<String[]> value) {
        super(name, value);
        this.value = null;
        this.supplier = value;
        this.stringValue = null;
    }

    public Optional<String[]> asArray() {
        return Utils.opt((Object)((String[])CollectionUtils.copyOf((Object[])this.value())));
    }

    public Optional<List<String>> asList() {
        return Utils.opt(this.toList());
    }

    public FluentListAssertion<String, BasicCsvArrayPart> assertList() {
        return new FluentListAssertion(CollectionUtils.u((List)CollectionUtils.l((Object[])this.value())), (Object)this);
    }

    public boolean contains(String val) {
        if (Utils.nn((Object)val)) {
            for (String v : this.value()) {
                if (!Utils.eq((Object)v, (Object)val)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean containsIgnoreCase(String val) {
        if (Utils.nn((Object)val)) {
            for (String v : this.value()) {
                if (!Utils.eqic((String)v, (String)val)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public String getValue() {
        if (Utils.nn(this.supplier)) {
            return StringUtils.join((Object[])this.supplier.get(), (char)',');
        }
        if (Utils.nn((Object)this.stringValue)) {
            this.stringValue = StringUtils.join((Object[])this.value, (char)',');
        }
        return this.stringValue;
    }

    public String[] orElse(String[] other) {
        String[] x = this.value();
        return Utils.nn((Object)x) ? x : other;
    }

    public String[] toArray() {
        return (String[])CollectionUtils.copyOf((Object[])this.value());
    }

    public List<String> toList() {
        return CollectionUtils.u((List)CollectionUtils.l((Object[])this.value()));
    }

    private String[] value() {
        if (Utils.nn(this.supplier)) {
            String[] v = this.supplier.get();
            return Utils.nn((Object)v) ? v : EMPTY;
        }
        return this.value;
    }
}

