/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.assertions;

import java.io.PrintStream;
import java.time.Duration;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.time.temporal.Temporal;
import org.apache.juneau.assertions.Assertion;
import org.apache.juneau.assertions.FluentComparableAssertion;
import org.apache.juneau.commons.utils.AssertionUtils;
import org.apache.juneau.commons.utils.Utils;
import org.apache.juneau.cp.Messages;

public class FluentZonedDateTimeAssertion<R>
extends FluentComparableAssertion<ZonedDateTime, R> {
    private static final Messages MESSAGES = Messages.of(FluentZonedDateTimeAssertion.class, "Messages");
    private static final String MSG_unexpectedValue = MESSAGES.getString("unexpectedValue");
    private static final String MSG_valueWasNotAfterExpected = MESSAGES.getString("valueWasNotAfterExpected");
    private static final String MSG_valueWasNotBeforeExpected = MESSAGES.getString("valueWasNotBeforeExpected");

    public FluentZonedDateTimeAssertion(Assertion creator, ZonedDateTime value, R returns) {
        super(creator, value, returns);
    }

    public FluentZonedDateTimeAssertion(ZonedDateTime value, R returns) {
        this((Assertion)null, value, returns);
    }

    public R is(ZonedDateTime value, ChronoUnit precision) throws AssertionError {
        Duration d;
        AssertionUtils.assertArgNotNull("precision", precision);
        ZonedDateTime v = this.orElse(null);
        if (this.valueIsNull() && value == null) {
            return this.returns();
        }
        if (this.valueIsNotNull() && Utils.nn(value) && (d = Duration.between((Temporal)this.value(), value)).compareTo(precision.getDuration()) <= 0) {
            return this.returns();
        }
        throw this.error(MSG_unexpectedValue, value, v);
    }

    public R isAfter(ZonedDateTime value) throws AssertionError {
        AssertionUtils.assertArgNotNull("value", value);
        if (!((ZonedDateTime)this.value()).isAfter(value)) {
            throw this.error(MSG_valueWasNotAfterExpected, value, this.value());
        }
        return this.returns();
    }

    public R isAfterNow() throws AssertionError {
        return this.isAfter(ZonedDateTime.now());
    }

    public R isBefore(ZonedDateTime value) throws AssertionError {
        AssertionUtils.assertArgNotNull("value", value);
        if (!((ZonedDateTime)this.value()).isBefore(value)) {
            throw this.error(MSG_valueWasNotBeforeExpected, value, this.value());
        }
        return this.returns();
    }

    public R isBeforeNow() throws AssertionError {
        return this.isBefore(ZonedDateTime.now());
    }

    public R isBetween(ZonedDateTime lower, ZonedDateTime upper) throws AssertionError {
        this.isExists();
        AssertionUtils.assertArgNotNull("lower", lower);
        AssertionUtils.assertArgNotNull("upper", upper);
        this.isLte(upper);
        this.isGte(lower);
        return this.returns();
    }

    @Override
    public FluentZonedDateTimeAssertion<R> setMsg(String msg, Object ... args) {
        super.setMsg(msg, args);
        return this;
    }

    @Override
    public FluentZonedDateTimeAssertion<R> setOut(PrintStream value) {
        super.setOut(value);
        return this;
    }

    @Override
    public FluentZonedDateTimeAssertion<R> setSilent() {
        super.setSilent();
        return this;
    }

    @Override
    public FluentZonedDateTimeAssertion<R> setStdOut() {
        super.setStdOut();
        return this;
    }

    @Override
    public FluentZonedDateTimeAssertion<R> setThrowable(Class<? extends RuntimeException> value) {
        super.setThrowable((Class)value);
        return this;
    }
}

