/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.annotation;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.apache.juneau.AnnotationApplier;
import org.apache.juneau.BeanContext;
import org.apache.juneau.annotation.BeanIgnore;
import org.apache.juneau.commons.annotation.AppliedAnnotationObject;
import org.apache.juneau.commons.annotation.AppliedOnClassAnnotationObject;
import org.apache.juneau.commons.reflect.AnnotationInfo;
import org.apache.juneau.commons.reflect.ClassInfo;
import org.apache.juneau.commons.reflect.ConstructorInfo;
import org.apache.juneau.commons.reflect.FieldInfo;
import org.apache.juneau.commons.reflect.MethodInfo;
import org.apache.juneau.commons.utils.CollectionUtils;
import org.apache.juneau.svl.VarResolverSession;

public class BeanIgnoreAnnotation {
    public static final BeanIgnore DEFAULT = BeanIgnoreAnnotation.create().build();

    public static BeanIgnore copy(BeanIgnore a, VarResolverSession r) {
        return ((Builder)BeanIgnoreAnnotation.create().on(r.resolve(a.on())).onClass((Class[])a.onClass())).build();
    }

    public static Builder create() {
        return new Builder();
    }

    public static Builder create(Class<?> ... on) {
        return BeanIgnoreAnnotation.create().on((Class[])on);
    }

    public static Builder create(String ... on) {
        return BeanIgnoreAnnotation.create().on(on);
    }

    public static class Builder
    extends AppliedAnnotationObject.BuilderTMFC {
        private String[] description = new String[0];

        protected Builder() {
            super(BeanIgnore.class);
        }

        public BeanIgnore build() {
            return new Object(this);
        }

        public Builder description(String ... value) {
            this.description = value;
            return this;
        }

        @Override
        public Builder on(String ... value) {
            super.on(value);
            return this;
        }

        @Override
        public Builder on(Class<?> ... value) {
            super.on(value);
            return this;
        }

        @Override
        public Builder onClass(Class<?> ... value) {
            super.onClass(value);
            return this;
        }

        @Override
        public Builder on(Method ... value) {
            super.on(value);
            return this;
        }

        @Override
        public Builder on(Field ... value) {
            super.on(value);
            return this;
        }

        @Override
        public Builder on(Constructor<?> ... value) {
            super.on(value);
            return this;
        }

        @Override
        public Builder on(ClassInfo ... value) {
            super.on(value);
            return this;
        }

        @Override
        public Builder onClass(ClassInfo ... value) {
            super.onClass(value);
            return this;
        }

        @Override
        public Builder on(FieldInfo ... value) {
            super.on(value);
            return this;
        }

        @Override
        public Builder on(MethodInfo ... value) {
            super.on(value);
            return this;
        }

        @Override
        public Builder on(ConstructorInfo ... value) {
            super.on(value);
            return this;
        }
    }

    private static class Object
    extends AppliedOnClassAnnotationObject
    implements BeanIgnore {
        private final String[] description;

        Object(Builder b) {
            super(b);
            this.description = CollectionUtils.copyOf(b.description);
        }

        @Override
        public String[] description() {
            return this.description;
        }
    }

    @Documented
    @Target(value={ElementType.METHOD, ElementType.TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    @Inherited
    public static @interface Array {
        public BeanIgnore[] value();
    }

    public static class Applier
    extends AnnotationApplier<BeanIgnore, BeanContext.Builder> {
        public Applier(VarResolverSession vr) {
            super(BeanIgnore.class, BeanContext.Builder.class, vr);
        }

        @Override
        public void apply(AnnotationInfo<BeanIgnore> ai, BeanContext.Builder b) {
            BeanIgnore a = ai.inner();
            if (CollectionUtils.isEmptyArray(a.on()) && CollectionUtils.isEmptyArray(a.onClass())) {
                return;
            }
            b.annotations(BeanIgnoreAnnotation.copy(a, this.vr()));
        }
    }
}

