/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.dto.swagger;

import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.juneau.BasicRuntimeException;
import org.apache.juneau.BeanRuntimeException;
import org.apache.juneau.MediaType;
import org.apache.juneau.annotation.Bean;
import org.apache.juneau.collections.JsonMap;
import org.apache.juneau.common.internal.StringUtils;
import org.apache.juneau.dto.swagger.ExternalDocumentation;
import org.apache.juneau.dto.swagger.Info;
import org.apache.juneau.dto.swagger.Operation;
import org.apache.juneau.dto.swagger.OperationMap;
import org.apache.juneau.dto.swagger.ParameterInfo;
import org.apache.juneau.dto.swagger.ResponseInfo;
import org.apache.juneau.dto.swagger.SecurityScheme;
import org.apache.juneau.dto.swagger.SwaggerElement;
import org.apache.juneau.dto.swagger.Tag;
import org.apache.juneau.internal.ClassUtils;
import org.apache.juneau.internal.CollectionUtils;
import org.apache.juneau.internal.ConverterUtils;
import org.apache.juneau.internal.FluentSetters;
import org.apache.juneau.internal.MultiSet;
import org.apache.juneau.json.JsonSerializer;
import org.apache.juneau.objecttools.ObjectRest;

@Bean(properties="swagger,info,tags,externalDocs,basePath,schemes,consumes,produces,paths,definitions,parameters,responses,securityDefinitions,security,*")
@FluentSetters
public class Swagger
extends SwaggerElement {
    public static final Swagger NULL = new Swagger();
    private static final Comparator<String> PATH_COMPARATOR = (o1, o2) -> o1.replace('{', '@').compareTo(o2.replace('{', '@'));
    private String swagger = "2.0";
    private String host;
    private String basePath;
    private Info info;
    private ExternalDocumentation externalDocs;
    private Set<String> schemes;
    private Set<MediaType> consumes;
    private Set<MediaType> produces;
    private Set<Tag> tags;
    private List<Map<String, List<String>>> security;
    private Map<String, JsonMap> definitions;
    private Map<String, ParameterInfo> parameters;
    private Map<String, ResponseInfo> responses;
    private Map<String, SecurityScheme> securityDefinitions;
    private Map<String, OperationMap> paths;

    public Swagger() {
    }

    public Swagger(Swagger copyFrom) {
        super(copyFrom);
        this.basePath = copyFrom.basePath;
        this.consumes = CollectionUtils.copyOf(copyFrom.consumes);
        this.externalDocs = copyFrom.externalDocs == null ? null : copyFrom.externalDocs.copy();
        this.host = copyFrom.host;
        this.info = copyFrom.info == null ? null : copyFrom.info.copy();
        this.produces = CollectionUtils.copyOf(copyFrom.produces);
        this.schemes = CollectionUtils.copyOf(copyFrom.schemes);
        this.swagger = copyFrom.swagger;
        if (copyFrom.definitions == null) {
            this.definitions = null;
        } else {
            this.definitions = CollectionUtils.map();
            copyFrom.definitions.forEach((k, v) -> this.definitions.put((String)k, new JsonMap((Map)v)));
        }
        if (copyFrom.paths == null) {
            this.paths = null;
        } else {
            this.paths = CollectionUtils.map();
            copyFrom.paths.forEach((k, v) -> {
                OperationMap m = new OperationMap();
                v.forEach((k2, v2) -> m.put(k2, v2.copy()));
                this.paths.put((String)k, m);
            });
        }
        if (copyFrom.parameters == null) {
            this.parameters = null;
        } else {
            this.parameters = CollectionUtils.map();
            copyFrom.parameters.forEach((k, v) -> this.parameters.put((String)k, v.copy()));
        }
        if (copyFrom.responses == null) {
            this.responses = null;
        } else {
            this.responses = CollectionUtils.map();
            copyFrom.responses.forEach((k, v) -> this.responses.put((String)k, v.copy()));
        }
        if (copyFrom.security == null) {
            this.security = null;
        } else {
            this.security = CollectionUtils.list((Object[])new Map[0]);
            copyFrom.security.forEach(x -> {
                LinkedHashMap m2 = CollectionUtils.map();
                x.forEach((k, v) -> m2.put(k, CollectionUtils.copyOf((List)v)));
                this.security.add(m2);
            });
        }
        if (copyFrom.securityDefinitions == null) {
            this.securityDefinitions = null;
        } else {
            this.securityDefinitions = CollectionUtils.map();
            copyFrom.securityDefinitions.forEach((k, v) -> this.securityDefinitions.put((String)k, v.copy()));
        }
        if (copyFrom.tags == null) {
            this.tags = null;
        } else {
            this.tags = CollectionUtils.set((Object[])new Tag[0]);
            copyFrom.tags.forEach(x -> this.tags.add(x.copy()));
        }
    }

    public Swagger copy() {
        return new Swagger(this);
    }

    public String getBasePath() {
        return this.basePath;
    }

    public Swagger setBasePath(String value) {
        this.basePath = value;
        return this;
    }

    public Set<MediaType> getConsumes() {
        return this.consumes;
    }

    public Swagger setConsumes(Collection<MediaType> value) {
        this.consumes = CollectionUtils.setFrom(value);
        return this;
    }

    public Swagger addConsumes(MediaType ... values) {
        this.consumes = CollectionUtils.setBuilder(this.consumes).sparse().add((Object[])values).build();
        return this;
    }

    public Swagger setConsumes(MediaType ... value) {
        this.setConsumes(CollectionUtils.setBuilder(MediaType.class, (Type[])new Type[0]).sparse().add((Object[])value).build());
        return this;
    }

    public Map<String, JsonMap> getDefinitions() {
        return this.definitions;
    }

    public Swagger setDefinitions(Map<String, JsonMap> value) {
        this.definitions = CollectionUtils.copyOf(value);
        return this;
    }

    public Swagger addDefinition(String name, JsonMap schema) {
        this.definitions = CollectionUtils.mapBuilder(this.definitions).sparse().add((Object)name, (Object)schema).build();
        return this;
    }

    public ExternalDocumentation getExternalDocs() {
        return this.externalDocs;
    }

    public Swagger setExternalDocs(ExternalDocumentation value) {
        this.externalDocs = value;
        return this;
    }

    public String getHost() {
        return this.host;
    }

    public Swagger setHost(String value) {
        this.host = value;
        return this;
    }

    public Info getInfo() {
        return this.info;
    }

    public Swagger setInfo(Info value) {
        this.info = value;
        return this;
    }

    public Map<String, ParameterInfo> getParameters() {
        return this.parameters;
    }

    public Swagger setParameters(Map<String, ParameterInfo> value) {
        this.parameters = CollectionUtils.copyOf(value);
        return this;
    }

    public Swagger addParameter(String name, ParameterInfo parameter) {
        this.parameters = CollectionUtils.mapBuilder(this.parameters).sparse().add((Object)name, (Object)parameter).build();
        return this;
    }

    public Map<String, OperationMap> getPaths() {
        return this.paths;
    }

    public Swagger setPaths(Map<String, OperationMap> value) {
        this.paths = CollectionUtils.mapBuilder(String.class, OperationMap.class, (Type[])new Type[0]).sparse().sorted(PATH_COMPARATOR).addAll(value).build();
        return this;
    }

    public Swagger addPath(String path, String methodName, Operation operation) {
        OperationMap p;
        if (this.paths == null) {
            this.paths = new TreeMap<String, OperationMap>(PATH_COMPARATOR);
        }
        if ((p = this.paths.get(path)) == null) {
            p = new OperationMap();
            this.paths.put(path, p);
        }
        p.put(methodName, operation);
        return this;
    }

    public Set<MediaType> getProduces() {
        return this.produces;
    }

    public Swagger setProduces(Collection<MediaType> value) {
        this.produces = CollectionUtils.setFrom(value);
        return this;
    }

    public Swagger addProduces(MediaType ... values) {
        this.produces = CollectionUtils.setBuilder(this.produces).sparse().add((Object[])values).build();
        return this;
    }

    public Swagger setProduces(MediaType ... value) {
        this.setProduces(CollectionUtils.setBuilder(MediaType.class, (Type[])new Type[0]).sparse().add((Object[])value).build());
        return this;
    }

    public Map<String, ResponseInfo> getResponses() {
        return this.responses;
    }

    public Swagger setResponses(Map<String, ResponseInfo> value) {
        this.responses = CollectionUtils.copyOf(value);
        return this;
    }

    public Swagger addResponse(String name, ResponseInfo response) {
        this.responses = CollectionUtils.mapBuilder(this.responses).sparse().add((Object)name, (Object)response).build();
        return this;
    }

    public Set<String> getSchemes() {
        return this.schemes;
    }

    public Swagger setSchemes(Collection<String> value) {
        this.schemes = CollectionUtils.setFrom(value);
        return this;
    }

    public Swagger addSchemes(String ... values) {
        this.schemes = CollectionUtils.setBuilder(this.schemes).sparse().add((Object[])values).build();
        return this;
    }

    public Swagger setSchemes(String ... value) {
        this.setSchemes(CollectionUtils.setBuilder(String.class, (Type[])new Type[0]).sparse().addJson(value).build());
        return this;
    }

    public List<Map<String, List<String>>> getSecurity() {
        return this.security;
    }

    public Swagger setSecurity(Collection<Map<String, List<String>>> value) {
        this.security = CollectionUtils.listFrom(value);
        return this;
    }

    public Swagger addSecurity(String scheme, String ... alternatives) {
        LinkedHashMap m = CollectionUtils.map();
        m.put(scheme, CollectionUtils.alist((Object[])alternatives));
        this.security = CollectionUtils.listBuilder(this.security).sparse().addAll(Collections.singleton(m)).build();
        return this;
    }

    public Map<String, SecurityScheme> getSecurityDefinitions() {
        return this.securityDefinitions;
    }

    public Swagger setSecurityDefinitions(Map<String, SecurityScheme> value) {
        this.securityDefinitions = CollectionUtils.copyOf(value);
        return this;
    }

    public Swagger addSecurityDefinition(String name, SecurityScheme securityScheme) {
        this.securityDefinitions = CollectionUtils.mapBuilder(this.securityDefinitions).sparse().add((Object)name, (Object)securityScheme).build();
        return this;
    }

    public String getSwagger() {
        return this.swagger;
    }

    public Swagger setSwagger(String value) {
        this.swagger = value;
        return this;
    }

    public Set<Tag> getTags() {
        return this.tags;
    }

    public Swagger setTags(Collection<Tag> value) {
        this.tags = CollectionUtils.setFrom(value);
        return this;
    }

    public Swagger addTags(Tag ... values) {
        this.tags = CollectionUtils.setBuilder(this.tags).sparse().add((Object[])values).build();
        return this;
    }

    public OperationMap getPath(String path) {
        return this.getPaths().get(path);
    }

    public Operation getOperation(String path, String operation) {
        OperationMap om = this.getPath(path);
        if (om == null) {
            return null;
        }
        return (Operation)om.get(operation);
    }

    public ResponseInfo getResponseInfo(String path, String operation, String status) {
        OperationMap om = this.getPath(path);
        if (om == null) {
            return null;
        }
        Operation op = (Operation)om.get(operation);
        if (op == null) {
            return null;
        }
        return op.getResponse(status);
    }

    public ResponseInfo getResponseInfo(String path, String operation, int status) {
        return this.getResponseInfo(path, operation, String.valueOf(status));
    }

    public ParameterInfo getParameterInfo(String path, String method, String in, String name) {
        Operation o;
        OperationMap om = this.getPath(path);
        if (om != null && (o = (Operation)om.get(method)) != null) {
            return o.getParameter(in, name);
        }
        return null;
    }

    @Override
    public <T> T get(String property, Class<T> type) {
        if (property == null) {
            return null;
        }
        switch (property) {
            case "basePath": {
                return (T)ConverterUtils.toType((Object)this.getBasePath(), type);
            }
            case "consumes": {
                return (T)ConverterUtils.toType(this.getConsumes(), type);
            }
            case "definitions": {
                return (T)ConverterUtils.toType(this.getDefinitions(), type);
            }
            case "externalDocs": {
                return (T)ConverterUtils.toType((Object)this.getExternalDocs(), type);
            }
            case "host": {
                return (T)ConverterUtils.toType((Object)this.getHost(), type);
            }
            case "info": {
                return (T)ConverterUtils.toType((Object)this.getInfo(), type);
            }
            case "parameters": {
                return (T)ConverterUtils.toType(this.getParameters(), type);
            }
            case "paths": {
                return (T)ConverterUtils.toType(this.getPaths(), type);
            }
            case "produces": {
                return (T)ConverterUtils.toType(this.getProduces(), type);
            }
            case "responses": {
                return (T)ConverterUtils.toType(this.getResponses(), type);
            }
            case "schemes": {
                return (T)ConverterUtils.toType(this.getSchemes(), type);
            }
            case "security": {
                return (T)ConverterUtils.toType(this.getSecurity(), type);
            }
            case "securityDefinitions": {
                return (T)ConverterUtils.toType(this.getSecurityDefinitions(), type);
            }
            case "swagger": {
                return (T)ConverterUtils.toType((Object)this.getSwagger(), type);
            }
            case "tags": {
                return (T)ConverterUtils.toType(this.getTags(), type);
            }
        }
        return super.get(property, type);
    }

    @Override
    public Swagger set(String property, Object value) {
        if (property == null) {
            return this;
        }
        switch (property) {
            case "basePath": {
                return this.setBasePath(StringUtils.stringify((Object)value));
            }
            case "consumes": {
                return this.setConsumes(CollectionUtils.listBuilder(MediaType.class, (Type[])new Type[0]).sparse().addAny(new Object[]{value}).build());
            }
            case "definitions": {
                return this.setDefinitions(CollectionUtils.mapBuilder(String.class, JsonMap.class, (Type[])new Type[0]).sparse().addAny(new Object[]{value}).build());
            }
            case "externalDocs": {
                return this.setExternalDocs((ExternalDocumentation)ConverterUtils.toType((Object)value, ExternalDocumentation.class));
            }
            case "host": {
                return this.setHost(StringUtils.stringify((Object)value));
            }
            case "info": {
                return this.setInfo((Info)ConverterUtils.toType((Object)value, Info.class));
            }
            case "parameters": {
                return this.setParameters(CollectionUtils.mapBuilder(String.class, ParameterInfo.class, (Type[])new Type[0]).sparse().addAny(new Object[]{value}).build());
            }
            case "paths": {
                return this.setPaths(CollectionUtils.mapBuilder(String.class, OperationMap.class, (Type[])new Type[0]).sparse().addAny(new Object[]{value}).build());
            }
            case "produces": {
                return this.setProduces(CollectionUtils.listBuilder(MediaType.class, (Type[])new Type[0]).sparse().addAny(new Object[]{value}).build());
            }
            case "responses": {
                return this.setResponses(CollectionUtils.mapBuilder(String.class, ResponseInfo.class, (Type[])new Type[0]).sparse().addAny(new Object[]{value}).build());
            }
            case "schemes": {
                return this.setSchemes(CollectionUtils.listBuilder(String.class, (Type[])new Type[0]).sparse().addAny(new Object[]{value}).build());
            }
            case "security": {
                return this.setSecurity(CollectionUtils.listBuilder(Map.class, (Type[])new Type[]{String.class, List.class, String.class}).sparse().addAny(new Object[]{value}).build());
            }
            case "securityDefinitions": {
                return this.setSecurityDefinitions(CollectionUtils.mapBuilder(String.class, SecurityScheme.class, (Type[])new Type[0]).sparse().addAny(new Object[]{value}).build());
            }
            case "swagger": {
                return this.setSwagger(StringUtils.stringify((Object)value));
            }
            case "tags": {
                return this.setTags(CollectionUtils.listBuilder(Tag.class, (Type[])new Type[0]).sparse().addAny(new Object[]{value}).build());
            }
        }
        super.set(property, value);
        return this;
    }

    @Override
    public Set<String> keySet() {
        Set s = CollectionUtils.setBuilder(String.class, (Type[])new Type[0]).addIf(this.basePath != null, (Object)"basePath").addIf(this.consumes != null, (Object)"consumes").addIf(this.definitions != null, (Object)"definitions").addIf(this.externalDocs != null, (Object)"externalDocs").addIf(this.host != null, (Object)"host").addIf(this.info != null, (Object)"info").addIf(this.parameters != null, (Object)"parameters").addIf(this.paths != null, (Object)"paths").addIf(this.produces != null, (Object)"produces").addIf(this.responses != null, (Object)"responses").addIf(this.schemes != null, (Object)"schemes").addIf(this.security != null, (Object)"security").addIf(this.securityDefinitions != null, (Object)"securityDefinitions").addIf(this.swagger != null, (Object)"swagger").addIf(this.tags != null, (Object)"tags").build();
        return new MultiSet(new Collection[]{s, super.keySet()});
    }

    public String asJson() {
        return this.toString();
    }

    @Override
    public String toString() {
        return JsonSerializer.DEFAULT.toString((Object)this);
    }

    public <T> T findRef(String ref, Class<T> c) {
        if (StringUtils.isEmpty((String)ref)) {
            return null;
        }
        if (!ref.startsWith("#/")) {
            throw new BasicRuntimeException("Unsupported reference:  ''{0}''", new Object[]{ref});
        }
        try {
            return (T)new ObjectRest((Object)this).get(ref.substring(1), c);
        }
        catch (Exception e) {
            throw new BeanRuntimeException((Throwable)e, c, "Reference ''{0}'' could not be converted to type ''{1}''.", new Object[]{ref, ClassUtils.className(c)});
        }
    }
}

