/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.svl;

import java.io.IOException;
import java.io.Writer;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.ConcurrentSkipListMap;
import org.apache.juneau.BeanBuilder;
import org.apache.juneau.cp.BeanStore;
import org.apache.juneau.internal.CollectionUtils;
import org.apache.juneau.internal.FluentSetters;
import org.apache.juneau.svl.Var;
import org.apache.juneau.svl.VarList;
import org.apache.juneau.svl.VarResolverSession;

public class VarResolver {
    public static final VarResolver DEFAULT = (VarResolver)VarResolver.create().defaultVars().build();
    final Var[] vars;
    private final Map<String, Var> varMap;
    final BeanStore beanStore;

    public static Builder create() {
        return new Builder();
    }

    protected VarResolver(Builder builder) {
        this.vars = (Var[])builder.vars.stream().map(x -> VarResolver.toVar(builder.beanStore(), x)).toArray(Var[]::new);
        ConcurrentSkipListMap<String, Var> m = new ConcurrentSkipListMap<String, Var>();
        for (Var v : this.vars) {
            m.put(v.getName(), v);
        }
        this.varMap = CollectionUtils.unmodifiable(m);
        this.beanStore = BeanStore.of(builder.beanStore());
    }

    private static Var toVar(BeanStore bs, Object o) {
        if (o instanceof Class) {
            return bs.createBean(Var.class).type((Class)o).run();
        }
        return (Var)o;
    }

    public Builder copy() {
        return new Builder(this);
    }

    protected Map<String, Var> getVarMap() {
        return this.varMap;
    }

    protected Var[] getVars() {
        return Arrays.copyOf(this.vars, this.vars.length);
    }

    public <T> VarResolver addBean(Class<T> c, T value) {
        this.beanStore.addBean(c, value);
        return this;
    }

    public VarResolverSession createSession() {
        return new VarResolverSession(this, null);
    }

    public VarResolverSession createSession(BeanStore beanStore) {
        return new VarResolverSession(this, beanStore);
    }

    public String resolve(String s) {
        return this.createSession(null).resolve(s);
    }

    public void resolveTo(String s, Writer w) throws IOException {
        this.createSession(null).resolveTo(s, w);
    }

    @FluentSetters
    public static class Builder
    extends BeanBuilder<VarResolver> {
        final VarList vars;

        protected Builder() {
            super(VarResolver.class, BeanStore.create().build());
            this.vars = VarList.create();
        }

        protected Builder(VarResolver copyFrom) {
            super(copyFrom.getClass(), copyFrom.beanStore);
            this.vars = VarList.of(copyFrom.vars);
        }

        @Override
        protected VarResolver buildDefault() {
            return new VarResolver(this);
        }

        @SafeVarargs
        public final Builder vars(Class<? extends Var> ... values) {
            this.vars.append(values);
            return this;
        }

        public Builder vars(Var ... values) {
            this.vars.append(values);
            return this;
        }

        public Builder vars(VarList values) {
            this.vars.append(values);
            return this;
        }

        public Builder defaultVars() {
            this.vars.addDefault();
            return this;
        }

        public <T> Builder bean(Class<T> c, T value) {
            this.beanStore().addBean(c, value);
            return this;
        }

        public Builder impl(Object value) {
            super.impl(value);
            return this;
        }

        public Builder type(Class<?> value) {
            super.type(value);
            return this;
        }
    }
}

