/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest.annotation;

import java.util.Map;
import java.util.logging.Level;
import org.apache.juneau.BasicRuntimeException;
import org.apache.juneau.ConfigApply;
import org.apache.juneau.ConfigException;
import org.apache.juneau.ObjectList;
import org.apache.juneau.PropertyStoreBuilder;
import org.apache.juneau.collections.OList;
import org.apache.juneau.collections.OMap;
import org.apache.juneau.cp.ResourceFinder;
import org.apache.juneau.httppart.HttpPartParser;
import org.apache.juneau.httppart.HttpPartSerializer;
import org.apache.juneau.internal.ArrayUtils;
import org.apache.juneau.internal.ConverterUtils;
import org.apache.juneau.internal.StringUtils;
import org.apache.juneau.parser.ParseException;
import org.apache.juneau.reflect.AnnotationInfo;
import org.apache.juneau.reflect.ClassInfo;
import org.apache.juneau.rest.Enablement;
import org.apache.juneau.rest.RestCallHandler;
import org.apache.juneau.rest.RestCallLogger;
import org.apache.juneau.rest.RestContext;
import org.apache.juneau.rest.RestInfoProvider;
import org.apache.juneau.rest.RestResourceResolver;
import org.apache.juneau.rest.StaticFileMapping;
import org.apache.juneau.rest.annotation.AnnotationUtils;
import org.apache.juneau.rest.annotation.Logging;
import org.apache.juneau.rest.annotation.LoggingRule;
import org.apache.juneau.rest.annotation.Property;
import org.apache.juneau.rest.annotation.Rest;
import org.apache.juneau.rest.util.RestUtils;
import org.apache.juneau.svl.VarResolverSession;
import org.apache.juneau.utils.Tuple2;

public class RestConfigApply
extends ConfigApply<Rest> {
    public RestConfigApply(Class<Rest> c, VarResolverSession r) {
        super(c, r);
    }

    /*
     * WARNING - void declaration
     */
    public void apply(AnnotationInfo<Rest> ai, PropertyStoreBuilder psb) {
        void var9_29;
        void var9_27;
        String[] h;
        String[] ra2;
        Rest a = (Rest)ai.getAnnotation();
        String s = null;
        ClassInfo c = ai.getClassOn();
        for (Property property : a.properties()) {
            psb.set(property.name(), (Object)this.string(property.value()));
            psb.putTo("RestContext.properties.sms", this.string(property.name()), (Object)this.string(property.value()));
        }
        for (String string : a.flags()) {
            psb.set(string, (Object)true);
            psb.putTo("RestContext.properties.sms", this.string(string), (Object)true);
        }
        if (a.serializers().length > 0) {
            psb.set("RestContext.serializers.lo", (Object)RestUtils.merge((Object[])ConverterUtils.toType((Object)psb.peek("RestContext.serializers.lo"), Object[].class), a.serializers()));
        }
        if (a.parsers().length > 0) {
            psb.set("RestContext.parsers.lo", (Object)RestUtils.merge((Object[])ConverterUtils.toType((Object)psb.peek("RestContext.parsers.lo"), Object[].class), a.parsers()));
        }
        if (a.partSerializer() != HttpPartSerializer.Null.class) {
            psb.set("RestContext.partSerializer.o", a.partSerializer());
        }
        if (a.partParser() != HttpPartParser.Null.class) {
            psb.set("RestContext.partParser.o", a.partParser());
        }
        psb.prependTo("RestContext.encoders.lo", a.encoders());
        if (a.produces().length > 0) {
            psb.set("RestContext.produces.ls", (Object)this.strings(a.produces()));
        }
        if (a.consumes().length > 0) {
            psb.set("RestContext.consumes.ls", (Object)this.strings(a.consumes()));
        }
        for (String string : this.strings(a.attrs())) {
            ra2 = RestUtils.parseKeyValuePair(string);
            if (ra2 == null) {
                throw new BasicRuntimeException("Invalid default request attribute specified: ''{0}''.  Must be in the format: ''Name: value''", new Object[]{string});
            }
            if (!StringUtils.isNotEmpty((String)ra2[1])) continue;
            psb.putTo("RestContext.reqAttrs.smo", ra2[0], (Object)ra2[1]);
        }
        for (String string : this.strings(a.reqAttrs())) {
            ra2 = RestUtils.parseKeyValuePair(string);
            if (ra2 == null) {
                throw new BasicRuntimeException("Invalid default request attribute specified: ''{0}''.  Must be in the format: ''Name: value''", new Object[]{string});
            }
            if (!StringUtils.isNotEmpty((String)ra2[1])) continue;
            psb.putTo("RestContext.reqAttrs.smo", ra2[0], (Object)ra2[1]);
        }
        for (String string : this.strings(a.defaultRequestHeaders())) {
            h = RestUtils.parseHeader(string);
            if (h == null) {
                throw new BasicRuntimeException("Invalid default request header specified: ''{0}''.  Must be in the format: ''Header-Name: header-value''", new Object[]{string});
            }
            if (!StringUtils.isNotEmpty((String)h[1])) continue;
            psb.putTo("RestContext.reqHeaders.smo", h[0], (Object)h[1]);
        }
        for (String string : this.strings(a.reqHeaders())) {
            h = RestUtils.parseHeader(string);
            if (h == null) {
                throw new BasicRuntimeException("Invalid default request header specified: ''{0}''.  Must be in the format: ''Header-Name: header-value''", new Object[]{string});
            }
            if (!StringUtils.isNotEmpty((String)h[1])) continue;
            psb.putTo("RestContext.reqHeaders.smo", h[0], (Object)h[1]);
        }
        if (a.defaultAccept().length() > 0 && StringUtils.isNotEmpty((String)(s = this.string(a.defaultAccept())))) {
            psb.putTo("RestContext.reqHeaders.smo", "Accept", (Object)s);
        }
        if (a.defaultContentType().length() > 0 && StringUtils.isNotEmpty((String)(s = this.string(a.defaultContentType())))) {
            psb.putTo("RestContext.reqHeaders.smo", "Content-Type", (Object)s);
        }
        for (String string : this.strings(a.defaultResponseHeaders())) {
            h = RestUtils.parseHeader(string);
            if (h == null) {
                throw new BasicRuntimeException("Invalid default response header specified: ''{0}''.  Must be in the format: ''Header-Name: header-value''", new Object[]{string});
            }
            if (!StringUtils.isNotEmpty((String)h[1])) continue;
            psb.putTo("RestContext.resHeaders.omo", h[0], (Object)h[1]);
        }
        for (String string : this.strings(a.resHeaders())) {
            h = RestUtils.parseHeader(string);
            if (h == null) {
                throw new BasicRuntimeException("Invalid default response header specified: ''{0}''.  Must be in the format: ''Header-Name: header-value''", new Object[]{string});
            }
            if (!StringUtils.isNotEmpty((String)h[1])) continue;
            psb.putTo("RestContext.resHeaders.omo", h[0], (Object)h[1]);
        }
        psb.prependTo("RestContext.responseHandlers.lo", a.responseHandlers());
        psb.prependTo("RestContext.converters.lo", a.converters());
        psb.prependTo("RestContext.guards.lo", (Object)ArrayUtils.reverse((Object[])a.guards()));
        psb.prependTo("RestContext.children.lo", a.children());
        psb.prependTo("RestContext.paramResolvers.lo", a.paramResolvers());
        Class<? extends RestContext> cc = a.context();
        if (!cc.equals(RestContext.Null.class)) {
            psb.set("RestContext.context.c", cc);
        }
        if (StringUtils.isNotEmpty((String)(s = this.string(a.uriContext())))) {
            psb.set("RestContext.uriContext.s", (Object)s);
        }
        if (StringUtils.isNotEmpty((String)(s = this.string(a.uriAuthority())))) {
            psb.set("RestContext.uriAuthority.s", (Object)s);
        }
        if (StringUtils.isNotEmpty((String)(s = this.string(a.uriRelativity())))) {
            psb.set("RestContext.uriRelativity.s", (Object)s);
        }
        if (StringUtils.isNotEmpty((String)(s = this.string(a.uriResolution())))) {
            psb.set("RestContext.uriResolution.s", (Object)s);
        }
        String[] stringArray = a.staticFiles();
        int n = stringArray.length;
        boolean bl = false;
        while (var9_27 < n) {
            String mapping = stringArray[var9_27];
            try {
                for (StaticFileMapping sfm : StaticFileMapping.parse(c.inner(), this.string(mapping)).riterable()) {
                    psb.prependTo("RestContext.staticFiles.lo", (Object)sfm);
                }
            }
            catch (ParseException e) {
                throw new ConfigException((Throwable)e, "Invalid @Resource(staticFiles) value on class ''{0}''", new Object[]{c});
            }
            ++var9_27;
        }
        psb.prependTo("RestContext.messages.lo", (Object)Tuple2.of((Object)c.inner(), (Object)this.string(a.messages())));
        stringArray = this.strings(a.staticFileResponseHeaders());
        n = stringArray.length;
        boolean bl2 = false;
        while (var9_29 < n) {
            String header = stringArray[var9_29];
            String[] h2 = RestUtils.parseHeader(header);
            if (h2 == null) {
                throw new BasicRuntimeException("Invalid static file response header specified: ''{0}''.  Must be in the format: ''Header-Name: header-value''", new Object[]{header});
            }
            if (StringUtils.isNotEmpty((String)h2[1])) {
                psb.putTo("RestContext.staticFileResponseHeaders.omo", h2[0], (Object)h2[1]);
            }
            ++var9_29;
        }
        if (!a.useClasspathResourceCaching().isEmpty()) {
            psb.set("RestContext.useClasspathResourceCaching.b", (Object)this.bool(a.useClasspathResourceCaching()));
        }
        if (a.classpathResourceFinder() != ResourceFinder.Null.class) {
            psb.set("RestContext.classpathResourceFinder.o", a.classpathResourceFinder());
        }
        if (!a.path().isEmpty()) {
            psb.set("RestContext.path.s", (Object)this.trimLeadingSlash(this.string(a.path())));
        }
        if (!a.clientVersionHeader().isEmpty()) {
            psb.set("RestContext.clientVersionHeader.s", (Object)this.string(a.clientVersionHeader()));
        }
        if (a.resourceResolver() != RestResourceResolver.Null.class) {
            psb.set("RestContext.resourceResolver.o", a.resourceResolver());
        }
        if (a.callLogger() != RestCallLogger.Null.class) {
            psb.set("RestContext.callLogger.o", a.callLogger());
        }
        if (!AnnotationUtils.empty(a.logging())) {
            Logging al = a.logging();
            OMap m = new OMap((Map)psb.peek(OMap.class, "RestContext.callLoggerConfig.o"));
            if (!al.useStackTraceHashing().isEmpty()) {
                m.append("useStackTraceHashing", (Object)this.bool(al.useStackTraceHashing()));
            }
            if (!al.stackTraceHashingTimeout().isEmpty()) {
                m.append("stackTraceHashingTimeout", (Object)this.integer(al.stackTraceHashingTimeout(), "@Logging(stackTraceHashingTimeout)"));
            }
            if (!al.disabled().isEmpty()) {
                m.append("disabled", (Object)this.enablement(al.disabled()));
            }
            if (!al.level().isEmpty()) {
                m.append("level", (Object)this.level(al.level(), "@Logging(level)"));
            }
            if (al.rules().length > 0) {
                OList oList = new OList();
                for (LoggingRule a2 : al.rules()) {
                    OMap m2 = new OMap();
                    if (!a2.codes().isEmpty()) {
                        m2.append("codes", (Object)this.string(a2.codes()));
                    }
                    if (!a2.exceptions().isEmpty()) {
                        m2.append("exceptions", (Object)this.string(a2.exceptions()));
                    }
                    if (!a2.debugOnly().isEmpty()) {
                        m2.append("debugOnly", (Object)this.bool(a2.debugOnly()));
                    }
                    if (!a2.level().isEmpty()) {
                        m2.append("level", (Object)this.level(a2.level(), "@LoggingRule(level)"));
                    }
                    if (!a2.req().isEmpty()) {
                        m2.append("req", (Object)this.string(a2.req()));
                    }
                    if (!a2.res().isEmpty()) {
                        m2.append("res", (Object)this.string(a2.res()));
                    }
                    if (!a2.verbose().isEmpty()) {
                        m2.append("verbose", (Object)this.bool(a2.verbose()));
                    }
                    if (!a2.disabled().isEmpty()) {
                        m2.append("disabled", (Object)this.bool(a2.disabled()));
                    }
                    oList.add((Object)m2);
                }
                m.put((Object)"rules", (Object)oList.appendAll((ObjectList)m.getList("rules")));
            }
            psb.set("RestContext.callLoggerConfig.o", (Object)m);
        }
        if (a.callHandler() != RestCallHandler.Null.class) {
            psb.set("RestContext.callHandler.o", a.callHandler());
        }
        if (a.infoProvider() != RestInfoProvider.Null.class) {
            psb.set("RestContext.infoProvider.o", a.infoProvider());
        }
        if (!a.allowBodyParam().isEmpty()) {
            psb.set("RestContext.allowBodyParam.b", (Object)this.bool(a.allowBodyParam()));
        }
        if (!a.allowedHeaderParams().isEmpty()) {
            psb.set("RestContext.allowedHeaderParams.s", (Object)this.string(a.allowedHeaderParams()));
        }
        if (!a.allowedMethodHeaders().isEmpty()) {
            psb.set("RestContext.allowedMethodHeaders.s", (Object)this.string(a.allowedMethodHeaders()));
        }
        if (!a.allowedMethodParams().isEmpty()) {
            psb.set("RestContext.allowedMethodParams.s", (Object)this.string(a.allowedMethodParams()));
        }
        if (!a.renderResponseStackTraces().isEmpty()) {
            psb.set("RestContext.renderResponseStackTraces.b", (Object)this.bool(a.renderResponseStackTraces()));
        }
        if (!a.defaultCharset().isEmpty()) {
            psb.set("RestContext.defaultCharset.s", (Object)this.string(a.defaultCharset()));
        }
        if (!a.maxInput().isEmpty()) {
            psb.set("RestContext.maxInput.s", (Object)this.string(a.maxInput()));
        }
        if (!a.debug().isEmpty()) {
            psb.set("RestContext.debug.s", (Object)this.string(a.debug()));
        }
        if (!a.debugOn().isEmpty()) {
            psb.set("RestContext.debugOn.s", (Object)this.string(a.debugOn()));
        }
        psb.addTo("RestContext.mimeTypes.ss", (Object)this.strings(a.mimeTypes()));
        if (!a.rolesDeclared().isEmpty()) {
            psb.addTo("RestContext.rolesDeclared.ss", (Object)this.strings(a.rolesDeclared()));
        }
        if (!a.roleGuard().isEmpty()) {
            psb.addTo("RestContext.roleGuard.ss", (Object)this.string(a.roleGuard()));
        }
    }

    private String trimLeadingSlash(String value) {
        if (StringUtils.startsWith((String)value, (char)'/')) {
            return value.substring(1);
        }
        return value;
    }

    private Enablement enablement(String in) {
        return Enablement.fromString(this.string(in));
    }

    private Level level(String in, String loc) {
        try {
            return Level.parse(this.string(in).toUpperCase());
        }
        catch (Exception e) {
            throw new ConfigException("Invalid syntax for level on annotation @Rest({0}): {1}", new Object[]{loc, in});
        }
    }
}

