/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.parser;

import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import org.apache.juneau.BasicException;
import org.apache.juneau.collections.OMap;
import org.apache.juneau.internal.StringUtils;
import org.apache.juneau.parser.ParserSession;
import org.apache.juneau.parser.Position;

public class ParseException
extends BasicException {
    private static final long serialVersionUID = 1L;

    public static ParseException create(Throwable e) {
        if (e instanceof InvocationTargetException) {
            e = ((InvocationTargetException)e).getCause();
        }
        if (e instanceof ParseException) {
            return (ParseException)e;
        }
        return new ParseException(e);
    }

    public ParseException(String message, Object ... args) {
        super(message, args);
    }

    public ParseException(Throwable causedBy, String message, Object ... args) {
        super(causedBy, message, args);
    }

    public ParseException(Throwable causedBy) {
        super(causedBy);
    }

    public ParseException(ParserSession session, String message, Object ... args) {
        super(ParseException.getMessage(session, message, args), new Object[0]);
    }

    public ParseException(ParserSession session, Throwable causedBy, String message, Object ... args) {
        super(causedBy, ParseException.getMessage(session, message, args), new Object[0]);
    }

    public ParseException(ParserSession session, Exception causedBy) {
        super(causedBy, ParseException.getMessage(session, causedBy.getMessage(), new Object[0]), new Object[0]);
    }

    private static String getMessage(ParserSession session, String msg, Object ... args) {
        if (args.length != 0) {
            msg = StringUtils.format(msg, args);
        }
        if (session != null) {
            String lines;
            Position p = session.getPosition();
            msg = msg + "\n\tAt: " + p;
            OMap lastLocation = session.getLastLocation();
            if (lastLocation != null) {
                msg = msg + "\n\tWhile parsing into: ";
                for (Map.Entry<String, Object> e : lastLocation.entrySet()) {
                    msg = msg + "\n\t\t" + e.getKey() + ": " + e.getValue();
                }
            }
            if ((lines = session.getInputAsString()) == null) {
                msg = msg + "\n\tUse BEAN_debug setting to display content.";
            } else {
                int numLines = session.getDebugOutputLines();
                int start = p.line - numLines;
                int end = p.line + numLines;
                msg = msg + "\n---start--\n" + StringUtils.getNumberedLines(lines, start, end) + "---end---";
            }
        }
        return msg;
    }

    public ParseException getRootCause() {
        ParseException t = this;
        while (t.getCause() != null && t.getCause() instanceof ParseException) {
            t = (ParseException)t.getCause();
        }
        return t;
    }
}

