/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.msgpack;

import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public final class MsgPackOutputStream
extends OutputStream {
    private final OutputStream os;
    final long L2X31 = 0x80000000L;

    protected MsgPackOutputStream(OutputStream os) {
        this.os = os;
    }

    @Override
    public void write(int b) throws IOException {
        this.os.write(b);
    }

    final MsgPackOutputStream append(byte b) throws IOException {
        this.os.write(b);
        return this;
    }

    final MsgPackOutputStream append(byte[] b) throws IOException {
        this.os.write(b);
        return this;
    }

    final MsgPackOutputStream append1(int i) throws IOException {
        this.os.write(i);
        return this;
    }

    final MsgPackOutputStream append2(int i) throws IOException {
        return this.append1(i >> 8).append1(i);
    }

    final MsgPackOutputStream append4(int i) throws IOException {
        return this.append1(i >> 24).append1(i >> 16).append1(i >> 8).append1(i);
    }

    final MsgPackOutputStream append8(long l) throws IOException {
        return this.append1((int)(l >> 56)).append1((int)(l >> 48)).append1((int)(l >> 40)).append1((int)(l >> 32)).append1((int)(l >> 24)).append1((int)(l >> 16)).append1((int)(l >> 8)).append1((int)l);
    }

    final MsgPackOutputStream appendNull() throws IOException {
        return this.append1(192);
    }

    final MsgPackOutputStream appendBoolean(boolean b) throws IOException {
        return this.append1(b ? 195 : 194);
    }

    final MsgPackOutputStream appendInt(int i) throws IOException {
        if (i >= 0) {
            if (i < 128) {
                return this.append1(i);
            }
            if (i < 32768) {
                return this.append1(209).append2(i);
            }
            return this.append1(210).append4(i);
        }
        if (i > -64) {
            return this.append((byte)(0xE0 | -i));
        }
        if (i > -128) {
            return this.append1(208).append1(i);
        }
        if (i > Short.MIN_VALUE) {
            return this.append1(209).append2(i);
        }
        return this.append1(210).append4(i);
    }

    final MsgPackOutputStream appendLong(long l) throws IOException {
        if (l < 0x80000000L && l > Integer.MIN_VALUE) {
            return this.appendInt((int)l);
        }
        return this.append1(211).append8(l);
    }

    final MsgPackOutputStream appendNumber(Number n) throws IOException {
        Class<?> c = n.getClass();
        if (c == Integer.class || c == Short.class || c == Byte.class || c == AtomicInteger.class) {
            return this.appendInt(n.intValue());
        }
        if (c == Long.class || c == AtomicLong.class) {
            return this.appendLong(n.longValue());
        }
        if (c == Float.class) {
            return this.appendFloat(n.floatValue());
        }
        if (c == Double.class) {
            return this.appendDouble(n.doubleValue());
        }
        if (c == BigInteger.class) {
            return this.appendLong(n.longValue());
        }
        if (c == BigDecimal.class) {
            return this.appendDouble(n.doubleValue());
        }
        return this.appendInt(0);
    }

    final MsgPackOutputStream appendFloat(float f) throws IOException {
        return this.append1(202).append4(Float.floatToIntBits(f));
    }

    final MsgPackOutputStream appendDouble(double d) throws IOException {
        return this.append1(203).append8(Double.doubleToLongBits(d));
    }

    final MsgPackOutputStream appendString(CharSequence cs) throws IOException {
        byte[] b = cs.toString().getBytes("UTF-8");
        if (b.length < 32) {
            return this.append1(160 + b.length).append(b);
        }
        if (b.length < 256) {
            return this.append1(217).append1(b.length).append(b);
        }
        if (b.length < 65536) {
            return this.append1(218).append2(b.length).append(b);
        }
        return this.append1(219).append4(b.length).append(b);
    }

    final MsgPackOutputStream appendBinary(byte[] b) throws IOException {
        if (b.length < 256) {
            return this.append1(196).append1(b.length).append(b);
        }
        if (b.length < 65536) {
            return this.append1(197).append2(b.length).append(b);
        }
        return this.append1(198).append4(b.length).append(b);
    }

    final MsgPackOutputStream startArray(int size) throws IOException {
        if (size < 16) {
            return this.append1(144 + size);
        }
        if (size < 65536) {
            return this.append1(220).append2(size);
        }
        return this.append1(221).append4(size);
    }

    final MsgPackOutputStream startMap(int size) throws IOException {
        if (size < 16) {
            return this.append1(128 + size);
        }
        if (size < 65536) {
            return this.append1(222).append2(size);
        }
        return this.append1(223).append4(size);
    }
}

