/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.juneau.Context;
import org.apache.juneau.ContextRuntimeException;
import org.apache.juneau.PropertyStore;
import org.apache.juneau.annotation.ConfigurableContext;
import org.apache.juneau.internal.ClassUtils;
import org.apache.juneau.reflect.ClassInfo;

public class ContextCache {
    public static final ContextCache INSTANCE = new ContextCache();
    private static final boolean USE_DEEP_MATCHING = Boolean.getBoolean("ContextCache.useDeepMatching");
    private final ConcurrentHashMap<Class<?>, ConcurrentHashMap<Integer, CacheEntry>> contextCache = new ConcurrentHashMap();
    private final ConcurrentHashMap<Class<?>, String[]> prefixCache = new ConcurrentHashMap();
    private static final boolean TRACK_CACHE_HITS = Boolean.getBoolean("juneau.trackCacheHits");
    static final Map<String, CacheHit> CACHE_HITS = new ConcurrentHashMap<String, CacheHit>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static void logCache(Class<?> contextClass, boolean wasCached) {
        if (!TRACK_CACHE_HITS) return;
        Class<ContextCache> clazz = ContextCache.class;
        synchronized (ContextCache.class) {
            String c = contextClass.getSimpleName();
            CacheHit ch = CACHE_HITS.get(c);
            if (ch == null) {
                ch = new CacheHit();
            }
            if (wasCached) {
                ++ch.cached;
            } else {
                ++ch.creates;
            }
            ch = CACHE_HITS.put(c, ch);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    ContextCache() {
    }

    public <T extends Context> T create(Class<T> c, PropertyStore ps) {
        Integer hashCode;
        String[] prefixes = this.getPrefixes(c);
        if (prefixes == null) {
            return this.instantiate(c, ps);
        }
        ConcurrentHashMap<Integer, CacheEntry> m = this.getContextCache(c);
        CacheEntry ce = m.get(hashCode = ps.hashCode(prefixes));
        if (ce != null && USE_DEEP_MATCHING && !ce.ps.equals(ps)) {
            throw new ContextRuntimeException("Property store hashcode mismatch!", new Object[0]);
        }
        ContextCache.logCache(c, ce != null);
        if (ce == null) {
            ce = new CacheEntry(ps, (Context)this.instantiate(c, ps));
            m.putIfAbsent(hashCode, ce);
        }
        return (T)ce.context;
    }

    private <T extends Context> T instantiate(Class<T> c, PropertyStore ps) {
        try {
            return (T)((Context)this.newInstance(c, ps));
        }
        catch (ContextRuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ContextRuntimeException(e, "Could not create instance of class ''{0}''", c);
        }
    }

    private ConcurrentHashMap<Integer, CacheEntry> getContextCache(Class<?> c) {
        ConcurrentHashMap<Integer, CacheEntry> m2;
        ConcurrentHashMap<Integer, CacheEntry> m = this.contextCache.get(c);
        if (m == null && (m2 = this.contextCache.putIfAbsent(c, m = new ConcurrentHashMap())) != null) {
            m = m2;
        }
        return m;
    }

    private String[] getPrefixes(Class<?> c) {
        String[] prefixes = this.prefixCache.get(c);
        if (prefixes == null) {
            String[] p2;
            HashSet<String> ps = new HashSet<String>();
            for (ClassInfo c2 : ClassInfo.of(c).getAllParents()) {
                ConfigurableContext cc = c2.getAnnotation(ConfigurableContext.class);
                if (cc == null) continue;
                if (cc.nocache()) {
                    prefixes = new String[]{};
                    break;
                }
                if (cc.prefixes().length == 0) {
                    ps.add(c2.getSimpleName());
                    continue;
                }
                ps.addAll(Arrays.asList(cc.prefixes()));
            }
            if ((p2 = this.prefixCache.putIfAbsent(c, prefixes = ps.toArray(new String[ps.size()]))) != null) {
                prefixes = p2;
            }
        }
        return prefixes.length == 0 ? null : prefixes;
    }

    private <T> T newInstance(Class<T> cc, PropertyStore ps) throws Exception {
        return (T)ClassUtils.castOrCreate(Context.class, cc, true, ps);
    }

    static {
        if (TRACK_CACHE_HITS) {
            Runtime.getRuntime().addShutdownHook(new Thread(){

                @Override
                public void run() {
                    int creates = 0;
                    int cached = 0;
                    System.out.println("Cache Hits:  [CacheObject] = [numCreated,numCached,cacheHitPercentage]");
                    for (Map.Entry<String, CacheHit> e : CACHE_HITS.entrySet()) {
                        CacheHit ch = e.getValue();
                        System.out.println("[" + e.getKey() + "] = [" + ch.creates + "," + ch.cached + "," + ch.cached * 100 / (ch.creates + ch.cached) + "%]");
                        creates += ch.creates;
                        cached += ch.cached;
                    }
                    if (creates + cached > 0) {
                        System.out.println("[total] = [" + creates + "," + cached + "," + cached * 100 / (creates + cached) + "%]");
                    }
                }
            });
        }
    }

    private static class CacheEntry {
        final PropertyStore ps;
        final Context context;

        CacheEntry(PropertyStore ps, Context context) {
            this.ps = ps;
            this.context = context;
        }
    }

    static class CacheHit {
        public int creates;
        public int cached;

        CacheHit() {
        }
    }
}

