/*
 * Decompiled with CFR 0.152.
 */
package org.apache.johnzon.maven.plugin;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Objects;
import java.util.stream.Stream;
import javax.json.bind.Jsonb;
import javax.json.bind.JsonbBuilder;
import javax.json.bind.JsonbConfig;
import org.apache.johnzon.jsonschema.generator.Schema;
import org.apache.johnzon.jsonschema.generator.SchemaProcessor;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;

@Mojo(name="jsonschema", defaultPhase=LifecyclePhase.PROCESS_CLASSES, requiresDependencyResolution=ResolutionScope.RUNTIME_PLUS_SYSTEM)
public class PojoToJsonSchemaMojo
extends AbstractMojo {
    @Parameter(property="johnzon.jsonschema.schemaClass")
    protected String schemaClass;
    @Parameter(property="johnzon.jsonschema.target", defaultValue="${project.build.outputDirectory}/jsonschema/schema.json")
    protected File target;
    @Parameter(property="johnzon.jsonschema.classesDir", defaultValue="${project.build.outputDirectory}")
    protected File classesDir;
    @Parameter(defaultValue="${project}", readonly=true)
    protected MavenProject project;
    @Component
    protected MavenProjectHelper projectHelper;
    @Parameter(property="johnzon.attach", defaultValue="true")
    protected boolean attach;
    @Parameter(property="johnzon.jsonschema.classifier", defaultValue="jsonschema")
    protected String classifier;
    @Parameter(property="johnzon.jsonschema.title")
    protected String title;
    @Parameter(property="johnzon.jsonschema.description")
    protected String description;

    public void execute() throws MojoExecutionException {
        Thread thread = Thread.currentThread();
        ClassLoader old = thread.getContextClassLoader();
        try (URLClassLoader loader = this.newLoader(old);
             Jsonb jsonb = JsonbBuilder.create((JsonbConfig)new JsonbConfig().withFormatting(Boolean.valueOf(true)).withPropertyOrderStrategy("LEXICOGRAPHICAL"));){
            thread.setContextClassLoader(loader);
            SchemaProcessor.InMemoryCache cache = new SchemaProcessor.InMemoryCache();
            Schema schema = new SchemaProcessor().mapSchemaFromClass(loader.loadClass(this.schemaClass.trim()), (SchemaProcessor.Cache)cache);
            schema.setTitle(this.title);
            schema.setDescription(this.description);
            if (!cache.getDefinitions().isEmpty()) {
                schema.setDefinitions(cache.getDefinitions());
            }
            if (this.target.getParent() != null) {
                Files.createDirectories(this.target.toPath().getParent(), new FileAttribute[0]);
            }
            Files.write(this.target.toPath(), jsonb.toJson((Object)schema).getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        }
        catch (Exception e) {
            throw new MojoExecutionException(e.getMessage(), e);
        }
        finally {
            thread.setContextClassLoader(old);
        }
        if (this.attach && this.project != null) {
            this.projectHelper.attachArtifact(this.project, "json", this.classifier, this.target);
        }
    }

    private URLClassLoader newLoader(ClassLoader parent) {
        return new URLClassLoader((URL[])Stream.concat(this.project.getArtifacts().stream().map(Artifact::getFile).filter(Objects::nonNull), Stream.of(this.classesDir)).filter(File::exists).map(it -> {
            try {
                return it.toURI().toURL();
            }
            catch (MalformedURLException e) {
                throw new IllegalStateException(e);
            }
        }).toArray(URL[]::new), parent);
    }
}

