/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.plot.builder.sampling.method;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.AbstractList;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.letsPlot.commons.geometry.DoubleVector;
import org.jetbrains.letsPlot.commons.intern.typedGeometry.algorithms.GeometryKt;
import org.jetbrains.letsPlot.core.commons.data.SeriesUtil;
import org.jetbrains.letsPlot.core.commons.geometry.PolylineSimplifier;
import org.jetbrains.letsPlot.core.commons.mutables.MutableInteger;
import org.jetbrains.letsPlot.core.plot.base.DataFrame;
import org.jetbrains.letsPlot.core.plot.builder.sampling.PointSampling;
import org.jetbrains.letsPlot.core.plot.builder.sampling.method.SamplingBase;
import org.jetbrains.letsPlot.core.plot.builder.sampling.method.SamplingUtil;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\b \u0018\u0000 \u00102\u00020\u00012\u00020\u0002:\u0004\u0010\u0011\u0012\u0013B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0016J$\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00040\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\n2\u0006\u0010\r\u001a\u00020\u0004H\u0002J)\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00040\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\n2\u0006\u0010\r\u001a\u00020\u0004H \u00a2\u0006\u0002\b\u000f\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/letsPlot/core/plot/builder/sampling/method/VertexSampling;", "Lorg/jetbrains/letsPlot/core/plot/builder/sampling/method/SamplingBase;", "Lorg/jetbrains/letsPlot/core/plot/builder/sampling/PointSampling;", "sampleSize", "", "(I)V", "apply", "Lorg/jetbrains/letsPlot/core/plot/base/DataFrame;", "population", "simplify", "", "points", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "limit", "simplifyInternal", "simplifyInternal$plot_builder", "Companion", "DoubleVectorComponentsList", "VertexDpSampling", "VertexVwSampling", "plot-builder"})
@SourceDebugExtension(value={"SMAP\nVertexSampling.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VertexSampling.kt\norg/jetbrains/letsPlot/core/plot/builder/sampling/method/VertexSampling\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,107:1\n1549#2:108\n1620#2,3:109\n1855#2:112\n1855#2,2:113\n1856#2:115\n*S KotlinDebug\n*F\n+ 1 VertexSampling.kt\norg/jetbrains/letsPlot/core/plot/builder/sampling/method/VertexSampling\n*L\n46#1:108\n46#1:109,3\n47#1:112\n49#1:113,2\n47#1:115\n*E\n"})
public abstract class VertexSampling
extends SamplingBase
implements PointSampling {
    @NotNull
    public static final Companion Companion = new Companion(null);

    public VertexSampling(int sampleSize) {
        super(sampleSize);
    }

    private final List<Integer> simplify(List<DoubleVector> points, int limit) {
        return limit == 0 ? CollectionsKt.emptyList() : this.simplifyInternal$plot_builder(points, limit);
    }

    @NotNull
    public abstract List<Integer> simplifyInternal$plot_builder(@NotNull List<DoubleVector> var1, int var2);

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public DataFrame apply(@NotNull DataFrame population) {
        void $this$forEach$iv;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)population, (String)"population");
        if (!this.isApplicable(population)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        List<List<DoubleVector>> rings = SamplingUtil.INSTANCE.splitRings(population);
        List limits = rings.size() == 1 && !GeometryKt.isClosed(rings.get(0)) ? CollectionsKt.listOf((Object)this.getSampleSize()) : SamplingUtil.INSTANCE.calculateRingLimits(rings, this.getSampleSize());
        ArrayList<Integer> indices = new ArrayList<Integer>();
        MutableInteger ringBase = new MutableInteger(0);
        Iterable iterable = (Iterable)RangesKt.until((int)0, (int)limits.size());
        boolean $i$f$map = false;
        Iterator iterator = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator2 = $this$mapTo$iv$iv.iterator();
        while (iterator2.hasNext()) {
            void it;
            int item$iv$iv;
            int n = item$iv$iv = ((IntIterator)iterator2).nextInt();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new Pair((Object)((int)it), limits.get((int)it)));
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            void $this$forEach$iv2;
            Pair p = (Pair)element$iv;
            boolean bl = false;
            Iterable item$iv$iv = this.simplify(rings.get(SamplingUtil.INSTANCE.getRingIndex(p)), SamplingUtil.INSTANCE.getRingLimit(p));
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                int index = ((Number)element$iv2).intValue();
                boolean bl2 = false;
                indices.add(ringBase.get() + index);
            }
            ringBase.getAndAdd(rings.get(SamplingUtil.INSTANCE.getRingIndex(p)).size());
        }
        return population.selectIndices((List)indices);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u0001H\u0002\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/letsPlot/core/plot/builder/sampling/method/VertexSampling$Companion;", "", "()V", "createPoint", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "x", "y", "plot-builder"})
    @SourceDebugExtension(value={"SMAP\nVertexSampling.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VertexSampling.kt\norg/jetbrains/letsPlot/core/plot/builder/sampling/method/VertexSampling$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,107:1\n1#2:108\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        private final DoubleVector createPoint(Object x, Object y) {
            if (!(!(x instanceof String) && !(y instanceof String))) {
                boolean $i$a$-require-VertexSampling$Companion$createPoint$32 = false;
                String $i$a$-require-VertexSampling$Companion$createPoint$32 = "String coords are not supported yet";
                throw new IllegalArgumentException($i$a$-require-VertexSampling$Companion$createPoint$32.toString());
            }
            Intrinsics.checkNotNull((Object)x, (String)"null cannot be cast to non-null type kotlin.Double");
            Double d = (Double)x;
            Intrinsics.checkNotNull((Object)y, (String)"null cannot be cast to non-null type kotlin.Double");
            if (!SeriesUtil.INSTANCE.allFinite(d, (Double)y)) {
                boolean bl = false;
                String string = "Invalid coord";
                throw new IllegalArgumentException(string.toString());
            }
            return new DoubleVector(((Number)x).doubleValue(), ((Number)y).doubleValue());
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B!\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\u0002\u0010\u0007J\u0011\u0010\f\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\tH\u0096\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/letsPlot/core/plot/builder/sampling/method/VertexSampling$DoubleVectorComponentsList;", "Lkotlin/collections/AbstractList;", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "myXValues", "", "", "myYValues", "(Ljava/util/List;Ljava/util/List;)V", "size", "", "getSize", "()I", "get", "index", "plot-builder"})
    public static final class DoubleVectorComponentsList
    extends AbstractList<DoubleVector> {
        @NotNull
        private final List<Object> myXValues;
        @NotNull
        private final List<Object> myYValues;

        public DoubleVectorComponentsList(@NotNull List<? extends Object> myXValues, @NotNull List<? extends Object> myYValues) {
            Intrinsics.checkNotNullParameter(myXValues, (String)"myXValues");
            Intrinsics.checkNotNullParameter(myYValues, (String)"myYValues");
            this.myXValues = myXValues;
            this.myYValues = myYValues;
        }

        public int getSize() {
            return this.myXValues.size();
        }

        @NotNull
        public DoubleVector get(int index) {
            return Companion.createPoint(this.myXValues.get(index), this.myYValues.get(index));
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J)\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00030\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\n2\u0006\u0010\r\u001a\u00020\u0003H\u0010\u00a2\u0006\u0002\b\u000eR\u0014\u0010\u0005\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/letsPlot/core/plot/builder/sampling/method/VertexSampling$VertexDpSampling;", "Lorg/jetbrains/letsPlot/core/plot/builder/sampling/method/VertexSampling;", "sampleSize", "", "(I)V", "expressionText", "", "getExpressionText", "()Ljava/lang/String;", "simplifyInternal", "", "points", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "limit", "simplifyInternal$plot_builder", "Companion", "plot-builder"})
    public static final class VertexDpSampling
    extends VertexSampling {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        public static final String ALIAS = "vertex_dp";

        public VertexDpSampling(int sampleSize) {
            super(sampleSize);
        }

        @Override
        @NotNull
        public String getExpressionText() {
            return "sampling_vertex_dp(n=" + this.getSampleSize() + ')';
        }

        @Override
        @NotNull
        public List<Integer> simplifyInternal$plot_builder(@NotNull List<DoubleVector> points, int limit) {
            Intrinsics.checkNotNullParameter(points, (String)"points");
            return PolylineSimplifier.Companion.douglasPeucker(points).setCountLimit(limit).getIndices();
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/letsPlot/core/plot/builder/sampling/method/VertexSampling$VertexDpSampling$Companion;", "", "()V", "ALIAS", "", "plot-builder"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J)\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00030\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\n2\u0006\u0010\r\u001a\u00020\u0003H\u0010\u00a2\u0006\u0002\b\u000eR\u0014\u0010\u0005\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/letsPlot/core/plot/builder/sampling/method/VertexSampling$VertexVwSampling;", "Lorg/jetbrains/letsPlot/core/plot/builder/sampling/method/VertexSampling;", "sampleSize", "", "(I)V", "expressionText", "", "getExpressionText", "()Ljava/lang/String;", "simplifyInternal", "", "points", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "limit", "simplifyInternal$plot_builder", "Companion", "plot-builder"})
    public static final class VertexVwSampling
    extends VertexSampling {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        public static final String ALIAS = "vertex_vw";

        public VertexVwSampling(int sampleSize) {
            super(sampleSize);
        }

        @Override
        @NotNull
        public String getExpressionText() {
            return "sampling_vertex_vw(n=" + this.getSampleSize() + ')';
        }

        @Override
        @NotNull
        public List<Integer> simplifyInternal$plot_builder(@NotNull List<DoubleVector> points, int limit) {
            Intrinsics.checkNotNullParameter(points, (String)"points");
            return PolylineSimplifier.Companion.visvalingamWhyatt(points).setCountLimit(limit).getIndices();
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/letsPlot/core/plot/builder/sampling/method/VertexSampling$VertexVwSampling$Companion;", "", "()V", "ALIAS", "", "plot-builder"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

