/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import org.apache.lucene.search.FuzzyTermsEnum;
import org.apache.lucene.util.UnicodeUtil;
import org.apache.lucene.util.automaton.CompiledAutomaton;
import org.apache.lucene.util.automaton.LevenshteinAutomata;
import org.apache.lucene.util.automaton.TooComplexToDeterminizeException;

class FuzzyAutomatonBuilder {
    private final String term;
    private final int maxEdits;
    private final LevenshteinAutomata levBuilder;
    private final String prefix;
    private final int termLength;

    FuzzyAutomatonBuilder(String term, int maxEdits, int prefixLength, boolean transpositions) {
        if (maxEdits < 0 || maxEdits > 2) {
            throw new IllegalArgumentException("max edits must be 0..2, inclusive; got: " + maxEdits);
        }
        if (prefixLength < 0) {
            throw new IllegalArgumentException("prefixLength cannot be less than 0");
        }
        this.term = term;
        this.maxEdits = maxEdits;
        int[] codePoints = FuzzyAutomatonBuilder.stringToUTF32(term);
        this.termLength = codePoints.length;
        prefixLength = Math.min(prefixLength, codePoints.length);
        int[] suffix = new int[codePoints.length - prefixLength];
        System.arraycopy(codePoints, prefixLength, suffix, 0, suffix.length);
        this.levBuilder = new LevenshteinAutomata(suffix, 0x10FFFF, transpositions);
        this.prefix = UnicodeUtil.newString(codePoints, 0, prefixLength);
    }

    CompiledAutomaton[] buildAutomatonSet() {
        CompiledAutomaton[] compiled = new CompiledAutomaton[this.maxEdits + 1];
        for (int i = 0; i <= this.maxEdits; ++i) {
            try {
                compiled[i] = new CompiledAutomaton(this.levBuilder.toAutomaton(i, this.prefix), true, false);
                continue;
            }
            catch (TooComplexToDeterminizeException e2) {
                throw new FuzzyTermsEnum.FuzzyTermsException(this.term, e2);
            }
        }
        return compiled;
    }

    CompiledAutomaton buildMaxEditAutomaton() {
        try {
            return new CompiledAutomaton(this.levBuilder.toAutomaton(this.maxEdits, this.prefix), true, false);
        }
        catch (TooComplexToDeterminizeException e2) {
            throw new FuzzyTermsEnum.FuzzyTermsException(this.term, e2);
        }
    }

    int getTermLength() {
        return this.termLength;
    }

    private static int[] stringToUTF32(String text) {
        int cp;
        int[] termText = new int[text.codePointCount(0, text.length())];
        int j = 0;
        for (int i = 0; i < text.length(); i += Character.charCount(cp)) {
            termText[j++] = cp = text.codePointAt(i);
        }
        return termText;
    }
}

