/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.tdb1.solver;

import java.util.Iterator;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.function.Predicate;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.atlas.lib.InternalErrorException;
import org.apache.jena.atlas.lib.tuple.Tuple;
import org.apache.jena.atlas.lib.tuple.TupleBase;
import org.apache.jena.atlas.lib.tuple.TupleFactory;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.sparql.core.Substitute;
import org.apache.jena.sparql.engine.ExecutionContext;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.engine.binding.BindingFactory;
import org.apache.jena.sparql.engine.iterator.IterAbortable;
import org.apache.jena.sparql.engine.main.solver.SolverLib;
import org.apache.jena.sparql.engine.main.solver.SolverRX4;
import org.apache.jena.tdb1.lib.TupleLib;
import org.apache.jena.tdb1.solver.BindingNodeId;
import org.apache.jena.tdb1.solver.BindingTDB;
import org.apache.jena.tdb1.solver.SolverLibTDB;
import org.apache.jena.tdb1.solver.StageMatchTuple;
import org.apache.jena.tdb1.store.NodeId;
import org.apache.jena.tdb1.store.nodetable.NodeTable;
import org.apache.jena.tdb1.store.nodetupletable.NodeTupleTable;

public class SolverRX {
    public static final boolean DATAPATH = true;
    private static Function<Tuple<NodeId>, Tuple<NodeId>> quadsToAnyTriples = item -> TupleFactory.create4(NodeId.NodeIdAny, (NodeId)item.get(1), (NodeId)item.get(2), (NodeId)item.get(3));

    static Iterator<BindingNodeId> matchQuadPattern(Iterator<BindingNodeId> chain, Node graphNode, Triple tPattern, NodeTupleTable nodeTupleTable, Tuple<Node> patternTuple, boolean anyGraph, Predicate<Tuple<NodeId>> filter, ExecutionContext execCxt) {
        if (!SolverLib.tripleHasEmbTripleWithVars(tPattern)) {
            return StageMatchTuple.access(nodeTupleTable, chain, patternTuple, filter, anyGraph, execCxt);
        }
        boolean isTriple = patternTuple.len() == 3;
        NodeTable nodeTable = nodeTupleTable.getNodeTable();
        Function<BindingNodeId, Iterator> step = bnid -> SolverRX.find(bnid, nodeTupleTable, graphNode, tPattern, anyGraph, filter, execCxt);
        return Iter.flatMap(chain, step);
    }

    private static Iterator<BindingNodeId> find(BindingNodeId bnid, NodeTupleTable nodeTupleTable, Node xGraphNode, Triple xPattern, boolean anyGraph, Predicate<Tuple<NodeId>> filter, ExecutionContext execCxt) {
        NodeTable nodeTable = nodeTupleTable.getNodeTable();
        Binding input = bnid.isEmpty() ? BindingFactory.empty() : new BindingTDB(bnid, nodeTable);
        Triple tPattern = Substitute.substitute(xPattern, input);
        Node graphNode = Substitute.substitute(xGraphNode, input);
        Node tGraphNode = anyGraph ? Quad.unionGraph : graphNode;
        Node g = graphNode == null ? null : SolverLib.nodeTopLevel(graphNode);
        Node s = SolverLib.nodeTopLevel(tPattern.getSubject());
        Node p = SolverLib.nodeTopLevel(tPattern.getPredicate());
        Node o = SolverLib.nodeTopLevel(tPattern.getObject());
        TupleBase patternTuple = g == null ? TupleFactory.create3(s, p, o) : TupleFactory.create4(g, s, p, o);
        Iterator<Quad> dsgIter = SolverRX.accessData(patternTuple, nodeTupleTable, anyGraph, filter, execCxt);
        Iter<Binding> matched = Iter.iter(dsgIter).map(dQuad -> SolverRX4.matchQuad(input, dQuad, tGraphNode, tPattern)).removeNulls();
        return SolverLibTDB.convFromBinding(matched, nodeTable);
    }

    private static Iterator<Quad> accessData(Tuple<Node> patternTuple, NodeTupleTable nodeTupleTable, boolean anyGraph, Predicate<Tuple<NodeId>> filter, ExecutionContext execCxt) {
        NodeTable nodeTable = nodeTupleTable.getNodeTable();
        Tuple<NodeId> patternTupleId = TupleLib.tupleNodeIds(nodeTable, patternTuple);
        if (patternTupleId.contains(NodeId.NodeDoesNotExist)) {
            return Iter.nullIterator();
        }
        Iterator<Tuple<NodeId>> iterMatches = nodeTupleTable.find(patternTupleId);
        AtomicBoolean cancelSignal = execCxt.getCancelSignal();
        iterMatches = IterAbortable.wrap(iterMatches, cancelSignal);
        if (filter != null) {
            iterMatches = Iter.filter(iterMatches, filter);
        }
        if (anyGraph) {
            iterMatches = Iter.map(iterMatches, quadsToAnyTriples);
            iterMatches = Iter.distinctAdjacent(iterMatches);
        }
        Function<Tuple<NodeId>, Quad> asQuad = SolverRX.asQuad(nodeTable, nodeTupleTable.getTupleLen(), anyGraph);
        Iterator<Quad> qIter = Iter.map(iterMatches, asQuad);
        return qIter;
    }

    private static Function<Tuple<NodeId>, Quad> asQuad(NodeTable nodeTable, int tupleLen, boolean anyGraph) {
        switch (tupleLen) {
            case 3: {
                return t -> {
                    Node gx = Quad.defaultGraphIRI;
                    Node sx = SolverRX.toNode((NodeId)t.get(0), nodeTable);
                    Node px = SolverRX.toNode((NodeId)t.get(1), nodeTable);
                    Node ox = SolverRX.toNode((NodeId)t.get(2), nodeTable);
                    return Quad.create(gx, sx, px, ox);
                };
            }
            case 4: {
                return t -> {
                    Node gx = anyGraph ? Quad.unionGraph : SolverRX.toNode((NodeId)t.get(0), nodeTable);
                    Node sx = SolverRX.toNode((NodeId)t.get(1), nodeTable);
                    Node px = SolverRX.toNode((NodeId)t.get(2), nodeTable);
                    Node ox = SolverRX.toNode((NodeId)t.get(3), nodeTable);
                    return Quad.create(gx, sx, px, ox);
                };
            }
        }
        throw new InternalErrorException("Tuple of unknown length");
    }

    private static Node toNode(NodeId nodeId, NodeTable nodeTable) {
        return nodeTable.getNodeForNodeId(nodeId);
    }
}

